/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.dialog;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.dialog.FreeColConfirmDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;

public class FirstContactDialog
extends FreeColConfirmDialog {
    private static final String BASE_KEY = "firstContactDialog.meeting.";
    private static final String NATIVES = "natives";
    private static final String TUTORIAL_KEY = "firstContactDialog.meeting.natives.tutorial";

    public FirstContactDialog(FreeColClient freeColClient, JFrame frame, Player player, Player other, Tile tile, int settlementCount) {
        super(freeColClient, frame);
        MigPanel panel = new MigPanel(new MigLayout("wrap 1", "[center]", "[]20"));
        panel.setOpaque(false);
        Object headerKey = BASE_KEY + other.getNation().getSuffix();
        if (!Messages.containsKey((String)headerKey)) {
            headerKey = "firstContactDialog.meeting.natives";
        }
        JLabel header = Utility.localizedHeaderLabel((String)headerKey, 10, Utility.FONTSPEC_SUBTITLE);
        JLabel image = new JLabel(new ImageIcon(ImageLibrary.getMeetingImage(other)));
        image.setOpaque(false);
        JTextArea tutorial = null;
        if (!player.hasContactedIndians() && freeColClient.tutorialMode()) {
            tutorial = Utility.localizedTextArea(TUTORIAL_KEY);
        }
        String messageId = tile != null ? "firstContactDialog.welcomeOffer.text" : "firstContactDialog.welcomeSimple.text";
        String type = ((IndianNationType)other.getNationType()).getSettlementTypeKey(true);
        JTextArea text = Utility.localizedTextArea(((StringTemplate)((StringTemplate)StringTemplate.template(messageId).addStringTemplate("%nation%", other.getNationLabel())).addName("%camps%", Integer.toString(settlementCount))).add("%settlementType%", type));
        int columns = (int)Math.floor((double)text.getColumns() * image.getPreferredSize().getWidth() / text.getPreferredSize().getWidth());
        text.setColumns(columns);
        text.setSize(text.getPreferredSize());
        if (tutorial != null) {
            tutorial.setColumns(columns);
            tutorial.setSize(tutorial.getPreferredSize());
        }
        panel.add(header);
        panel.add(image);
        if (tutorial != null) {
            panel.add(tutorial);
        }
        panel.add(text);
        panel.setSize(panel.getPreferredSize());
        ImageIcon icon = new ImageIcon(this.getImageLibrary().getScaledNationImage(other.getNation()));
        this.initializeConfirmDialog(frame, false, panel, icon, "yes", "no");
    }
}

