/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.colopedia;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaPanel;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaTreeItem;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.util.ImageUtils;

public class FatherDetailPanel
extends ColopediaGameObjectTypePanel<FoundingFather> {
    private static final Logger logger = Logger.getLogger(FatherDetailPanel.class.getName());

    public FatherDetailPanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel) {
        super(freeColClient, colopediaPanel, ColopediaAction.PanelType.FATHERS.getKey());
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        Specification spec = this.getSpecification();
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(new ColopediaTreeItem(this, this.getId(), this.getName(), null));
        EnumMap fathersByType = new EnumMap(FoundingFather.FoundingFatherType.class);
        for (FoundingFather.FoundingFatherType fatherType : FoundingFather.FoundingFatherType.values()) {
            fathersByType.put(fatherType, new ArrayList());
        }
        for (FoundingFather foundingFather : spec.getFoundingFathers()) {
            ((List)fathersByType.get((Object)foundingFather.getType())).add(foundingFather);
        }
        ImageIcon icon = new ImageIcon(ImageUtils.createCenteredImage(this.getImageLibrary().getLibertyImage(), this.getListItemIconSize()));
        for (FoundingFather.FoundingFatherType fatherType : FoundingFather.FoundingFatherType.values()) {
            String id = fatherType.getTypeKey();
            String typeName = Messages.message(id);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ColopediaTreeItem(this, id, typeName, null));
            parent.add(node);
            for (FoundingFather father : (List)fathersByType.get((Object)fatherType)) {
                node.add(this.buildItem(father, icon));
            }
        }
        root.add(parent);
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        FoundingFather father = this.getSpecification().getFoundingFather(id);
        if (father == null) {
            logger.warning("Bogus father detail requested for: " + id);
        } else {
            this.buildDetail(father, panel);
        }
    }

    public void buildDetail(FoundingFather father, JPanel panel) {
        panel.setLayout(new MigLayout("wrap 2, fillx, gapx 20", "", ""));
        String name = Messages.getName(father);
        String type = Messages.message(father.getTypeKey());
        String text = name + " (" + type + ")";
        JLabel header = new JLabel(text);
        header.setFont(FontLibrary.getScaledFont(Utility.FONTSPEC_SUBTITLE, text));
        BufferedImage image = this.getImageLibrary().getFoundingFatherImage(father, false);
        JLabel label = new JLabel(new ImageIcon(image));
        Object template = ((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.label("").add(Messages.descriptionKey(father))).addName("\n\n[")).add(father.getId() + ".birthAndDeath")).addName("] ")).add(father.getId() + ".text");
        Turn turn = this.getMyPlayer().getElectionTurns().get(name);
        if (turn != null) {
            ((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)template).addName("\n\n")).add("report.continentalCongress.elected")).addName(" ")).addStringTemplate(turn.getLabel());
        }
        panel.add((Component)header, "span, align center, wrap 40");
        panel.add((Component)label, "top");
        JTextArea description = Utility.localizedTextArea(template, 20);
        panel.add((Component)description, "top, growx, wmin 0");
        Dimension hSize = header.getPreferredSize();
        Dimension lSize = label.getPreferredSize();
        Dimension dSize = description.getPreferredSize();
        Dimension size = new Dimension();
        size.setSize(lSize.getWidth() + dSize.getWidth() + 20.0, hSize.getHeight() + lSize.getHeight() + 10.0);
        panel.setPreferredSize(size);
    }
}

