/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class BuildingTest
extends FreeColTestCase {
    private static final BuildingType armoryType = BuildingTest.spec().getBuildingType("model.building.armory");
    private static final BuildingType arsenalType = BuildingTest.spec().getBuildingType("model.building.arsenal");
    private static final BuildingType blacksmithHouseType = BuildingTest.spec().getBuildingType("model.building.blacksmithHouse");
    private static final BuildingType blacksmithShopType = BuildingTest.spec().getBuildingType("model.building.blacksmithShop");
    private static final BuildingType carpenterHouseType = BuildingTest.spec().getBuildingType("model.building.carpenterHouse");
    private static final BuildingType cathedralType = BuildingTest.spec().getBuildingType("model.building.cathedral");
    private static final BuildingType chapelType = BuildingTest.spec().getBuildingType("model.building.chapel");
    private static final BuildingType churchType = BuildingTest.spec().getBuildingType("model.building.church");
    private static final BuildingType cigarFactoryType = BuildingTest.spec().getBuildingType("model.building.cigarFactory");
    private static final BuildingType countryType = BuildingTest.spec().getBuildingType("model.building.country");
    private static final BuildingType depotType = BuildingTest.spec().getBuildingType("model.building.depot");
    private static final BuildingType distillerHouseType = BuildingTest.spec().getBuildingType("model.building.distillerHouse");
    private static final BuildingType fortType = BuildingTest.spec().getBuildingType("model.building.fort");
    private static final BuildingType fortressType = BuildingTest.spec().getBuildingType("model.building.fortress");
    private static final BuildingType furTraderHouseType = BuildingTest.spec().getBuildingType("model.building.furTraderHouse");
    private static final BuildingType furTradingPostType = BuildingTest.spec().getBuildingType("model.building.furTradingPost");
    private static final BuildingType furFactoryType = BuildingTest.spec().getBuildingType("model.building.furFactory");
    private static final BuildingType ironWorksType = BuildingTest.spec().getBuildingType("model.building.ironWorks");
    private static final BuildingType lumberMillType = BuildingTest.spec().getBuildingType("model.building.lumberMill");
    private static final BuildingType magazineType = BuildingTest.spec().getBuildingType("model.building.magazine");
    private static final BuildingType newspaperType = BuildingTest.spec().getBuildingType("model.building.newspaper");
    private static final BuildingType printingPressType = BuildingTest.spec().getBuildingType("model.building.printingPress");
    private static final BuildingType rumDistilleryType = BuildingTest.spec().getBuildingType("model.building.rumDistillery");
    private static final BuildingType rumFactoryType = BuildingTest.spec().getBuildingType("model.building.rumFactory");
    private static final BuildingType schoolType = BuildingTest.spec().getBuildingType("model.building.schoolhouse");
    private static final BuildingType stockadeType = BuildingTest.spec().getBuildingType("model.building.stockade");
    private static final BuildingType textileMillType = BuildingTest.spec().getBuildingType("model.building.textileMill");
    private static final BuildingType tobacconistHouseType = BuildingTest.spec().getBuildingType("model.building.tobacconistHouse");
    private static final BuildingType tobacconistShopType = BuildingTest.spec().getBuildingType("model.building.tobacconistShop");
    private static final BuildingType townHallType = BuildingTest.spec().getBuildingType("model.building.townHall");
    private static final BuildingType universityType = BuildingTest.spec().getBuildingType("model.building.university");
    private static final BuildingType warehouseType = BuildingTest.spec().getBuildingType("model.building.warehouse");
    private static final BuildingType weaverHouseType = BuildingTest.spec().getBuildingType("model.building.weaverHouse");
    private static final BuildingType weaverShopType = BuildingTest.spec().getBuildingType("model.building.weaverShop");
    private static final GoodsType bellsType = BuildingTest.spec().getGoodsType("model.goods.bells");
    private static final GoodsType clothType = BuildingTest.spec().getGoodsType("model.goods.cloth");
    private static final GoodsType cottonType = BuildingTest.spec().getGoodsType("model.goods.cotton");
    private static final GoodsType crossesType = BuildingTest.spec().getGoodsType("model.goods.crosses");
    private static final GoodsType foodType = BuildingTest.spec().getPrimaryFoodType();
    private static final GoodsType grainType = BuildingTest.spec().getGoodsType("model.goods.grain");
    private static final GoodsType hammersType = BuildingTest.spec().getGoodsType("model.goods.hammers");
    private static final GoodsType horsesType = BuildingTest.spec().getGoodsType("model.goods.horses");
    private static final GoodsType lumberType = BuildingTest.spec().getGoodsType("model.goods.lumber");
    private static final GoodsType musketsType = BuildingTest.spec().getGoodsType("model.goods.muskets");
    private static final GoodsType oreType = BuildingTest.spec().getGoodsType("model.goods.ore");
    private static final GoodsType toolsType = BuildingTest.spec().getGoodsType("model.goods.tools");
    private static final Role missionaryRole = BuildingTest.spec().getRole("model.role.missionary");
    private static final TileType plainsType = BuildingTest.spec().getTileType("model.tile.plains");
    private static final UnitType elderStatesmanType = BuildingTest.spec().getUnitType("model.unit.elderStatesman");
    private static final UnitType expertFarmerType = BuildingTest.spec().getUnitType("model.unit.expertFarmer");
    private static final UnitType firebrandPreacherType = BuildingTest.spec().getUnitType("model.unit.firebrandPreacher");
    private static final UnitType freeColonistType = BuildingTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType indenturedServantType = BuildingTest.spec().getUnitType("model.unit.indenturedServant");
    private static final UnitType indianConvertType = BuildingTest.spec().getUnitType("model.unit.indianConvert");
    private static final UnitType masterBlacksmithType = BuildingTest.spec().getUnitType("model.unit.masterBlacksmith");
    private static final UnitType masterCarpenterType = BuildingTest.spec().getUnitType("model.unit.masterCarpenter");
    private static final UnitType masterDistillerType = BuildingTest.spec().getUnitType("model.unit.masterDistiller");
    private static final UnitType pettyCriminalType = BuildingTest.spec().getUnitType("model.unit.pettyCriminal");
    private static final Integer[] bonusLevels = new Integer[]{-2, -1, 0, 1, 2};
    private static int[][][] lumberProd = new int[][][]{new int[][]{{0, 0, 0, 1, 4}, {0, 0, 1, 2, 5}, {1, 1, 2, 3, 6}, {2, 2, 3, 4, 7}, {3, 3, 4, 5, 8}}, new int[][]{{0, 0, 0, 2, 8}, {0, 0, 2, 4, 10}, {2, 2, 4, 6, 12}, {4, 4, 6, 8, 14}, {6, 6, 8, 10, 16}}};
    private static final BuildingType[] lumberBuildings = new BuildingType[]{carpenterHouseType, lumberMillType};
    private static int[][][] crossProd = new int[][][]{new int[][]{{2, 2, 2, 3, 6}, {2, 2, 3, 4, 7}, {3, 3, 4, 5, 8}, {4, 4, 5, 6, 9}, {5, 5, 6, 7, 10}}, new int[][]{{3, 3, 3, 5, 11}, {3, 3, 5, 7, 13}, {5, 5, 7, 9, 15}, {7, 7, 9, 11, 17}, {9, 9, 11, 13, 19}}};
    private static final BuildingType[] crossBuildings = new BuildingType[]{churchType, cathedralType};
    private static int[][][] factoryProd = new int[][][]{new int[][]{{0, 0, 0, 1, 2}, {0, 0, 1, 2, 4}, {1, 1, 2, 3, 6}, {2, 2, 3, 4, 8}, {3, 3, 4, 5, 10}}, new int[][]{{0, 0, 2, 4, 8}, {1, 1, 3, 5, 10}, {2, 2, 4, 6, 12}, {3, 3, 5, 7, 14}, {4, 4, 6, 8, 16}}, new int[][]{{0, 0, 3, 6, 12}, {1, 1, 4, 7, 14}, {3, 3, 6, 9, 18}, {4, 4, 7, 10, 20}, {6, 6, 9, 12, 24}}};
    private static final BuildingType[] clothBuildings = new BuildingType[]{weaverHouseType, weaverShopType, textileMillType};
    private static final BuildingType[] furBuildings = new BuildingType[]{furTraderHouseType, furTradingPostType, furFactoryType};
    private static final BuildingType[] sugarBuildings = new BuildingType[]{distillerHouseType, rumDistilleryType, rumFactoryType};
    private static final BuildingType[] tobaccoBuildings = new BuildingType[]{tobacconistHouseType, tobacconistShopType, cigarFactoryType};
    private static final BuildingType[] toolBuildings = new BuildingType[]{blacksmithHouseType, blacksmithShopType, ironWorksType};
    private static final BuildingType[] musketBuildings = new BuildingType[]{armoryType, magazineType, arsenalType};

    private void clearBuilding(Building b) {
        Colony colony = b.getColony();
        for (Unit u : b.getUnitList()) {
            u.setLocation(colony.getTile());
            u.setWorkType(grainType);
            colony.joinColony(u);
        }
        BuildingTest.assertEquals((int)0, (int)b.getUnitCount());
    }

    private void productionTest(BuildingType[] buildings, int[][][] values) {
        Game game = BuildingTest.getGame();
        game.changeMap(BuildingTest.getTestMap(true));
        Colony colony = this.getStandardColony(8);
        colony.getOwner().addFather(BuildingTest.spec().getFoundingFather("model.foundingFather.adamSmith"));
        Building building = colony.getBuilding(buildings[0]);
        if (building == null) {
            building = new ServerBuilding(game, colony, buildings[0]);
            colony.addBuilding(building);
        }
        while (building.getType() != buildings[0]) {
            building.upgrade();
        }
        this.clearBuilding(building);
        ProductionType pt = building.getBestProductionType(false, null);
        BuildingTest.assertNotNull((Object)pt);
        CollectionUtils.forEach(pt.getInputs(), ag -> colony.addGoods(ag.getType(), 50));
        GoodsType outputType = CollectionUtils.first(pt.getOutputs()).getType();
        UnitType[] unitTypes = new UnitType[]{indianConvertType, pettyCriminalType, indenturedServantType, freeColonistType, building.getExpertUnitType()};
        Tile tile = colony.getTile();
        for (UnitType ut : unitTypes) {
            if (!CollectionUtils.none(colony.getUnits(), CollectionUtils.matchKey(ut, Unit::getType))) continue;
            Unit u = CollectionUtils.find(colony.getUnits(), CollectionUtils.matchKey(freeColonistType, Unit::getType));
            u.changeType(ut);
        }
        StringBuilder sb = new StringBuilder(64);
        for (int i = 0; i < values.length; ++i) {
            BuildingType bt = buildings[i];
            for (int j = 0; j < values[0].length; ++j) {
                int level = bonusLevels[j];
                for (int k = 0; k < values[0][0].length; ++k) {
                    UnitType ut = unitTypes[k];
                    while (building.getType() != bt) {
                        building.upgrade();
                    }
                    BuildingTest.assertEquals((Object)building.getType(), (Object)bt);
                    this.clearBuilding(building);
                    colony.setProductionBonus(level);
                    Unit worker = CollectionUtils.find(colony.getUnits(), CollectionUtils.matchKey(ut, Unit::getType));
                    BuildingTest.assertNotNull((Object)worker);
                    worker.setWorkType(outputType);
                    worker.setLocation(building);
                    BuildingTest.assertEquals((int)1, (int)building.getUnitCount());
                    BuildingTest.assertEquals((Object)worker, (Object)building.getUnitList().get(0));
                    BuildingTest.assertEquals((Object)outputType, (Object)worker.getWorkType());
                    colony.invalidateCache();
                    BuildingTest.assertEquals((int)colony.getProductionBonus(), (int)level);
                    sb.setLength(0);
                    sb.append(outputType.getSuffix()).append(" produced in ").append(bt.getSuffix()).append(" at bonus ").append(String.valueOf(level)).append(" with ").append(ut.getSuffix());
                    int totalProductionInColony = building.getTotalProductionOf(outputType);
                    BuildingTest.assertEquals((String)sb.toString(), (int)values[i][j][k], (int)totalProductionInColony);
                    if (level != 0) continue;
                    BuildingTest.assertEquals((String)("BuildingType.getPotentialProduction does not match actual production. " + sb.toString()), (int)totalProductionInColony, (int)bt.getPotentialProduction(outputType, ut));
                }
            }
        }
    }

    public void testCanBuildNext() {
        Game game = BuildingTest.getGame();
        game.changeMap(BuildingTest.getTestMap(true));
        Colony colony = this.getStandardColony();
        ServerBuilding warehouse = new ServerBuilding(BuildingTest.getGame(), colony, depotType);
        colony.addBuilding(warehouse);
        BuildingTest.assertTrue((boolean)warehouse.canBuildNext());
        BuildingTest.assertNotNull(warehouse.upgrade());
        BuildingTest.assertTrue((boolean)warehouse.canBuildNext());
        BuildingTest.assertNotNull(warehouse.upgrade());
        BuildingTest.assertFalse((boolean)warehouse.canBuildNext());
        BuildingTest.assertNull(warehouse.upgrade());
        BuildingTest.assertFalse((boolean)warehouse.canBuildNext());
    }

    public void testStockadeRequiresMinimumPopulation() {
        Game game = BuildingTest.getGame();
        game.changeMap(BuildingTest.getTestMap(true));
        Colony colony = this.getStandardColony(2);
        BuildingTest.assertEquals((Object)((Object)Colony.NoBuildReason.POPULATION_TOO_SMALL), (Object)((Object)colony.getNoBuildReason(stockadeType, null)));
        ServerUnit colonist = new ServerUnit(game, colony.getTile(), colony.getOwner(), freeColonistType);
        colonist.setLocation(colony);
        BuildingTest.assertEquals((Object)((Object)Colony.NoBuildReason.NONE), (Object)((Object)colony.getNoBuildReason(stockadeType, null)));
    }

    public void testFortRequiresMinimumPopulation() {
        Game game = BuildingTest.getGame();
        game.changeMap(BuildingTest.getTestMap(true));
        Colony colony = this.getStandardColony(2);
        BuildingTest.assertEquals((Object)((Object)Colony.NoBuildReason.POPULATION_TOO_SMALL), (Object)((Object)colony.getNoBuildReason(fortType, null)));
        ServerUnit colonist = new ServerUnit(game, colony.getTile(), colony.getOwner(), freeColonistType);
        colonist.setLocation(colony);
        colony.addBuilding(new ServerBuilding(game, colony, stockadeType));
        BuildingTest.assertEquals((Object)((Object)Colony.NoBuildReason.NONE), (Object)((Object)colony.getNoBuildReason(fortType, null)));
    }

    public void testFortressRequiresMinimumPopulation() {
        Game game = BuildingTest.getGame();
        game.changeMap(BuildingTest.getTestMap(true));
        Colony colony = this.getStandardColony(7);
        colony.addBuilding(new ServerBuilding(game, colony, stockadeType));
        colony.addBuilding(new ServerBuilding(game, colony, fortType));
        BuildingTest.assertEquals((Object)((Object)Colony.NoBuildReason.POPULATION_TOO_SMALL), (Object)((Object)colony.getNoBuildReason(fortressType, null)));
        ServerUnit colonist = new ServerUnit(game, colony.getTile(), colony.getOwner(), freeColonistType);
        colonist.setLocation(colony);
        BuildingTest.assertEquals((int)8, (int)colony.getUnitCount());
        BuildingTest.assertEquals((Object)((Object)Colony.NoBuildReason.NONE), (Object)((Object)colony.getNoBuildReason(fortressType, null)));
    }

    public void testInitialColony() {
        Game game = BuildingTest.getGame();
        game.changeMap(BuildingTest.getTestMap(true));
        Colony colony = this.getStandardColony();
        Building warehouse = colony.getBuilding(warehouseType);
        BuildingTest.assertTrue((warehouse != null ? 1 : 0) != 0);
        BuildingTest.assertTrue((boolean)warehouse.canBuildNext());
    }

    public void testChurch() {
        Game game = BuildingTest.getGame();
        game.changeMap(BuildingTest.getTestMap(true));
        Colony colony = this.getStandardColony(10);
        while (colony.getProductionBonus() < 0) {
            colony.modifyLiberty(100);
        }
        Unit unit0 = colony.getUnitList().get(0);
        Unit unit1 = colony.getUnitList().get(1);
        Unit unit2 = colony.getUnitList().get(2);
        BuildingTest.assertFalse((boolean)chapelType.hasAbility("model.ability.dressMissionary"));
        BuildingTest.assertFalse((boolean)unit0.hasAbility("model.ability.dressMissionary"));
        BuildingTest.assertFalse((boolean)unit0.roleIsAvailable(missionaryRole));
        Building church = colony.getBuilding(chapelType);
        BuildingTest.assertNotNull((Object)church);
        BuildingTest.assertFalse((boolean)colony.hasAbility("model.ability.dressMissionary"));
        BuildingTest.assertEquals((String)"Chapel base cross production, no unit", (int)1, (int)church.getBaseProduction(null, crossesType, null));
        BuildingTest.assertEquals((String)"Chapel potential cross production, no unit", (int)1, (int)church.getPotentialProduction(crossesType, null));
        BuildingTest.assertEquals((String)"Chapel total cross production, no unit", (int)1, (int)church.getTotalProductionOf(crossesType));
        church.upgrade();
        BuildingTest.assertTrue((boolean)"model.building.church".equals(church.getType().getId()));
        BuildingTest.assertTrue((boolean)church.getType().hasAbility("model.ability.dressMissionary"));
        BuildingTest.assertTrue((boolean)colony.hasAbility("model.ability.dressMissionary"));
        BuildingTest.assertTrue((boolean)unit0.hasAbility("model.ability.dressMissionary"));
        BuildingTest.assertTrue((boolean)unit0.roleIsAvailable(missionaryRole));
        BuildingTest.assertEquals((String)"Church base cross production, no unit", (int)2, (int)church.getBaseProduction(null, crossesType, null));
        BuildingTest.assertEquals((String)"Church potential cross production, no unit", (int)2, (int)church.getPotentialProduction(crossesType, null));
        BuildingTest.assertEquals((String)"Church cross production, no unit", (int)2, (int)church.getTotalProductionOf(crossesType));
        church.setWorkFor(unit0);
        BuildingTest.assertEquals((String)"Church base cross production, free colonist", (int)3, (int)church.getBaseProduction(church.getProductionType(), crossesType, unit0.getType()));
        BuildingTest.assertEquals((String)"Church potential cross production, free colonist", (int)3, (int)church.getPotentialProduction(crossesType, unit0.getType()));
        BuildingTest.assertEquals((String)"Church total cross production, free colonist", (int)5, (int)church.getTotalProductionOf(crossesType));
        church.setWorkFor(unit1);
        BuildingTest.assertEquals((String)"Church base cross production, 2 x free colonist", (int)3, (int)church.getBaseProduction(church.getProductionType(), crossesType, unit1.getType()));
        BuildingTest.assertEquals((String)"Church potential cross production, 2 x free colonist", (int)3, (int)church.getPotentialProduction(crossesType, unit1.getType()));
        BuildingTest.assertEquals((String)"Church total cross production, 2 x free colonist", (int)8, (int)church.getTotalProductionOf(crossesType));
        church.setWorkFor(unit2);
        BuildingTest.assertEquals((String)"Church base cross production, 3 x free colonist", (int)3, (int)church.getBaseProduction(church.getProductionType(), crossesType, unit2.getType()));
        BuildingTest.assertEquals((String)"Church potential cross production, 3 x free colonist", (int)3, (int)church.getPotentialProduction(crossesType, unit2.getType()));
        BuildingTest.assertEquals((String)"Church total cross production, 3 x free colonist", (int)11, (int)church.getTotalProductionOf(crossesType));
        Building smithy = colony.getBuilding(blacksmithHouseType);
        BuildingTest.assertTrue((boolean)unit0.setLocation(smithy));
        BuildingTest.assertTrue((boolean)unit1.setLocation(smithy));
        BuildingTest.assertTrue((boolean)unit2.setLocation(smithy));
        unit0.setType(firebrandPreacherType);
        church.setWorkFor(unit0);
        BuildingTest.assertEquals((String)"Church base cross production, firebrand preacher", (int)3, (int)church.getBaseProduction(church.getProductionType(), crossesType, unit0.getType()));
        BuildingTest.assertEquals((String)"Church potential cross production, firebrand preacher", (int)6, (int)church.getPotentialProduction(crossesType, unit0.getType()));
        BuildingTest.assertEquals((String)"Church total cross production, firebrand preacher", (int)8, (int)church.getTotalProductionOf(crossesType));
        unit0.setType(freeColonistType);
        BuildingTest.assertTrue((boolean)unit0.setLocation(smithy));
        church.upgrade();
        BuildingTest.assertTrue((boolean)"model.building.cathedral".equals(church.getType().getId()));
        BuildingTest.assertTrue((boolean)church.getType().hasAbility("model.ability.dressMissionary"));
        BuildingTest.assertTrue((boolean)colony.hasAbility("model.ability.dressMissionary"));
        BuildingTest.assertTrue((boolean)unit0.hasAbility("model.ability.dressMissionary"));
        BuildingTest.assertTrue((boolean)unit0.roleIsAvailable(missionaryRole));
        BuildingTest.assertEquals((String)"Cathedral base cross production, no unit", (int)3, (int)church.getBaseProduction(null, crossesType, null));
        BuildingTest.assertEquals((String)"Cathedral potential cross production, no unit", (int)3, (int)church.getPotentialProduction(crossesType, null));
        BuildingTest.assertEquals((String)"Cathedral cross production, no colonist", (int)3, (int)church.getTotalProductionOf(crossesType));
        church.setWorkFor(unit0);
        BuildingTest.assertEquals((String)"Cathedral base cross production, free colonist", (int)6, (int)church.getBaseProduction(church.getProductionType(), crossesType, unit0.getType()));
        BuildingTest.assertEquals((String)"Cathedral potential cross production, free colonist", (int)6, (int)church.getPotentialProduction(crossesType, unit0.getType()));
        BuildingTest.assertEquals((String)"Cathedral total cross production, free colonist", (int)9, (int)church.getTotalProductionOf(crossesType));
        church.setWorkFor(unit1);
        BuildingTest.assertEquals((String)"Cathedral base cross production, 2 x free colonist", (int)6, (int)church.getBaseProduction(church.getProductionType(), crossesType, unit1.getType()));
        BuildingTest.assertEquals((String)"Cathedral potential cross production, 2 x free colonist", (int)6, (int)church.getPotentialProduction(crossesType, unit1.getType()));
        BuildingTest.assertEquals((String)"Cathedral total cross production, 2 x free colonist", (int)15, (int)church.getTotalProductionOf(crossesType));
        church.setWorkFor(unit2);
        BuildingTest.assertEquals((String)"Cathedral base cross production, 3 x free colonist", (int)6, (int)church.getBaseProduction(church.getProductionType(), crossesType, unit2.getType()));
        BuildingTest.assertEquals((String)"Cathedral potential cross production, 3 x free colonist", (int)6, (int)church.getPotentialProduction(crossesType, unit2.getType()));
        BuildingTest.assertEquals((String)"Cathedral total cross production, 3 x free colonist", (int)21, (int)church.getTotalProductionOf(crossesType));
        unit0.setLocation(smithy);
        unit1.setLocation(smithy);
        unit2.setLocation(smithy);
        unit0.setType(firebrandPreacherType);
        church.setWorkFor(unit0);
        BuildingTest.assertEquals((String)"Cathedral base cross production, firebrand preacher", (int)6, (int)church.getBaseProduction(church.getProductionType(), crossesType, unit0.getType()));
        BuildingTest.assertEquals((String)"Cathedral potential cross production, firebrand preacher", (int)12, (int)church.getPotentialProduction(crossesType, unit0.getType()));
        BuildingTest.assertEquals((String)"Cathedral total cross production, firebrand preacher", (int)15, (int)church.getTotalProductionOf(crossesType));
    }

    public void testCanAddToBuilding() {
        Game game = BuildingTest.getGame();
        game.changeMap(BuildingTest.getTestMap(true));
        Colony colony = this.getStandardColony(6);
        Tile tile = colony.getTile();
        List<Unit> units = colony.getUnitList();
        for (Unit u : units) {
            if (!(u.getLocation() instanceof Building)) continue;
            u.setLocation(tile);
        }
        for (Building building : colony.getBuildings()) {
            int index;
            if (building.canTeach()) continue;
            int maxUnits = building.getUnitCapacity();
            BuildingTest.assertEquals((int)0, (int)building.getUnitCount());
            for (index = 0; index < maxUnits; ++index) {
                BuildingTest.assertTrue((String)("unable to add unit " + index + " to building type " + building.getType()), (boolean)building.canAdd(units.get(index)));
                building.add(units.get(index));
            }
            BuildingTest.assertFalse((String)("able to add unit " + maxUnits + " to building type " + building.getType()), (boolean)building.canAdd(units.get(maxUnits)));
            for (index = 0; index < maxUnits; ++index) {
                building.remove(building.getUnitList().get(0));
            }
        }
    }

    public void testCanAddToSchool() {
        Game game = BuildingTest.getGame();
        game.changeMap(BuildingTest.getTestMap(true));
        Colony colony = this.getStandardColony(10);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit farmer = units.next();
        farmer.setType(expertFarmerType);
        Unit colonist = units.next();
        colonist.setType(freeColonistType);
        Unit criminal = units.next();
        criminal.setType(pettyCriminalType);
        Unit servant = units.next();
        servant.setType(indenturedServantType);
        Unit indian = units.next();
        indian.setType(indianConvertType);
        Unit distiller = units.next();
        distiller.setType(masterDistillerType);
        Unit elder = units.next();
        elder.setType(elderStatesmanType);
        Unit carpenter = units.next();
        carpenter.setType(masterCarpenterType);
        Building school = colony.getBuilding(schoolType);
        BuildingTest.assertTrue((school == null ? 1 : 0) != 0);
        colony.addBuilding(new ServerBuilding(BuildingTest.getGame(), colony, schoolType));
        school = colony.getBuilding(schoolType);
        BuildingTest.assertTrue((school != null ? 1 : 0) != 0);
        BuildingTest.assertEquals((Object)((Object)UnitLocation.NoAddReason.MINIMUM_SKILL), (Object)((Object)school.getNoAddReason(colonist)));
        BuildingTest.assertFalse((String)"able to add free colonist to Schoolhouse", (boolean)school.canAdd(colonist));
        BuildingTest.assertEquals((Object)((Object)UnitLocation.NoAddReason.MINIMUM_SKILL), (Object)((Object)school.getNoAddReason(criminal)));
        BuildingTest.assertFalse((String)"able to add petty criminal to Schoolhouse", (boolean)school.canAdd(criminal));
        BuildingTest.assertEquals((Object)((Object)UnitLocation.NoAddReason.MINIMUM_SKILL), (Object)((Object)school.getNoAddReason(servant)));
        BuildingTest.assertFalse((String)"able to add indentured servant to Schoolhouse", (boolean)school.canAdd(servant));
        BuildingTest.assertEquals((Object)((Object)UnitLocation.NoAddReason.MINIMUM_SKILL), (Object)((Object)school.getNoAddReason(indian)));
        BuildingTest.assertFalse((String)"able to add indian convert to Schoolhouse", (boolean)school.canAdd(indian));
        BuildingTest.assertEquals((Object)((Object)UnitLocation.NoAddReason.MAXIMUM_SKILL), (Object)((Object)school.getNoAddReason(elder)));
        BuildingTest.assertFalse((String)"able to add elder statesman to Schoolhouse", (boolean)school.canAdd(elder));
        BuildingTest.assertEquals((Object)((Object)UnitLocation.NoAddReason.MAXIMUM_SKILL), (Object)((Object)school.getNoAddReason(distiller)));
        BuildingTest.assertFalse((String)"able to add master distiller to Schoolhouse", (boolean)school.canAdd(distiller));
        BuildingTest.assertTrue((String)"unable to add master farmer to Schoolhouse", (boolean)school.canAdd(farmer));
        farmer.setLocation(school);
        BuildingTest.assertEquals((Object)school, (Object)farmer.getLocation());
        BuildingTest.assertFalse((String)"able to add master carpenter to Schoolhouse", (boolean)school.canAdd(carpenter));
        school.upgrade();
        farmer.setLocation(colony.getTile());
        BuildingTest.assertFalse((String)"able to add free colonist to College", (boolean)school.canAdd(colonist));
        BuildingTest.assertFalse((String)"able to add petty criminal to College", (boolean)school.canAdd(criminal));
        BuildingTest.assertFalse((String)"able to add indentured servant to College", (boolean)school.canAdd(servant));
        BuildingTest.assertFalse((String)"able to add indian convert to College", (boolean)school.canAdd(indian));
        BuildingTest.assertFalse((String)"able to add elder statesman to College", (boolean)school.canAdd(elder));
        BuildingTest.assertTrue((String)"unable to add master distiller to College", (boolean)school.canAdd(distiller));
        distiller.setLocation(school);
        BuildingTest.assertTrue((String)"unable to add master farmer to College", (boolean)school.canAdd(farmer));
        farmer.setLocation(school);
        BuildingTest.assertFalse((String)"able to add master carpenter to College", (boolean)school.canAdd(carpenter));
        school.upgrade();
        BuildingTest.assertEquals((String)school.getType().toString(), (Object)universityType, (Object)school.getType());
        distiller.setLocation(colony.getTile());
        farmer.setLocation(colony.getTile());
        BuildingTest.assertFalse((String)"able to add free colonist to University", (boolean)school.canAdd(colonist));
        BuildingTest.assertFalse((String)"able to add petty criminal to University", (boolean)school.canAdd(criminal));
        BuildingTest.assertFalse((String)"able to add indentured servant to University", (boolean)school.canAdd(servant));
        BuildingTest.assertFalse((String)"able to add indian convert to University", (boolean)school.canAdd(indian));
        BuildingTest.assertTrue((String)"unable to add elder statesman to University", (boolean)school.canAdd(elder));
        elder.setLocation(school);
        BuildingTest.assertTrue((String)"unable to add master distiller to University", (boolean)school.canAdd(distiller));
        distiller.setLocation(school);
        BuildingTest.assertTrue((String)"unable to add master farmer to University", (boolean)school.canAdd(farmer));
        farmer.setLocation(school);
        BuildingTest.assertFalse((String)"able to add master carpenter to University", (boolean)school.canAdd(carpenter));
    }

    public void testSerialize() {
        Game game = BuildingTest.getGame();
        game.changeMap(BuildingTest.getTestMap(true));
        Colony colony = this.getStandardColony(6);
        for (Building building : colony.getBuildings()) {
            try (StringWriter sw = new StringWriter();
                 FreeColXMLWriter xw = new FreeColXMLWriter(sw, FreeColXMLWriter.WriteScope.toSave(), false);){
                building.toXML(xw);
            }
            catch (IOException | XMLStreamException ex) {
                BuildingTest.fail((String)ex.toString());
            }
        }
    }

    public void testStockade() {
        Game game = BuildingTest.getGame();
        game.changeMap(BuildingTest.getTestMap(true));
        Turn turn = game.getTurn();
        Colony colony = this.getStandardColony(2);
        List<Modifier> modifiers = CollectionUtils.toList(colony.getModifiers("model.modifier.defence"));
        BuildingTest.assertEquals((int)1, (int)modifiers.size());
        Modifier modifier = CollectionUtils.first(modifiers);
        BuildingTest.assertEquals((Object)Float.valueOf(50.0f), (Object)Float.valueOf(modifier.getValue()));
        BuildingTest.assertEquals((Object)((Object)Modifier.ModifierType.PERCENTAGE), (Object)((Object)modifier.getType()));
        modifiers = CollectionUtils.toList(stockadeType.getModifiers("model.modifier.defence"));
        BuildingTest.assertEquals((int)1, (int)modifiers.size());
        modifier = CollectionUtils.first(modifiers);
        BuildingTest.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(modifier.getValue()));
        BuildingTest.assertEquals((Object)((Object)Modifier.ModifierType.PERCENTAGE), (Object)((Object)modifier.getType()));
        BuildingTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(stockadeType.apply(0.0f, turn, "model.modifier.minimumColonySize")));
        modifiers = CollectionUtils.toList(fortType.getModifiers("model.modifier.defence"));
        BuildingTest.assertEquals((int)1, (int)modifiers.size());
        modifier = CollectionUtils.first(modifiers);
        BuildingTest.assertEquals((Object)Float.valueOf(150.0f), (Object)Float.valueOf(modifier.getValue()));
        BuildingTest.assertEquals((Object)((Object)Modifier.ModifierType.PERCENTAGE), (Object)((Object)modifier.getType()));
        BuildingTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(stockadeType.apply(0.0f, turn, "model.modifier.minimumColonySize")));
        modifiers = CollectionUtils.toList(fortressType.getModifiers("model.modifier.defence"));
        BuildingTest.assertEquals((int)1, (int)modifiers.size());
        modifier = CollectionUtils.first(modifiers);
        BuildingTest.assertEquals((Object)Float.valueOf(200.0f), (Object)Float.valueOf(modifier.getValue()));
        BuildingTest.assertEquals((Object)((Object)Modifier.ModifierType.PERCENTAGE), (Object)((Object)modifier.getType()));
        BuildingTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(stockadeType.apply(0.0f, turn, "model.modifier.minimumColonySize")));
    }

    public void testCottonClothProduction() {
        Game game = BuildingTest.getGame();
        game.changeMap(BuildingTest.getTestMap(true));
        Colony colony = this.getStandardColony(2);
        List<Unit> units = colony.getUnitList();
        Unit colonist = units.get(0);
        Unit worker = units.get(1);
        Building weaver = colony.getBuilding(weaverHouseType);
        BuildingTest.assertTrue((boolean)(colonist.getLocation() instanceof ColonyTile));
        BuildingTest.assertEquals((Object)plainsType, (Object)colonist.getWorkTile().getType());
        BuildingTest.assertTrue((boolean)(worker.getLocation() instanceof ColonyTile));
        BuildingTest.assertEquals((Object)plainsType, (Object)worker.getWorkTile().getType());
        BuildingTest.assertTrue((boolean)weaver.add(worker));
        BuildingTest.assertEquals((Object)worker, (Object)weaver.getUnitList().get(0));
        colony.addGoods(cottonType, 2);
        colony.invalidateCache();
        BuildingTest.assertEquals((int)2, (int)colony.getTotalProductionOf(cottonType));
        BuildingTest.assertEquals((int)3, (int)weaver.getTotalProductionOf(clothType));
        BuildingTest.assertEquals((int)3, (int)colony.getTotalProductionOf(clothType));
        BuildingTest.assertEquals((int)-1, (int)colony.getNetProductionOf(cottonType));
        BuildingTest.assertEquals((int)3, (int)colony.getNetProductionOf(clothType));
        colonist.changeWorkType(cottonType);
        colony.invalidateCache();
        BuildingTest.assertEquals((int)4, (int)colony.getTotalProductionOf(cottonType));
        colony.addGoods(cottonType, 4);
        BuildingTest.assertEquals((int)3, (int)colony.getTotalProductionOf(clothType));
        BuildingTest.assertEquals((int)1, (int)colony.getNetProductionOf(cottonType));
        BuildingTest.assertEquals((int)3, (int)colony.getNetProductionOf(clothType));
    }

    public void testPasture() {
        Game game = BuildingTest.getGame();
        game.changeMap(BuildingTest.getTestMap(true));
        Colony colony = this.getStandardColony(1);
        Building country = colony.getBuilding(countryType);
        BuildingTest.assertNotNull((Object)country.getProductionType());
        Unit unit = colony.getFirstUnit();
        BuildingTest.assertEquals((Object)grainType, (Object)unit.getWorkType());
        BuildingTest.assertEquals((int)6, (int)colony.getNetProductionOf(foodType));
        BuildingTest.assertEquals((int)0, (int)country.getTotalProductionOf(horsesType));
        BuildingTest.assertEquals((int)0, (int)colony.getNetProductionOf(horsesType));
        BuildingTest.assertEquals((int)0, (int)country.getMaximumProductionOf(horsesType));
        colony.addGoods(horsesType, 50);
        colony.invalidateCache();
        BuildingTest.assertEquals((int)2, (int)country.getTotalProductionOf(horsesType));
        BuildingTest.assertEquals((int)2, (int)country.getMaximumProductionOf(horsesType));
        BuildingTest.assertEquals((int)2, (int)colony.getNetProductionOf(horsesType));
        colony.addGoods(horsesType, 1);
        colony.invalidateCache();
        BuildingTest.assertEquals((int)3, (int)country.getTotalProductionOf(horsesType));
        BuildingTest.assertEquals((int)4, (int)country.getMaximumProductionOf(horsesType));
        BuildingTest.assertEquals((int)3, (int)colony.getNetProductionOf(horsesType));
        country.upgrade();
        colony.removeGoods(horsesType);
        colony.addGoods(horsesType, 25);
        colony.invalidateCache();
        BuildingTest.assertEquals((int)25, (int)colony.getGoodsCount(horsesType));
        BuildingTest.assertEquals((int)2, (int)country.getTotalProductionOf(horsesType));
        BuildingTest.assertEquals((int)2, (int)country.getMaximumProductionOf(horsesType));
        BuildingTest.assertEquals((int)2, (int)colony.getNetProductionOf(horsesType));
        colony.addGoods(horsesType, 1);
        colony.invalidateCache();
        BuildingTest.assertEquals((int)26, (int)colony.getGoodsCount(horsesType));
        BuildingTest.assertEquals((int)3, (int)country.getTotalProductionOf(horsesType));
        BuildingTest.assertEquals((int)4, (int)country.getMaximumProductionOf(horsesType));
        BuildingTest.assertEquals((int)3, (int)colony.getNetProductionOf(horsesType));
        colony.addGoods(horsesType, 24);
        colony.invalidateCache();
        BuildingTest.assertEquals((int)50, (int)colony.getGoodsCount(horsesType));
        BuildingTest.assertEquals((int)3, (int)country.getTotalProductionOf(horsesType));
        BuildingTest.assertEquals((int)4, (int)country.getMaximumProductionOf(horsesType));
        BuildingTest.assertEquals((int)3, (int)colony.getNetProductionOf(horsesType));
        colony.addGoods(horsesType, 1);
        colony.invalidateCache();
        BuildingTest.assertEquals((int)51, (int)colony.getGoodsCount(horsesType));
        BuildingTest.assertEquals((int)3, (int)country.getTotalProductionOf(horsesType));
        BuildingTest.assertEquals((int)6, (int)country.getMaximumProductionOf(horsesType));
        BuildingTest.assertEquals((String)"Horse production should equal food surplus.", (int)colony.getNetProductionOf(foodType), (int)colony.getNetProductionOf(horsesType));
    }

    public void testTownhallProduction() {
        Game game = BuildingTest.getGame();
        game.changeMap(BuildingTest.getTestMap(true));
        Turn turn = game.getTurn();
        Colony colony = this.getStandardColony(6);
        Player owner = colony.getOwner();
        Unit colonist = colony.getUnitList().get(0);
        Unit statesman = colony.getUnitList().get(1);
        statesman.setType(elderStatesmanType);
        Tile tile = colony.getTile();
        Building building = colony.getBuilding(townHallType);
        for (Unit u : building.getUnitList()) {
            u.setLocation(tile);
        }
        BuildingTest.assertTrue((String)"No initial modifiers", (boolean)CollectionUtils.none(colony.getModifiers("model.goods.bells")));
        BuildingTest.assertEquals((String)"Initial bell production", (int)1, (int)building.getTotalProductionOf(bellsType));
        colonist.setLocation(building);
        BuildingTest.assertEquals((String)"Production(Colonist)", (int)3, (int)building.getUnitProduction(colonist, bellsType));
        BuildingTest.assertEquals((String)"Total production(Colonist)", (int)4, (int)building.getTotalProductionOf(bellsType));
        FoundingFather jefferson = BuildingTest.spec().getFoundingFather("model.foundingFather.thomasJefferson");
        List<Modifier> modifiers = CollectionUtils.toList(jefferson.getModifiers("model.goods.bells"));
        BuildingTest.assertEquals((String)"Jefferson modifier size", (int)1, (int)modifiers.size());
        Modifier bellsModifier = CollectionUtils.first(modifiers);
        owner.addFather(jefferson);
        BuildingTest.assertTrue((String)"Jefferson should be present in player", (boolean)CollectionUtils.any(owner.getModifiers("model.goods.bells"), m -> m == bellsModifier));
        BuildingTest.assertTrue((String)"Jefferson should be present in player in building scope", (boolean)CollectionUtils.any(owner.getModifiers("model.goods.bells", townHallType, turn), m -> m == bellsModifier));
        BuildingTest.assertFalse((String)"Jefferson should not be present in player in unit scope", (boolean)CollectionUtils.any(owner.getModifiers("model.goods.bells", freeColonistType, turn), m -> m == bellsModifier));
        BuildingTest.assertFalse((String)"Jefferson modifier should not be present in colony", (boolean)CollectionUtils.any(colony.getModifiers("model.goods.bells"), m -> m == bellsModifier));
        BuildingTest.assertFalse((String)"Jefferson modifier should not be present in building modifiers", (boolean)CollectionUtils.any(building.getModifiers("model.goods.bells"), m -> m == bellsModifier));
        BuildingTest.assertEquals((String)"Production(Colonist/Jefferson)", (int)3, (int)building.getUnitProduction(colonist, bellsType));
        BuildingTest.assertEquals((String)"Total production(Colonist/Jefferson)", (int)6, (int)building.getTotalProductionOf(bellsType));
        statesman.setLocation(building);
        BuildingTest.assertEquals((String)"Production(Statesman/Jefferson)", (int)6, (int)building.getUnitProduction(statesman, bellsType));
        BuildingTest.assertEquals((String)"Total production(Colonist/Statesman/Jefferson)", (int)15, (int)building.getTotalProductionOf(bellsType));
        this.setProductionBonus(colony, 2);
        colony.invalidateCache();
        BuildingTest.assertEquals((String)"Production(Colonist/Jefferson/2)", (int)5, (int)building.getUnitProduction(colonist, bellsType));
        BuildingTest.assertEquals((String)"Production(Statesman/Jefferson/2)", (int)10, (int)building.getUnitProduction(statesman, bellsType));
        BuildingTest.assertEquals((String)"Total production(Colonist/Statesman/Jefferson/2)", (int)24, (int)building.getTotalProductionOf(bellsType));
        ServerBuilding newspaper = new ServerBuilding(BuildingTest.getGame(), colony, newspaperType);
        colony.addBuilding(newspaper);
        colony.invalidateCache();
        BuildingTest.assertEquals((String)"Production(Colonist/Jefferson/2/Newspaper)", (int)5, (int)building.getUnitProduction(colonist, bellsType));
        BuildingTest.assertEquals((String)"Production(Statesman/Jefferson/2/Newspaper)", (int)10, (int)building.getUnitProduction(statesman, bellsType));
        BuildingTest.assertEquals((String)"Total production(Colonist/Statesman/Jefferson/2/Newspaper)", (int)48, (int)building.getTotalProductionOf(bellsType));
    }

    public void testPrintingPressBonus() {
        Game game = BuildingTest.getGame();
        game.changeMap(BuildingTest.getTestMap(true));
        Colony colony = this.getStandardColony(6);
        Unit unit = colony.getUnitList().get(0);
        Building building = colony.getBuilding(townHallType);
        Tile tile = colony.getTile();
        for (Unit u : building.getUnitList()) {
            u.setLocation(tile);
        }
        int bellProduction = building.getTotalProductionOf(bellsType);
        int expectBellProd = 1;
        BuildingTest.assertEquals((String)"Wrong initial bell production", (int)expectBellProd, (int)bellProduction);
        ServerBuilding printingPress = new ServerBuilding(BuildingTest.getGame(), colony, printingPressType);
        colony.addBuilding(printingPress);
        bellProduction = building.getTotalProductionOf(bellsType);
        expectBellProd = 1;
        BuildingTest.assertEquals((String)"Wrong bell production with printing press", (int)expectBellProd, (int)bellProduction);
        unit.setLocation(building);
        bellProduction = building.getTotalProductionOf(bellsType);
        expectBellProd = 6;
        BuildingTest.assertEquals((String)"Wrong final bell production", (int)expectBellProd, (int)bellProduction);
    }

    public void testNewspaperBonus() {
        Game game = BuildingTest.getGame();
        game.changeMap(BuildingTest.getTestMap(true));
        Colony colony = this.getStandardColony(6);
        Unit unit = colony.getUnitList().get(0);
        Building building = colony.getBuilding(townHallType);
        this.clearWorkLocation(building);
        int bellProduction = building.getTotalProductionOf(bellsType);
        int expectBellProd = 1;
        BuildingTest.assertEquals((String)"Wrong initial bell production", (int)expectBellProd, (int)bellProduction);
        ServerBuilding newspaper = new ServerBuilding(BuildingTest.getGame(), colony, newspaperType);
        colony.addBuilding(newspaper);
        colony.invalidateCache();
        bellProduction = building.getTotalProductionOf(bellsType);
        expectBellProd = 2;
        BuildingTest.assertEquals((String)"Wrong bell production with newspaper", (int)expectBellProd, (int)bellProduction);
        unit.setLocation(building);
        bellProduction = building.getTotalProductionOf(bellsType);
        expectBellProd = 8;
        BuildingTest.assertEquals((String)"Wrong final bell production", (int)expectBellProd, (int)bellProduction);
    }

    public void testUnitProduction() {
        Game game = BuildingTest.getGame();
        game.changeMap(BuildingTest.getTestMap(true));
        Colony colony = this.getStandardColony(4);
        Unit unit = colony.getUnitList().get(0);
        for (Building building : colony.getBuildings()) {
            this.clearWorkLocation(building);
            unit.setLocation(building);
            for (AbstractGoods output : CollectionUtils.iterable(building.getOutputs())) {
                GoodsType outputType = output.getType();
                for (UnitType type : CollectionUtils.transform(BuildingTest.spec().getUnitTypeList(), ut -> building.getType().canAdd((UnitType)ut) && ut.isAvailableTo(colony.getOwner()))) {
                    int expect;
                    unit.changeType(type);
                    if (output == null) continue;
                    int productivity = building.getUnitProduction(unit, outputType);
                    int n = type == building.getExpertUnitType() ? 6 : (type == indenturedServantType ? 2 : (type == indianConvertType ? 1 : (expect = type == pettyCriminalType ? 1 : output.getAmount())));
                    if (expect != output.getAmount()) {
                        BuildingTest.assertTrue((String)"Modifiers expected", (CollectionUtils.count(type.getModifiers(outputType.getId())) > 0 ? 1 : 0) != 0);
                    }
                    BuildingTest.assertEquals((String)("Wrong productivity for " + type + " in " + building), (int)expect, (int)productivity);
                }
            }
        }
    }

    public void testLumberProduction() {
        this.productionTest(lumberBuildings, lumberProd);
    }

    public void testCrossProduction() {
        this.productionTest(crossBuildings, crossProd);
    }

    public void testFactoryProduction() {
        this.productionTest(clothBuildings, factoryProd);
        this.productionTest(clothBuildings, factoryProd);
        this.productionTest(sugarBuildings, factoryProd);
        this.productionTest(tobaccoBuildings, factoryProd);
        this.productionTest(toolBuildings, factoryProd);
        this.productionTest(musketBuildings, factoryProd);
    }

    public void testToolsMusketProduction() {
        Game game = BuildingTest.getGame();
        game.changeMap(BuildingTest.getTestMap(true));
        Colony colony = this.getStandardColony(8);
        Tile tile = colony.getTile();
        List<Unit> units = colony.getUnitList();
        BuildingTest.assertEquals((int)8, (int)units.size());
        colony.addGoods(bellsType, 600);
        units.get(0).setLocation(tile);
        units.get(1).setLocation(tile);
        units.get(2).setLocation(tile);
        units.get(3).setLocation(tile);
        BuildingTest.assertTrue((boolean)colony.getColonyTile(tile.getNeighbourOrNull(Direction.N)).setWorkFor(units.get(4)));
        BuildingTest.assertTrue((boolean)colony.getColonyTile(tile.getNeighbourOrNull(Direction.E)).setWorkFor(units.get(5)));
        BuildingTest.assertTrue((boolean)colony.getColonyTile(tile.getNeighbourOrNull(Direction.S)).setWorkFor(units.get(6)));
        BuildingTest.assertTrue((boolean)colony.getBuilding(townHallType).setWorkFor(units.get(7)));
        Building smithy = colony.getBuilding(blacksmithHouseType);
        BuildingTest.assertFalse((boolean)smithy.setWorkFor(units.get(0)));
        colony.addGoods(oreType, 50);
        BuildingTest.assertTrue((boolean)smithy.setWorkFor(units.get(0)));
        BuildingTest.assertTrue((boolean)smithy.setWorkFor(units.get(1)));
        ServerBuilding armory = new ServerBuilding(game, colony, armoryType);
        colony.addBuilding(armory);
        colony.invalidateCache();
        BuildingTest.assertTrue((boolean)armory.setWorkFor(units.get(2)));
        BuildingTest.assertTrue((boolean)armory.setWorkFor(units.get(3)));
        BuildingTest.assertEquals((Object)toolsType, (Object)units.get(0).getWorkType());
        BuildingTest.assertEquals((Object)toolsType, (Object)units.get(1).getWorkType());
        BuildingTest.assertEquals((Object)musketsType, (Object)units.get(2).getWorkType());
        BuildingTest.assertEquals((Object)musketsType, (Object)units.get(3).getWorkType());
        BuildingTest.assertEquals((int)6, (int)smithy.getTotalProductionOf(toolsType));
        BuildingTest.assertEquals((int)6, (int)armory.getTotalProductionOf(musketsType));
        smithy.upgrade();
        armory.upgrade();
        colony.invalidateCache();
        BuildingTest.assertEquals((Object)toolsType, (Object)units.get(0).getWorkType());
        BuildingTest.assertEquals((Object)toolsType, (Object)units.get(1).getWorkType());
        BuildingTest.assertEquals((Object)musketsType, (Object)units.get(2).getWorkType());
        BuildingTest.assertEquals((Object)musketsType, (Object)units.get(3).getWorkType());
        BuildingTest.assertEquals((int)12, (int)smithy.getTotalProductionOf(toolsType));
        BuildingTest.assertEquals((int)12, (int)armory.getTotalProductionOf(musketsType));
        colony.getOwner().addFather(BuildingTest.spec().getFoundingFather("model.foundingFather.adamSmith"));
        smithy.upgrade();
        armory.upgrade();
        colony.invalidateCache();
        BuildingTest.assertEquals((Object)toolsType, (Object)units.get(0).getWorkType());
        BuildingTest.assertEquals((Object)toolsType, (Object)units.get(1).getWorkType());
        BuildingTest.assertEquals((Object)musketsType, (Object)units.get(2).getWorkType());
        BuildingTest.assertEquals((Object)musketsType, (Object)units.get(3).getWorkType());
        BuildingTest.assertEquals((int)18, (int)smithy.getTotalProductionOf(toolsType));
        BuildingTest.assertEquals((int)18, (int)armory.getTotalProductionOf(musketsType));
    }
}

