/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class SetDestinationMessage
extends AttributeMessage {
    public static final String TAG = "setDestination";
    private static final String DESTINATION_TAG = "destination";
    private static final String UNIT_TAG = "unit";

    public SetDestinationMessage(Unit unit, Location destination) {
        super(TAG, UNIT_TAG, unit.getId(), DESTINATION_TAG, destination == null ? null : destination.getId());
    }

    public SetDestinationMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, DESTINATION_TAG);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Unit unit;
        ServerGame game = freeColServer.getGame();
        String unitId = this.getStringAttribute(UNIT_TAG);
        String destinationId = this.getStringAttribute(DESTINATION_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        Location destination = destinationId == null ? null : game.findFreeColLocation(destinationId);
        return this.igc(freeColServer).setDestination(serverPlayer, unit, destination);
    }
}

