/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.logging.Logger;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.CloseMessage;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.TimedSession;

public class NativeDemandSession
extends TimedSession {
    private static final Logger logger = Logger.getLogger(NativeDemandSession.class.getName());
    private Unit unit;
    private Colony colony;
    private GoodsType type;
    private int amount;

    public NativeDemandSession(Unit unit, Colony colony, GoodsType goodsType, int amount, long timeout) {
        super(NativeDemandSession.makeSessionKey(NativeDemandSession.class, unit, colony), timeout);
        this.unit = unit;
        this.colony = colony;
        this.type = goodsType;
        this.amount = amount;
    }

    private ServerPlayer getColonyOwner() {
        return (ServerPlayer)this.colony.getOwner();
    }

    private ServerPlayer getUnitOwner() {
        return (ServerPlayer)this.unit.getOwner();
    }

    private ServerGame getGame() {
        return (ServerGame)this.unit.getGame();
    }

    private void completeInternal(boolean result, ChangeSet cs) {
        ServerPlayer demandPlayer = this.getUnitOwner();
        ServerPlayer colonyPlayer = this.getColonyOwner();
        colonyPlayer.csCompleteNativeDemand(demandPlayer, this.unit, this.colony, this.type, this.amount, result ? Constants.IndianDemandAction.INDIAN_DEMAND_ACCEPT : Constants.IndianDemandAction.INDIAN_DEMAND_REJECT, cs);
    }

    public boolean complete(boolean result, ChangeSet cs) {
        boolean ret = super.complete(cs);
        if (!ret) {
            this.completeInternal(result, cs);
        }
        return ret;
    }

    @Override
    protected boolean complete(boolean result) {
        ChangeSet cs = new ChangeSet();
        boolean ret = super.complete(cs);
        if (!ret) {
            this.completeInternal(result, cs);
            cs.add(ChangeSet.See.only(this.getColonyOwner()), new CloseMessage("net.sf.freecol.client.gui.dialog.NativeDemandDialog"));
            this.getGame().sendToAll(cs);
        }
        return ret;
    }

    @Override
    public boolean complete(ChangeSet cs) {
        boolean ret = super.complete(cs);
        if (!ret) {
            this.completeInternal(false, cs);
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append('[').append(this.getClass()).append(" unit=").append(this.unit).append(" colony=").append(this.colony).append(" goods=").append(this.amount).append(' ').append(this.type.getSuffix()).append(']');
        return sb.toString();
    }
}

