/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state.configuration;

import java.io.IOException;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.state.AbstractStateCommand;
import org.jboss.galleon.cli.cmd.state.configuration.ProvisionedConfigurationCompleter;
import org.jboss.galleon.cli.cmd.state.configuration.ResetConfigCommandActivator;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.cli.path.FeatureContainerPathConsumer;
import org.jboss.galleon.cli.path.PathConsumerException;
import org.jboss.galleon.cli.path.PathParser;
import org.jboss.galleon.cli.path.PathParserException;

@CommandDefinition(name="reset-config", description="Reset a configuration to its default state", activator=ResetConfigCommandActivator.class)
public class StateResetConfigCommand
extends AbstractStateCommand {
    @Argument(required=true, description="Configuration full name (<model>/<name>)", completer=ProvisionedConfigurationCompleter.class)
    private String configuration;

    @Override
    protected void runCommand(PmCommandInvocation invoc, State state) throws IOException, ProvisioningException, CommandExecutionException {
        try {
            state.resetConfiguration(invoc.getPmSession(), this.getConfiguration(state));
        }
        catch (Exception ex) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.resetConfigFailed(), ex);
        }
    }

    protected ConfigInfo getConfiguration(State state) throws PathParserException, PathConsumerException, ProvisioningException, Exception {
        String path = "/configs/final/" + this.configuration + "/";
        FeatureContainerPathConsumer consumer = new FeatureContainerPathConsumer(state.getContainer(), false);
        PathParser.parse(path, consumer);
        ConfigInfo ci = consumer.getConfig();
        if (ci == null) {
            throw new ProvisioningException("Not a valid config " + this.configuration);
        }
        return ci;
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.EDITING;
    }
}

