/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.creator;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeatureGroup;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.creator.FeaturePackCreator;
import org.jboss.galleon.creator.PackageBuilder;
import org.jboss.galleon.creator.tasks.FsTaskContext;
import org.jboss.galleon.creator.tasks.FsTaskList;
import org.jboss.galleon.plugin.InstallPlugin;
import org.jboss.galleon.spec.ConfigLayerSpec;
import org.jboss.galleon.spec.FeaturePackPlugin;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.LayoutUtils;
import org.jboss.galleon.util.ZipUtils;
import org.jboss.galleon.xml.ConfigLayerXmlWriter;
import org.jboss.galleon.xml.ConfigXmlWriter;
import org.jboss.galleon.xml.FeatureGroupXmlWriter;
import org.jboss.galleon.xml.FeaturePackXmlWriter;
import org.jboss.galleon.xml.FeatureSpecXmlWriter;

public class FeaturePackBuilder {
    private final FeaturePackCreator creator;
    private final FeaturePackSpec.Builder fpBuilder = FeaturePackSpec.builder();
    private List<PackageBuilder> pkgs = Collections.emptyList();
    private Set<Class<?>> classes = Collections.emptySet();
    private Map<String, Set<String>> services = Collections.emptyMap();
    private String pluginFileName = "plugins.jar";
    private Set<Path> plugins = Collections.emptySet();
    private Map<String, FeatureSpec> specs = Collections.emptyMap();
    private Map<String, FeatureGroup> featureGroups = Collections.emptyMap();
    private Map<ConfigId, ConfigModel> configs = Collections.emptyMap();
    private Map<ConfigId, ConfigLayerSpec> layers = Collections.emptyMap();
    private FsTaskList tasks;

    FeaturePackBuilder(FeaturePackCreator creator) {
        this.creator = creator;
    }

    public FeaturePackCreator getCreator() {
        return this.creator;
    }

    public FeaturePackBuilder setFPID(FeaturePackLocation.FPID fpid) {
        this.fpBuilder.setFPID(fpid);
        return this;
    }

    public FeaturePackBuilder setPatchFor(FeaturePackLocation.FPID fpid) {
        this.fpBuilder.setPatchFor(fpid);
        return this;
    }

    public FeaturePackBuilder setDefaultUniverse(String factory, String location) throws ProvisioningDescriptionException {
        this.fpBuilder.setDefaultUniverse(factory, location);
        return this;
    }

    public FeaturePackBuilder addUniverse(String name, String factory, String location) throws ProvisioningDescriptionException {
        this.fpBuilder.addUniverse(name, factory, location);
        return this;
    }

    public FeaturePackBuilder addDependency(String origin, FeaturePackConfig dep) throws ProvisioningDescriptionException {
        this.fpBuilder.addFeaturePackDep(origin, dep);
        return this;
    }

    public FeaturePackBuilder addDependency(FeaturePackLocation fpl) throws ProvisioningDescriptionException {
        return this.addDependency(FeaturePackConfig.forLocation(fpl));
    }

    public FeaturePackBuilder addDependency(FeaturePackConfig dep) throws ProvisioningDescriptionException {
        if (dep.isTransitive()) {
            this.fpBuilder.addFeaturePackDep(dep);
            return this;
        }
        return this.addDependency(null, dep);
    }

    public FeaturePackBuilder addDependency(String origin, FeaturePackLocation fpl) throws ProvisioningDescriptionException {
        return this.addDependency(origin, FeaturePackConfig.forLocation(fpl));
    }

    public FeaturePackBuilder addTransitiveDependency(FeaturePackLocation fpl) throws ProvisioningDescriptionException {
        this.fpBuilder.addTransitiveDep(fpl);
        return this;
    }

    public FeaturePackBuilder addPackage(PackageBuilder pkg) {
        this.pkgs = CollectionUtils.add(this.pkgs, pkg);
        return this;
    }

    public PackageBuilder newPackage(String name) {
        return this.newPackage(name, false);
    }

    public PackageBuilder newPackage(String name, boolean isDefault) {
        PackageBuilder pkg = PackageBuilder.newInstance(this, name);
        if (isDefault) {
            pkg.setDefault();
        }
        this.addPackage(pkg);
        return pkg;
    }

    public FeaturePackBuilder addFeatureSpec(FeatureSpec spec) throws ProvisioningDescriptionException {
        if (this.specs.isEmpty()) {
            this.specs = new HashMap<String, FeatureSpec>();
        }
        if (this.specs.put(spec.getName(), spec) != null) {
            throw new ProvisioningDescriptionException("Feature-pack " + this.fpBuilder.getFPID() + ": duplicate spec name " + spec.getName());
        }
        return this;
    }

    public FeaturePackBuilder addFeatureGroup(FeatureGroup featureGroup) throws ProvisioningDescriptionException {
        if (this.featureGroups.isEmpty()) {
            this.featureGroups = new HashMap<String, FeatureGroup>();
        }
        if (this.featureGroups.put(featureGroup.getName(), featureGroup) != null) {
            throw new ProvisioningDescriptionException("Feature-pack " + this.fpBuilder.getFPID() + ": duplicate feature-group name " + featureGroup.getName());
        }
        return this;
    }

    public FeaturePackBuilder addConfig(ConfigModel config) throws ProvisioningDescriptionException {
        return this.addConfig(config, !config.getId().isModelOnly());
    }

    public FeaturePackBuilder addConfig(ConfigModel config, boolean asDefault) throws ProvisioningDescriptionException {
        ConfigId id = config.getId();
        if (asDefault && id.isModelOnly()) {
            throw new ProvisioningDescriptionException("Feature-pack " + this.fpBuilder.getFPID() + ": model-only config can not be added as the default one");
        }
        if (this.configs.isEmpty()) {
            this.configs = new HashMap<ConfigId, ConfigModel>();
        }
        if (this.configs.put(id, config) != null) {
            throw new ProvisioningDescriptionException("Feature-pack " + this.fpBuilder.getFPID() + ": duplicate config " + id);
        }
        if (asDefault) {
            this.fpBuilder.addConfig(ConfigModel.builder(id.getModel(), id.getName()).build());
        }
        return this;
    }

    public FeaturePackBuilder addConfigLayer(ConfigLayerSpec layer) throws ProvisioningDescriptionException {
        if (this.layers.isEmpty()) {
            this.layers = new HashMap<ConfigId, ConfigLayerSpec>();
        }
        if (this.layers.put(layer.getId(), layer) != null) {
            throw new ProvisioningDescriptionException("Feature-pack " + this.fpBuilder.getFPID() + ": duplicate layer " + layer.getId());
        }
        return this;
    }

    public FeaturePackBuilder setPluginFileName(String pluginFileName) {
        this.pluginFileName = pluginFileName;
        return this;
    }

    public FeaturePackBuilder addClassToPlugin(Class<?> cls) {
        this.classes = CollectionUtils.add(this.classes, cls);
        return this;
    }

    public FeaturePackBuilder addPlugin(Path file) {
        this.plugins = CollectionUtils.add(this.plugins, file);
        return this;
    }

    public FeaturePackBuilder addPlugin(String id, String location) {
        return this.addPlugin(FeaturePackPlugin.getInstance(id, location));
    }

    public FeaturePackBuilder addPlugin(FeaturePackPlugin plugin) {
        this.fpBuilder.addPlugin(plugin);
        return this;
    }

    public FeaturePackBuilder addSystemPaths(String systemPath) {
        this.fpBuilder.addSystemPaths(systemPath);
        return this;
    }

    public FeaturePackBuilder addPlugin(Class<? extends InstallPlugin> pluginCls) {
        return this.addService(InstallPlugin.class, pluginCls);
    }

    public FeaturePackBuilder addService(Class<?> serviceInterface, Class<?> serviceImpl) {
        String serviceName = serviceInterface.getName();
        Set<String> implSet = this.services.get(serviceName);
        if (implSet == null) {
            this.services = CollectionUtils.put(this.services, serviceName, Collections.singleton(serviceImpl.getName()));
        } else {
            if (implSet.contains(serviceImpl.getName())) {
                return this;
            }
            if (implSet.size() == 1) {
                implSet = new HashSet<String>(implSet);
                implSet.add(serviceImpl.getName());
                if (this.services.size() == 1) {
                    this.services = Collections.singletonMap(serviceName, implSet);
                } else {
                    this.services.put(serviceName, implSet);
                }
            } else {
                implSet.add(serviceImpl.getName());
            }
        }
        this.addClassToPlugin(serviceImpl);
        return this;
    }

    public FeaturePackBuilder writeResources(String relativePath, String content) throws ProvisioningDescriptionException {
        if (this.tasks == null) {
            this.tasks = FsTaskList.newList();
        }
        this.tasks.write(content, relativePath, false);
        return this;
    }

    void build() throws ProvisioningException {
        FeaturePackLocation fps = this.fpBuilder.getFPID().getLocation();
        if (fps == null) {
            throw new ProvisioningDescriptionException("Feature-pack location has not been set");
        }
        if (fps.getProducerName() == null) {
            throw new ProvisioningDescriptionException("Feature-pack producer has not been set");
        }
        if (fps.getBuild() == null) {
            throw new ProvisioningDescriptionException("Feature-pack build number has not been set");
        }
        Path fpWorkDir = LayoutUtils.getFeaturePackDir(this.creator.getWorkDir(), fps.getFPID(), false);
        try {
            FeaturePackBuilder.ensureDir(fpWorkDir);
            for (PackageBuilder packageBuilder : this.pkgs) {
                Iterator<FeatureGroup> pkgDescr = packageBuilder.build(fpWorkDir);
                if (!packageBuilder.isDefault()) continue;
                this.fpBuilder.addDefaultPackage(((PackageSpec)((Object)pkgDescr)).getName());
            }
            if (!this.specs.isEmpty()) {
                Path featuresDir = fpWorkDir.resolve("features");
                FeatureSpecXmlWriter featureSpecXmlWriter = FeatureSpecXmlWriter.getInstance();
                for (FeatureSpec spec : this.specs.values()) {
                    Path featureDir = featuresDir.resolve(spec.getName());
                    FeaturePackBuilder.ensureDir(featureDir);
                    featureSpecXmlWriter.write(spec, featureDir.resolve("spec.xml"));
                }
            }
            if (!this.featureGroups.isEmpty()) {
                Path fgsDir = fpWorkDir.resolve("feature_groups");
                FeaturePackBuilder.ensureDir(fgsDir);
                FeatureGroupXmlWriter featureGroupXmlWriter = FeatureGroupXmlWriter.getInstance();
                for (FeatureGroup fg : this.featureGroups.values()) {
                    featureGroupXmlWriter.write(fg, fgsDir.resolve(fg.getName() + ".xml"));
                }
            }
            if (!this.classes.isEmpty()) {
                FeaturePackBuilder.createPluginJar(this.classes, this.services, fpWorkDir.resolve("plugins").resolve(this.pluginFileName));
            }
            if (!this.plugins.isEmpty()) {
                Iterator<ConfigModel> pluginsDir = fpWorkDir.resolve("plugins");
                FeaturePackBuilder.ensureDir((Path)((Object)pluginsDir));
                for (Path plugin : this.plugins) {
                    Files.copy(plugin, pluginsDir.resolve(plugin.getFileName()), new CopyOption[0]);
                }
            }
            if (!this.layers.isEmpty()) {
                for (Map.Entry entry : this.layers.entrySet()) {
                    ConfigId id = (ConfigId)entry.getKey();
                    Path xml = LayoutUtils.getLayerSpecXml(fpWorkDir, id.getModel(), id.getName(), false);
                    if (Files.exists(xml, new LinkOption[0])) {
                        throw new ProvisioningException("Failed to create feature-pack: " + xml + " already exists");
                    }
                    ConfigLayerXmlWriter.getInstance().write((ConfigLayerSpec)entry.getValue(), xml);
                }
            }
            if (!this.configs.isEmpty()) {
                for (ConfigModel configModel : this.configs.values()) {
                    Path modelXml = LayoutUtils.getConfigXml(fpWorkDir, configModel.getId(), false);
                    if (Files.exists(modelXml, new LinkOption[0])) {
                        throw new ProvisioningException("Failed to create feature-pack: " + modelXml + " already exists");
                    }
                    ConfigXmlWriter.getInstance().write(configModel, modelXml);
                }
            }
            FeaturePackSpec fpSpec = this.fpBuilder.build();
            FeaturePackXmlWriter writer = FeaturePackXmlWriter.getInstance();
            writer.write(fpSpec, fpWorkDir.resolve("feature-pack.xml"));
            if (this.tasks != null && !this.tasks.isEmpty()) {
                this.tasks.execute(FsTaskContext.builder().setTargetRoot(fpWorkDir.resolve("resources")).build());
            }
            this.creator.install(fps.getFPID(), fpWorkDir);
        }
        catch (ProvisioningDescriptionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            IoUtils.recursiveDelete(fpWorkDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPluginJar(Set<Class<?>> classes, Map<String, Set<String>> services, Path target) throws IOException {
        Path tmpDir = IoUtils.createRandomTmpDir();
        try {
            byte[] bytes = new byte[65536];
            for (Class<?> cls : classes) {
                Path p = tmpDir;
                String[] parts = cls.getName().split("\\.");
                int i = 0;
                while (i < parts.length - 1) {
                    p = p.resolve(parts[i++]);
                }
                p = p.resolve(parts[i] + ".class");
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                InputStream is = cls.getClassLoader().getResourceAsStream(tmpDir.relativize(p).toString());
                if (is == null) {
                    throw new IOException("Failed to locate " + tmpDir.relativize(p));
                }
                try {
                    OutputStream os = Files.newOutputStream(p, new OpenOption[0]);
                    try {
                        int rc;
                        while ((rc = is.read(bytes)) != -1) {
                            os.write(bytes, 0, rc);
                        }
                        os.flush();
                    }
                    finally {
                        if (os == null) continue;
                        os.close();
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException os) {}
                }
            }
            if (!services.isEmpty()) {
                Path servicesDir = tmpDir.resolve("META-INF").resolve("services");
                Files.createDirectories(servicesDir, new FileAttribute[0]);
                for (Map.Entry<String, Set<String>> entry : services.entrySet()) {
                    Path service = servicesDir.resolve(entry.getKey());
                    try (BufferedWriter writer = Files.newBufferedWriter(service, new OpenOption[0]);){
                        for (String impl : entry.getValue()) {
                            writer.write(impl);
                            writer.newLine();
                        }
                    }
                }
            }
            FeaturePackBuilder.ensureDir(target.getParent());
            ZipUtils.zip(tmpDir, target);
        }
        finally {
            IoUtils.recursiveDelete(tmpDir);
        }
    }

    private static void ensureDir(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IllegalStateException(dir + " is not a directory.");
        }
    }
}

