/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util;

import java.util.Map;
import java.util.Set;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class ParsingUtils {
    public static String getNextElement(XMLStreamReader reader, String name, Map<String, String> attributes, boolean getElementText) throws XMLStreamException {
        if (!reader.hasNext()) {
            throw new XMLStreamException("Expected more elements", reader.getLocation());
        }
        int type = reader.next();
        while (reader.hasNext() && type != 1) {
            type = reader.next();
        }
        if (reader.getEventType() != 1) {
            throw new XMLStreamException("No <" + name + "> found");
        }
        if (!reader.getLocalName().equals(name)) {
            throw new XMLStreamException("<" + name + "> expected", reader.getLocation());
        }
        if (attributes != null) {
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attr = reader.getAttributeLocalName(i);
                if (!attributes.containsKey(attr)) {
                    throw new XMLStreamException("Unexpected attribute " + attr, reader.getLocation());
                }
                attributes.put(attr, reader.getAttributeValue(i));
            }
        }
        return getElementText ? reader.getElementText() : null;
    }

    public static void parseNoContent(XMLStreamReader reader) throws XMLStreamException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    public static void parseNoAttributes(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() != 0) {
            throw ParsingUtils.unexpectedContent(reader);
        }
    }

    public static XMLStreamException unexpectedContent(XMLStreamReader reader) {
        String kind;
        switch (reader.getEventType()) {
            case 10: {
                kind = "attribute";
                break;
            }
            case 12: {
                kind = "cdata";
                break;
            }
            case 4: {
                kind = "characters";
                break;
            }
            case 5: {
                kind = "comment";
                break;
            }
            case 11: {
                kind = "dtd";
                break;
            }
            case 8: {
                kind = "document end";
                break;
            }
            case 2: {
                kind = "element end";
                break;
            }
            case 15: {
                kind = "entity declaration";
                break;
            }
            case 9: {
                kind = "entity ref";
                break;
            }
            case 13: {
                kind = "namespace";
                break;
            }
            case 14: {
                kind = "notation declaration";
                break;
            }
            case 3: {
                kind = "processing instruction";
                break;
            }
            case 6: {
                kind = "whitespace";
                break;
            }
            case 7: {
                kind = "document start";
                break;
            }
            case 1: {
                kind = "element start";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        return new XMLStreamException("unexpected content: " + kind + (reader.hasName() ? reader.getName() : null) + (reader.hasText() ? reader.getText() : null), reader.getLocation());
    }

    public static XMLStreamException endOfDocument(Location location) {
        return new XMLStreamException("Unexpected end of document ", location);
    }

    public static XMLStreamException missingAttributes(Location location, Set<? extends XmlNameProvider> requiredAttributes) {
        StringBuilder b = new StringBuilder("Missing required attributes");
        for (XmlNameProvider xmlNameProvider : requiredAttributes) {
            b.append(' ').append(xmlNameProvider.getLocalName());
        }
        return new XMLStreamException(b.toString(), location);
    }

    public static XMLStreamException missingOneOfAttributes(Location location, XmlNameProvider ... attrs) {
        StringBuilder b = new StringBuilder("Missing one of required attributes");
        for (XmlNameProvider attribute : attrs) {
            b.append(' ').append(attribute.getLocalName());
        }
        return new XMLStreamException(b.toString(), location);
    }

    public static String wildcardToJavaRegexp(String expr) {
        if (expr == null) {
            throw new IllegalArgumentException("expr is null");
        }
        String regex = expr.replaceAll("([(){}\\[\\].+^$])", "\\\\$1");
        regex = regex.replaceAll("\\*", ".*");
        regex = regex.replaceAll("\\?", ".");
        return regex;
    }

    public static XMLStreamException unexpectedAttribute(XMLExtendedStreamReader reader, int index) {
        return new XMLStreamException(String.format("Unexpected attribute '%s' encountered", reader.getAttributeName(index)), reader.getLocation());
    }

    public static XMLStreamException expectedAtLeastOneChild(XMLExtendedStreamReader reader, XmlNameProvider parent, XmlNameProvider ... child) {
        StringBuilder buf = new StringBuilder("The content of element '").append(parent.getLocalName()).append("' is not complete. One of ");
        XmlNameProvider c = child[0];
        buf.append('\'').append(c.getLocalName()).append('\'');
        if (child.length > 1) {
            for (int i = 1; i < child.length; ++i) {
                buf.append(", '").append(child[i].getLocalName()).append('\'');
            }
        }
        buf.append(" is expected.");
        return new XMLStreamException(buf.toString(), reader.getLocation());
    }

    public static String error(String msg, Location location) {
        return "ParseError at [row,col]:[" + location.getLineNumber() + "," + location.getColumnNumber() + "]\nMessage: " + msg;
    }

    public static XMLStreamException error(String string, Location location, Throwable e) {
        return new XMLStreamException(ParsingUtils.error(string, location), e);
    }
}

