/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.FileLogWriter;
import net.i2p.util.I2PAppThread;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.LogConsoleBuffer;
import net.i2p.util.LogLimit;
import net.i2p.util.LogRecord;
import net.i2p.util.LogRecordFormatter;
import net.i2p.util.LogWriter;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SystemVersion;

public class LogManager
implements Flushable {
    public static final String CONFIG_LOCATION_PROP = "loggerConfigLocation";
    public static final String FILENAME_OVERRIDE_PROP = "loggerFilenameOverride";
    public static final String CONFIG_LOCATION_DEFAULT = "logger.config";
    public static final char DATE = 'd';
    public static final char CLASS = 'c';
    public static final char THREAD = 't';
    public static final char PRIORITY = 'p';
    public static final char MESSAGE = 'm';
    public static final String PROP_FORMAT = "logger.format";
    public static final String PROP_DATEFORMAT = "logger.dateFormat";
    public static final String PROP_FILENAME = "logger.logFileName";
    public static final String PROP_FILESIZE = "logger.logFileSize";
    public static final String PROP_ROTATIONLIMIT = "logger.logRotationLimit";
    public static final String PROP_DISPLAYONSCREEN = "logger.displayOnScreen";
    public static final String PROP_CONSOLEBUFFERSIZE = "logger.consoleBufferSize";
    public static final String PROP_DISPLAYONSCREENLEVEL = "logger.minimumOnScreenLevel";
    public static final String PROP_DEFAULTLEVEL = "logger.defaultLevel";
    private static final String PROP_LOG_BUFFER_SIZE = "logger.logBufferSize";
    private static final String PROP_DROP = "logger.dropOnOverflow";
    private static final String PROP_DUP = "logger.dropDuplicates";
    private static final String PROP_FLUSH = "logger.flushInterval";
    private static final String PROP_GZIP = "logger.gzip";
    private static final String PROP_MIN_GZIP_SIZE = "logger.minGzipSize";
    public static final String PROP_RECORD_PREFIX = "logger.record.";
    public static final String DEFAULT_FORMAT = "d p [t] c: m";
    public static final String DEFAULT_DATEFORMAT = "";
    public static final String DEFAULT_FILENAME = "logs/log-@.txt";
    public static final String DEFAULT_FILESIZE = "10m";
    public static final boolean DEFAULT_DISPLAYONSCREEN = true;
    public static final int DEFAULT_CONSOLEBUFFERSIZE = 20;
    public static final String DEFAULT_ROTATIONLIMIT = "2";
    public static final String DEFAULT_DEFAULTLEVEL = "ERROR";
    public static final String DEFAULT_ONSCREENLEVEL = "CRIT";
    private static final int MIN_FILESIZE_LIMIT = 16384;
    private static final boolean DEFAULT_GZIP = false;
    private static final int DEFAULT_MIN_GZIP_SIZE = 65536;
    private final I2PAppContext _context;
    private final Log _log;
    private long _configLastRead;
    private File _locationFile;
    private static final int MAX_BUFFER = 1024;
    private final LinkedBlockingQueue<LogRecord> _records;
    private final Set<LogLimit> _limits;
    private final ConcurrentHashMap<Object, Log> _logs;
    private LogWriter _writer;
    private volatile boolean _shutdown;
    private int _defaultLimit = 40;
    private char[] _format;
    private SimpleDateFormat _dateFormat;
    private String _dateFormatPattern;
    private String _baseLogfilename;
    private int _fileSize;
    private int _rotationLimit;
    private int _onScreenLimit;
    private boolean _displayOnScreen = true;
    private int _consoleBufferSize = 20;
    private final LogConsoleBuffer _consoleBuffer;
    private int _logBufferSize = 1024;
    private boolean _dropOnOverflow;
    private boolean _dropDuplicates;
    private final AtomicLong _droppedRecords = new AtomicLong();
    private int _flushInterval = 29;
    private boolean _gzip;
    private long _minGzipSize;
    private boolean _alreadyNoticedMissingConfig = false;

    public LogManager(I2PAppContext context) {
        this._limits = new ConcurrentHashSet<LogLimit>();
        this._logs = new ConcurrentHashMap(128);
        this._context = context;
        this._log = this.getLog(LogManager.class);
        String location = context.getProperty(CONFIG_LOCATION_PROP, CONFIG_LOCATION_DEFAULT);
        this.setConfig(location);
        this._records = new LinkedBlockingQueue(this._logBufferSize);
        this._consoleBuffer = new LogConsoleBuffer(this._consoleBufferSize);
        if (context.isRouterContext()) {
            this.startLogWriter();
        } else {
            try {
                Runtime.getRuntime().addShutdownHook(new ShutdownHook());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private synchronized void startLogWriter() {
        if (this._writer != null) {
            return;
        }
        if (SystemVersion.isAndroid()) {
            try {
                Class<LogWriter> clazz = Class.forName("net.i2p.util.AndroidLogWriter").asSubclass(LogWriter.class);
                Constructor<LogWriter> ctor = clazz.getDeclaredConstructor(LogManager.class);
                this._writer = ctor.newInstance(this);
            }
            catch (ClassNotFoundException clazz) {
            }
            catch (InstantiationException clazz) {
            }
            catch (IllegalAccessException clazz) {
            }
            catch (InvocationTargetException clazz) {
            }
            catch (NoSuchMethodException clazz) {
                // empty catch block
            }
        }
        if (this._writer == null) {
            this._writer = new FileLogWriter(this);
        }
        this._writer.setFlushInterval(this._flushInterval * 1000);
        I2PThread t = new I2PThread(this._writer, "LogWriter");
        t.setDaemon(true);
        ((Thread)t).start();
    }

    public Log getLog(Class<?> cls) {
        return this.getLog(cls, null);
    }

    public Log getLog(String name) {
        return this.getLog(null, name);
    }

    public Log getLog(Class<?> cls, String name) {
        String scope = Log.getScope(name, cls);
        boolean isNew = false;
        Log rv = this._logs.get(scope);
        if (rv == null) {
            rv = new Log(this, cls, name);
            Log old = this._logs.putIfAbsent(scope, rv);
            boolean bl = isNew = old == null;
            if (!isNew) {
                rv = old;
            }
        }
        if (isNew) {
            this.updateLimit(rv);
        }
        return rv;
    }

    public List<Log> getLogs() {
        return new ArrayList<Log>(this._logs.values());
    }

    void addLog(Log log) {
        Log old = this._logs.putIfAbsent(log.getScope(), log);
        this.updateLimit(log);
        if (old != null && this._log.shouldLog(20)) {
            this._log.info("Duplicate log for " + log.getName());
        }
    }

    public LogConsoleBuffer getBuffer() {
        return this._consoleBuffer;
    }

    @Deprecated
    public void setDisplayOnScreen(boolean yes) {
        this._displayOnScreen = yes;
    }

    public boolean displayOnScreen() {
        return this._displayOnScreen;
    }

    public int getDisplayOnScreenLevel() {
        return this._onScreenLimit;
    }

    @Deprecated
    public void setDisplayOnScreenLevel(int level) {
        this._onScreenLimit = level;
    }

    public int getConsoleBufferSize() {
        return this._consoleBufferSize;
    }

    @Deprecated
    public void setConsoleBufferSize(int numRecords) {
        this._consoleBufferSize = numRecords;
    }

    public void setConfig(String filename) {
        this._locationFile = new File(filename);
        if (!this._locationFile.isAbsolute()) {
            this._locationFile = new File(this._context.getConfigDir(), filename);
        }
        this.loadConfig();
    }

    public String currentFile() {
        if (this._writer == null) {
            return "No log file created yet";
        }
        return this._writer.currentFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRecord(LogRecord record) {
        boolean success;
        if (this._shutdown && !SystemVersion.isAndroid()) {
            if (this._context.isRouterContext() || this._displayOnScreen && this._onScreenLimit <= record.getPriority()) {
                boolean showDate = !SystemVersion.hasWrapper();
                System.out.print("(shutdown) " + LogRecordFormatter.formatRecord(this, record, showDate));
            }
            return;
        }
        if (!this._context.isRouterContext() && this._writer == null) {
            this.startLogWriter();
        }
        if (!(success = this._records.offer(record))) {
            if (this._dropOnOverflow) {
                this._droppedRecords.incrementAndGet();
                return;
            }
            LogWriter logWriter = this._writer;
            synchronized (logWriter) {
                this._writer.notifyAll();
            }
            try {
                this._records.put(record);
            }
            catch (InterruptedException interruptedException) {}
        } else if (this._flushInterval <= 0) {
            LogWriter logWriter = this._writer;
            synchronized (logWriter) {
                this._writer.notifyAll();
            }
        }
    }

    void rereadConfig() {
        this.loadConfig();
    }

    boolean shouldDropDuplicates() {
        return this._dropDuplicates;
    }

    private synchronized void loadConfig() {
        File cfgFile = this._locationFile;
        if (!cfgFile.exists()) {
            if (!this._alreadyNoticedMissingConfig) {
                this._alreadyNoticedMissingConfig = true;
            }
            this.parseConfig(new Properties());
            this.updateLimits();
            return;
        }
        this._alreadyNoticedMissingConfig = false;
        if (this._configLastRead > 0L && this._configLastRead >= cfgFile.lastModified()) {
            return;
        }
        Properties p = new Properties();
        try {
            DataHelper.loadProps(p, cfgFile);
            this._configLastRead = this._context.clock().now();
        }
        catch (IOException ioe) {
            System.err.println("Error loading logger config from " + cfgFile.getAbsolutePath());
        }
        this.parseConfig(p);
        this.updateLimits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseConfig(Properties config) {
        String str2;
        block20: {
            String fmt = config.getProperty(PROP_FORMAT, DEFAULT_FORMAT);
            this._format = fmt.toCharArray();
            String df = config.getProperty(PROP_DATEFORMAT, DEFAULT_DATEFORMAT);
            this.setDateFormat(df);
            String disp = config.getProperty(PROP_DISPLAYONSCREEN);
            this._displayOnScreen = disp == null ? true : ("TRUE".equals(disp.toUpperCase(Locale.US).trim()) ? true : "YES".equals(disp.toUpperCase(Locale.US).trim()));
            String filename = config.getProperty(PROP_FILENAME, DEFAULT_FILENAME);
            String filenameOverride = this._context.getProperty(FILENAME_OVERRIDE_PROP);
            if (filenameOverride != null && filename.equals(DEFAULT_FILENAME)) {
                this.setBaseLogfilename(filenameOverride);
            } else {
                this.setBaseLogfilename(filename);
            }
            this._fileSize = Math.max(16384, LogManager.getFileSize(config.getProperty(PROP_FILESIZE, DEFAULT_FILESIZE)));
            this._rotationLimit = -1;
            try {
                this._rotationLimit = Integer.parseInt(config.getProperty(PROP_ROTATIONLIMIT, DEFAULT_ROTATIONLIMIT));
            }
            catch (NumberFormatException nfe) {
                System.err.println("Invalid rotation limit");
                nfe.printStackTrace();
            }
            this._defaultLimit = Log.getLevel(config.getProperty(PROP_DEFAULTLEVEL, DEFAULT_DEFAULTLEVEL));
            this._onScreenLimit = Log.getLevel(config.getProperty(PROP_DISPLAYONSCREENLEVEL, DEFAULT_ONSCREENLEVEL));
            try {
                str2 = config.getProperty(PROP_CONSOLEBUFFERSIZE);
                if (str2 != null) {
                    this._consoleBufferSize = Integer.parseInt(str2);
                }
            }
            catch (NumberFormatException str2) {
                // empty catch block
            }
            try {
                str2 = config.getProperty(PROP_LOG_BUFFER_SIZE);
                if (str2 != null) {
                    this._logBufferSize = Integer.parseInt(str2);
                }
            }
            catch (NumberFormatException str3) {
                // empty catch block
            }
            try {
                str2 = config.getProperty(PROP_FLUSH);
                if (str2 == null) break block20;
                this._flushInterval = Integer.parseInt(str2);
                LogManager logManager = this;
                synchronized (logManager) {
                    if (this._writer != null) {
                        this._writer.setFlushInterval(this._flushInterval * 1000);
                    }
                }
            }
            catch (NumberFormatException str4) {
                // empty catch block
            }
        }
        this._dropOnOverflow = Boolean.parseBoolean(config.getProperty(PROP_DROP));
        str2 = config.getProperty(PROP_DUP);
        this._dropDuplicates = str2 == null || Boolean.parseBoolean(str2);
        str2 = config.getProperty(PROP_GZIP);
        boolean bl = this._gzip = str2 != null ? Boolean.parseBoolean(str2) : false;
        if (this._gzip) {
            this._minGzipSize = 65536L;
            try {
                str2 = config.getProperty(PROP_MIN_GZIP_SIZE);
                if (str2 != null) {
                    this._minGzipSize = Long.parseLong(str2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.parseLimits(config);
    }

    private void parseLimits(Properties config) {
        this.parseLimits(config, PROP_RECORD_PREFIX);
    }

    private void parseLimits(Properties config, String recordPrefix) {
        this._limits.clear();
        if (config != null) {
            for (Map.Entry<Object, Object> e : config.entrySet()) {
                String val;
                LogLimit lim;
                String key = (String)e.getKey();
                if (recordPrefix != null) {
                    if (!key.startsWith(recordPrefix)) continue;
                    key = key.substring(recordPrefix.length());
                }
                if (this._limits.contains(lim = new LogLimit(key, Log.getLevel(val = (String)e.getValue())))) continue;
                this._limits.add(lim);
            }
        }
        this.updateLimits();
    }

    public void setLimits(Properties limits) {
        this.parseLimits(limits, null);
    }

    public boolean setDateFormat(String format) {
        if (format == null) {
            format = DEFAULT_DATEFORMAT;
        }
        if (format.equals(this._dateFormatPattern) && this._dateFormat != null) {
            return true;
        }
        try {
            SimpleDateFormat fmt = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 2);
            if (!format.equals(DEFAULT_DATEFORMAT)) {
                fmt.applyPattern(format);
            }
            fmt.setTimeZone(SystemVersion.getSystemTimeZone(this._context));
            this._dateFormatPattern = format;
            this._dateFormat = fmt;
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public void setFileSize(int numBytes) {
        if (numBytes > 0) {
            this._fileSize = Math.max(16384, numBytes);
        }
    }

    public String getDefaultLimit() {
        return Log.toLevelString(this._defaultLimit);
    }

    public void setDefaultLimit(String lim) {
        this._defaultLimit = Log.getLevel(lim);
        this.updateLimits();
    }

    public Properties getLimits() {
        Properties rv = new Properties();
        for (LogLimit lim : this._limits) {
            rv.setProperty(lim.getRootName(), Log.toLevelString(lim.getLimit()));
        }
        return rv;
    }

    public static int getFileSize(String size) {
        try {
            String v = size.trim().toUpperCase(Locale.US);
            if (v.length() < 2) {
                return -1;
            }
            if (v.endsWith("IB")) {
                v = v.substring(0, v.length() - 2);
            } else if (v.endsWith("B")) {
                v = v.substring(0, v.length() - 1);
            }
            char mod = v.charAt(v.length() - 1);
            if (!Character.isDigit(mod)) {
                v = v.substring(0, v.length() - 1);
            }
            double val = new DecimalFormat().parse(v.trim()).doubleValue();
            switch (mod) {
                case 'K': {
                    val *= 1024.0;
                    break;
                }
                case 'M': {
                    val *= 1048576.0;
                    break;
                }
                case 'G': {
                    val *= 1.073741824E9;
                    break;
                }
            }
            if (val < 16384.0 || val > 2.147483647E9) {
                return -1;
            }
            return (int)val;
        }
        catch (Throwable t) {
            System.err.println("Error parsing config for filesize: [" + size + "]");
            return -1;
        }
    }

    private void updateLimits() {
        for (Log log : this._logs.values()) {
            this.updateLimit(log);
        }
    }

    private void updateLimit(Log log) {
        List<LogLimit> limits = this.getLimits(log);
        LogLimit max = null;
        if (limits != null) {
            for (LogLimit cur : limits) {
                if (max == null) {
                    max = cur;
                    continue;
                }
                if (cur.getRootName().length() <= max.getRootName().length()) continue;
                max = cur;
            }
        }
        if (max != null) {
            log.setMinimumPriority(max.getLimit());
        } else {
            log.setMinimumPriority(this._defaultLimit);
        }
    }

    private List<LogLimit> getLimits(Log log) {
        ArrayList<LogLimit> limits = null;
        for (LogLimit limit : this._limits) {
            if (!limit.matches(log)) continue;
            if (limits == null) {
                limits = new ArrayList<LogLimit>(4);
            }
            limits.add(limit);
        }
        return limits;
    }

    public String getBaseLogfilename() {
        return this._baseLogfilename;
    }

    public void setBaseLogfilename(String filenamePattern) {
        this._baseLogfilename = filenamePattern.replace('#', '@');
    }

    public int getFileSize() {
        return this._fileSize;
    }

    public int getRotationLimit() {
        return this._rotationLimit;
    }

    public boolean shouldGzip() {
        return this._gzip;
    }

    public void setGzip(boolean yes) {
        this._gzip = yes;
    }

    long getMinGzipSize() {
        return this._gzip ? this._minGzipSize : Long.MAX_VALUE;
    }

    public synchronized boolean saveConfig() {
        Properties props = this.createConfig();
        try {
            DataHelper.storeProps(props, this._locationFile);
            return true;
        }
        catch (IOException ioe) {
            this.getLog(LogManager.class).error("Error saving the config", ioe);
            return false;
        }
    }

    private Properties createConfig() {
        OrderedProperties rv = new OrderedProperties();
        rv.setProperty(PROP_FORMAT, new String(this._format));
        rv.setProperty(PROP_DATEFORMAT, this._dateFormatPattern);
        rv.setProperty(PROP_DISPLAYONSCREEN, Boolean.toString(this._displayOnScreen));
        rv.setProperty(PROP_DROP, Boolean.toString(this._dropOnOverflow));
        rv.setProperty(PROP_DUP, Boolean.toString(this._dropDuplicates));
        rv.setProperty(PROP_LOG_BUFFER_SIZE, Integer.toString(this._logBufferSize));
        rv.setProperty(PROP_FILENAME, this._baseLogfilename);
        if (this._fileSize >= 0x100000) {
            rv.setProperty(PROP_FILESIZE, this._fileSize / 0x100000 + "m");
        } else if (this._fileSize >= 1024) {
            rv.setProperty(PROP_FILESIZE, this._fileSize / 1024 + "k");
        } else if (this._fileSize > 0) {
            rv.setProperty(PROP_FILESIZE, Integer.toString(this._fileSize));
        }
        rv.setProperty(PROP_ROTATIONLIMIT, Integer.toString(this._rotationLimit));
        rv.setProperty(PROP_DEFAULTLEVEL, Log.toLevelString(this._defaultLimit));
        rv.setProperty(PROP_DISPLAYONSCREENLEVEL, Log.toLevelString(this._onScreenLimit));
        rv.setProperty(PROP_CONSOLEBUFFERSIZE, Integer.toString(this._consoleBufferSize));
        rv.setProperty(PROP_FLUSH, Integer.toString(this._flushInterval));
        rv.setProperty(PROP_GZIP, Boolean.toString(this._gzip));
        rv.setProperty(PROP_MIN_GZIP_SIZE, Long.toString(this._minGzipSize));
        for (LogLimit lim : this._limits) {
            rv.setProperty(PROP_RECORD_PREFIX + lim.getRootName(), Log.toLevelString(lim.getLimit()));
        }
        return rv;
    }

    Queue<LogRecord> getQueue() {
        return this._records;
    }

    public char[] getFormat() {
        return this._format;
    }

    public void setFormat(char[] fmt) {
        this._format = fmt;
    }

    public SimpleDateFormat getDateFormat() {
        return this._dateFormat;
    }

    public String getDateFormatPattern() {
        return this._dateFormatPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        if (this._writer != null) {
            int i = 50;
            while (!this._records.isEmpty() && i-- > 0) {
                LogWriter logWriter = this._writer;
                synchronized (logWriter) {
                    this._writer.notifyAll();
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        this._shutdown = true;
        if (this._writer != null) {
            this.flush();
            if (!SystemVersion.isMac()) {
                this._writer.flushRecords(false);
            }
            this._writer.stopWriting();
            LogWriter logWriter = this._writer;
            synchronized (logWriter) {
                this._writer.notifyAll();
            }
        }
        this._records.clear();
        this._limits.clear();
        this._logs.clear();
        this._consoleBuffer.clear();
    }

    I2PAppContext getContext() {
        return this._context;
    }

    private class ShutdownHook
    extends I2PAppThread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            this.setName("Log shutdown");
            LogManager.this.shutdown();
        }
    }
}

