/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime.html;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.runtime.html.AppletParser;
import net.sourceforge.jnlp.util.logging.OutputController;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AppletsFilter {
    private final List<Element> found;
    private final URL docBase;
    private final List<String> ids;

    public AppletsFilter(List<Element> found, URL docBase, List<String> ids) {
        this.found = found;
        this.docBase = docBase;
        this.ids = ids;
    }

    public List<AppletParser> getApplets() throws ParserConfigurationException, SAXException, IOException {
        List<Element> appletElement = this.getAppletElements();
        ArrayList<AppletParser> aps = new ArrayList<AppletParser>(appletElement.size());
        for (int i = 0; i < appletElement.size(); ++i) {
            Element element = appletElement.get(i);
            AppletParser ap = new AppletParser(element, this.docBase);
            aps.add(ap);
            OutputController.getLogger().log("added: " + (aps.size() - 1));
            OutputController.getLogger().log(ap.toString());
        }
        return aps;
    }

    private List<Element> getAppletElements() throws ParserConfigurationException, SAXException, IOException {
        if (this.found.isEmpty()) {
            throw new RuntimeException(Translator.R("HTMLnoneFound"));
        }
        List<Integer> id = this.sanitizeFilter();
        ArrayList<Element> r = new ArrayList<Element>(this.found.size());
        for (int i = 0; i < this.found.size(); ++i) {
            Element element = this.found.get(i);
            if (!id.contains(i)) continue;
            r.add(element);
            OutputController.getLogger().log("adding applet id: " + i + " as: " + (r.size() - 1));
        }
        return r;
    }

    private List<Integer> sanitizeFilter() {
        ArrayList<Integer> r = new ArrayList<Integer>(this.found.size());
        if (this.ids.isEmpty()) {
            if (this.found.size() > 1) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("HTMLmoreThenOne", this.found.size()));
            }
            r.add(0);
            return r;
        }
        if (this.ids.size() == 1 && this.ids.get(0).equalsIgnoreCase("all")) {
            for (int i = 0; i < this.found.size(); ++i) {
                r.add(i);
            }
            return r;
        }
        for (int i = 0; i < this.ids.size(); ++i) {
            Integer id = null;
            try {
                id = Integer.parseInt(this.ids.get(i));
            }
            catch (NumberFormatException ex) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
                continue;
            }
            if (id < 0) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "You have selected lesser then 0th applet. Using first");
                if (r.contains(0)) continue;
                r.add(0);
                continue;
            }
            if (id >= this.found.size()) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "You have selected higher then " + (this.found.size() - 1) + "th applet. Using last");
                if (r.contains(this.found.size() - 1)) continue;
                r.add(this.found.size() - 1);
                continue;
            }
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Using " + id + "th applet from total of  count " + (this.found.size() - 1));
            r.add(id);
        }
        return r;
    }
}

