/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.util.logging.OutputController;

public class UrlUtils {
    private static final String UTF8 = "utf-8";

    public static URL normalizeUrlAndStripParams(URL url, boolean encodeFileUrls) {
        if (url == null) {
            return null;
        }
        try {
            String[] urlParts = url.toString().split("\\?");
            URL strippedUrl = new URL(urlParts[0]);
            return UrlUtils.normalizeUrl(strippedUrl, encodeFileUrls);
        }
        catch (IOException | URISyntaxException e) {
            OutputController.getLogger().log(e);
            return url;
        }
    }

    public static URL normalizeUrlAndStripParams(URL url) {
        return UrlUtils.normalizeUrlAndStripParams(url, false);
    }

    public static boolean isLocalFile(URL url) {
        return !(!url.getProtocol().equals("file") || url.getAuthority() != null && !url.getAuthority().equals("") || url.getHost() != null && !url.getHost().equals(""));
    }

    public static URL decodeUrlQuietly(URL url) {
        try {
            return new URL(URLDecoder.decode(url.toString(), UTF8));
        }
        catch (IOException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            return url;
        }
    }

    public static boolean isValidRFC2396Url(URL url) {
        try {
            url.toURI();
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static URL normalizeUrl(URL url, boolean encodeFileUrls) throws MalformedURLException, UnsupportedEncodingException, URISyntaxException {
        boolean shouldEncode;
        if (url == null) {
            return null;
        }
        String protocol = url.getProtocol();
        boolean bl = shouldEncode = encodeFileUrls || !"file".equals(protocol);
        if (protocol == null || !shouldEncode || url.getPath() == null || UrlUtils.isValidRFC2396Url(url)) {
            return url;
        }
        URL decodedURL = new URL(URLDecoder.decode(url.toString(), UTF8));
        URI uri = new URI(decodedURL.getProtocol(), null, decodedURL.getHost(), decodedURL.getPort(), decodedURL.getPath(), decodedURL.getQuery(), null);
        URL encodedURL = new URL(uri.toASCIIString());
        return encodedURL;
    }

    public static URL normalizeUrl(URL url) throws MalformedURLException, UnsupportedEncodingException, URISyntaxException {
        return UrlUtils.normalizeUrl(url, false);
    }

    public static URL normalizeUrlQuietly(URL url, boolean encodeFileUrls) {
        try {
            return UrlUtils.normalizeUrl(url, encodeFileUrls);
        }
        catch (UnsupportedEncodingException | MalformedURLException | URISyntaxException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            return url;
        }
    }

    public static URL normalizeUrlQuietly(URL url) {
        return UrlUtils.normalizeUrlQuietly(url, false);
    }

    public static File decodeUrlAsFile(URL url) {
        return new File(UrlUtils.decodeUrlQuietly(url).getFile());
    }

    public static URL removeFileName(URL src) {
        int i2;
        if (src == null) {
            return src;
        }
        URL nsrc = UrlUtils.normalizeUrlAndStripParams(src);
        String s = nsrc.getPath();
        int i1 = s.lastIndexOf("/");
        int i = Math.max(i1, i2 = s.lastIndexOf("\\"));
        if (i < 0) {
            return src;
        }
        s = s.substring(0, i);
        try {
            return UrlUtils.sanitizeLastSlash(new URL(src.getProtocol(), src.getHost(), src.getPort(), s));
        }
        catch (MalformedURLException ex) {
            OutputController.getLogger().log(ex);
            return nsrc;
        }
    }

    public static String setOfUrlsToHtmlList(Iterable<URL> remoteUrls) {
        StringBuilder sb = new StringBuilder();
        sb.append("<ul>");
        for (URL url : remoteUrls) {
            sb.append("<li>").append(url.toExternalForm()).append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    public static URL sanitizeLastSlash(URL in) throws MalformedURLException {
        if (in == null) {
            return null;
        }
        String s = UrlUtils.sanitizeLastSlash(in.toExternalForm());
        return new URL(s);
    }

    public static String sanitizeLastSlash(String in) {
        if (in == null) {
            return null;
        }
        String s = in;
        while (s.endsWith("/") || s.endsWith("\\")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static boolean equalsIgnoreLastSlash(URL u1, URL u2) {
        try {
            if (u1 == null && u2 == null) {
                return true;
            }
            if (u1 == null && u2 != null) {
                return false;
            }
            if (u1 != null && u2 == null) {
                return false;
            }
            return UrlUtils.sanitizeLastSlash(u1).equals(UrlUtils.sanitizeLastSlash(u2));
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static URL guessCodeBase(JNLPFile file) {
        if (file.getCodeBase() != null) {
            return file.getCodeBase();
        }
        return file.getResources().getMainJAR().getLocation();
    }

    public static boolean urlEquals(URL u1, URL u2) {
        if (u1 == u2) {
            return true;
        }
        if (u1 == null || u2 == null) {
            return false;
        }
        if (UrlUtils.notNullUrlEquals(u1, u2)) {
            return true;
        }
        try {
            URL nu1 = UrlUtils.normalizeUrl(u1);
            URL nu2 = UrlUtils.normalizeUrl(u2);
            if (UrlUtils.notNullUrlEquals(nu1, nu2)) {
                return true;
            }
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
        }
        return false;
    }

    static boolean notNullUrlEquals(URL u1, URL u2) {
        return UrlUtils.compareNullableStrings(u1.getProtocol(), u2.getProtocol(), true) && UrlUtils.compareNullableStrings(u1.getHost(), u2.getHost(), true) && UrlUtils.compareNullableStrings(u1.getPath(), u2.getPath(), false) && UrlUtils.compareNullableStrings(u1.getQuery(), u2.getQuery(), false) && UrlUtils.compareNullableStrings(u1.getRef(), u2.getRef(), false);
    }

    static boolean compareNullableStrings(String s1, String s2, boolean ignore) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (ignore) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }

    public static int getSanitizedPort(URL u) {
        if (u.getPort() < 0) {
            return u.getDefaultPort();
        }
        return u.getPort();
    }

    public static int getPort(URL url) {
        return UrlUtils.getSanitizedPort(url);
    }

    public static String getHostAndPort(URL url) {
        return url.getHost() + ":" + UrlUtils.getSanitizedPort(url);
    }

    public static URL ensureSlashTail(URL u) {
        if (u == null) {
            return null;
        }
        String s = UrlUtils.ensureSlashTail(u.toExternalForm());
        try {
            return new URL(s);
        }
        catch (MalformedURLException ex) {
            OutputController.getLogger().log(ex);
            return u;
        }
    }

    public static String ensureSlashTail(String s) {
        if (s.endsWith("/")) {
            return s;
        }
        if (s.endsWith("\\")) {
            return s;
        }
        if (s.contains("/")) {
            return s + "/";
        }
        if (s.contains("\\")) {
            return s + "\\";
        }
        return s + "/";
    }

    public static String stripFile(URL documentbase) {
        return UrlUtils.ensureSlashTail(UrlUtils.stripFileImp(documentbase));
    }

    private static String stripFileImp(URL documentbase) {
        try {
            String normalized = UrlUtils.normalizeUrlAndStripParams(documentbase).toExternalForm().trim();
            if (normalized.endsWith("/") || normalized.endsWith("\\")) {
                return normalized;
            }
            URL middleway = new URL(normalized);
            String file = middleway.getFile();
            int i = Math.max(file.lastIndexOf(47), file.lastIndexOf(92));
            if (i < 0) {
                return normalized;
            }
            String parent = file.substring(0, i + 1);
            String stripped = normalized.replace(file, parent);
            return stripped;
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
            return documentbase.toExternalForm();
        }
    }
}

