/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.core.operators.layer.recurrent.lstm;

import io.kinference.core.operators.layer.recurrent.LayerDirection;
import io.kinference.core.operators.layer.recurrent.lstm.AbstractLSTMInput;
import io.kinference.core.operators.layer.recurrent.lstm.AbstractLSTMWeights;
import io.kinference.core.operators.layer.recurrent.lstm.BiLSTMLayer;
import io.kinference.core.operators.layer.recurrent.lstm.LSTMLayer;
import io.kinference.core.operators.layer.recurrent.lstm.LSTMLayerOutput;
import io.kinference.ndarray.arrays.IntNDArray;
import io.kinference.ndarray.arrays.NumberNDArrayCore;
import io.kinference.primitives.types.DataType;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 !2\u00020\u0001:\u0001!B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJc\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Lio/kinference/core/operators/layer/recurrent/lstm/LSTMLayerBase;", "", "hiddenSize", "", "activations", "", "", "direction", "Lio/kinference/core/operators/layer/recurrent/LayerDirection;", "(ILjava/util/List;Lio/kinference/core/operators/layer/recurrent/LayerDirection;)V", "getActivations", "()Ljava/util/List;", "getDirection", "()Lio/kinference/core/operators/layer/recurrent/LayerDirection;", "getHiddenSize", "()I", "apply", "Lio/kinference/core/operators/layer/recurrent/lstm/LSTMLayerOutput;", "input", "Lio/kinference/core/operators/layer/recurrent/lstm/AbstractLSTMInput;", "weights", "Lio/kinference/core/operators/layer/recurrent/lstm/AbstractLSTMWeights;", "recurrentWeights", "bias", "Lio/kinference/ndarray/arrays/NumberNDArrayCore;", "sequenceLens", "Lio/kinference/ndarray/arrays/IntNDArray;", "initialHiddenState", "initialCellState", "peepholes", "dataType", "Lio/kinference/primitives/types/DataType;", "(Lio/kinference/core/operators/layer/recurrent/lstm/AbstractLSTMInput;Lio/kinference/core/operators/layer/recurrent/lstm/AbstractLSTMWeights;Lio/kinference/core/operators/layer/recurrent/lstm/AbstractLSTMWeights;Lio/kinference/ndarray/arrays/NumberNDArrayCore;Lio/kinference/ndarray/arrays/IntNDArray;Lio/kinference/ndarray/arrays/NumberNDArrayCore;Lio/kinference/ndarray/arrays/NumberNDArrayCore;Lio/kinference/ndarray/arrays/NumberNDArrayCore;Lio/kinference/primitives/types/DataType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "inference-core"})
public abstract class LSTMLayerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int hiddenSize;
    @NotNull
    private final List<String> activations;
    @NotNull
    private final LayerDirection direction;

    public LSTMLayerBase(int hiddenSize2, @NotNull List<String> activations2, @NotNull LayerDirection direction2) {
        Intrinsics.checkNotNullParameter(activations2, (String)"activations");
        Intrinsics.checkNotNullParameter((Object)((Object)direction2), (String)"direction");
        this.hiddenSize = hiddenSize2;
        this.activations = activations2;
        this.direction = direction2;
    }

    public final int getHiddenSize() {
        return this.hiddenSize;
    }

    @NotNull
    public final List<String> getActivations() {
        return this.activations;
    }

    @NotNull
    public final LayerDirection getDirection() {
        return this.direction;
    }

    @Nullable
    public abstract Object apply(@NotNull AbstractLSTMInput var1, @NotNull AbstractLSTMWeights var2, @NotNull AbstractLSTMWeights var3, @Nullable NumberNDArrayCore var4, @Nullable IntNDArray var5, @Nullable NumberNDArrayCore var6, @Nullable NumberNDArrayCore var7, @Nullable NumberNDArrayCore var8, @NotNull DataType var9, @NotNull Continuation<? super LSTMLayerOutput> var10);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lio/kinference/core/operators/layer/recurrent/lstm/LSTMLayerBase$Companion;", "", "()V", "create", "Lio/kinference/core/operators/layer/recurrent/lstm/LSTMLayerBase;", "hiddenSize", "", "activations", "", "", "direction", "Lio/kinference/core/operators/layer/recurrent/LayerDirection;", "inference-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LSTMLayerBase create(int hiddenSize2, @NotNull List<String> activations2, @NotNull LayerDirection direction2) {
            Intrinsics.checkNotNullParameter(activations2, (String)"activations");
            Intrinsics.checkNotNullParameter((Object)((Object)direction2), (String)"direction");
            return switch (WhenMappings.$EnumSwitchMapping$0[direction2.ordinal()]) {
                case 1, 2 -> new LSTMLayer(hiddenSize2, activations2, direction2);
                case 3 -> new BiLSTMLayer(hiddenSize2, activations2);
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LayerDirection.values().length];
                try {
                    nArray[LayerDirection.FORWARD.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LayerDirection.REVERSE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LayerDirection.BIDIRECTIONAL.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

