/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.SvnClient;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;

public abstract class BaseSvnClient
implements SvnClient {
    protected SvnVcs myVcs;
    protected ClientFactory myFactory;
    protected boolean myIsActive;

    @Override
    @NotNull
    public SvnVcs getVcs() {
        SvnVcs svnVcs = this.myVcs;
        if (svnVcs == null) {
            BaseSvnClient.$$$reportNull$$$0(0);
        }
        return svnVcs;
    }

    @Override
    public void setVcs(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            BaseSvnClient.$$$reportNull$$$0(1);
        }
        this.myVcs = vcs;
    }

    @Override
    @NotNull
    public ClientFactory getFactory() {
        ClientFactory clientFactory = this.myFactory;
        if (clientFactory == null) {
            BaseSvnClient.$$$reportNull$$$0(2);
        }
        return clientFactory;
    }

    @Override
    public void setFactory(@NotNull ClientFactory factory) {
        if (factory == null) {
            BaseSvnClient.$$$reportNull$$$0(3);
        }
        this.myFactory = factory;
    }

    @Override
    public void setIsActive(boolean isActive) {
        this.myIsActive = isActive;
    }

    protected void assertUrl(@NotNull Target target) {
        if (target == null) {
            BaseSvnClient.$$$reportNull$$$0(4);
        }
        if (!target.isUrl()) {
            throw new IllegalArgumentException("Target should be url " + target);
        }
    }

    protected void assertFile(@NotNull Target target) {
        if (target == null) {
            BaseSvnClient.$$$reportNull$$$0(5);
        }
        if (!target.isFile()) {
            throw new IllegalArgumentException("Target should be file " + target);
        }
    }

    protected void assertDirectory(@NotNull Target target) {
        if (target == null) {
            BaseSvnClient.$$$reportNull$$$0(6);
        }
        this.assertFile(target);
        if (!target.getFile().isDirectory()) {
            throw new IllegalArgumentException("Target should be directory " + target);
        }
    }

    protected void validateFormat(@NotNull WorkingCopyFormat format, @NotNull Collection<WorkingCopyFormat> supported) throws VcsException {
        if (format == null) {
            BaseSvnClient.$$$reportNull$$$0(7);
        }
        if (supported == null) {
            BaseSvnClient.$$$reportNull$$$0(8);
        }
        if (!supported.contains((Object)format)) {
            throw new VcsException(SvnBundle.message("error.format.is.not.supported", format.getDisplayName(), StringUtil.join(supported, it -> it.getDisplayName(), (String)",")));
        }
    }

    @NotNull
    public CommandExecutor execute(@NotNull SvnVcs vcs, @NotNull Target target, @NotNull SvnCommandName name, @NotNull List<String> parameters, @Nullable LineCommandListener listener2) throws SvnBindException {
        if (vcs == null) {
            BaseSvnClient.$$$reportNull$$$0(9);
        }
        if (target == null) {
            BaseSvnClient.$$$reportNull$$$0(10);
        }
        if (name == null) {
            BaseSvnClient.$$$reportNull$$$0(11);
        }
        if (parameters == null) {
            BaseSvnClient.$$$reportNull$$$0(12);
        }
        CommandExecutor commandExecutor = this.execute(vcs, target, null, name, parameters, listener2);
        if (commandExecutor == null) {
            BaseSvnClient.$$$reportNull$$$0(13);
        }
        return commandExecutor;
    }

    @NotNull
    public CommandExecutor execute(@NotNull SvnVcs vcs, @NotNull Target target, @Nullable File workingDirectory, @NotNull SvnCommandName name, @NotNull List<String> parameters, @Nullable LineCommandListener listener2) throws SvnBindException {
        if (vcs == null) {
            BaseSvnClient.$$$reportNull$$$0(14);
        }
        if (target == null) {
            BaseSvnClient.$$$reportNull$$$0(15);
        }
        if (name == null) {
            BaseSvnClient.$$$reportNull$$$0(16);
        }
        if (parameters == null) {
            BaseSvnClient.$$$reportNull$$$0(17);
        }
        Command command = this.newCommand(name);
        command.put(parameters);
        CommandExecutor commandExecutor = this.execute(vcs, target, workingDirectory, command, listener2);
        if (commandExecutor == null) {
            BaseSvnClient.$$$reportNull$$$0(18);
        }
        return commandExecutor;
    }

    @NotNull
    public CommandExecutor execute(@NotNull SvnVcs vcs, @NotNull Target target, @Nullable File workingDirectory, @NotNull Command command, @Nullable LineCommandListener listener2) throws SvnBindException {
        if (vcs == null) {
            BaseSvnClient.$$$reportNull$$$0(19);
        }
        if (target == null) {
            BaseSvnClient.$$$reportNull$$$0(20);
        }
        if (command == null) {
            BaseSvnClient.$$$reportNull$$$0(21);
        }
        command.setTarget(target);
        command.setWorkingDirectory(workingDirectory);
        command.setResultBuilder(listener2);
        CommandExecutor commandExecutor = this.newRuntime(vcs).runWithAuthenticationAttempt(command);
        if (commandExecutor == null) {
            BaseSvnClient.$$$reportNull$$$0(22);
        }
        return commandExecutor;
    }

    @NotNull
    public Command newCommand(@NotNull SvnCommandName name) {
        if (name == null) {
            BaseSvnClient.$$$reportNull$$$0(23);
        }
        return new Command(name);
    }

    @NotNull
    public CommandRuntime newRuntime(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            BaseSvnClient.$$$reportNull$$$0(24);
        }
        return new CommandRuntime(vcs, new AuthenticationService(vcs, this.myIsActive));
    }

    public static void callHandler(@Nullable ProgressTracker handler, @NotNull ProgressEvent event) throws SvnBindException {
        if (event == null) {
            BaseSvnClient.$$$reportNull$$$0(25);
        }
        if (handler != null) {
            handler.consume(event);
        }
    }

    @NotNull
    protected static ProgressEvent createEvent(@NotNull File path, @Nullable EventAction action) {
        if (path == null) {
            BaseSvnClient.$$$reportNull$$$0(26);
        }
        return new ProgressEvent(path, 0L, null, null, action, null, null);
    }

    @NotNull
    protected static Revision notNullize(@Nullable Revision revision) {
        Revision revision2 = revision != null ? revision : Revision.UNDEFINED;
        if (revision2 == null) {
            BaseSvnClient.$$$reportNull$$$0(27);
        }
        return revision2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17, 19, 20, 21, 23, 24, 25, 26 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/api/BaseSvnClient";
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supported";
                break;
            }
            case 11: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/api/BaseSvnClient";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 13: 
            case 18: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setVcs";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setFactory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "assertUrl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "assertFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assertDirectory";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateFormat";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "newCommand";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "newRuntime";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "callHandler";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createEvent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17, 19, 20, 21, 23, 24, 25, 26 -> new IllegalArgumentException(string);
        };
    }
}

