/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchDataImpl;
import com.intellij.vcs.branch.BranchStateProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.NewRootBunch;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchStateProviderKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/svn/branchConfig/SvnBranchStateProvider;", "Lcom/intellij/vcs/branch/BranchStateProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCurrentBranch", "Lcom/intellij/vcs/branch/BranchData;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.vcs.svn"})
public final class SvnBranchStateProvider
implements BranchStateProvider {
    @NotNull
    private final Project project;

    public SvnBranchStateProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public BranchData getCurrentBranch(@NotNull FilePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.project);
        if (!vcsManager.checkVcsIsActive("svn")) {
            return null;
        }
        AbstractVcs abstractVcs = vcsManager.getVcsFor(path);
        Object object = abstractVcs instanceof SvnVcs ? (SvnVcs)abstractVcs : null;
        if (object == null || (object = object.getSvnFileUrlMapping()) == null || (object = object.getWcRootForFilePath(path)) == null) {
            return null;
        }
        SvnVcs wcRoot = object;
        NewRootBunch newRootBunch = SvnBranchConfigurationManager.Companion.getInstance(this.project).getSvnBranchConfigManager();
        VirtualFile virtualFile = ((RootUrlInfo)((Object)wcRoot)).getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        SvnBranchConfigurationNew svnBranchConfigurationNew = newRootBunch.getConfigOrNull(virtualFile);
        if (svnBranchConfigurationNew == null) {
            return null;
        }
        SvnBranchConfigurationNew configuration = svnBranchConfigurationNew;
        Url url = ((RootUrlInfo)((Object)wcRoot)).getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"getUrl(...)");
        Url url2 = configuration.getWorkingBranch(url);
        if (url2 == null) {
            return null;
        }
        Url branchUrl = url2;
        String string = ((RootUrlInfo)((Object)wcRoot)).getRoot().getPresentableName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
        String presentableRootName = SvnBranchStateProviderKt.access$join(string, VfsUtilCore.getRelativePath((VirtualFile)((RootUrlInfo)((Object)wcRoot)).getVirtualFile(), (VirtualFile)((RootUrlInfo)((Object)wcRoot)).getRoot()));
        return (BranchData)new BranchDataImpl(presentableRootName, Intrinsics.areEqual((Object)branchUrl, (Object)configuration.getTrunk()) ? "trunk" : branchUrl.getTail());
    }
}

