/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.beust.jcommander.defaultprovider;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.gradle.internal.impldep.com.beust.jcommander.IDefaultProvider;
import org.gradle.internal.impldep.com.beust.jcommander.ParameterException;

public class PropertyFileDefaultProvider
implements IDefaultProvider {
    public static final String DEFAULT_FILE_NAME = "jcommander.properties";
    private Properties properties;

    public PropertyFileDefaultProvider() {
        this.init(DEFAULT_FILE_NAME);
    }

    public PropertyFileDefaultProvider(String fileName) {
        this.init(fileName);
    }

    private void init(String fileName) {
        try {
            this.properties = new Properties();
            URL url = ClassLoader.getSystemResource(fileName);
            if (url == null) {
                throw new ParameterException("Could not find property file: " + fileName + " on the class path");
            }
            this.properties.load(url.openStream());
        }
        catch (IOException e) {
            throw new ParameterException("Could not open property file: " + fileName);
        }
    }

    @Override
    public String getDefaultValueFor(String optionName) {
        int index;
        for (index = 0; index < optionName.length() && !Character.isLetterOrDigit(optionName.charAt(index)); ++index) {
        }
        String key = optionName.substring(index);
        return this.properties.getProperty(key);
    }
}

