/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.diff;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.internal.impldep.org.eclipse.jgit.diff.Sequence;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.BinaryBlobException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.LargeObjectException;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectLoader;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectStream;
import org.gradle.internal.impldep.org.eclipse.jgit.util.IO;
import org.gradle.internal.impldep.org.eclipse.jgit.util.IntList;
import org.gradle.internal.impldep.org.eclipse.jgit.util.RawParseUtils;

public class RawText
extends Sequence {
    public static final RawText EMPTY_TEXT = new RawText(new byte[0]);
    static final int FIRST_FEW_BYTES = 8000;
    protected final byte[] content;
    protected final IntList lines;

    public RawText(byte[] input) {
        this(input, RawParseUtils.lineMap(input, 0, input.length));
    }

    public RawText(byte[] input, IntList lineMap) {
        this.content = input;
        this.lines = lineMap;
    }

    public RawText(File file) throws IOException {
        this(IO.readFully(file));
    }

    public byte[] getRawContent() {
        return this.content;
    }

    @Override
    public int size() {
        return this.lines.size() - 2;
    }

    public void writeLine(OutputStream out, int i) throws IOException {
        int start = this.getStart(i);
        int end = this.getEnd(i);
        if (this.content[end - 1] == 10) {
            --end;
        }
        out.write(this.content, start, end - start);
    }

    public boolean isMissingNewlineAtEnd() {
        int end = this.lines.get(this.lines.size() - 1);
        if (end == 0) {
            return true;
        }
        return this.content[end - 1] != 10;
    }

    public String getString(int i) {
        return this.getString(i, i + 1, true);
    }

    public String getString(int begin, int end, boolean dropLF) {
        if (begin == end) {
            return "";
        }
        int s = this.getStart(begin);
        int e = this.getEnd(end - 1);
        if (dropLF && this.content[e - 1] == 10) {
            --e;
        }
        return this.decode(s, e);
    }

    protected String decode(int start, int end) {
        return RawParseUtils.decode(this.content, start, end);
    }

    private int getStart(int i) {
        return this.lines.get(i + 1);
    }

    private int getEnd(int i) {
        return this.lines.get(i + 2);
    }

    public static boolean isBinary(byte[] raw) {
        return RawText.isBinary(raw, raw.length);
    }

    public static boolean isBinary(InputStream raw) throws IOException {
        byte[] buffer = new byte[8000];
        int cnt = 0;
        while (cnt < buffer.length) {
            int n = raw.read(buffer, cnt, buffer.length - cnt);
            if (n == -1) break;
            cnt += n;
        }
        return RawText.isBinary(buffer, cnt);
    }

    public static boolean isBinary(byte[] raw, int length) {
        if (length > 8000) {
            length = 8000;
        }
        int ptr = 0;
        while (ptr < length) {
            if (raw[ptr] == 0) {
                return true;
            }
            ++ptr;
        }
        return false;
    }

    public static boolean isCrLfText(byte[] raw) {
        return RawText.isCrLfText(raw, raw.length);
    }

    public static boolean isCrLfText(InputStream raw) throws IOException {
        byte[] buffer = new byte[8000];
        int cnt = 0;
        while (cnt < buffer.length) {
            int n = raw.read(buffer, cnt, buffer.length - cnt);
            if (n == -1) break;
            cnt += n;
        }
        return RawText.isCrLfText(buffer, cnt);
    }

    public static boolean isCrLfText(byte[] raw, int length) {
        boolean has_crlf = false;
        int ptr = 0;
        while (ptr < length - 1) {
            if (raw[ptr] == 0) {
                return false;
            }
            if (raw[ptr] == 13 && raw[ptr + 1] == 10) {
                has_crlf = true;
            }
            ++ptr;
        }
        return has_crlf;
    }

    public String getLineDelimiter() {
        if (this.size() == 0) {
            return null;
        }
        int e = this.getEnd(0);
        if (this.content[e - 1] != 10) {
            return null;
        }
        if (this.content.length > 1 && e > 1 && this.content[e - 2] == 13) {
            return "\r\n";
        }
        return "\n";
    }

    public static RawText load(ObjectLoader ldr, int threshold) throws IOException, BinaryBlobException {
        long sz = ldr.getSize();
        if (sz > (long)threshold) {
            throw new BinaryBlobException();
        }
        if (sz <= 8000L) {
            byte[] data = ldr.getCachedBytes(8000);
            if (RawText.isBinary(data)) {
                throw new BinaryBlobException();
            }
            return new RawText(data);
        }
        byte[] head = new byte[8000];
        Throwable throwable = null;
        Object var6_7 = null;
        try (ObjectStream stream = ldr.openStream();){
            byte[] data;
            int off = 0;
            int left = head.length;
            while (left > 0) {
                int n = stream.read(head, off, left);
                if (n < 0) {
                    throw new EOFException();
                }
                left -= n;
                while (n > 0) {
                    if (head[off] == 0) {
                        throw new BinaryBlobException();
                    }
                    ++off;
                    --n;
                }
            }
            try {
                data = new byte[(int)sz];
            }
            catch (OutOfMemoryError e) {
                throw new LargeObjectException.OutOfMemory(e);
            }
            System.arraycopy(head, 0, data, 0, head.length);
            IO.readFully(stream, data, off, (int)(sz - (long)off));
            return new RawText(data, RawParseUtils.lineMapOrBinary(data, 0, (int)sz));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

