/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.treewalk.filter;

import java.io.IOException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.MissingObjectException;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Constants;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.TreeWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.filter.TreeFilter;

public class PathSuffixFilter
extends TreeFilter {
    final String pathStr;
    final byte[] pathRaw;

    public static PathSuffixFilter create(String path) {
        if (path.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().emptyPathNotPermitted);
        }
        return new PathSuffixFilter(path);
    }

    private PathSuffixFilter(String s) {
        this.pathStr = s;
        this.pathRaw = Constants.encode(this.pathStr);
    }

    @Override
    public TreeFilter clone() {
        return this;
    }

    @Override
    public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (walker.isSubtree()) {
            return true;
        }
        return walker.isPathSuffix(this.pathRaw, this.pathRaw.length);
    }

    @Override
    public boolean shouldBeRecursive() {
        return true;
    }
}

