/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.testng;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.gradle.internal.impldep.org.testng.ITestResult;
import org.gradle.internal.impldep.org.testng.TestRunner;
import org.gradle.internal.impldep.org.testng.collections.Lists;
import org.gradle.internal.impldep.org.testng.collections.Maps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reporter {
    private static ThreadLocal<ITestResult> m_currentTestResult = new InheritableThreadLocal<ITestResult>();
    private static List<String> m_output = new Vector<String>();
    private static Map<ITestResult, List<Integer>> m_methodOutputMap = Maps.newHashMap();

    public static void setCurrentTestResult(ITestResult m) {
        m_currentTestResult.set(m);
    }

    public static List<String> getOutput() {
        return m_output;
    }

    public static void clear() {
        m_methodOutputMap.clear();
        m_output.clear();
    }

    private static synchronized void log(String s, ITestResult m) {
        int n = Reporter.getOutput().size();
        List<Integer> lines = m_methodOutputMap.get(m);
        if (lines == null) {
            lines = Lists.newArrayList();
            m_methodOutputMap.put(m, lines);
        }
        lines.add(n);
        Reporter.getOutput().add(s);
    }

    public static void log(String s) {
        Reporter.log(s, Reporter.getCurrentTestResult());
    }

    public static void log(String s, int level, boolean logToStandardOut) {
        if (TestRunner.getVerbose() >= level) {
            Reporter.log(s, Reporter.getCurrentTestResult());
            if (logToStandardOut) {
                System.out.println(s);
            }
        }
    }

    public static void log(String s, boolean logToStandardOut) {
        Reporter.log(s, Reporter.getCurrentTestResult());
        if (logToStandardOut) {
            System.out.println(s);
        }
    }

    public static void log(String s, int level) {
        if (TestRunner.getVerbose() >= level) {
            Reporter.log(s, Reporter.getCurrentTestResult());
        }
    }

    public static ITestResult getCurrentTestResult() {
        return m_currentTestResult.get();
    }

    public static synchronized List<String> getOutput(ITestResult tr) {
        List<String> result = Lists.newArrayList();
        List<Integer> lines = m_methodOutputMap.get(tr);
        if (lines != null) {
            for (Integer n : lines) {
                result.add(Reporter.getOutput().get(n));
            }
        }
        return result;
    }
}

