/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.TerminalTitleKt;
import com.intellij.ui.util.UiSizeUtilKt;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TtyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.BlockTerminalController;
import org.jetbrains.plugins.terminal.exp.SimpleTerminalController;
import org.jetbrains.plugins.terminal.exp.SimpleTerminalView;
import org.jetbrains.plugins.terminal.exp.TerminalCommandExecutor;
import org.jetbrains.plugins.terminal.exp.TerminalContentView;
import org.jetbrains.plugins.terminal.exp.TerminalEventsHandler;
import org.jetbrains.plugins.terminal.exp.TerminalFocusModel;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.exp.TerminalOutputController;
import org.jetbrains.plugins.terminal.exp.TerminalOutputView;
import org.jetbrains.plugins.terminal.exp.TerminalPromptController;
import org.jetbrains.plugins.terminal.exp.TerminalPromptView;
import org.jetbrains.plugins.terminal.exp.TerminalSelectionController;
import org.jetbrains.plugins.terminal.exp.TerminalSession;
import org.jetbrains.plugins.terminal.exp.TerminalUi;
import org.jetbrains.plugins.terminal.exp.TerminalUiUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u00013B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u001dH\u0016J\n\u0010+\u001a\u0004\u0018\u00010)H\u0016J\b\u0010,\u001a\u00020\u001dH\u0002J\b\u0010-\u001a\u00020\u001dH\u0002J\b\u0010.\u001a\u00020$H\u0016J\u0010\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020\u001dH\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/plugins/terminal/exp/BlockTerminalView;", "Lorg/jetbrains/plugins/terminal/exp/TerminalContentView;", "Lorg/jetbrains/plugins/terminal/exp/TerminalCommandExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "terminalTitle", "Lcom/intellij/terminal/TerminalTitle;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/exp/TerminalSession;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lcom/intellij/terminal/TerminalTitle;)V", "alternateBufferView", "Lorg/jetbrains/plugins/terminal/exp/SimpleTerminalView;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "controller", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalController;", "outputView", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputView;", "preferredFocusableComponent", "getPreferredFocusableComponent", "promptView", "Lorg/jetbrains/plugins/terminal/exp/TerminalPromptView;", "selectionController", "Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionController;", "addTerminationCallback", "", "onTerminated", "Ljava/lang/Runnable;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "alternateBufferStateChanged", "enabled", "", "connectToTty", "ttyConnector", "Lcom/jediterm/terminal/TtyConnector;", "initialTermSize", "Lcom/jediterm/core/util/TermSize;", "dispose", "getTerminalSize", "installAlternateBufferPanel", "installPromptAndOutput", "isFocused", "startCommandExecution", "command", "", "updateTerminalSize", "BlockTerminalPanel", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nBlockTerminalView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockTerminalView.kt\norg/jetbrains/plugins/terminal/exp/BlockTerminalView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
public final class BlockTerminalView
implements TerminalContentView,
TerminalCommandExecutor {
    @NotNull
    private final Project project;
    @NotNull
    private final TerminalSession session;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final BlockTerminalController controller;
    @NotNull
    private final TerminalSelectionController selectionController;
    @NotNull
    private final TerminalOutputView outputView;
    @NotNull
    private final TerminalPromptView promptView;
    @Nullable
    private SimpleTerminalView alternateBufferView;
    @NotNull
    private final JComponent component;

    public BlockTerminalView(@NotNull Project project, @NotNull TerminalSession session2, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalTitle terminalTitle) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)terminalTitle, (String)"terminalTitle");
        this.project = project;
        this.session = session2;
        this.settings = settings;
        this.outputView = new TerminalOutputView(this.project, this.session, this.settings);
        this.promptView = new TerminalPromptView(this.project, this.settings, this.session, this);
        this.component = new BlockTerminalPanel();
        Disposer.register((Disposable)this, (Disposable)this.outputView);
        Disposer.register((Disposable)this, (Disposable)this.promptView);
        this.promptView.getController().addListener(new TerminalPromptController.PromptStateListener(){

            @Override
            public void promptVisibilityChanged(boolean visible) {
                promptView.getComponent().setVisible(visible);
                this.getComponent().revalidate();
                ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ BlockTerminalView this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        IdeFocusManager.getInstance((Project)BlockTerminalView.access$getProject$p(this.this$0)).requestFocus((Component)this.this$0.getPreferredFocusableComponent(), true);
                    }
                }), (int)1, null);
            }
        });
        TerminalPromptController.addDocumentListener$default(this.promptView.getController(), new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (UiSizeUtilKt.getPreferredHeight((JComponent)promptView.getComponent()) != promptView.getComponent().getHeight()) {
                    this.getComponent().revalidate();
                }
            }
        }, null, 2, null);
        TerminalFocusModel focusModel = new TerminalFocusModel(this.project, this.outputView, this.promptView);
        this.selectionController = new TerminalSelectionController(focusModel, this.outputView.getController().getSelectionModel(), this.outputView.getController().getOutputModel());
        this.controller = new BlockTerminalController(this.project, this.session, this.outputView.getController(), this.promptView.getController(), this.selectionController, focusModel);
        this.getComponent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@Nullable ComponentEvent e) {
                this.updateTerminalSize();
            }
        });
        TerminalModel.addTerminalListener$default(this.session.getModel(), new TerminalModel.TerminalListener(){

            @Override
            public void onAlternateBufferChanged(boolean enabled) {
                ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this, enabled){
                    final /* synthetic */ BlockTerminalView this$0;
                    final /* synthetic */ boolean $enabled;
                    {
                        this.this$0 = $receiver;
                        this.$enabled = $enabled;
                        super(0);
                    }

                    public final void invoke() {
                        BlockTerminalView.access$alternateBufferStateChanged(this.this$0, this.$enabled);
                    }
                }), (int)1, null);
            }
        }, null, 2, null);
        TerminalTitleKt.bindApplicationTitle((TerminalTitle)terminalTitle, (Terminal)((Terminal)this.session.getController$intellij_terminal()), (Disposable)this);
        BlockTerminalController.addListener$default(this.controller, new BlockTerminalController.BlockTerminalControllerListener(){

            @Override
            public void searchSessionStarted(@NotNull SearchSession session2) {
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                TerminalOutputView terminalOutputView = outputView;
                SearchReplaceComponent searchReplaceComponent = session2.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)searchReplaceComponent, (String)"getComponent(...)");
                terminalOutputView.installSearchComponent(searchReplaceComponent);
            }

            @Override
            public void searchSessionFinished(@NotNull SearchSession session2) {
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                TerminalOutputView terminalOutputView = outputView;
                SearchReplaceComponent searchReplaceComponent = session2.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)searchReplaceComponent, (String)"getComponent(...)");
                terminalOutputView.removeSearchComponent(searchReplaceComponent);
            }
        }, null, 2, null);
        this.installPromptAndOutput();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusableComponent() {
        JComponent jComponent;
        if (this.alternateBufferView != null) {
            SimpleTerminalView simpleTerminalView = this.alternateBufferView;
            Intrinsics.checkNotNull((Object)simpleTerminalView);
            jComponent = simpleTerminalView.getPreferredFocusableComponent();
        } else {
            jComponent = this.promptView.getComponent().isVisible() ? this.promptView.getPreferredFocusableComponent() : this.outputView.getPreferredFocusableComponent();
        }
        return jComponent;
    }

    @Override
    public void connectToTty(@NotNull TtyConnector ttyConnector, @NotNull TermSize initialTermSize) {
        Intrinsics.checkNotNullParameter((Object)ttyConnector, (String)"ttyConnector");
        Intrinsics.checkNotNullParameter((Object)initialTermSize, (String)"initialTermSize");
        this.session.getController$intellij_terminal().resize(initialTermSize, RequestOrigin.User);
        this.session.start(ttyConnector);
    }

    private final void alternateBufferStateChanged(boolean enabled) {
        if (enabled) {
            this.installAlternateBufferPanel();
        } else {
            SimpleTerminalView simpleTerminalView = this.alternateBufferView;
            if (simpleTerminalView != null) {
                SimpleTerminalView it = simpleTerminalView;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            this.alternateBufferView = null;
            this.installPromptAndOutput();
        }
        IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)this.getPreferredFocusableComponent(), true);
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ BlockTerminalView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                BlockTerminalView.access$updateTerminalSize(this.this$0);
            }
        }), (int)1, null);
    }

    private final void installAlternateBufferPanel() {
        TerminalEventsHandler eventsHandler = new TerminalEventsHandler(this.session, this.settings);
        SimpleTerminalView view = new SimpleTerminalView(this.project, this.settings, this.session, eventsHandler, false);
        Disposer.register((Disposable)this, (Disposable)view);
        this.alternateBufferView = view;
        JComponent $this$installAlternateBufferPanel_u24lambda_u241 = this.getComponent();
        boolean bl = false;
        $this$installAlternateBufferPanel_u24lambda_u241.removeAll();
        $this$installAlternateBufferPanel_u24lambda_u241.add((Component)view.getComponent(), "Center");
        $this$installAlternateBufferPanel_u24lambda_u241.revalidate();
    }

    private final void installPromptAndOutput() {
        JComponent $this$installPromptAndOutput_u24lambda_u242 = this.getComponent();
        boolean bl = false;
        $this$installPromptAndOutput_u24lambda_u242.removeAll();
        $this$installPromptAndOutput_u24lambda_u242.add((Component)this.outputView.getComponent(), "Center");
        $this$installPromptAndOutput_u24lambda_u242.add((Component)this.promptView.getComponent(), "South");
        $this$installPromptAndOutput_u24lambda_u242.revalidate();
    }

    @Override
    public void startCommandExecution(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.controller.startCommandExecution(command);
    }

    private final void updateTerminalSize() {
        TermSize termSize = this.getTerminalSize();
        if (termSize == null) {
            return;
        }
        TermSize newSize = termSize;
        this.controller.resize(newSize);
    }

    @Override
    @Nullable
    public TermSize getTerminalSize() {
        Pair pair;
        if (this.alternateBufferView != null) {
            SimpleTerminalView simpleTerminalView = this.alternateBufferView;
            Intrinsics.checkNotNull((Object)simpleTerminalView);
            it = simpleTerminalView;
            boolean bl = false;
            pair = TuplesKt.to((Object)((SimpleTerminalView)it).getTerminalWidth(), (Object)((SimpleTerminalView)it).getCharSize());
        } else {
            it = this.outputView;
            boolean bl = false;
            pair = TuplesKt.to((Object)((TerminalOutputView)it).getTerminalWidth(), (Object)((TerminalOutputView)it).getCharSize());
        }
        Pair pair2 = pair;
        int width = ((Number)pair2.component1()).intValue();
        Dimension charSize = (Dimension)pair2.component2();
        return width > 0 && this.getComponent().getHeight() > 0 ? TerminalUiUtils.INSTANCE.calculateTerminalSize(new Dimension(width, this.getComponent().getHeight()), charSize) : null;
    }

    @Override
    public boolean isFocused() {
        return this.outputView.getComponent().hasFocus() || this.promptView.getComponent().hasFocus();
    }

    @Override
    public void addTerminationCallback(@NotNull Runnable onTerminated, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)onTerminated, (String)"onTerminated");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.session.addTerminationCallback(onTerminated, parentDisposable);
    }

    public void dispose() {
    }

    public static final /* synthetic */ Project access$getProject$p(BlockTerminalView $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$alternateBufferStateChanged(BlockTerminalView $this, boolean enabled) {
        $this.alternateBufferStateChanged(enabled);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/exp/BlockTerminalView$BlockTerminalPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "(Lorg/jetbrains/plugins/terminal/exp/BlockTerminalView;)V", "getData", "", "dataId", "", "intellij.terminal"})
    private final class BlockTerminalPanel
    extends JPanel
    implements DataProvider {
        public BlockTerminalPanel() {
            this.setBackground(TerminalUi.INSTANCE.getTerminalBackground());
            this.setLayout(new BorderLayout());
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
            String string = dataId;
            if (Intrinsics.areEqual((Object)string, (Object)TerminalPromptController.Companion.getKEY().getName())) {
                object = BlockTerminalView.this.promptView.getController();
            } else if (Intrinsics.areEqual((Object)string, (Object)TerminalOutputController.Companion.getKEY().getName())) {
                object = BlockTerminalView.this.outputView.getController();
            } else if (Intrinsics.areEqual((Object)string, (Object)SimpleTerminalController.Companion.getKEY().getName())) {
                SimpleTerminalView simpleTerminalView = BlockTerminalView.this.alternateBufferView;
                object = simpleTerminalView != null ? simpleTerminalView.getController() : null;
            } else {
                object = Intrinsics.areEqual((Object)string, (Object)BlockTerminalController.Companion.getKEY().getName()) ? BlockTerminalView.this.controller : (Intrinsics.areEqual((Object)string, (Object)TerminalSelectionController.Companion.getKEY().getName()) ? BlockTerminalView.this.selectionController : (Intrinsics.areEqual((Object)string, (Object)TerminalSession.Companion.getDATA_KEY().getName()) ? BlockTerminalView.this.session : null));
            }
            return object;
        }
    }
}

