/*
 * Decompiled with CFR 0.152.
 */
package training.learn;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileOpenedSyncListener;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.FocusUtil;
import com.intellij.util.ui.TimerUtil;
import java.awt.AWTEvent;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.TaskContext;
import training.dsl.impl.LessonExecutor;
import training.learn.ActionsRecorder;
import training.learn.ActionsRecorderKt;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.course.Lesson;
import training.learn.exceptons.NoTextEditor;
import training.learn.lesson.LessonManager;
import training.statistic.LessonStartingWay;
import training.statistic.StatisticBase;
import training.ui.LearnToolWindow;
import training.ui.LearningUiManager;
import training.util.DataLoader;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u001e\u001a\u00020\u000e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0016\u0010 \u001a\u00020\u000e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J$\u0010\"\u001a\u00020\u00122\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120$2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\rH\u0002J\u0016\u0010%\u001a\u00020\u00172\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\b\u0010'\u001a\u00020\u000eH\u0016J \u0010(\u001a\b\u0012\u0004\u0012\u00020\u00120$2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00120*J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00120$2\u0006\u0010,\u001a\u00020+J0\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120$2\u0006\u0010,\u001a\u00020+2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\rJ\"\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00120$2\u0006\u0010,\u001a\u00020+2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\rJ\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020\u00120$2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00120\rJ\u001a\u00102\u001a\b\u0012\u0004\u0012\u00020\u00120$2\f\u00103\u001a\b\u0012\u0004\u0012\u00020+04J\u0010\u00105\u001a\u00020+2\u0006\u00106\u001a\u000207H\u0002J@\u00108\u001a\u00020\u000b26\u00109\u001a2\u0012\u0013\u0012\u00110+\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b(,\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b(\u0002\u0012\u0004\u0012\u00020\u000e0:H\u0002J\b\u0010=\u001a\u00020\u000eH\u0002J$\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00120$2\b\b\u0002\u0010?\u001a\u00020@2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00120\rJ\u0006\u0010A\u001a\u00020\u000eR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Ltraining/learn/ActionsRecorder;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "lessonExecutor", "Ltraining/dsl/impl/LessonExecutor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Ltraining/dsl/impl/LessonExecutor;)V", "actionListeners", "", "Lcom/intellij/openapi/actionSystem/ex/AnActionListener;", "checkCallback", "Lkotlin/Function0;", "", "commandListener", "Lcom/intellij/openapi/command/CommandListener;", "<set-?>", "", "disposed", "getDisposed", "()Z", "documentListeners", "Lcom/intellij/openapi/editor/event/DocumentListener;", "editorListener", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "eventDispatchers", "Lcom/intellij/ide/IdeEventQueue$EventDispatcher;", "timer", "Ljavax/swing/Timer;", "addKeyEventListener", "onKeyEvent", "addSimpleCommandListener", "check", "checkAndCancelForException", "future", "Ljava/util/concurrent/CompletableFuture;", "createDocumentListener", "onDocumentChange", "dispose", "futureAction", "checkId", "Lkotlin/Function1;", "", "actionId", "futureActionAndCheckAround", "before", "futureActionOnStart", "futureCheck", "checkFunction", "futureListActions", "listOfActions", "", "getActionId", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "registerActionListener", "processAction", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "removeListeners", "timerCheck", "delayMillis", "", "tryToCheckCallback", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nActionsRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionsRecorder.kt\ntraining/learn/ActionsRecorder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n1#2:346\n1855#3,2:347\n1855#3,2:349\n*S KotlinDebug\n*F\n+ 1 ActionsRecorder.kt\ntraining/learn/ActionsRecorder\n*L\n298#1:347,2\n299#1:349,2\n*E\n"})
public final class ActionsRecorder
implements Disposable {
    @NotNull
    private final Project project;
    @Nullable
    private final Document document;
    @NotNull
    private final LessonExecutor lessonExecutor;
    @NotNull
    private final List<DocumentListener> documentListeners;
    @NotNull
    private final List<AnActionListener> actionListeners;
    @NotNull
    private final List<IdeEventQueue.EventDispatcher> eventDispatchers;
    private boolean disposed;
    @Nullable
    private Timer timer;
    @Nullable
    private CommandListener commandListener;
    @Nullable
    private FileEditorManagerListener editorListener;
    @Nullable
    private Function0<Unit> checkCallback;

    public ActionsRecorder(@NotNull Project project, @Nullable Document document, @NotNull LessonExecutor lessonExecutor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lessonExecutor, (String)"lessonExecutor");
        this.project = project;
        this.document = document;
        this.lessonExecutor = lessonExecutor;
        this.documentListeners = new ArrayList();
        this.actionListeners = new ArrayList();
        this.eventDispatchers = new ArrayList();
        Disposer.register((Disposable)this.lessonExecutor, (Disposable)this);
        MessageBusConnection busConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = AnActionListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        busConnection.subscribe(topic, (Object)new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Iterable $this$forEach$iv = actionListeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AnActionListener it = (AnActionListener)element$iv;
                    boolean bl = false;
                    it.beforeActionPerformed(action2, event);
                }
            }

            public void afterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                Iterable $this$forEach$iv = actionListeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AnActionListener it = (AnActionListener)element$iv;
                    boolean bl = false;
                    it.afterActionPerformed(action2, event, result2);
                }
            }

            public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
                Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                Iterable $this$forEach$iv = actionListeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AnActionListener it = (AnActionListener)element$iv;
                    boolean bl = false;
                    it.beforeEditorTyping(c, dataContext);
                }
            }
        });
        Topic topic2 = CommandListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        busConnection.subscribe(topic2, (Object)new CommandListener(){

            public void commandStarted(@NotNull CommandEvent event) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    CommandListener commandListener = commandListener;
                    if (commandListener == null) break block0;
                    commandListener.commandStarted(event);
                }
            }

            public void beforeCommandFinished(@NotNull CommandEvent event) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    CommandListener commandListener = commandListener;
                    if (commandListener == null) break block0;
                    commandListener.beforeCommandFinished(event);
                }
            }

            public void commandFinished(@NotNull CommandEvent event) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    CommandListener commandListener = commandListener;
                    if (commandListener == null) break block0;
                    commandListener.commandFinished(event);
                }
            }

            public void undoTransparentActionStarted() {
                block0: {
                    CommandListener commandListener = commandListener;
                    if (commandListener == null) break block0;
                    commandListener.undoTransparentActionStarted();
                }
            }

            public void beforeUndoTransparentActionFinished() {
                block0: {
                    CommandListener commandListener = commandListener;
                    if (commandListener == null) break block0;
                    commandListener.beforeUndoTransparentActionFinished();
                }
            }

            public void undoTransparentActionFinished() {
                block0: {
                    CommandListener commandListener = commandListener;
                    if (commandListener == null) break block0;
                    commandListener.undoTransparentActionFinished();
                }
            }
        });
        busConnection.subscribe(FileOpenedSyncListener.TOPIC, (Object)new FileOpenedSyncListener(){

            public void fileOpenedSync(@NotNull FileEditorManager source, @NotNull VirtualFile file, @NotNull List<FileEditorWithProvider> editorsWithProviders) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter(editorsWithProviders, (String)"editorsWithProviders");
                    FileEditorManagerListener fileEditorManagerListener = editorListener;
                    if (fileEditorManagerListener == null) break block0;
                    fileEditorManagerListener.fileOpenedSync(source, file, editorsWithProviders);
                }
            }
        });
        Topic topic3 = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic3, (String)"FILE_EDITOR_MANAGER");
        busConnection.subscribe(topic3, (Object)new FileEditorManagerListener(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    FileEditorManagerListener fileEditorManagerListener = editorListener;
                    if (fileEditorManagerListener == null) break block0;
                    fileEditorManagerListener.fileClosed(source, file);
                }
            }

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    FileEditorManagerListener fileEditorManagerListener = editorListener;
                    if (fileEditorManagerListener == null) break block0;
                    fileEditorManagerListener.fileOpened(source, file);
                }
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    FileEditorManagerListener fileEditorManagerListener = editorListener;
                    if (fileEditorManagerListener == null) break block0;
                    fileEditorManagerListener.selectionChanged(event);
                }
            }
        });
    }

    public final boolean getDisposed() {
        return this.disposed;
    }

    public void dispose() {
        this.removeListeners();
        this.disposed = true;
    }

    @NotNull
    public final CompletableFuture<Boolean> futureActionOnStart(@NotNull String actionId, @NotNull Function0<Boolean> check2) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter(check2, (String)"check");
        CompletableFuture<Boolean> future2 = new CompletableFuture<Boolean>();
        AnActionListener actionListener2 = new AnActionListener(this, future2, actionId, check2){
            final /* synthetic */ ActionsRecorder this$0;
            final /* synthetic */ CompletableFuture<Boolean> $future;
            final /* synthetic */ String $actionId;
            final /* synthetic */ Function0<Boolean> $check;
            {
                this.this$0 = $receiver;
                this.$future = $future;
                this.$actionId = $actionId;
                this.$check = $check;
            }

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ActionsRecorder.access$checkAndCancelForException(this.this$0, this.$future, (Function0)new Function0<Boolean>(this.this$0, action2, this.$actionId, this.$check){
                    final /* synthetic */ ActionsRecorder this$0;
                    final /* synthetic */ AnAction $action;
                    final /* synthetic */ String $actionId;
                    final /* synthetic */ Function0<Boolean> $check;
                    {
                        this.this$0 = $receiver;
                        this.$action = $action;
                        this.$actionId = $actionId;
                        this.$check = $check;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return Intrinsics.areEqual((Object)ActionsRecorder.access$getActionId(this.this$0, this.$action), (Object)this.$actionId) && (Boolean)this.$check.invoke() != false;
                    }
                });
            }
        };
        this.actionListeners.add(actionListener2);
        return future2;
    }

    @NotNull
    public final CompletableFuture<Boolean> futureActionAndCheckAround(@NotNull String actionId, @NotNull Function0<Unit> before, @NotNull Function0<Boolean> check2) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter(before, (String)"before");
        Intrinsics.checkNotNullParameter(check2, (String)"check");
        CompletableFuture<Boolean> future2 = new CompletableFuture<Boolean>();
        AnActionListener actionListener2 = new AnActionListener(actionId, before, this, future2, check2){
            final /* synthetic */ String $actionId;
            final /* synthetic */ Function0<Unit> $before;
            final /* synthetic */ ActionsRecorder this$0;
            final /* synthetic */ CompletableFuture<Boolean> $future;
            final /* synthetic */ Function0<Boolean> $check;
            {
                this.$actionId = $actionId;
                this.$before = $before;
                this.this$0 = $receiver;
                this.$future = $future;
                this.$check = $check;
            }

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                String caughtActionId = ActionManager.getInstance().getId(action2);
                if (Intrinsics.areEqual((Object)this.$actionId, (Object)caughtActionId)) {
                    this.$before.invoke();
                } else if (caughtActionId != null) {
                    ActionsRecorder.access$setCommandListener$p(this.this$0, null);
                }
            }

            public void afterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
                boolean complete;
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                if (Intrinsics.areEqual((Object)this.$actionId, (Object)ActionManager.getInstance().getId(action2)) && !(complete = this.checkComplete())) {
                    ActionsRecorder.access$addSimpleCommandListener(this.this$0, (Function0)new Function0<Unit>(this){
                        final /* synthetic */ futureActionAndCheckAround.actionListener.1 this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            futureActionAndCheckAround.actionListener.1.access$checkComplete(this.this$0);
                        }
                    });
                }
            }

            public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
                Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            }

            private final boolean checkComplete() {
                return ActionsRecorder.access$checkAndCancelForException(this.this$0, this.$future, this.$check);
            }

            public static final /* synthetic */ boolean access$checkComplete(futureActionAndCheckAround.actionListener.1 $this) {
                return $this.checkComplete();
            }
        };
        this.actionListeners.add(actionListener2);
        return future2;
    }

    @NotNull
    public final CompletableFuture<Boolean> futureAction(@NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        CompletableFuture<Boolean> future2 = new CompletableFuture<Boolean>();
        this.registerActionListener((Function2<? super String, ? super Project, Unit>)((Function2)new Function2<String, Project, Unit>(actionId, future2){
            final /* synthetic */ String $actionId;
            final /* synthetic */ CompletableFuture<Boolean> $future;
            {
                this.$actionId = $actionId;
                this.$future = $future;
                super(2);
            }

            public final void invoke(@NotNull String caughtActionId, @NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)caughtActionId, (String)"caughtActionId");
                Intrinsics.checkNotNullParameter((Object)project, (String)"<anonymous parameter 1>");
                if (Intrinsics.areEqual((Object)this.$actionId, (Object)caughtActionId)) {
                    this.$future.complete(true);
                }
            }
        }));
        return future2;
    }

    @NotNull
    public final CompletableFuture<Boolean> futureAction(@NotNull Function1<? super String, Boolean> checkId) {
        Intrinsics.checkNotNullParameter(checkId, (String)"checkId");
        CompletableFuture<Boolean> future2 = new CompletableFuture<Boolean>();
        this.registerActionListener((Function2<? super String, ? super Project, Unit>)((Function2)new Function2<String, Project, Unit>(checkId, future2){
            final /* synthetic */ Function1<String, Boolean> $checkId;
            final /* synthetic */ CompletableFuture<Boolean> $future;
            {
                this.$checkId = $checkId;
                this.$future = $future;
                super(2);
            }

            public final void invoke(@NotNull String caughtActionId, @NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)caughtActionId, (String)"caughtActionId");
                Intrinsics.checkNotNullParameter((Object)project, (String)"<anonymous parameter 1>");
                if (((Boolean)this.$checkId.invoke((Object)caughtActionId)).booleanValue()) {
                    this.$future.complete(true);
                }
            }
        }));
        return future2;
    }

    @NotNull
    public final CompletableFuture<Boolean> futureListActions(@NotNull List<String> listOfActions) {
        Intrinsics.checkNotNullParameter(listOfActions, (String)"listOfActions");
        CompletableFuture<Boolean> future2 = new CompletableFuture<Boolean>();
        List mutableListOfActions = CollectionsKt.toMutableList((Collection)listOfActions);
        this.registerActionListener((Function2<? super String, ? super Project, Unit>)((Function2)new Function2<String, Project, Unit>((List<String>)mutableListOfActions, future2){
            final /* synthetic */ List<String> $mutableListOfActions;
            final /* synthetic */ CompletableFuture<Boolean> $future;
            {
                this.$mutableListOfActions = $mutableListOfActions;
                this.$future = $future;
                super(2);
            }

            public final void invoke(@NotNull String caughtActionId, @NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)caughtActionId, (String)"caughtActionId");
                Intrinsics.checkNotNullParameter((Object)project, (String)"<anonymous parameter 1>");
                if (!((Collection)this.$mutableListOfActions).isEmpty() && Intrinsics.areEqual((Object)CollectionsKt.first(this.$mutableListOfActions), (Object)caughtActionId)) {
                    this.$mutableListOfActions.remove(0);
                }
                if (this.$mutableListOfActions.isEmpty()) {
                    this.$future.complete(true);
                }
            }
        }));
        this.editorListener = new FileEditorManagerListener(mutableListOfActions, future2){
            final /* synthetic */ List<String> $mutableListOfActions;
            final /* synthetic */ CompletableFuture<Boolean> $future;
            {
                this.$mutableListOfActions = $mutableListOfActions;
                this.$future = $future;
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = event.getNewFile();
                String string = virtualFile != null ? virtualFile.getName() : null;
                List<String> list2 = this.$mutableListOfActions;
                CompletableFuture<Boolean> completableFuture = this.$future;
                String it = string;
                boolean bl = false;
                if (!((Collection)list2).isEmpty()) {
                    VirtualFile virtualFile2 = event.getNewFile();
                    if (Intrinsics.areEqual((Object)CollectionsKt.first(list2), (Object)(virtualFile2 != null ? virtualFile2.getName() : null))) {
                        list2.remove(0);
                    }
                }
                if (list2.isEmpty()) {
                    completableFuture.complete(true);
                }
            }
        };
        return future2;
    }

    @NotNull
    public final CompletableFuture<Boolean> timerCheck(int delayMillis, @NotNull Function0<Boolean> checkFunction2) {
        Intrinsics.checkNotNullParameter(checkFunction2, (String)"checkFunction");
        CompletableFuture<Boolean> future2 = new CompletableFuture<Boolean>();
        Timer timer = this.timer;
        if (timer == null) {
            Timer timer2;
            Timer it = timer2 = TimerUtil.createNamedTimer((String)"State Timer Check", (int)delayMillis);
            boolean bl = false;
            this.timer = it;
            it.start();
            Timer timer3 = timer2;
            timer = timer3;
            Intrinsics.checkNotNullExpressionValue((Object)timer3, (String)"also(...)");
        }
        Timer t = timer;
        t.addActionListener(arg_0 -> ActionsRecorder.timerCheck$lambda$1(checkFunction2, future2, arg_0));
        return future2;
    }

    public static /* synthetic */ CompletableFuture timerCheck$default(ActionsRecorder actionsRecorder, int n, Function0 function0, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 200;
        }
        return actionsRecorder.timerCheck(n, (Function0<Boolean>)function0);
    }

    @NotNull
    public final CompletableFuture<Boolean> futureCheck(@NotNull Function0<Boolean> checkFunction2) {
        Function0 check2;
        Intrinsics.checkNotNullParameter(checkFunction2, (String)"checkFunction");
        CompletableFuture<Boolean> future2 = new CompletableFuture<Boolean>();
        this.checkCallback = check2 = (Function0)new Function0<Unit>(this, future2, checkFunction2){
            final /* synthetic */ ActionsRecorder this$0;
            final /* synthetic */ CompletableFuture<Boolean> $future;
            final /* synthetic */ Function0<Boolean> $checkFunction;
            {
                this.this$0 = $receiver;
                this.$future = $future;
                this.$checkFunction = $checkFunction;
                super(0);
            }

            public final void invoke() {
                ActionsRecorder.access$checkAndCancelForException(this.this$0, this.$future, this.$checkFunction);
            }
        };
        this.addKeyEventListener((Function0<Unit>)((Function0)new Function0<Unit>((Function0<Unit>)check2){
            final /* synthetic */ Function0<Unit> $check;
            {
                this.$check = $check;
                super(0);
            }

            public final void invoke() {
                this.$check.invoke();
            }
        }));
        Document document = this.document;
        if (document != null) {
            document.addDocumentListener(this.createDocumentListener((Function0<Unit>)((Function0)new Function0<Unit>((Function0<Unit>)check2){
                final /* synthetic */ Function0<Unit> $check;
                {
                    this.$check = $check;
                    super(0);
                }

                public final void invoke() {
                    this.$check.invoke();
                }
            })));
        }
        this.addSimpleCommandListener((Function0<Unit>)check2);
        this.actionListeners.add(new AnActionListener((Function0<Unit>)check2){
            final /* synthetic */ Function0<Unit> $check;
            {
                this.$check = $check;
            }

            public void afterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                this.$check.invoke();
            }
        });
        FocusUtil.addFocusOwnerListener((Disposable)this, arg_0 -> ActionsRecorder.futureCheck$lambda$2(check2, arg_0));
        return future2;
    }

    public final void tryToCheckCallback() {
        block0: {
            Function0<Unit> function0 = this.checkCallback;
            if (function0 == null) break block0;
            Function0<Unit> it = function0;
            boolean bl = false;
            it.invoke();
        }
    }

    private final void addSimpleCommandListener(Function0<Unit> check2) {
        this.commandListener = new CommandListener(check2){
            final /* synthetic */ Function0<Unit> $check;
            {
                this.$check = $check;
            }

            public void commandFinished(@NotNull CommandEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$check.invoke();
            }
        };
    }

    private final void addKeyEventListener(Function0<Unit> onKeyEvent) {
        IdeEventQueue.EventDispatcher myEventDispatcher = arg_0 -> ActionsRecorder.addKeyEventListener$lambda$4(onKeyEvent, arg_0);
        this.eventDispatchers.add(myEventDispatcher);
        IdeEventQueue.Companion.getInstance().addDispatcher(myEventDispatcher, (Disposable)this);
    }

    private final DocumentListener createDocumentListener(Function0<Unit> onDocumentChange) {
        DocumentListener documentListener2 = new DocumentListener(this, onDocumentChange){
            final /* synthetic */ ActionsRecorder this$0;
            final /* synthetic */ Function0<Unit> $onDocumentChange;
            {
                this.this$0 = $receiver;
                this.$onDocumentChange = $onDocumentChange;
            }

            public void beforeDocumentChange(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            }

            /*
             * WARNING - void declaration
             */
            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (ActionsRecorder.access$getDocument$p(this.this$0) != null && PsiDocumentManager.getInstance((Project)ActionsRecorder.access$getProject$p(this.this$0)).isUncommited(ActionsRecorder.access$getDocument$p(this.this$0))) {
                    void $this$iv;
                    LessonExecutor lessonExecutor = ActionsRecorder.access$getLessonExecutor$p(this.this$0);
                    ActionsRecorder actionsRecorder = this.this$0;
                    Function0<Unit> function0 = this.$onDocumentChange;
                    ModalityState modalityState$iv = null;
                    boolean $i$f$taskInvokeLater = false;
                    ActionsKt.invokeLater(modalityState$iv, (Function0)((Function0)new Function0<Unit>((LessonExecutor)$this$iv, actionsRecorder, function0){
                        final /* synthetic */ LessonExecutor this$0$inline_fun;
                        final /* synthetic */ ActionsRecorder this$0;
                        final /* synthetic */ Function0 $onDocumentChange$inlined;
                        {
                            this.this$0$inline_fun = $receiver;
                            this.this$0 = actionsRecorder;
                            this.$onDocumentChange$inlined = function0;
                            super(0);
                        }

                        public final void invoke() {
                            try {
                                if (!this.this$0$inline_fun.getHasBeenStopped()) {
                                    boolean bl = false;
                                    if (!this.this$0.getDisposed() && !ActionsRecorder.access$getProject$p(this.this$0).isDisposed()) {
                                        PsiDocumentManager.getInstance((Project)ActionsRecorder.access$getProject$p(this.this$0)).commitAndRunReadAction(new Runnable((Function0<Unit>)this.$onDocumentChange$inlined){
                                            final /* synthetic */ Function0<Unit> $onDocumentChange;
                                            {
                                                this.$onDocumentChange = $onDocumentChange;
                                            }

                                            public final void run() {
                                                this.$onDocumentChange.invoke();
                                            }
                                        });
                                    }
                                }
                            }
                            catch (Throwable e) {
                                LessonExecutor $this$thisLogger$iv = this.this$0$inline_fun;
                                boolean $i$f$thisLogger = false;
                                Logger logger = Logger.getInstance(LessonExecutor.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                                logger.error(this.this$0$inline_fun.getLessonInfoString(), e);
                            }
                        }
                    }));
                }
            }
        };
        this.documentListeners.add(documentListener2);
        return documentListener2;
    }

    private final AnActionListener registerActionListener(Function2<? super String, ? super Project, Unit> processAction) {
        AnActionListener actionListener2 = new AnActionListener(processAction, this){
            final /* synthetic */ Function2<String, Project, Unit> $processAction;
            final /* synthetic */ ActionsRecorder this$0;
            {
                this.$processAction = $processAction;
                this.this$0 = $receiver;
            }

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$processAction.invoke((Object)ActionsRecorder.access$getActionId(this.this$0, action2), (Object)ActionsRecorder.access$getProject$p(this.this$0));
            }
        };
        this.actionListeners.add(actionListener2);
        return actionListener2;
    }

    private final void removeListeners() {
        DocumentListener it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        if (!((Collection)this.documentListeners).isEmpty() && this.document != null) {
            $this$forEach$iv = this.documentListeners;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (DocumentListener)element$iv;
                boolean bl = false;
                this.document.removeDocumentListener(it);
            }
        }
        if (!((Collection)this.eventDispatchers).isEmpty()) {
            $this$forEach$iv = this.eventDispatchers;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (IdeEventQueue.EventDispatcher)element$iv;
                boolean bl = false;
                IdeEventQueue.Companion.getInstance().removeDispatcher((IdeEventQueue.EventDispatcher)it);
            }
        }
        this.actionListeners.clear();
        this.documentListeners.clear();
        this.eventDispatchers.clear();
        this.commandListener = null;
        this.editorListener = null;
        Timer timer = this.timer;
        if (timer != null) {
            timer.stop();
        }
        this.timer = null;
    }

    private final String getActionId(AnAction action2) {
        String actionId;
        String string = ActionManager.getInstance().getId(action2);
        if (string == null) {
            string = actionId = action2.getClass().getName();
        }
        if (DataLoader.INSTANCE.getLiveMode()) {
            System.out.println((Object)actionId);
        }
        Intrinsics.checkNotNull((Object)actionId);
        return actionId;
    }

    private final boolean checkAndCancelForException(CompletableFuture<Boolean> future2, Function0<Boolean> check2) {
        try {
            if (!future2.isDone() && !future2.isCancelled() && ((Boolean)check2.invoke()).booleanValue()) {
                future2.complete(true);
                return true;
            }
            return false;
        }
        catch (NoTextEditor e) {
            LearnToolWindow activeToolWindow = LearningUiManager.INSTANCE.getActiveToolWindow$intellij_featuresTrainer();
            Lesson lesson = LessonManager.Companion.getInstance().getCurrentLesson();
            if (activeToolWindow != null && lesson != null) {
                TaskContext.RestoreNotification notification2 = new TaskContext.RestoreNotification(LearnBundle.INSTANCE.message("learn.restore.notification.editor.closed", new Object[0]), null, (Function0)new Function0<Unit>(activeToolWindow, lesson){
                    final /* synthetic */ LearnToolWindow $activeToolWindow;
                    final /* synthetic */ Lesson $lesson;
                    {
                        this.$activeToolWindow = $activeToolWindow;
                        this.$lesson = $lesson;
                        super(0);
                    }

                    public final void invoke() {
                        CourseManager.openLesson$default(CourseManager.Companion.getInstance(), this.$activeToolWindow.getProject(), this.$lesson, LessonStartingWay.RESTORE_LINK, false, false, 24, null);
                    }
                }, 2, null);
                LessonManager.Companion.getInstance().setRestoreNotification(notification2);
            }
            if (!StatisticBase.Companion.isLearnProjectCloseLogged()) {
                StatisticBase.Companion.logLessonStopped(StatisticBase.LessonStopReason.CLOSE_FILE);
            }
            LessonManager.Companion.getInstance().stopLesson();
        }
        catch (Exception e) {
            ActionsRecorderKt.access$getLOG$p().error("IFT check produces exception", (Throwable)e);
        }
        return false;
    }

    private static final void timerCheck$lambda$1(Function0 $checkFunction, CompletableFuture $future, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$checkFunction, (String)"$checkFunction");
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        if (((Boolean)$checkFunction.invoke()).booleanValue()) {
            $future.complete(true);
        }
    }

    private static final void futureCheck$lambda$2(Function0 $check, PropertyChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)$check, (String)"$check");
        $check.invoke();
    }

    private static final boolean addKeyEventListener$lambda$4(Function0 $onKeyEvent, AWTEvent e) {
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)$onKeyEvent, (String)"$onKeyEvent");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e instanceof KeyEvent) break block3;
                MouseEvent mouseEvent = e instanceof MouseEvent ? (MouseEvent)e : null;
                if (mouseEvent != null ? mouseEvent.getID() == 502 : false) break block3;
                MouseEvent mouseEvent2 = e instanceof MouseEvent ? (MouseEvent)e : null;
                boolean bl = mouseEvent2 != null ? mouseEvent2.getID() == 500 : false;
                if (!bl) break block4;
            }
            $onKeyEvent.invoke();
        }
        return false;
    }

    public static final /* synthetic */ boolean access$checkAndCancelForException(ActionsRecorder $this, CompletableFuture future2, Function0 check2) {
        return $this.checkAndCancelForException(future2, (Function0<Boolean>)check2);
    }

    public static final /* synthetic */ String access$getActionId(ActionsRecorder $this, AnAction action2) {
        return $this.getActionId(action2);
    }

    public static final /* synthetic */ void access$setCommandListener$p(ActionsRecorder $this, CommandListener commandListener) {
        $this.commandListener = commandListener;
    }

    public static final /* synthetic */ void access$addSimpleCommandListener(ActionsRecorder $this, Function0 check2) {
        $this.addSimpleCommandListener((Function0<Unit>)check2);
    }

    public static final /* synthetic */ Document access$getDocument$p(ActionsRecorder $this) {
        return $this.document;
    }

    public static final /* synthetic */ Project access$getProject$p(ActionsRecorder $this) {
        return $this.project;
    }

    public static final /* synthetic */ LessonExecutor access$getLessonExecutor$p(ActionsRecorder $this) {
        return $this.lessonExecutor;
    }
}

