/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.rsync;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.rsync.RsyncService;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RsyncStatusService
implements Disposable {
    private static final Logger LOG = Logger.getInstance(RsyncStatusService.class);
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    private final EventDispatcher<Listener> myDispatcher = EventDispatcher.create(Listener.class);
    private volatile Status myRsyncStatus = Status.UNKNOWN;

    @NotNull
    public static RsyncStatusService getInstance() {
        RsyncStatusService rsyncStatusService = (RsyncStatusService)ApplicationManager.getApplication().getService(RsyncStatusService.class);
        if (rsyncStatusService == null) {
            RsyncStatusService.$$$reportNull$$$0(0);
        }
        return rsyncStatusService;
    }

    public Status getCachedRsyncStatus() {
        this.requestStatusRefresh();
        return this.myRsyncStatus;
    }

    private void requestStatusRefresh() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> this.checkIfRSyncCommandExists(), this.myRsyncStatus == Status.UNKNOWN ? 0 : 2000);
    }

    public boolean checkIfRSyncCommandExists() {
        this.myAlarm.cancelAllRequests();
        boolean exists = RsyncStatusService.doCheckIfRsyncCommandExists();
        this.myRsyncStatus = exists ? Status.INSTALLED_AND_CONFIGURED : Status.NOT_INSTALLED_OR_CONFIGURED;
        ((Listener)this.myDispatcher.getMulticaster()).statusChanged();
        return exists;
    }

    private static boolean doCheckIfRsyncCommandExists() {
        return RsyncStatusService.validateRsyncCommand() == null;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public static String validateRsyncCommand(@NlsSafe String rsync, @NlsSafe String rsyncOptions, @NlsSafe String shell2, boolean validateSsh) {
        String message;
        String rsyncMessage = RsyncStatusService.validateTool(rsync, StringUtil.split((String)rsyncOptions, (String)","), "--version", "Rsync");
        if (rsyncMessage != null) {
            return rsyncMessage;
        }
        if (validateSsh && (message = RsyncStatusService.validateTool(shell2, Collections.emptyList(), "-V", "SSH")) != null) {
            return message;
        }
        return null;
    }

    @Nullable
    @Nls
    private static String validateTool(String command, List<String> options, String versionOption, String toolName) {
        if (StringUtil.isEmptyOrSpaces((String)command)) {
            return SshBundle.message("path.validation.rsync.command.is.not.provided", toolName);
        }
        File executablePath = new File(command);
        if (!executablePath.exists() && (executablePath = PathEnvironmentVariableUtil.findExecutableInPathOnAnyOS((String)command)) == null) {
            LOG.debug(command + " not found in Path");
            return SshBundle.message("path.validation.rsync.not.found.in.path", command, toolName);
        }
        PtyCommandLine commandLine = new PtyCommandLine(new GeneralCommandLine(new String[]{executablePath.getAbsolutePath()}));
        commandLine.withConsoleMode(false);
        ArrayList<String> parameters = new ArrayList<String>(options);
        parameters.add(versionOption);
        commandLine.addParameters(parameters);
        try {
            String commandOutput = ApplicationManager.getApplication().isDispatchThread() ? (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ScriptRunnerUtil.getProcessOutput((GeneralCommandLine)commandLine), SshBundle.message("progress.title.version", toolName), true, null) : ScriptRunnerUtil.getProcessOutput((GeneralCommandLine)commandLine);
            if (commandOutput == null) {
                return SshBundle.message("path.validation.failed.to.execute.rsync.command.0", command, toolName);
            }
            String firstLine = commandOutput.split("\n")[0];
            if (firstLine.matches(".*command not found.*")) {
                LOG.info("Tool not found for " + executablePath);
                return SshBundle.message("path.validation.rsync.command.0.was.not.found", command, toolName);
            }
            if (firstLine.matches(".*unknown option.*")) {
                LOG.info("Incorrect options for " + executablePath);
                return SshBundle.message("options.validation.rsync.command.0.are.not.correct", options);
            }
            LOG.info("Tool version: " + firstLine);
        }
        catch (ExecutionException e) {
            LOG.error("Error during execution of command " + command);
            return SshBundle.message("path.validation.failed.to.execute.rsync.command.0", command, toolName);
        }
        return null;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public static String validateRsyncCommand() {
        return RsyncStatusService.validateRsyncCommand(false);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public static String validateRsyncCommand(boolean validateSSh) {
        return RsyncStatusService.validateRsyncCommand(RsyncService.getInstance().getRsyncPath(), RsyncService.getInstance().getOptions(), RsyncService.getInstance().getShellPath(), validateSSh);
    }

    public void addListener(@NotNull Listener listener, @NotNull Disposable disposable) {
        if (listener == null) {
            RsyncStatusService.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            RsyncStatusService.$$$reportNull$$$0(2);
        }
        this.myDispatcher.addListener((EventListener)listener, disposable);
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/rsync/RsyncStatusService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/rsync/RsyncStatusService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    public static interface Listener
    extends EventListener {
        public void statusChanged();
    }

    public static enum Status {
        INSTALLED_AND_CONFIGURED,
        NOT_INSTALLED_OR_CONFIGURED,
        UNKNOWN;

    }
}

