/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.diff;

import org.jetbrains.jps.dependency.diff.Difference;

public interface DiffCapable<T extends DiffCapable<T, D>, D extends Difference> {
    public boolean isSame(DiffCapable<?, ?> var1);

    public int diffHashCode();

    public D difference(T var1);

    public static <T> Adapter<T> wrap(final T value) {
        return new Adapter<T>(){

            @Override
            public T getValue() {
                return value;
            }

            @Override
            public boolean isSame(DiffCapable<?, ?> other) {
                return other instanceof Adapter && value.equals(((Adapter)other).getValue());
            }

            @Override
            public int diffHashCode() {
                return value.hashCode();
            }

            @Override
            public Difference difference(Adapter past) {
                return () -> value.equals(past.getValue());
            }
        };
    }

    public static interface Adapter<T>
    extends DiffCapable<Adapter<T>, Difference> {
        public T getValue();
    }
}

