/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.Usage;
import org.jetbrains.jps.dependency.diff.DiffCapable;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.java.JVMFlags;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.MethodUsage;
import org.jetbrains.jps.dependency.java.ParamAnnotation;
import org.jetbrains.jps.dependency.java.ProtoMember;
import org.jetbrains.jps.dependency.java.TypeRepr;
import org.jetbrains.jps.javac.Iterators;
import org.jetbrains.org.objectweb.asm.Type;

public final class JvmMethod
extends ProtoMember
implements DiffCapable<JvmMethod, Diff> {
    private final Iterable<TypeRepr> myArgTypes;
    private final Set<ParamAnnotation> myParamAnnotations;
    private final Set<TypeRepr.ClassType> myExceptions;

    public JvmMethod(JVMFlags flags, String signature, String name, String descriptor, @NotNull Iterable<TypeRepr.ClassType> annotations, Set<ParamAnnotation> parameterAnnotations, String[] exceptions, Object defaultValue) {
        if (annotations == null) {
            JvmMethod.$$$reportNull$$$0(0);
        }
        super(flags, signature, name, TypeRepr.getType(Type.getReturnType((String)descriptor)), annotations, defaultValue);
        this.myParamAnnotations = parameterAnnotations;
        this.myExceptions = (Set)Iterators.collect((Iterable)Iterators.map((Iterable)Iterators.asIterable((Object[])exceptions), s -> new TypeRepr.ClassType((String)s)), new HashSet());
        this.myArgTypes = TypeRepr.getTypes(Type.getArgumentTypes((String)descriptor));
    }

    public boolean isConstructor() {
        return "<init>".equals(this.getName());
    }

    @Override
    public MethodUsage createUsage(String owner) {
        return new MethodUsage(owner, this.getName(), this.getDescriptor());
    }

    public BiPredicate<Node<?, ?>, Usage> createUsageQuery(String owner) {
        String thisMethodName = this.getName();
        JvmNodeReferenceID ownerID = new JvmNodeReferenceID(owner);
        return (n, u) -> u instanceof MethodUsage && ownerID.equals(u.getElementOwner()) && Objects.equals(((MethodUsage)u).getName(), thisMethodName);
    }

    public Set<ParamAnnotation> getParamAnnotations() {
        return this.myParamAnnotations;
    }

    public Set<TypeRepr.ClassType> getExceptions() {
        return this.myExceptions;
    }

    public Iterable<TypeRepr> getArgTypes() {
        return this.myArgTypes;
    }

    public boolean isSameByJavaRules(JvmMethod other) {
        return this.getName().equals(other.getName()) && Iterators.equals(this.myArgTypes, other.myArgTypes);
    }

    @Override
    public boolean isSame(DiffCapable<?, ?> other) {
        if (!(other instanceof JvmMethod)) {
            return false;
        }
        JvmMethod that = (JvmMethod)other;
        return Objects.equals(this.getType(), that.getType()) && this.isSameByJavaRules(that);
    }

    @Override
    public int diffHashCode() {
        return 31 * (31 * Iterators.hashCode(this.myArgTypes) + this.getType().hashCode()) + this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JvmMethod && this.isSame((JvmMethod)obj);
    }

    public int hashCode() {
        return this.diffHashCode();
    }

    @Override
    public Diff difference(JvmMethod past) {
        return new Diff(past);
    }

    public String getDescriptor() {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (TypeRepr t : this.myArgTypes) {
            buf.append(t.getDescriptor());
        }
        buf.append(")");
        buf.append(this.getType().getDescriptor());
        return buf.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jps/dependency/java/JvmMethod", "<init>"));
    }

    public final class Diff
    extends ProtoMember.Diff<JvmMethod> {
        public Diff(JvmMethod past) {
            super((ProtoMember)JvmMethod.this, (ProtoMember)past);
        }

        @Override
        public boolean unchanged() {
            return super.unchanged() && this.paramAnnotations().unchanged() && this.exceptions().unchanged();
        }

        public Difference.Specifier<ParamAnnotation, ?> paramAnnotations() {
            return Difference.diff(((JvmMethod)this.myPast).getParamAnnotations(), JvmMethod.this.getParamAnnotations());
        }

        public Difference.Specifier<TypeRepr.ClassType, ?> exceptions() {
            return Difference.diff(((JvmMethod)this.myPast).getExceptions(), JvmMethod.this.getExceptions());
        }
    }
}

