/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.build.events.MessageEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.compiler.progress.BuildIssueContributor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.java.LanguageLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.SetupModuleSdkQuickFix;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.UpdateSourceLevelQuickFix;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JL\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J(\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J0\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00162\u0006\u0010\r\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/JpsLanguageLevelQuickFix;", "Lcom/intellij/compiler/progress/BuildIssueContributor;", "()V", "matchersList", "", "", "createBuildIssue", "Lcom/intellij/build/issue/BuildIssue;", "project", "Lcom/intellij/openapi/project/Project;", "moduleNames", "", "title", "message", "kind", "Lcom/intellij/build/events/MessageEvent$Kind;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "navigatable", "Lcom/intellij/pom/Navigatable;", "getBuildIssueSourceVersionGreat", "sourceLanguageLevel", "Lcom/intellij/pom/java/LanguageLevel;", "moduleProjectLanguageLevel", "errorMessage", "moduleRootManager", "Lcom/intellij/openapi/roots/ModuleRootManager;", "getBuildIssueSourceVersionLess", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "getLanguageLevelFromError", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nJpsLanguageLevelQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsLanguageLevelQuickFix.kt\norg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/JpsLanguageLevelQuickFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1#2:136\n766#3:137\n857#3:138\n1726#3,3:139\n858#3:142\n1549#3:143\n1620#3,3:144\n*S KotlinDebug\n*F\n+ 1 JpsLanguageLevelQuickFix.kt\norg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/JpsLanguageLevelQuickFix\n*L\n62#1:137\n62#1:138\n62#1:139,3\n62#1:142\n63#1:143\n63#1:144,3\n*E\n"})
public final class JpsLanguageLevelQuickFix
implements BuildIssueContributor {
    @NotNull
    private final List<List<String>> matchersList;

    public JpsLanguageLevelQuickFix() {
        Object[] objectArray = new List[4];
        Object[] objectArray2 = new String[]{"source release", "requires target release"};
        objectArray[0] = CollectionsKt.listOf((Object[])objectArray2);
        objectArray2 = new String[]{"release version", "not supported"};
        objectArray[1] = CollectionsKt.listOf((Object[])objectArray2);
        objectArray[2] = CollectionsKt.listOf((Object)"invalid source release:");
        objectArray[3] = CollectionsKt.listOf((Object)"invalid target release");
        this.matchersList = CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public BuildIssue createBuildIssue(@NotNull Project project2, @NotNull Collection<String> moduleNames, @NotNull String title, @NotNull String message, @NotNull MessageEvent.Kind kind, @Nullable VirtualFile virtualFile, @Nullable Navigatable navigatable) {
        Sdk sdk;
        ModuleRootManager moduleRootManager;
        MavenProject mavenProject2;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter(moduleNames, (String)"moduleNames");
                Intrinsics.checkNotNullParameter((Object)title, (String)"title");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
                if (project2.isDisposed()) {
                    return null;
                }
                MavenProjectsManager mavenManager = MavenProjectsManager.getInstance(project2);
                if (!mavenManager.isMavenizedProject()) {
                    return null;
                }
                if (moduleNames.size() != 1) {
                    return null;
                }
                String moduleName = (String)CollectionsKt.first((Iterable)moduleNames);
                Module module2 = ModuleManager.Companion.getInstance(project2).findModuleByName(moduleName);
                if (module2 == null) {
                    return null;
                }
                Module module3 = module2;
                MavenProject mavenProject3 = mavenManager.findProject(module3);
                if (mavenProject3 == null) {
                    return null;
                }
                mavenProject2 = mavenProject3;
                ModuleRootManager moduleRootManager2 = ModuleRootManager.getInstance((Module)module3);
                if (moduleRootManager2 == null) {
                    return null;
                }
                moduleRootManager = moduleRootManager2;
                Sdk moduleJdk = moduleRootManager.getSdk();
                sdk = moduleJdk;
                if (sdk == null) break block11;
                Sdk it = sdk;
                boolean bl = false;
                LanguageLevel languageLevel = LanguageLevel.parse((String)it.getVersionString());
                sdk = languageLevel;
                if (languageLevel != null) break block12;
            }
            return null;
        }
        Sdk moduleProjectLanguageLevel = sdk;
        LanguageLevel languageLevel = this.getLanguageLevelFromError(message);
        if (languageLevel == null) {
            return null;
        }
        LanguageLevel sourceLanguageLevel = languageLevel;
        if (sourceLanguageLevel.isLessThan((LanguageLevel)moduleProjectLanguageLevel)) {
            return this.getBuildIssueSourceVersionLess(sourceLanguageLevel, (LanguageLevel)moduleProjectLanguageLevel, message, mavenProject2, moduleRootManager);
        }
        return this.getBuildIssueSourceVersionGreat(sourceLanguageLevel, (LanguageLevel)moduleProjectLanguageLevel, message, moduleRootManager);
    }

    @Nullable
    public final LanguageLevel getLanguageLevelFromError(@NotNull String message) {
        LanguageLevel languageLevel;
        String $this$mapTo$iv$iv;
        List it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Iterable $this$filter$iv = this.matchersList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block8: {
                it = (List)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$all$iv = it;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String it2 = (String)element$iv;
                        boolean bl3 = false;
                        if (StringsKt.contains$default((CharSequence)message, (CharSequence)it2, (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            it = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = message.substring(StringsKt.indexOf$default((CharSequence)message, (String)((String)CollectionsKt.first((List)it)), (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            collection.add(string);
        }
        String string = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (string == null) {
            return null;
        }
        String targetMessage = string;
        String[] stringArray = (String[])targetMessage;
        Regex $i$f$map22 = new Regex("[^.0123456789]");
        $this$mapTo$iv$iv = " ";
        CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)$i$f$map22.replace((CharSequence)stringArray, $this$mapTo$iv$iv))).toString();
        stringArray = new String[]{" "};
        String string2 = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        if (string2 != null) {
            String it3 = string2;
            boolean bl = false;
            languageLevel = LanguageLevel.parse((String)it3);
        } else {
            languageLevel = null;
        }
        return languageLevel;
    }

    private final BuildIssue getBuildIssueSourceVersionGreat(LanguageLevel sourceLanguageLevel, LanguageLevel moduleProjectLanguageLevel, String errorMessage, ModuleRootManager moduleRootManager) {
        String string = moduleRootManager.getModule().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String moduleName = string;
        SetupModuleSdkQuickFix setupModuleSdkQuickFix = new SetupModuleSdkQuickFix(moduleName, moduleRootManager.isSdkInherited());
        List quickFixes = CollectionsKt.listOf((Object)setupModuleSdkQuickFix);
        StringBuilder issueDescription = new StringBuilder(errorMessage);
        issueDescription.append("\n\n");
        Object[] objectArray = new Object[]{moduleName, moduleProjectLanguageLevel.toJavaVersion(), sourceLanguageLevel.toJavaVersion(), setupModuleSdkQuickFix.getId()};
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.source.version.great", objectArray));
        return new BuildIssue(errorMessage, issueDescription, quickFixes){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<SetupModuleSdkQuickFix> quickFixes;
            {
                this.title = $errorMessage;
                String string = $issueDescription.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                this.description = string;
                this.quickFixes = $quickFixes;
            }

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<SetupModuleSdkQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                return null;
            }
        };
    }

    private final BuildIssue getBuildIssueSourceVersionLess(LanguageLevel sourceLanguageLevel, LanguageLevel moduleProjectLanguageLevel, String errorMessage, MavenProject mavenProject2, ModuleRootManager moduleRootManager) {
        String string = moduleRootManager.getModule().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String moduleName = string;
        List quickFixes = new ArrayList();
        StringBuilder issueDescription = new StringBuilder(errorMessage);
        issueDescription.append("\n\n");
        Object[] objectArray = new Object[]{moduleName, moduleProjectLanguageLevel.toJavaVersion(), sourceLanguageLevel.toJavaVersion()};
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.source.version.less.header", objectArray));
        SetupModuleSdkQuickFix setupModuleSdkQuickFix = new SetupModuleSdkQuickFix(moduleName, moduleRootManager.isSdkInherited());
        quickFixes.add(setupModuleSdkQuickFix);
        issueDescription.append("\n");
        Object[] objectArray2 = new Object[]{sourceLanguageLevel.toJavaVersion(), setupModuleSdkQuickFix.getId()};
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.source.version.less.part1", objectArray2));
        UpdateSourceLevelQuickFix updateSourceLevelQuickFix = new UpdateSourceLevelQuickFix(mavenProject2);
        quickFixes.add(updateSourceLevelQuickFix);
        issueDescription.append("\n");
        Object[] objectArray3 = new Object[]{moduleProjectLanguageLevel.toJavaVersion(), updateSourceLevelQuickFix.getId()};
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.source.version.less.part2", objectArray3));
        return new BuildIssue(errorMessage, issueDescription, quickFixes){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            {
                this.title = $errorMessage;
                String string = $issueDescription.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                this.description = string;
                this.quickFixes = $quickFixes;
            }

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                return null;
            }
        };
    }
}

