/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.auto.reload;

import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.buildtool.MavenImportSpec;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.auto.reload.MavenProjectManagerWatcher;

@ApiStatus.Internal
public class MavenProjectRootWatcher
implements ModuleRootListener {
    @NotNull
    private final MavenProjectsManager myProjectManager;
    @NotNull
    private final MavenProjectManagerWatcher myWatcher;

    public MavenProjectRootWatcher(@NotNull MavenProjectsManager projectManager, @NotNull MavenProjectManagerWatcher watcher) {
        if (projectManager == null) {
            MavenProjectRootWatcher.$$$reportNull$$$0(0);
        }
        if (watcher == null) {
            MavenProjectRootWatcher.$$$reportNull$$$0(1);
        }
        this.myProjectManager = projectManager;
        this.myWatcher = watcher;
    }

    public void rootsChanged(@NotNull ModuleRootEvent event) {
        if (event == null) {
            MavenProjectRootWatcher.$$$reportNull$$$0(2);
        }
        List<VirtualFile> existingFiles = this.myWatcher.getProjectTree().getProjectsFiles();
        ArrayList<VirtualFile> newFiles = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> deletedFiles = new ArrayList<VirtualFile>();
        for (VirtualFile f : this.myWatcher.getProjectTree().getExistingManagedFiles()) {
            if (existingFiles.contains(f)) continue;
            newFiles.add(f);
        }
        for (VirtualFile f : existingFiles) {
            if (f.isValid()) continue;
            deletedFiles.add(f);
        }
        if (!deletedFiles.isEmpty() || !newFiles.isEmpty()) {
            this.myProjectManager.scheduleUpdateMavenProjects(new MavenImportSpec(false, false, true), newFiles, deletedFiles);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/project/auto/reload/MavenProjectRootWatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "rootsChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

