/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.build.events.MessageEvent;
import com.intellij.gradle.toolingExtension.impl.model.projectModel.GradleExternalProjectModelProvider;
import com.intellij.gradle.toolingExtension.impl.model.sourceSetModel.GradleSourceSetModelProvider;
import com.intellij.gradle.toolingExtension.impl.model.taskModel.GradleTaskModelProvider;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.debugger.DebuggerBackendExtension;
import com.intellij.openapi.externalSystem.model.ConfigurationDataImpl;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.IExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.model.project.TestData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.CanonicalPathPrefixTreeFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.prefix.map.MutablePrefixTreeMap;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleModuleVersion;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.idea.IdeaCompilerOutput;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaDependencyScope;
import org.gradle.tooling.model.idea.IdeaJavaLanguageSettings;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.gradle.tooling.model.idea.IdeaSourceDirectory;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.UnresolvedDependencySyncIssue;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.DefaultGradleExtensions;
import org.jetbrains.plugins.gradle.model.DependencyAccessorsModel;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.GradleExtensions;
import org.jetbrains.plugins.gradle.model.IntelliJProjectSettings;
import org.jetbrains.plugins.gradle.model.IntelliJSettings;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;
import org.jetbrains.plugins.gradle.model.UnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.VersionCatalogsModel;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.model.data.GradleProjectBuildScriptData;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.model.tests.ExternalTestSourceMapping;
import org.jetbrains.plugins.gradle.model.tests.ExternalTestsModel;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.ArtifactMappingService;
import org.jetbrains.plugins.gradle.service.project.DefaultProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.service.project.data.GradleExtensionsDataService;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleData;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Order(value=0x7FFFFFFE)
public final class CommonGradleProjectResolverExtension
extends AbstractProjectResolverExtension {
    private static final Logger LOG = Logger.getInstance(CommonGradleProjectResolverExtension.class);
    @NotNull
    @NonNls
    private static final String UNRESOLVED_DEPENDENCY_PREFIX = "unresolved dependency - ";
    public static final String GRADLE_VERSION_CATALOGS_DYNAMIC_SUPPORT = "gradle.version.catalogs.dynamic.support";

    @Override
    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> ideProject) {
        VersionCatalogsModel versionCatalogsModel;
        DependencyAccessorsModel dependencyAccessorsModel;
        IntelliJSettings intellijSettings;
        ExternalProject externalProject;
        if (gradleProject == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(0);
        }
        if (ideProject == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(1);
        }
        if ((externalProject = this.resolverCtx.getExtraProject(ExternalProject.class)) != null) {
            ideProject.createChild(ExternalProjectDataCache.KEY, (Object)externalProject);
            ((ProjectData)ideProject.getData()).setDescription(externalProject.getDescription());
        }
        if ((intellijSettings = (IntelliJSettings)this.resolverCtx.getExtraProject(IntelliJProjectSettings.class)) != null) {
            ideProject.createChild(ProjectKeys.CONFIGURATION, (Object)new ConfigurationDataImpl(GradleConstants.SYSTEM_ID, intellijSettings.getSettings()));
        }
        if ((dependencyAccessorsModel = this.resolverCtx.getExtraProject(DependencyAccessorsModel.class)) != null && Registry.is((String)GRADLE_VERSION_CATALOGS_DYNAMIC_SUPPORT, (boolean)false)) {
            ideProject.createChild(BuildScriptClasspathData.ACCESSORS, (Object)dependencyAccessorsModel);
        }
        if ((versionCatalogsModel = this.resolverCtx.getExtraProject(VersionCatalogsModel.class)) != null) {
            ideProject.createChild(BuildScriptClasspathData.VERSION_CATALOGS, (Object)versionCatalogsModel);
        }
    }

    @Override
    @NotNull
    public DataNode<ModuleData> createModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(2);
        }
        if (projectDataNode == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(3);
        }
        DataNode<ModuleData> mainModuleNode = GradleProjectResolverUtil.createMainModule(this.resolverCtx, gradleModule, projectDataNode);
        ModuleData mainModuleData = (ModuleData)mainModuleNode.getData();
        String mainModuleConfigPath = mainModuleData.getLinkedExternalProjectPath();
        String mainModuleFileDirectoryPath = mainModuleData.getModuleFileDirectoryPath();
        String jdkName = CommonGradleProjectResolverExtension.getJdkName(gradleModule);
        String[] moduleGroup = null;
        if (!this.resolverCtx.isUseQualifiedModuleNames()) {
            moduleGroup = CommonGradleProjectResolverExtension.getIdeModuleGroup(mainModuleData.getInternalName(), gradleModule);
            mainModuleData.setIdeModuleGroup(moduleGroup);
        }
        if (this.resolverCtx.isResolveModulePerSourceSet()) {
            ExternalProject externalProject = CommonGradleProjectResolverExtension.getExternalProject(gradleModule, this.resolverCtx);
            assert (externalProject != null);
            for (ExternalSourceSet sourceSet : externalProject.getSourceSets().values()) {
                String moduleId = GradleProjectResolverUtil.getModuleId(this.resolverCtx, gradleModule, sourceSet);
                String moduleExternalName = gradleModule.getName() + ":" + sourceSet.getName();
                String moduleInternalName = GradleProjectResolverUtil.getInternalModuleName(gradleModule, externalProject, sourceSet.getName(), this.resolverCtx);
                GradleSourceSetData sourceSetData = new GradleSourceSetData(moduleId, moduleExternalName, moduleInternalName, mainModuleFileDirectoryPath, mainModuleConfigPath);
                sourceSetData.setGroup(externalProject.getGroup());
                if ("main".equals(sourceSet.getName())) {
                    sourceSetData.setPublication((ProjectCoordinate)new ProjectId(externalProject.getGroup(), externalProject.getName(), externalProject.getVersion()));
                }
                sourceSetData.setVersion(externalProject.getVersion());
                sourceSetData.setIdeModuleGroup(moduleGroup);
                sourceSetData.internalSetSourceCompatibility(sourceSet.getSourceCompatibility());
                sourceSetData.internalSetTargetCompatibility(sourceSet.getTargetCompatibility());
                sourceSetData.internalSetSdkName(jdkName);
                Set artifacts = FileCollectionFactory.createCanonicalFileSet();
                if ("main".equals(sourceSet.getName())) {
                    Set defaultArtifacts = (Set)externalProject.getArtifactsByConfiguration().get("default");
                    if (defaultArtifacts != null) {
                        artifacts.addAll(defaultArtifacts);
                    }
                } else if ("test".equals(sourceSet.getName())) {
                    sourceSetData.setProductionModuleId(GradleProjectResolverUtil.getInternalModuleName(gradleModule, externalProject, "main", this.resolverCtx));
                    Set testsArtifacts = (Set)externalProject.getArtifactsByConfiguration().get("tests");
                    if (testsArtifacts != null) {
                        artifacts.addAll(testsArtifacts);
                    }
                }
                artifacts.addAll(sourceSet.getArtifacts());
                for (ExternalSourceDirectorySet directorySet : sourceSet.getSources().values()) {
                    artifacts.addAll(directorySet.getGradleOutputDirs());
                }
                sourceSetData.setArtifacts(new ArrayList(artifacts));
                DataNode sourceSetDataNode = mainModuleNode.createChild(GradleSourceSetData.KEY, (Object)sourceSetData);
                Map sourceSetMap = (Map)projectDataNode.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
                assert (sourceSetMap != null);
                sourceSetMap.put(moduleId, Pair.create((Object)sourceSetDataNode, (Object)sourceSet));
            }
        } else {
            try {
                IdeaJavaLanguageSettings languageSettings = gradleModule.getJavaLanguageSettings();
                if (languageSettings != null) {
                    if (languageSettings.getLanguageLevel() != null) {
                        mainModuleData.internalSetSourceCompatibility(languageSettings.getLanguageLevel().toString());
                    }
                    if (languageSettings.getTargetBytecodeVersion() != null) {
                        mainModuleData.internalSetTargetCompatibility(languageSettings.getTargetBytecodeVersion().toString());
                    }
                }
                mainModuleData.internalSetSdkName(jdkName);
            }
            catch (UnsupportedMethodException languageSettings) {
                // empty catch block
            }
        }
        ProjectData projectData = (ProjectData)projectDataNode.getData();
        if (StringUtil.equals((CharSequence)mainModuleData.getLinkedExternalProjectPath(), (CharSequence)projectData.getLinkedExternalProjectPath())) {
            projectData.setGroup(mainModuleData.getGroup());
            projectData.setVersion(mainModuleData.getVersion());
        }
        CommonGradleProjectResolverExtension.populateBuildScriptSource(gradleModule, mainModuleNode);
        DataNode<ModuleData> dataNode = mainModuleNode;
        if (dataNode == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(4);
        }
        return dataNode;
    }

    private static void populateBuildScriptSource(@NotNull IdeaModule ideaModule, @NotNull DataNode<? extends ModuleData> mainModuleNode) {
        if (ideaModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(5);
        }
        if (mainModuleNode == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(6);
        }
        try {
            File buildScriptSource = ideaModule.getGradleProject().getBuildScript().getSourceFile();
            GradleProjectBuildScriptData buildProjectData = new GradleProjectBuildScriptData(buildScriptSource);
            mainModuleNode.createChild(GradleProjectBuildScriptData.KEY, (Object)buildProjectData);
        }
        catch (UnsupportedMethodException unsupportedMethodException) {
            // empty catch block
        }
    }

    private static String @NotNull [] getIdeModuleGroup(String moduleName, IdeaModule gradleModule) {
        String gradlePath2 = gradleModule.getGradleProject().getPath();
        String rootName = gradleModule.getProject().getName();
        if (StringUtil.isEmpty((String)gradlePath2) || ":".equals(gradlePath2)) {
            String[] stringArray = new String[]{moduleName};
            if (stringArray == null) {
                CommonGradleProjectResolverExtension.$$$reportNull$$$0(7);
            }
            return stringArray;
        }
        String[] stringArray = (rootName + gradlePath2).split(":");
        if (stringArray == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    @Nullable
    private static String getJdkName(@NotNull IdeaModule gradleModule) {
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(9);
        }
        try {
            return gradleModule.getJdkName();
        }
        catch (UnsupportedMethodException e) {
            return null;
        }
    }

    @Override
    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        ProjectImportAction.AllModels models;
        ExternalTestsModel externalTestsModel;
        IntelliJSettings intellijSettings;
        GradleExtensions gradleExtensions;
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(10);
        }
        if (ideModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(11);
        }
        if ((gradleExtensions = this.resolverCtx.getExtraProject(gradleModule, GradleExtensions.class)) != null) {
            boolean isGradleProxyClass = gradleExtensions instanceof Proxy || !(gradleExtensions instanceof DefaultGradleExtensions);
            DefaultGradleExtensions extensions = isGradleProxyClass ? new DefaultGradleExtensions(gradleExtensions) : (DefaultGradleExtensions)gradleExtensions;
            ExternalProject externalProject = CommonGradleProjectResolverExtension.getExternalProject(gradleModule, this.resolverCtx);
            if (externalProject != null) {
                extensions.addTasks(externalProject.getTasks().values());
            }
            ideModule.createChild(GradleExtensionsDataService.KEY, (Object)extensions);
        }
        if ((intellijSettings = this.resolverCtx.getExtraProject(gradleModule, IntelliJSettings.class)) != null) {
            ideModule.createChild(ProjectKeys.CONFIGURATION, (Object)new ConfigurationDataImpl(GradleConstants.SYSTEM_ID, intellijSettings.getSettings()));
        }
        if ((externalTestsModel = (ExternalTestsModel)(models = this.resolverCtx.getModels()).getModel((ProjectModel)gradleModule, ExternalTestsModel.class)) != null) {
            for (ExternalTestSourceMapping testSourceMapping : externalTestsModel.getTestSourceMappings()) {
                String testName = testSourceMapping.getTestName();
                String testTaskName = testSourceMapping.getTestTaskPath();
                Set sourceFolders = testSourceMapping.getSourceFolders();
                TestData testData = new TestData(GradleConstants.SYSTEM_ID, testName, testTaskName, sourceFolders);
                ideModule.createChild(ProjectKeys.TEST, (Object)testData);
            }
        }
    }

    @Override
    public void populateModuleContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(12);
        }
        if (ideModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(13);
        }
        ExternalProject externalProject = CommonGradleProjectResolverExtension.getExternalProject(gradleModule, this.resolverCtx);
        Set<Object> sourceSetContentRoots = Set.of();
        if (externalProject != null) {
            sourceSetContentRoots = this.addExternalProjectContentRoots(gradleModule, ideModule, externalProject);
        }
        MutablePrefixTreeMap contentRootIndex = CanonicalPathPrefixTreeFactory.INSTANCE.createMap(new kotlin.Pair[0]);
        for (Object contentRootDataNode : ExternalSystemApiUtil.findAll(ideModule, (Key)ProjectKeys.CONTENT_ROOT)) {
            ContentRootData contentRootData = (ContentRootData)contentRootDataNode.getData();
            contentRootIndex.set((Object)contentRootData.getRootPath(), (Object)contentRootData);
        }
        DomainObjectSet contentRoots = gradleModule.getContentRoots();
        if (contentRoots == null) {
            return;
        }
        for (IdeaContentRoot gradleContentRoot : contentRoots) {
            List testResourceDirectories;
            List resourceDirectories;
            List testDirectories;
            List sourceDirectories;
            boolean oldGradle;
            block13: {
                File rootDirectory;
                if (gradleContentRoot == null || (rootDirectory = gradleContentRoot.getRootDirectory()) == null) continue;
                oldGradle = false;
                String contentRootPath = FileUtil.toCanonicalPath((String)rootDirectory.getPath());
                boolean sameAsSourceSetContentRoot = sourceSetContentRoots.contains(contentRootPath);
                if (!sameAsSourceSetContentRoot) {
                    ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, contentRootPath);
                    contentRootIndex.set((Object)contentRootPath, (Object)ideContentRoot);
                    Set excluded = gradleContentRoot.getExcludeDirectories();
                    if (excluded != null) {
                        for (File file : excluded) {
                            ideContentRoot.storePath(ExternalSystemSourceType.EXCLUDED, file.getPath());
                        }
                    }
                }
                boolean sourceSetsAreNotConfigured = sourceSetContentRoots.isEmpty();
                if (this.resolverCtx.isResolveModulePerSourceSet() && !sourceSetsAreNotConfigured) continue;
                sourceDirectories = gradleContentRoot.getSourceDirectories().getAll();
                testDirectories = gradleContentRoot.getTestDirectories().getAll();
                resourceDirectories = Collections.emptyList();
                testResourceDirectories = Collections.emptyList();
                try {
                    Set<File> notResourceDirs = CommonGradleProjectResolverExtension.collectExplicitNonResourceDirectories(externalProject);
                    resourceDirectories = gradleContentRoot.getResourceDirectories().getAll();
                    CommonGradleProjectResolverExtension.removeDuplicateResources(sourceDirectories, resourceDirectories, notResourceDirs);
                    testResourceDirectories = gradleContentRoot.getTestResourceDirectories().getAll();
                    CommonGradleProjectResolverExtension.removeDuplicateResources(testDirectories, testResourceDirectories, notResourceDirs);
                }
                catch (UnsupportedMethodException e) {
                    oldGradle = true;
                    LOG.debug(e.getMessage());
                    if (externalProject != null) break block13;
                    CommonGradleProjectResolverExtension.populateContentRoot((MutablePrefixTreeMap<String, ContentRootData>)contentRootIndex, ExternalSystemSourceType.SOURCE, (Iterable<? extends IdeaSourceDirectory>)gradleContentRoot.getSourceDirectories());
                    CommonGradleProjectResolverExtension.populateContentRoot((MutablePrefixTreeMap<String, ContentRootData>)contentRootIndex, ExternalSystemSourceType.TEST, (Iterable<? extends IdeaSourceDirectory>)gradleContentRoot.getTestDirectories());
                }
            }
            if (oldGradle) continue;
            CommonGradleProjectResolverExtension.populateContentRoot((MutablePrefixTreeMap<String, ContentRootData>)contentRootIndex, ExternalSystemSourceType.SOURCE, sourceDirectories);
            CommonGradleProjectResolverExtension.populateContentRoot((MutablePrefixTreeMap<String, ContentRootData>)contentRootIndex, ExternalSystemSourceType.TEST, testDirectories);
            CommonGradleProjectResolverExtension.populateContentRoot((MutablePrefixTreeMap<String, ContentRootData>)contentRootIndex, ExternalSystemSourceType.RESOURCE, resourceDirectories);
            CommonGradleProjectResolverExtension.populateContentRoot((MutablePrefixTreeMap<String, ContentRootData>)contentRootIndex, ExternalSystemSourceType.TEST_RESOURCE, testResourceDirectories);
        }
        LinkedHashSet<String> existsContentRoots = new LinkedHashSet<String>();
        for (DataNode contentRootDataNode : ExternalSystemApiUtil.findAll(ideModule, (Key)ProjectKeys.CONTENT_ROOT)) {
            ContentRootData contentRootData = (ContentRootData)contentRootDataNode.getData();
            existsContentRoots.add(contentRootData.getRootPath());
        }
        for (ContentRootData ideContentRoot : contentRootIndex.values()) {
            if (existsContentRoots.contains(ideContentRoot.getRootPath())) continue;
            ideModule.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
        }
    }

    @Nullable
    private static ExternalProject getExternalProject(@NotNull IdeaModule gradleModule, @NotNull ProjectResolverContext resolverCtx) {
        ExternalProject project;
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(14);
        }
        if (resolverCtx == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(15);
        }
        if ((project = resolverCtx.getExtraProject(gradleModule, ExternalProject.class)) == null && resolverCtx.isResolveModulePerSourceSet()) {
            LOG.error("External Project model is missing for module-per-sourceSet import mode. Please, check import log for error messages.");
        }
        return project;
    }

    private Set<String> addExternalProjectContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull ExternalProject externalProject) {
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(16);
        }
        if (ideModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(17);
        }
        if (externalProject == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(18);
        }
        final LinkedHashSet<String> contentsRoots = new LinkedHashSet<String>();
        final String buildDirPath = FileUtil.toCanonicalPath((String)externalProject.getBuildDir().getPath());
        CommonGradleProjectResolverExtension.processSourceSets(this.resolverCtx, gradleModule, externalProject, ideModule, new SourceSetsProcessor(){

            @Override
            public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                if (dataNode == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (sourceSet == null) {
                    1.$$$reportNull$$$0(1);
                }
                sourceSet.getSources().forEach((key, sourceDirectorySet) -> {
                    ExternalSystemSourceType sourceType = ExternalSystemSourceType.from((IExternalSystemSourceType)key);
                    for (File file : sourceDirectorySet.getSrcDirs()) {
                        String path = FileUtil.toCanonicalPath((String)file.getPath());
                        contentsRoots.add(path);
                        ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, path);
                        if (FileUtil.isAncestor((String)path, (String)buildDirPath, (boolean)true)) {
                            ideContentRoot.storePath(ExternalSystemSourceType.EXCLUDED, buildDirPath);
                        }
                        ideContentRoot.storePath(sourceType, path);
                        dataNode.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataNode";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sourceSet";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/gradle/service/project/CommonGradleProjectResolverExtension$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return contentsRoots;
    }

    private static void removeDuplicateResources(@NotNull List<? extends IdeaSourceDirectory> sourceDirectories, @NotNull List<? extends IdeaSourceDirectory> resourceDirectories, @NotNull Set<File> notResourceDirs) {
        if (sourceDirectories == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(19);
        }
        if (resourceDirectories == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(20);
        }
        if (notResourceDirs == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(21);
        }
        resourceDirectories.removeIf(ideaSourceDirectory -> notResourceDirs.contains(ideaSourceDirectory.getDirectory()));
        CommonGradleProjectResolverExtension.removeAll(sourceDirectories, resourceDirectories);
    }

    @NotNull
    private static Set<File> collectExplicitNonResourceDirectories(@Nullable ExternalProject externalProject) {
        if (externalProject == null) {
            Set<File> set = Collections.emptySet();
            if (set == null) {
                CommonGradleProjectResolverExtension.$$$reportNull$$$0(22);
            }
            return set;
        }
        Set set = externalProject.getSourceSets().values().stream().flatMap(ss -> ss.getSources().entrySet().stream().filter(e -> !((IExternalSystemSourceType)e.getKey()).isResource()).flatMap(e -> ((ExternalSourceDirectorySet)e.getValue()).getSrcDirs().stream())).collect(Collectors.toCollection(() -> FileCollectionFactory.createCanonicalFileSet()));
        if (set == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(23);
        }
        return set;
    }

    private static void removeAll(List<? extends IdeaSourceDirectory> list2, List<? extends IdeaSourceDirectory> toRemove) {
        Set files = toRemove.stream().map(o -> o.getDirectory()).collect(Collectors.toSet());
        list2.removeIf(o -> files.contains(o.getDirectory()));
    }

    private static void processSourceSets(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule, @NotNull ExternalProject externalProject, @NotNull DataNode<ModuleData> ideModule, @NotNull SourceSetsProcessor processor) {
        if (resolverCtx == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(24);
        }
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(25);
        }
        if (externalProject == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(26);
        }
        if (ideModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(27);
        }
        if (processor == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(28);
        }
        HashMap<String, DataNode> sourceSetsMap = new HashMap<String, DataNode>();
        for (DataNode dataNode : ExternalSystemApiUtil.findAll(ideModule, GradleSourceSetData.KEY)) {
            sourceSetsMap.put(((GradleSourceSetData)((Object)dataNode.getData())).getId(), dataNode);
        }
        for (ExternalSourceSet sourceSet : externalProject.getSourceSets().values()) {
            DataNode moduleDataNode;
            if (sourceSet == null || sourceSet.getSources().isEmpty()) continue;
            String moduleId = GradleProjectResolverUtil.getModuleId(resolverCtx, gradleModule, sourceSet);
            DataNode dataNode = moduleDataNode = sourceSetsMap.isEmpty() ? ideModule : (DataNode)sourceSetsMap.get(moduleId);
            if (moduleDataNode == null) continue;
            processor.process((DataNode<? extends ModuleData>)moduleDataNode, sourceSet);
        }
    }

    @Override
    public void populateModuleCompileOutputSettings(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        boolean inheritOutputDirs;
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(29);
        }
        if (ideModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(30);
        }
        ModuleData moduleData = (ModuleData)ideModule.getData();
        moduleData.useExternalCompilerOutput(this.resolverCtx.isDelegatedBuild());
        File ideaOutDir = new File(moduleData.getLinkedExternalProjectPath(), "out");
        ExternalProject externalProject = CommonGradleProjectResolverExtension.getExternalProject(gradleModule, this.resolverCtx);
        if (this.resolverCtx.isResolveModulePerSourceSet()) {
            DataNode projectDataNode = ideModule.getDataNode(ProjectKeys.PROJECT);
            assert (projectDataNode != null);
            final Map moduleOutputsMap = (Map)projectDataNode.getUserData(GradleProjectResolver.MODULES_OUTPUTS);
            assert (moduleOutputsMap != null);
            final HashSet outputDirs = new HashSet();
            assert (externalProject != null);
            CommonGradleProjectResolverExtension.processSourceSets(this.resolverCtx, gradleModule, externalProject, ideModule, new SourceSetsProcessor(){

                @Override
                public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                    MultiMap gradleOutputMap;
                    if (dataNode == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (sourceSet == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if ((gradleOutputMap = (MultiMap)dataNode.getUserData(GradleProjectResolver.GRADLE_OUTPUTS)) == null) {
                        gradleOutputMap = MultiMap.create();
                        dataNode.putUserData(GradleProjectResolver.GRADLE_OUTPUTS, (Object)gradleOutputMap);
                    }
                    ModuleData moduleData = (ModuleData)dataNode.getData();
                    moduleData.useExternalCompilerOutput(CommonGradleProjectResolverExtension.this.resolverCtx.isDelegatedBuild());
                    for (Map.Entry directorySetEntry : sourceSet.getSources().entrySet()) {
                        ExternalSystemSourceType sourceType = ExternalSystemSourceType.from((IExternalSystemSourceType)((IExternalSystemSourceType)directorySetEntry.getKey()));
                        ExternalSourceDirectorySet sourceDirectorySet = (ExternalSourceDirectorySet)directorySetEntry.getValue();
                        File ideOutputDir = CommonGradleProjectResolverExtension.getIdeOutputDir(sourceDirectorySet);
                        File gradleOutputDir = CommonGradleProjectResolverExtension.getGradleOutputDir(sourceDirectorySet);
                        File outputDir = CommonGradleProjectResolverExtension.this.resolverCtx.isDelegatedBuild() ? gradleOutputDir : ideOutputDir;
                        moduleData.setCompileOutputPath(sourceType, ideOutputDir == null ? null : ideOutputDir.getPath());
                        moduleData.setExternalCompilerOutputPath(sourceType, gradleOutputDir == null ? null : gradleOutputDir.getPath());
                        moduleData.setInheritProjectCompileOutputPath(sourceDirectorySet.isCompilerOutputPathInherited());
                        if (outputDir == null) continue;
                        outputDirs.add(outputDir.getPath());
                        for (File file : sourceDirectorySet.getGradleOutputDirs()) {
                            String gradleOutputPath = ExternalSystemApiUtil.toCanonicalPath((String)file.getPath());
                            gradleOutputMap.putValue((Object)sourceType, (Object)gradleOutputPath);
                            if (file.getPath().equals(outputDir.getPath())) continue;
                            moduleOutputsMap.put(gradleOutputPath, Pair.create((Object)moduleData.getId(), (Object)sourceType));
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "dataNode";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "sourceSet";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/gradle/service/project/CommonGradleProjectResolverExtension$2";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            if (outputDirs.stream().anyMatch(path -> FileUtil.isAncestor((File)ideaOutDir, (File)new File((String)path), (boolean)false))) {
                GradleUtil.excludeOutDir(ideModule, ideaOutDir);
            }
            return;
        }
        IdeaCompilerOutput moduleCompilerOutput = gradleModule.getCompilerOutput();
        boolean bl = inheritOutputDirs = moduleCompilerOutput != null && moduleCompilerOutput.getInheritOutputDirs();
        if (moduleCompilerOutput != null) {
            File outputDir = moduleCompilerOutput.getOutputDir();
            if (outputDir != null) {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.SOURCE, outputDir.getPath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.RESOURCE, outputDir.getPath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.SOURCE, outputDir.getPath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.RESOURCE, outputDir.getPath());
            } else {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.SOURCE, new File(ideaOutDir, "production/classes").getPath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.RESOURCE, new File(ideaOutDir, "production/resources").getPath());
                if (externalProject != null) {
                    File gradleOutputDir = CommonGradleProjectResolverExtension.getGradleOutputDir(externalProject, "main", ExternalSystemSourceType.SOURCE);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.SOURCE, gradleOutputDir == null ? null : gradleOutputDir.getPath());
                    File gradleResourceOutputDir = CommonGradleProjectResolverExtension.getGradleOutputDir(externalProject, "main", ExternalSystemSourceType.RESOURCE);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.RESOURCE, gradleResourceOutputDir == null ? null : gradleResourceOutputDir.getPath());
                }
            }
            File testOutputDir = moduleCompilerOutput.getTestOutputDir();
            if (testOutputDir != null) {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST, testOutputDir.getPath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST_RESOURCE, testOutputDir.getPath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST, testOutputDir.getPath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST_RESOURCE, testOutputDir.getPath());
            } else {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST, new File(ideaOutDir, "test/classes").getPath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST_RESOURCE, new File(ideaOutDir, "test/resources").getPath());
                if (externalProject != null) {
                    File gradleOutputDir = CommonGradleProjectResolverExtension.getGradleOutputDir(externalProject, "test", ExternalSystemSourceType.TEST);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST, gradleOutputDir == null ? null : gradleOutputDir.getPath());
                    File gradleResourceOutputDir = CommonGradleProjectResolverExtension.getGradleOutputDir(externalProject, "test", ExternalSystemSourceType.TEST_RESOURCE);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST_RESOURCE, gradleResourceOutputDir == null ? null : gradleResourceOutputDir.getPath());
                }
            }
            if (!(this.resolverCtx.isDelegatedBuild() || inheritOutputDirs || outputDir != null && testOutputDir != null)) {
                GradleUtil.excludeOutDir(ideModule, ideaOutDir);
            }
        }
        moduleData.setInheritProjectCompileOutputPath(inheritOutputDirs);
    }

    @Nullable
    public static File getGradleOutputDir(@NotNull ExternalProject externalProject, @NotNull String sourceSetName, @NotNull ExternalSystemSourceType sourceType) {
        ExternalSourceSet sourceSet;
        if (externalProject == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(31);
        }
        if (sourceSetName == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(32);
        }
        if (sourceType == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(33);
        }
        if ((sourceSet = (ExternalSourceSet)externalProject.getSourceSets().get(sourceSetName)) == null) {
            return null;
        }
        return CommonGradleProjectResolverExtension.getGradleOutputDir((ExternalSourceDirectorySet)sourceSet.getSources().get(sourceType));
    }

    @Nullable
    private static File getIdeOutputDir(@Nullable ExternalSourceDirectorySet sourceDirectorySet) {
        if (sourceDirectorySet == null) {
            return null;
        }
        return sourceDirectorySet.getOutputDir();
    }

    @Nullable
    private static File getGradleOutputDir(@Nullable ExternalSourceDirectorySet sourceDirectorySet) {
        if (sourceDirectorySet == null) {
            return null;
        }
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Collection outputDirectories = sourceDirectorySet.getGradleOutputDirs();
        String firstExistingLang = srcDirs.stream().sorted().filter(File::exists).findFirst().map(File::getName).orElse(null);
        if (firstExistingLang == null) {
            return (File)ContainerUtil.getFirstItem((Collection)outputDirectories);
        }
        return outputDirectories.stream().filter(f -> f.getPath().contains(firstExistingLang)).findFirst().orElse((File)ContainerUtil.getFirstItem((Collection)outputDirectories));
    }

    @Override
    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, final @NotNull DataNode<ProjectData> ideProject) {
        ExternalSystemTaskId taskId;
        Project project;
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(34);
        }
        if (ideModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(35);
        }
        if (ideProject == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(36);
        }
        ExternalProject externalProject = CommonGradleProjectResolverExtension.getExternalProject(gradleModule, this.resolverCtx);
        if (this.resolverCtx.isResolveModulePerSourceSet()) {
            final Map sourceSetMap = (Map)ideProject.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
            final ArtifactMappingService artifactsMap = this.resolverCtx.getArtifactsMap();
            assert (sourceSetMap != null);
            assert (artifactsMap != null);
            assert (externalProject != null);
            CommonGradleProjectResolverExtension.processSourceSets(this.resolverCtx, gradleModule, externalProject, ideModule, new SourceSetsProcessor(){

                @Override
                public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                    if (dataNode == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (sourceSet == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    GradleProjectResolverUtil.buildDependencies(CommonGradleProjectResolverExtension.this.resolverCtx, sourceSetMap, artifactsMap, dataNode, sourceSet.getDependencies(), (DataNode<ProjectData>)ideProject);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "dataNode";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "sourceSet";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/gradle/service/project/CommonGradleProjectResolverExtension$3";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            return;
        }
        List dependencies = gradleModule.getDependencies().getAll();
        if (dependencies == null) {
            return;
        }
        ArrayList<String> orphanModules = new ArrayList<String>();
        HashMap<String, ModuleData> modulesIndex = new HashMap<String, ModuleData>();
        for (DataNode dataNode : ExternalSystemApiUtil.getChildren(ideProject, (Key)ProjectKeys.MODULE)) {
            modulesIndex.put(((ModuleData)dataNode.getData()).getExternalName(), (ModuleData)dataNode.getData());
        }
        for (int i = 0; i < dependencies.size(); ++i) {
            ModuleDependencyData d;
            IdeaDependency dependency = (IdeaDependency)dependencies.get(i);
            if (dependency == null) continue;
            DependencyScope scope = CommonGradleProjectResolverExtension.parseScope(dependency.getScope());
            if (dependency instanceof IdeaModuleDependency) {
                d = CommonGradleProjectResolverExtension.buildDependency(this.resolverCtx, ideModule, (IdeaModuleDependency)dependency, modulesIndex);
                d.setExported(dependency.getExported());
                if (scope != null) {
                    d.setScope(scope);
                }
                d.setOrder(i);
                ideModule.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)d);
                ModuleData targetModule = (ModuleData)d.getTarget();
                if (!targetModule.getId().isEmpty() || !targetModule.getLinkedExternalProjectPath().isEmpty()) continue;
                orphanModules.add(targetModule.getExternalName());
                continue;
            }
            if (!(dependency instanceof IdeaSingleEntryLibraryDependency)) continue;
            d = this.buildDependency(gradleModule, ideModule, (IdeaSingleEntryLibraryDependency)dependency, ideProject);
            d.setExported(dependency.getExported());
            if (scope != null) {
                d.setScope(scope);
            }
            d.setOrder(i);
            ideModule.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)d);
        }
        if (!orphanModules.isEmpty() && (project = (taskId = this.resolverCtx.getExternalSystemTaskId()).findProject()) != null) {
            String title = GradleBundle.message("gradle.project.resolver.orphan.modules.error.title", new Object[0]);
            String targetOption = GradleBundle.message("gradle.settings.text.module.per.source.set", ApplicationNamesInfo.getInstance().getFullProductName());
            String message = GradleBundle.message("gradle.project.resolver.orphan.modules.error.description", orphanModules.size(), StringUtil.join(orphanModules, (String)", "), targetOption);
            NotificationData notification = new NotificationData(title, message, NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
            ExternalSystemNotificationManager.getInstance((Project)project).showNotification(taskId.getProjectSystemId(), notification);
        }
    }

    @Override
    @NotNull
    public Collection<TaskData> populateModuleTasks(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) throws IllegalArgumentException, IllegalStateException {
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(37);
        }
        if (ideModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(38);
        }
        if (ideProject == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(39);
        }
        ArrayList<TaskData> tasks2 = new ArrayList<TaskData>();
        GradleModuleData gradleModuleData = new GradleModuleData(ideModule);
        String moduleConfigPath = gradleModuleData.getGradleProjectDir();
        ExternalProject externalProject = CommonGradleProjectResolverExtension.getExternalProject(gradleModule, this.resolverCtx);
        if (externalProject != null) {
            String directoryToRunTask = gradleModuleData.getDirectoryToRunTask();
            boolean isSimpleTaskNameAllowed = directoryToRunTask.equals(moduleConfigPath);
            for (ExternalTask task2 : externalProject.getTasks().values()) {
                String taskFullName;
                String taskGroup = task2.getGroup();
                if (task2.getName().trim().isEmpty() || GradleProjectResolverUtil.isIdeaTask(task2.getName(), taskGroup)) continue;
                boolean inherited = StringUtil.equals((CharSequence)task2.getName(), (CharSequence)task2.getQName());
                if (gradleModuleData.isIncludedBuild()) {
                    if (inherited) continue;
                    taskFullName = gradleModuleData.getTaskPathOfSimpleTaskName(task2.getName());
                } else {
                    taskFullName = isSimpleTaskNameAllowed ? task2.getName() : task2.getQName();
                }
                String escapedTaskName = ParametersListUtil.escape((CharSequence)taskFullName);
                TaskData taskData = new TaskData(GradleConstants.SYSTEM_ID, escapedTaskName, directoryToRunTask, task2.getDescription());
                taskData.setGroup(taskGroup);
                taskData.setType(task2.getType());
                taskData.setTest(task2.isTest());
                taskData.setJvmTest(task2.isJvmTest());
                ideModule.createChild(ProjectKeys.TASK, (Object)taskData);
                taskData.setInherited(inherited);
                tasks2.add(taskData);
            }
            ArrayList<TaskData> arrayList = tasks2;
            if (arrayList == null) {
                CommonGradleProjectResolverExtension.$$$reportNull$$$0(40);
            }
            return arrayList;
        }
        for (GradleTask task3 : gradleModule.getGradleProject().getTasks()) {
            String taskName = task3.getName();
            String taskGroup = CommonGradleProjectResolverExtension.getTaskGroup(task3);
            if (taskName == null || taskName.trim().isEmpty() || GradleProjectResolverUtil.isIdeaTask(taskName, taskGroup)) continue;
            TaskData taskData = new TaskData(GradleConstants.SYSTEM_ID, taskName, moduleConfigPath, task3.getDescription());
            taskData.setGroup(taskGroup);
            ideModule.createChild(ProjectKeys.TASK, (Object)taskData);
            tasks2.add(taskData);
        }
        ArrayList<TaskData> arrayList = tasks2;
        if (arrayList == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    @Nullable
    private static String getTaskGroup(GradleTask task2) {
        String taskGroup;
        try {
            taskGroup = task2.getGroup();
        }
        catch (UnsupportedMethodException e) {
            taskGroup = null;
        }
        return taskGroup;
    }

    @Override
    @NotNull
    public Set<Class<?>> getExtraProjectModelClasses() {
        LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet((Object[])new Class[]{BuildScriptClasspathModel.class, GradleExtensions.class, ExternalTestsModel.class, IntelliJProjectSettings.class, IntelliJSettings.class, DependencyAccessorsModel.class, VersionCatalogsModel.class});
        if (linkedHashSet == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(42);
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public Set<Class<?>> getExtraBuildModelClasses() {
        LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet((Object[])new Class[]{IdeaProject.class});
        if (linkedHashSet == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(43);
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public List<ProjectImportModelProvider> getModelProviders() {
        List list2 = ContainerUtil.append(super.getModelProviders(), (Object[])new ProjectImportModelProvider[]{new GradleSourceSetModelProvider(), new GradleTaskModelProvider(), new GradleExternalProjectModelProvider()});
        if (list2 == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(44);
        }
        return list2;
    }

    @Override
    public Set<Class<?>> getTargetTypes() {
        return ContainerUtil.newLinkedHashSet((Object[])new Class[]{ExternalProjectDependency.class, ExternalLibraryDependency.class, FileCollectionDependency.class, UnresolvedExternalDependency.class});
    }

    @Override
    public void enhanceTaskProcessing(@NotNull List<String> taskNames, @NotNull Consumer<String> initScriptConsumer, @NotNull Map<String, String> parameters) {
        String dispatchPort;
        if (taskNames == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(45);
        }
        if (initScriptConsumer == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(46);
        }
        if (parameters == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(47);
        }
        if ((dispatchPort = parameters.get("DEBUG_DISPATCH_PORT")) == null) {
            return;
        }
        String debugOptions = parameters.get("DEBUG_OPTIONS");
        if (debugOptions == null) {
            debugOptions = "";
        }
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        String esRtJarPath = FileUtil.toCanonicalPath((String)PathManager.getJarPathForClass(ExternalSystemSourceType.class));
        lines.add((CallSite)((Object)("initscript { dependencies { classpath files(mapPath(\"" + esRtJarPath + "\")) } }")));
        for (DebuggerBackendExtension extension : DebuggerBackendExtension.EP_NAME.getExtensionList()) {
            lines.addAll(extension.initializationCode(dispatchPort, debugOptions));
        }
        String script = StringUtil.join(lines, (String)System.lineSeparator());
        initScriptConsumer.consume((Object)script);
    }

    private static void populateContentRoot(@NotNull MutablePrefixTreeMap<String, ContentRootData> contentRootIndex, @NotNull ExternalSystemSourceType type, @Nullable Iterable<? extends IdeaSourceDirectory> dirs2) throws IllegalArgumentException {
        if (contentRootIndex == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(48);
        }
        if (type == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(49);
        }
        if (dirs2 == null) {
            return;
        }
        for (IdeaSourceDirectory ideaSourceDirectory : dirs2) {
            ExternalSystemSourceType dirSourceType = type;
            try {
                if (ideaSourceDirectory.isGenerated() && !dirSourceType.isGenerated()) {
                    ExternalSystemSourceType generatedType = ExternalSystemSourceType.from((boolean)dirSourceType.isTest(), (boolean)ideaSourceDirectory.isGenerated(), (boolean)dirSourceType.isResource(), (boolean)dirSourceType.isExcluded());
                    dirSourceType = generatedType != null ? generatedType : dirSourceType;
                }
            }
            catch (UnsupportedMethodException e) {
                LOG.warn(e.getMessage());
            }
            catch (Throwable e) {
                LOG.debug(e);
            }
            String path = FileUtil.toCanonicalPath((String)ideaSourceDirectory.getDirectory().getPath());
            ArrayList<String> contentRoots = new ArrayList<String>(contentRootIndex.getAncestorKeys((Object)path));
            if (contentRoots.isEmpty()) {
                ContentRootData contentRootData = new ContentRootData(GradleConstants.SYSTEM_ID, path);
                contentRootIndex.set((Object)path, (Object)contentRootData);
                contentRoots.add(path);
            }
            String contentRootPath = (String)ContainerUtil.getLastItem(contentRoots);
            assert (contentRootPath != null);
            ContentRootData contentRoot = (ContentRootData)contentRootIndex.get((Object)contentRootPath);
            assert (contentRoot != null);
            contentRoot.storePath(dirSourceType, path);
        }
    }

    @Nullable
    private static DependencyScope parseScope(@Nullable IdeaDependencyScope scope) {
        if (scope == null) {
            return null;
        }
        String scopeAsString = scope.getScope();
        if (scopeAsString == null) {
            return null;
        }
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!scopeAsString.equalsIgnoreCase(dependencyScope.toString())) continue;
            return dependencyScope;
        }
        return null;
    }

    @NotNull
    private static ModuleDependencyData buildDependency(@NotNull ProjectResolverContext resolverContext, @NotNull DataNode<ModuleData> ownerModule, @NotNull IdeaModuleDependency dependency, @NotNull Map<String, ModuleData> registeredModulesIndex) throws IllegalStateException {
        ModuleData moduleData;
        ModuleData moduleData2;
        IdeaModule dependencyModule;
        GradleVersion projectGradleVersion;
        if (resolverContext == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(50);
        }
        if (ownerModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(51);
        }
        if (dependency == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(52);
        }
        if (registeredModulesIndex == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(53);
        }
        GradleExecutionSettings gradleExecutionSettings = resolverContext.getSettings();
        String projectGradleVersionString = resolverContext.getProjectGradleVersion();
        if (gradleExecutionSettings != null && projectGradleVersionString != null && (projectGradleVersion = GradleVersion.version((String)projectGradleVersionString)).compareTo(GradleVersion.version((String)"4.0")) < 0 && (dependencyModule = CommonGradleProjectResolverExtension.getDependencyModuleByReflection(dependency)) != null && (moduleData2 = gradleExecutionSettings.getExecutionWorkspace().findModuleDataByModule(resolverContext, dependencyModule)) != null) {
            return new ModuleDependencyData((ModuleData)ownerModule.getData(), moduleData2);
        }
        String moduleName = dependency.getTargetModuleName();
        if (gradleExecutionSettings != null && (moduleData = gradleExecutionSettings.getExecutionWorkspace().findModuleDataByGradleModuleName(moduleName)) != null) {
            return new ModuleDependencyData((ModuleData)ownerModule.getData(), moduleData);
        }
        ModuleData registeredModuleData = registeredModulesIndex.get(moduleName);
        if (registeredModuleData != null) {
            return new ModuleDependencyData((ModuleData)ownerModule.getData(), registeredModuleData);
        }
        throw new IllegalStateException(String.format("Can't parse gradle module dependency '%s'. Reason: no module with such name (%s) is found. Registered modules: %s", dependency, moduleName, registeredModulesIndex.keySet()));
    }

    @Nullable
    private static IdeaModule getDependencyModuleByReflection(@NotNull IdeaModuleDependency dependency) {
        Method getDependencyModule;
        if (dependency == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(54);
        }
        if ((getDependencyModule = ReflectionUtil.getMethod(dependency.getClass(), (String)"getDependencyModule", (Class[])new Class[0])) != null) {
            try {
                Object result = getDependencyModule.invoke((Object)dependency, new Object[0]);
                return (IdeaModule)result;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.info("Failed to get dependency module for [" + dependency + "]", (Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    private LibraryDependencyData buildDependency(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ownerModule, @NotNull IdeaSingleEntryLibraryDependency dependency, @NotNull DataNode<ProjectData> ideProject) throws IllegalStateException {
        Object libraryName;
        LibraryLevel level;
        File binaryPath;
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(55);
        }
        if (ownerModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(56);
        }
        if (dependency == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(57);
        }
        if (ideProject == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(58);
        }
        if ((binaryPath = dependency.getFile()) == null) {
            throw new IllegalStateException(String.format("Can't parse external library dependency '%s'. Reason: it doesn't specify path to the binaries", dependency));
        }
        GradleModuleVersion moduleVersion = dependency.getGradleModuleVersion();
        boolean unresolved = binaryPath.getName().startsWith(UNRESOLVED_DEPENDENCY_PREFIX);
        if (moduleVersion == null) {
            if (binaryPath.isFile()) {
                boolean isModuleLocalLibrary = false;
                try {
                    isModuleLocalLibrary = FileUtil.isAncestor((File)gradleModule.getGradleProject().getProjectDirectory(), (File)binaryPath, (boolean)false);
                }
                catch (UnsupportedMethodException unsupportedMethodException) {
                    // empty catch block
                }
                level = isModuleLocalLibrary ? LibraryLevel.MODULE : LibraryLevel.PROJECT;
                libraryName = CommonGradleProjectResolverExtension.chooseName(binaryPath, level, ideProject);
            } else {
                level = LibraryLevel.MODULE;
                libraryName = "";
            }
            if (unresolved) {
                libraryName = binaryPath.getName().substring(UNRESOLVED_DEPENDENCY_PREFIX.length());
                libraryName = StringUtil.join((Collection)StringUtil.split((String)libraryName, (String)" "), (String)":");
            }
        } else {
            level = LibraryLevel.PROJECT;
            libraryName = String.format("%s:%s:%s", moduleVersion.getGroup(), moduleVersion.getName(), moduleVersion.getVersion());
            if (binaryPath.isFile()) {
                String libraryFileName = FileUtilRt.getNameWithoutExtension((String)binaryPath.getName());
                String mavenLibraryFileName = String.format("%s-%s", moduleVersion.getName(), moduleVersion.getVersion());
                if (!mavenLibraryFileName.equals(libraryFileName)) {
                    Pattern pattern = Pattern.compile(moduleVersion.getName() + "-" + moduleVersion.getVersion() + "-(.*)");
                    Matcher matcher = pattern.matcher(libraryFileName);
                    if (matcher.matches()) {
                        String classifier = matcher.group(1);
                        libraryName = (String)libraryName + ":" + classifier;
                    } else {
                        String artifactId = StringUtil.trimEnd((String)StringUtil.trimEnd((String)libraryFileName, (String)moduleVersion.getVersion()), (String)"-");
                        libraryName = String.format("%s:%s:%s", moduleVersion.getGroup(), artifactId, moduleVersion.getVersion());
                    }
                }
            }
        }
        if (!unresolved && StringUtil.isNotEmpty((String)libraryName) && !FileUtilRt.extensionEquals((String)binaryPath.getName(), (String)"jar")) {
            libraryName = (String)libraryName + ":" + FileUtilRt.getExtension((String)binaryPath.getName());
        }
        LibraryData library = new LibraryData(GradleConstants.SYSTEM_ID, (String)libraryName, unresolved);
        if (moduleVersion != null) {
            library.setGroup(moduleVersion.getGroup());
            library.setArtifactId(moduleVersion.getName());
            library.setVersion(moduleVersion.getVersion());
        }
        if (!unresolved) {
            library.addPath(LibraryPathType.BINARY, binaryPath.getPath());
        } else {
            boolean isOfflineWork = this.resolverCtx.getSettings() != null && this.resolverCtx.getSettings().isOfflineWork();
            String message = String.format("Could not resolve %s.", libraryName);
            UnresolvedDependencySyncIssue buildIssue = new UnresolvedDependencySyncIssue((String)libraryName, message, this.resolverCtx.getProjectPath(), isOfflineWork, ((ModuleData)ownerModule.getData()).getId());
            this.resolverCtx.report(MessageEvent.Kind.ERROR, buildIssue);
        }
        File sourcePath = dependency.getSource();
        if (!unresolved && sourcePath != null) {
            library.addPath(LibraryPathType.SOURCE, sourcePath.getPath());
        }
        if (!unresolved && sourcePath == null) {
            GradleProjectResolverUtil.attachGradleSdkSources(gradleModule, binaryPath, library, this.resolverCtx);
            if (this.resolverCtx instanceof DefaultProjectResolverContext) {
                GradleProjectResolverUtil.attachSourcesAndJavadocFromGradleCacheIfNeeded(this.resolverCtx, ((DefaultProjectResolverContext)this.resolverCtx).getGradleUserHome(), library);
            }
        }
        File javadocPath = dependency.getJavadoc();
        if (!unresolved && javadocPath != null) {
            library.addPath(LibraryPathType.DOC, javadocPath.getPath());
        }
        if (level == LibraryLevel.PROJECT && !GradleProjectResolverUtil.linkProjectLibrary(ideProject, library)) {
            level = LibraryLevel.MODULE;
        }
        return new LibraryDependencyData((ModuleData)ownerModule.getData(), library, level);
    }

    private static String chooseName(File path, LibraryLevel level, DataNode<ProjectData> ideProject) {
        String candidateName;
        DataNode libraryData;
        String fileName = FileUtilRt.getNameWithoutExtension((String)path.getName());
        if (level == LibraryLevel.MODULE) {
            return fileName;
        }
        int count = 0;
        while ((libraryData = ExternalSystemApiUtil.find(ideProject, (Key)ProjectKeys.LIBRARY, arg_0 -> CommonGradleProjectResolverExtension.lambda$chooseName$9(candidateName = fileName + (String)(count == 0 ? "" : "_" + count), arg_0))) != null) {
            if (((LibraryData)libraryData.getData()).getPaths(LibraryPathType.BINARY).contains(FileUtil.toSystemIndependentName((String)path.getPath()))) {
                return candidateName;
            }
            ++count;
        }
        return candidateName;
    }

    private static /* synthetic */ boolean lambda$chooseName$9(String candidateName, DataNode node) {
        return ((LibraryData)node.getData()).getExternalName().equals(candidateName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8, 22, 23, 40, 41, 42, 43, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 1: 
            case 36: 
            case 39: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProject";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 25: 
            case 29: 
            case 34: 
            case 37: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModule";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 22: 
            case 23: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/CommonGradleProjectResolverExtension";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaModule";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainModuleNode";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 27: 
            case 30: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 15: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverCtx";
                break;
            }
            case 18: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProject";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceDirectories";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDirectories";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notResourceDirs";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskNames";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initScriptConsumer";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRootIndex";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverContext";
                break;
            }
            case 51: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerModule";
                break;
            }
            case 52: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registeredModulesIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/CommonGradleProjectResolverExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeModuleGroup";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExplicitNonResourceDirectories";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "populateModuleTasks";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraProjectModelClasses";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraBuildModelClasses";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "populateProjectExtraModels";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 22: 
            case 23: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "populateBuildScriptSource";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getJdkName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleExtraModels";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleContentRoots";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProject";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addExternalProjectContentRoots";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicateResources";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processSourceSets";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleCompileOutputSettings";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getGradleOutputDir";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleDependencies";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleTasks";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "enhanceTaskProcessing";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "populateContentRoot";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "buildDependency";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyModuleByReflection";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 7, 8, 22, 23, 40, 41, 42, 43, 44 -> new IllegalStateException(string2);
        };
    }

    private static interface SourceSetsProcessor {
        public void process(@NotNull DataNode<? extends ModuleData> var1, @NotNull ExternalSourceSet var2);
    }
}

