/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.configurationStore.StorageManagerFileWriteRequestor;
import com.intellij.history.LocalHistory;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.impl.ChangeRange;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoProvider;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileUndoProvider
implements UndoProvider,
BulkFileListener {
    public static final Logger LOG = Logger.getInstance(FileUndoProvider.class);
    private final Key<DocumentReference> DELETION_WAS_UNDOABLE = new Key(FileUndoProvider.class.getName() + ".DeletionWasUndoable");
    private final Project myProject;
    private boolean myIsInsideCommand;
    private LocalHistoryFacade myLocalHistory;
    private IdeaGateway myGateway;
    private long myLastChangeId;

    public FileUndoProvider() {
        this(null);
    }

    private FileUndoProvider(Project project2) {
        this.myProject = project2;
        if (this.myProject == null) {
            return;
        }
        @NotNull LocalHistory localHistory = LocalHistory.getInstance();
        if (!(localHistory instanceof LocalHistoryImpl)) {
            return;
        }
        this.myLocalHistory = ((LocalHistoryImpl)localHistory).getFacade();
        this.myGateway = ((LocalHistoryImpl)localHistory).getGateway();
        if (this.myLocalHistory == null || this.myGateway == null) {
            return;
        }
        ((LocalHistoryImpl)localHistory).addVFSListenerAfterLocalHistoryOne(this, (Disposable)project2);
        this.myLocalHistory.addListener(new LocalHistoryFacade.Listener(){

            @Override
            public void changeAdded(Change c) {
                if (!(c instanceof StructuralChange) || c instanceof ContentChange) {
                    return;
                }
                FileUndoProvider.this.myLastChangeId = c.getId();
            }
        }, (Disposable)this.myProject);
    }

    public void commandStarted(Project p) {
        if (this.myProject != p) {
            return;
        }
        this.myIsInsideCommand = true;
    }

    public void commandFinished(Project p) {
        if (this.myProject != p) {
            return;
        }
        this.myIsInsideCommand = false;
    }

    public void before(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            FileUndoProvider.$$$reportNull$$$0(0);
        }
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFileContentChangeEvent) {
                this.beforeContentsChange((VFileContentChangeEvent)vFileEvent);
                continue;
            }
            if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
            this.beforeFileDeletion((VFileDeleteEvent)vFileEvent);
        }
    }

    public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            FileUndoProvider.$$$reportNull$$$0(1);
        }
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFileMoveEvent || vFileEvent instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)vFileEvent).isRename()) {
                this.processEvent(vFileEvent, vFileEvent.getFile());
                continue;
            }
            if (vFileEvent instanceof VFileCopyEvent) {
                this.processEvent(vFileEvent, ((VFileCopyEvent)vFileEvent).findCreatedFile());
                continue;
            }
            if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
            this.fileDeleted((VFileDeleteEvent)vFileEvent);
        }
    }

    private void processEvent(@NotNull VFileEvent e, @Nullable VirtualFile file) {
        if (e == null) {
            FileUndoProvider.$$$reportNull$$$0(2);
        }
        if (file == null || !this.shouldProcess(e, file)) {
            return;
        }
        if (FileUndoProvider.isUndoable(e, file)) {
            this.registerUndoableAction(file);
        } else {
            this.registerNonUndoableAction(file);
        }
    }

    private void beforeContentsChange(@NotNull VFileContentChangeEvent e) {
        VirtualFile file;
        if (e == null) {
            FileUndoProvider.$$$reportNull$$$0(3);
        }
        if (!this.shouldProcess((VFileEvent)e, file = e.getFile())) {
            return;
        }
        if (FileUndoProvider.isUndoable((VFileEvent)e, file)) {
            return;
        }
        this.registerNonUndoableAction(file);
    }

    private void beforeFileDeletion(@NotNull VFileDeleteEvent e) {
        VirtualFile file;
        if (e == null) {
            FileUndoProvider.$$$reportNull$$$0(4);
        }
        if (!this.shouldProcess((VFileEvent)e, file = e.getFile())) {
            this.invalidateActionsFor(file);
            return;
        }
        if (FileUndoProvider.isUndoable((VFileEvent)e, file)) {
            file.putUserData(this.DELETION_WAS_UNDOABLE, (Object)FileUndoProvider.createDocumentReference(file));
        } else {
            this.registerNonUndoableAction(file);
        }
    }

    private void fileDeleted(@NotNull VFileDeleteEvent e) {
        VirtualFile f;
        if (e == null) {
            FileUndoProvider.$$$reportNull$$$0(5);
        }
        if (!this.shouldProcess((VFileEvent)e, f = e.getFile())) {
            return;
        }
        DocumentReference ref = (DocumentReference)f.getUserData(this.DELETION_WAS_UNDOABLE);
        if (ref != null) {
            this.registerUndoableAction(ref);
            f.putUserData(this.DELETION_WAS_UNDOABLE, null);
        }
    }

    private boolean shouldProcess(@NotNull VFileEvent e, VirtualFile file) {
        if (e == null) {
            FileUndoProvider.$$$reportNull$$$0(6);
        }
        if (!this.myIsInsideCommand || this.myProject.isDisposed()) {
            return false;
        }
        if (UndoUtil.isUndoDisabledFor((VirtualFile)file)) {
            return false;
        }
        Object requestor = e.getRequestor();
        if ("FileContentUtilCore.saveOrReload".equals(requestor) || requestor instanceof StorageManagerFileWriteRequestor) {
            return false;
        }
        return LocalHistory.getInstance().isUnderControl(file);
    }

    private static boolean isUndoable(@NotNull VFileEvent e, @NotNull VirtualFile file) {
        if (e == null) {
            FileUndoProvider.$$$reportNull$$$0(7);
        }
        if (file == null) {
            FileUndoProvider.$$$reportNull$$$0(8);
        }
        return !e.isFromRefresh() || UndoUtil.isForceUndoFlagSet((VirtualFile)file);
    }

    private void registerUndoableAction(@NotNull VirtualFile file) {
        if (file == null) {
            FileUndoProvider.$$$reportNull$$$0(9);
        }
        this.registerUndoableAction(FileUndoProvider.createDocumentReference(file));
    }

    private void registerUndoableAction(DocumentReference ref) {
        this.getUndoManager().undoableActionPerformed((UndoableAction)new MyUndoableAction(ref));
    }

    private void registerNonUndoableAction(@NotNull VirtualFile file) {
        if (file == null) {
            FileUndoProvider.$$$reportNull$$$0(10);
        }
        this.getUndoManager().nonundoableActionPerformed(FileUndoProvider.createDocumentReference(file), true);
    }

    private void invalidateActionsFor(@NotNull VirtualFile file) {
        if (file == null) {
            FileUndoProvider.$$$reportNull$$$0(11);
        }
        if (this.myProject == null || !this.myProject.isDisposed()) {
            this.getUndoManager().invalidateActionsFor(FileUndoProvider.createDocumentReference(file));
        }
    }

    private static DocumentReference createDocumentReference(@NotNull VirtualFile file) {
        if (file == null) {
            FileUndoProvider.$$$reportNull$$$0(12);
        }
        return DocumentReferenceManager.getInstance().create(file);
    }

    private UndoManagerImpl getUndoManager() {
        if (this.myProject != null) {
            return (UndoManagerImpl)UndoManager.getInstance((Project)this.myProject);
        }
        return (UndoManagerImpl)UndoManager.getGlobalInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/command/impl/FileUndoProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "before";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processEvent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeContentsChange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileDeletion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fileDeleted";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldProcess";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isUndoable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "registerUndoableAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "registerNonUndoableAction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "invalidateActionsFor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createDocumentReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyUndoableAction
    extends GlobalUndoableAction {
        private ChangeRange myActionChangeRange;
        private ChangeRange myUndoChangeRange;

        MyUndoableAction(DocumentReference r) {
            super(new DocumentReference[]{r});
            this.myActionChangeRange = new ChangeRange(FileUndoProvider.this.myGateway, FileUndoProvider.this.myLocalHistory, FileUndoProvider.this.myLastChangeId);
        }

        public void undo() throws UnexpectedUndoException {
            try {
                this.myUndoChangeRange = this.myActionChangeRange.revert(this.myUndoChangeRange);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                throw new UnexpectedUndoException(e.getMessage());
            }
        }

        public void redo() throws UnexpectedUndoException {
            try {
                this.myActionChangeRange = this.myUndoChangeRange.revert(this.myActionChangeRange);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                throw new UnexpectedUndoException(e.getMessage());
            }
        }
    }
}

