/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionAction;
import com.intellij.openapi.vcs.changes.ignore.actions.CreateNewIgnoreFileAction;
import com.intellij.openapi.vcs.changes.ignore.actions.IgnoreFileAction;
import com.intellij.openapi.vcs.changes.ignore.actions.IgnoreFileActionGroupKt;
import com.intellij.openapi.vcs.changes.ignore.actions.IgnoreFileActionKt;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J2\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u000eH\u0014J \u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000eH\u0002J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u000eH\u0002J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u001d\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001c2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\u001f\u001a\t\u0018\u00010 \u00a2\u0006\u0002\b!*\u00020\"H\u0082\u0002J\u0012\u0010#\u001a\u00070\u0012\u00a2\u0006\u0002\b$*\u00020\"H\u0082\u0002J(\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'H\u0002J+\u0010(\u001a\u00070)\u00a2\u0006\u0002\b**\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010+\u001a\u0004\u0018\u00010\u00122\u0006\u0010,\u001a\u00020'H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/openapi/vcs/changes/ignore/actions/IgnoreFileActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "ignoreFileType", "Lcom/intellij/openapi/vcs/changes/ignore/lang/IgnoreFileType;", "(Lcom/intellij/openapi/vcs/changes/ignore/lang/IgnoreFileType;)V", "actions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createAdditionalActions", "", "project", "Lcom/intellij/openapi/project/Project;", "selectedFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "unversionedFiles", "createNewIgnoreFileAction", "filterSelectedFiles", "files", "findSuitableIgnoreFiles", "file", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getChildren", "", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "update", "component1", "Lcom/intellij/openapi/vcs/AbstractVcs;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/openapi/vcs/VcsRoot;", "component2", "Lorg/jetbrains/annotations/NotNull;", "toActions", "additionalActionsSize", "", "toTextRepresentation", "", "Lorg/jetbrains/annotations/Nls;", "projectDir", "size", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nIgnoreFileActionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IgnoreFileActionGroup.kt\ncom/intellij/openapi/vcs/changes/ignore/actions/IgnoreFileActionGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,156:1\n1549#2:157\n1620#2,3:158\n819#2:161\n847#2,2:162\n766#2:166\n857#2,2:167\n766#2:169\n857#2,2:170\n1549#2:172\n1620#2,3:173\n37#3,2:164\n*S KotlinDebug\n*F\n+ 1 IgnoreFileActionGroup.kt\ncom/intellij/openapi/vcs/changes/ignore/actions/IgnoreFileActionGroup\n*L\n52#1:157\n52#1:158,3\n52#1:161\n52#1:162,2\n90#1:166\n90#1:167,2\n96#1:169\n96#1:170,2\n103#1:172\n103#1:173,3\n85#1:164,2\n*E\n"})
public class IgnoreFileActionGroup
extends ActionGroup
implements DumbAware {
    @NotNull
    private final IgnoreFileType ignoreFileType;
    @NotNull
    private Collection<? extends AnAction> actions;

    public IgnoreFileActionGroup(@NotNull IgnoreFileType ignoreFileType) {
        Intrinsics.checkNotNullParameter((Object)((Object)ignoreFileType), (String)"ignoreFileType");
        Object[] objectArray = new Object[]{ignoreFileType.getIgnoreLanguage().getFilename()};
        Supplier<String> supplier2 = VcsBundle.messagePointer("vcs.add.to.ignore.file.action.group.text", objectArray);
        objectArray = new Object[]{ignoreFileType.getIgnoreLanguage().getFilename()};
        super(supplier2, VcsBundle.messagePointer("vcs.add.to.ignore.file.action.group.description", objectArray), () -> IgnoreFileActionGroup._init_$lambda$0(ignoreFileType));
        this.ignoreFileType = ignoreFileType;
        this.actions = CollectionsKt.emptyList();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent e) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List<VirtualFile> selectedFiles = IgnoreFileActionKt.getSelectedFiles(e);
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
        Presentation presentation3 = presentation2;
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            presentation3.setVisible(false);
            return;
        }
        List list2 = ScheduleForAdditionAction.Manager.INSTANCE.getUnversionedFiles(e, project2).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"toList(...)");
        List unversionedFiles = list2;
        if (unversionedFiles.isEmpty()) {
            presentation3.setVisible(false);
            return;
        }
        Iterable $this$map$iv = this.filterSelectedFiles(project2, selectedFiles);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.findSuitableIgnoreFiles(project2, (VirtualFile)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Collection p0 = (Collection)element$iv$iv;
            boolean bl = false;
            if (p0.isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List ignoreFiles = (List)destination$iv$iv;
        HashSet resultedIgnoreFiles = CollectionsKt.toHashSet((Iterable)CollectionsKt.flatten((Iterable)ignoreFiles));
        for (Collection files2 : ignoreFiles) {
            resultedIgnoreFiles.retainAll(files2);
        }
        List<AnAction> additionalActions = this.createAdditionalActions(project2, selectedFiles, unversionedFiles);
        this.actions = !((Collection)resultedIgnoreFiles).isEmpty() ? this.toActions(resultedIgnoreFiles, project2, additionalActions.size()) : (Collection)CollectionsKt.listOfNotNull((Object)this.createNewIgnoreFileAction(project2, selectedFiles));
        if (!((Collection)additionalActions).isEmpty()) {
            this.actions = CollectionsKt.plus(this.actions, (Iterable)additionalActions);
        }
        presentation3.setPopupGroup(this.actions.size() > 1);
        presentation3.setPerformGroup(this.actions.size() == 1);
        e.getPresentation().putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)e.getPresentation().isPerformGroup());
        presentation3.setVisible(!this.actions.isEmpty());
    }

    @NotNull
    protected List<AnAction> createAdditionalActions(@NotNull Project project2, @NotNull List<? extends VirtualFile> selectedFiles, @NotNull List<? extends VirtualFile> unversionedFiles) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(selectedFiles, (String)"selectedFiles");
        Intrinsics.checkNotNullParameter(unversionedFiles, (String)"unversionedFiles");
        return CollectionsKt.emptyList();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            AnAction anAction = (AnAction)CollectionsKt.firstOrNull((Iterable)this.actions);
            if (anAction == null) break block0;
            anAction.actionPerformed(e);
        }
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        Collection<? extends AnAction> $this$toTypedArray$iv = this.actions;
        boolean $i$f$toTypedArray = false;
        Collection<? extends AnAction> thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new AnAction[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> filterSelectedFiles(Project project2, List<? extends VirtualFile> files2) {
        void $this$filterTo$iv$iv;
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance(project2);
        ChangeListManager changeListManager = ChangeListManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        Iterable $this$filter$iv = files2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile file = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(vcsManager2.getVcsFor(file) != null && !changeListManager2.isIgnoredFile(file))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<VirtualFile> findSuitableIgnoreFiles(Project project2, VirtualFile file) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        VirtualFile fileParent = file.getParent();
        Collection collection = FileTypeIndex.getFiles((FileType)((FileType)this.ignoreFileType), (GlobalSearchScope)ProjectScope.getProjectScope((Project)project2));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFiles(...)");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)fileParent, (Object)it.getParent()) || fileParent != null && it.getParent() != null && VfsUtil.isAncestor((VirtualFile)it.getParent(), (VirtualFile)fileParent, (boolean)false))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<AnAction> toActions(Collection<? extends VirtualFile> $this$toActions, Project project2, int additionalActionsSize) {
        void $this$mapTo$iv$iv;
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project2);
        Iterable $this$map$iv = $this$toActions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Presentation presentation2;
            void file;
            IgnoreFileAction ignoreFileAction;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IgnoreFileAction $this$toActions_u24lambda_u246_u24lambda_u245 = ignoreFileAction = new IgnoreFileAction((VirtualFile)file);
            boolean bl2 = false;
            Presentation $this$toActions_u24lambda_u246_u24lambda_u245_u24lambda_u244 = presentation2 = $this$toActions_u24lambda_u246_u24lambda_u245.getTemplatePresentation();
            boolean bl3 = false;
            $this$toActions_u24lambda_u246_u24lambda_u245_u24lambda_u244.setIcon(this.ignoreFileType.getIcon());
            $this$toActions_u24lambda_u246_u24lambda_u245_u24lambda_u244.setText(this.toTextRepresentation((VirtualFile)file, project2, projectDir, $this$toActions.size() + additionalActionsSize));
            collection.add(ignoreFileAction);
        }
        return (List)destination$iv$iv;
    }

    private final AnAction createNewIgnoreFileAction(Project project2, List<? extends VirtualFile> selectedFiles) {
        Presentation presentation2;
        CreateNewIgnoreFileAction createNewIgnoreFileAction;
        String string2 = this.ignoreFileType.getIgnoreLanguage().getFilename();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFilename(...)");
        String filename = string2;
        VcsRoot vcsRoot = IgnoreFileActionGroupKt.access$getCommonIgnoreFileRoot(selectedFiles, project2);
        if (vcsRoot == null) {
            return null;
        }
        VcsRoot vcsRoot2 = vcsRoot;
        AbstractVcs rootVcs = this.component1(vcsRoot2);
        VirtualFile commonIgnoreFileRoot = this.component2(vcsRoot2);
        if (rootVcs == null) {
            return null;
        }
        if (commonIgnoreFileRoot.findChild(filename) != null) {
            return null;
        }
        IgnoredFileContentProvider ignoredFileContentProvider = VcsImplUtil.findIgnoredFileContentProvider(rootVcs);
        if (ignoredFileContentProvider == null) {
            return null;
        }
        IgnoredFileContentProvider ignoredFileContentProvider2 = ignoredFileContentProvider;
        if (!Intrinsics.areEqual((Object)ignoredFileContentProvider2.getFileName(), (Object)filename)) {
            return null;
        }
        CreateNewIgnoreFileAction $this$createNewIgnoreFileAction_u24lambda_u248 = createNewIgnoreFileAction = new CreateNewIgnoreFileAction(filename, commonIgnoreFileRoot);
        boolean bl = false;
        Presentation $this$createNewIgnoreFileAction_u24lambda_u248_u24lambda_u247 = presentation2 = $this$createNewIgnoreFileAction_u24lambda_u248.getTemplatePresentation();
        boolean bl2 = false;
        $this$createNewIgnoreFileAction_u24lambda_u248_u24lambda_u247.setIcon(this.ignoreFileType.getIcon());
        Object[] objectArray = new Object[]{filename};
        $this$createNewIgnoreFileAction_u24lambda_u248_u24lambda_u247.setText(VcsBundle.message("vcs.add.to.ignore.file.action.group.text", objectArray));
        return (AnAction)createNewIgnoreFileAction;
    }

    private final String toTextRepresentation(VirtualFile $this$toTextRepresentation, Project project2, VirtualFile projectDir, int size) {
        if (size == 1) {
            Object[] objectArray = new Object[]{this.ignoreFileType.getIgnoreLanguage().getFilename()};
            String string2 = VcsBundle.message("vcs.add.to.ignore.file.action.group.text", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return string2;
        }
        VirtualFile virtualFile = projectDir;
        if (virtualFile == null && (virtualFile = VcsUtil.getVcsRootFor(project2, $this$toTextRepresentation)) == null) {
            String string3 = $this$toTextRepresentation.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            return string3;
        }
        VirtualFile projectRootOrVcsRoot = virtualFile;
        String string4 = VfsUtil.getRelativePath((VirtualFile)$this$toTextRepresentation, (VirtualFile)projectRootOrVcsRoot);
        if (string4 == null) {
            String string5 = $this$toTextRepresentation.getName();
            string4 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
        }
        return string4;
    }

    private final AbstractVcs component1(VcsRoot $this$component1) {
        Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"<this>");
        return $this$component1.getVcs();
    }

    private final VirtualFile component2(VcsRoot $this$component2) {
        Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"<this>");
        VirtualFile virtualFile = $this$component2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getPath(...)");
        return virtualFile;
    }

    private static final Icon _init_$lambda$0(IgnoreFileType $ignoreFileType) {
        Intrinsics.checkNotNullParameter((Object)((Object)$ignoreFileType), (String)"$ignoreFileType");
        return $ignoreFileType.getIcon();
    }
}

