/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.DiffPreviewUpdateProcessor;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreviewManager;
import com.intellij.openapi.vcs.changes.EditorTabPreview;
import com.intellij.openapi.vcs.changes.PreviewDiffSplitterComponent;
import com.intellij.openapi.vcs.changes.VcsToolwindowDnDTarget;
import com.intellij.openapi.vcs.changes.actions.ShowDiffPreviewAction;
import com.intellij.openapi.vcs.changes.shelf.DiffShelvedChangesActionProvider;
import com.intellij.openapi.vcs.changes.shelf.ShelfDeleteNotification;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManagerListener;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedWrapper;
import com.intellij.openapi.vcs.changes.shelf.ShelvedWrapperDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTree;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentI;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.SimpleTreeEditorDiffPreview;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.TwoStepAsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.FontUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlinx.coroutines.CoroutineScope;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedChangesViewManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ShelvedChangesViewManager.class);
    private static final String HELP_ID = "ideaInterface.shelf";
    @NonNls
    static final String SHELF_CONTEXT_MENU = "Vcs.Shelf.ContextMenu";
    private static final String SHELVE_PREVIEW_SPLITTER_PROPORTION = "ShelvedChangesViewManager.DETAILS_SPLITTER_PROPORTION";
    @NonNls
    static final String SHELVED_CHANGES_TOOLBAR = "ShelvedChangesToolbar";
    private final Project myProject;
    private final MergingUpdateQueue myUpdateQueue;
    private final List<Runnable> myPostUpdateEdtActivity = new ArrayList<Runnable>();
    @Nullable
    private ShelfToolWindowPanel myPanel = null;
    public static final DataKey<ChangesTree> SHELVED_CHANGES_TREE = DataKey.create((String)"ShelveChangesManager.ShelvedChangesTree");
    public static final DataKey<List<ShelvedChangeList>> SHELVED_CHANGELIST_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedChangeListData");
    public static final DataKey<List<ShelvedChangeList>> SHELVED_RECYCLED_CHANGELIST_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedRecycledChangeListData");
    public static final DataKey<List<ShelvedChangeList>> SHELVED_DELETED_CHANGELIST_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedDeletedChangeListData");
    public static final DataKey<List<ShelvedChange>> SHELVED_CHANGE_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedChange");
    public static final DataKey<List<ShelvedBinaryFile>> SHELVED_BINARY_FILE_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedBinaryFile");

    public static ShelvedChangesViewManager getInstance(Project project2) {
        return (ShelvedChangesViewManager)project2.getService(ShelvedChangesViewManager.class);
    }

    public ShelvedChangesViewManager(Project project2) {
        this.myProject = project2;
        this.myUpdateQueue = new MergingUpdateQueue("Update Shelf Content", 200, true, null, (Disposable)this.myProject, null, true);
        MessageBusConnection connection = project2.getMessageBus().connect((Disposable)this);
        connection.subscribe(ShelveChangesManager.SHELF_TOPIC, () -> this.scheduleTreeUpdate());
    }

    private void scheduleTreeUpdate() {
        this.myUpdateQueue.queue(Update.create((Object)"update", () -> this.updateTreeModel()));
    }

    @RequiresEdt
    @NotNull
    private ShelfToolWindowPanel initToolWindowPanel() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myPanel == null) {
            Activity activity2 = StartUpMeasurer.startActivity((String)"ShelvedChangesViewManager initialization");
            this.myPanel = new ShelfToolWindowPanel(this.myProject);
            Disposer.register((Disposable)this.myPanel, () -> {
                this.myPanel = null;
            });
            this.updateTreeModel();
            activity2.end();
        }
        ShelfToolWindowPanel shelfToolWindowPanel = this.myPanel;
        if (shelfToolWindowPanel == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(0);
        }
        return shelfToolWindowPanel;
    }

    public void activateView(@Nullable ShelvedChangeList list2) {
        this.activateAndUpdate(() -> {
            if (list2 != null) {
                this.selectShelvedList(list2);
            }
        });
    }

    @NotNull
    private static Set<ShelvedChangeList> getSelectedLists(@NotNull ChangesTree tree2, @NotNull Predicate<? super ShelvedChangeList> condition) {
        Object[] selectionPaths;
        if (tree2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(1);
        }
        if (condition == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(2);
        }
        if ((selectionPaths = tree2.getSelectionPaths()) == null) {
            Set<ShelvedChangeList> set = Collections.emptySet();
            if (set == null) {
                ShelvedChangesViewManager.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set set = (Set)((StreamEx)((StreamEx)StreamEx.of((Object[])selectionPaths).map(path2 -> (ShelvedChangeList)TreeUtil.findObjectInPath((TreePath)path2, ShelvedChangeList.class)).filter(Predicates.nonNull())).filter(condition)).collect(Collectors.toSet());
        if (set == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    static ListSelection<ShelvedWrapper> getSelectedChangesOrAll(@NotNull DataContext dataContext) {
        List<ShelvedWrapper> allWrappers;
        ChangesBrowserNode changeListNode;
        ShelvedChangeList changeList;
        ChangesTree tree2;
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(5);
        }
        if ((tree2 = (ChangesTree)((Object)dataContext.getData(SHELVED_CHANGES_TREE))) == null) {
            ListSelection listSelection = ListSelection.empty();
            if (listSelection == null) {
                ShelvedChangesViewManager.$$$reportNull$$$0(6);
            }
            return listSelection;
        }
        ListSelection wrappers = ListSelection.createAt(VcsTreeModelData.selected((JTree)((Object)tree2)).userObjects(ShelvedWrapper.class), (int)0);
        if (wrappers.getList().size() == 1 && (changeList = (ShelvedChangeList)ContainerUtil.getFirstItem(ShelvedChangesViewManager.getSelectedLists(tree2, it -> true))) != null && (changeListNode = (ChangesBrowserNode)TreeUtil.findNodeWithObject(tree2.getRoot(), (Object)changeList)) != null && (allWrappers = changeListNode.getAllObjectsUnder(ShelvedWrapper.class)).size() > 1) {
            ShelvedWrapper toSelect = (ShelvedWrapper)ContainerUtil.getFirstItem((List)wrappers.getList());
            ListSelection listSelection = ListSelection.create(allWrappers, (Object)toSelect);
            if (listSelection == null) {
                ShelvedChangesViewManager.$$$reportNull$$$0(7);
            }
            return listSelection;
        }
        ListSelection listSelection = wrappers.asExplicitSelection();
        if (listSelection == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(8);
        }
        return listSelection;
    }

    private void updateTreeIfShown(@NotNull Consumer<? super ShelfTree> treeConsumer) {
        if (treeConsumer == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(9);
        }
        if (this.myPanel != null) {
            treeConsumer.consume((Object)this.myPanel.myTree);
        }
    }

    @RequiresEdt
    void updateTreeView() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree2 -> tree2.rebuildTree()));
    }

    @ApiStatus.Internal
    public static boolean hideDefaultShelfTab(@NotNull Project project2) {
        AbstractVcs singleVcs;
        if (project2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(10);
        }
        if ((singleVcs = ProjectLevelVcsManager.getInstance(project2).getSingleVCS()) == null) {
            return false;
        }
        return singleVcs.isWithCustomShelves();
    }

    protected void removeContent(Content content) {
        ChangesViewContentI contentManager = ChangesViewContentManager.getInstance(this.myProject);
        contentManager.removeContent(content);
        contentManager.selectContent("Local Changes");
    }

    protected void addContent(Content content) {
        ChangesViewContentI contentManager = ChangesViewContentManager.getInstance(this.myProject);
        contentManager.addContent(content);
    }

    protected void activateContent() {
        ChangesViewContentI contentManager = ChangesViewContentManager.getInstance(this.myProject);
        contentManager.selectContent("Shelf");
        ToolWindow window = ChangesViewContentManager.getToolWindowFor(this.myProject, "Shelf");
        if (window != null && !window.isVisible()) {
            window.activate(null);
        }
    }

    @RequiresEdt
    private void updateTreeModel() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree2 -> tree2.invalidateDataAndRefresh(() -> ApplicationManager.getApplication().invokeLater(() -> {
            this.myPostUpdateEdtActivity.forEach(Runnable::run);
            this.myPostUpdateEdtActivity.clear();
        }, ModalityState.nonModal(), this.myProject.getDisposed()))));
    }

    @RequiresEdt
    public void startEditing(@NotNull ShelvedChangeList shelvedChangeList) {
        if (shelvedChangeList == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.activateAndUpdate(() -> {
            this.selectShelvedList(shelvedChangeList);
            this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree2 -> tree2.startEditingAtPath(tree2.getLeadSelectionPath())));
        });
    }

    @NotNull
    public static List<ShelvedChangeList> getShelvedLists(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(12);
        }
        ArrayList<ShelvedChangeList> shelvedChangeLists = new ArrayList<ShelvedChangeList>();
        shelvedChangeLists.addAll(ContainerUtil.notNullize((List)((List)SHELVED_CHANGELIST_KEY.getData(dataContext))));
        shelvedChangeLists.addAll(ContainerUtil.notNullize((List)((List)SHELVED_RECYCLED_CHANGELIST_KEY.getData(dataContext))));
        shelvedChangeLists.addAll(ContainerUtil.notNullize((List)((List)SHELVED_DELETED_CHANGELIST_KEY.getData(dataContext))));
        ArrayList<ShelvedChangeList> arrayList = shelvedChangeLists;
        if (arrayList == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public static List<ShelvedChangeList> getExactlySelectedLists(@NotNull DataContext dataContext) {
        ChangesTree shelvedChangeTree;
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(14);
        }
        if ((shelvedChangeTree = (ChangesTree)((Object)dataContext.getData(SHELVED_CHANGES_TREE))) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                ShelvedChangesViewManager.$$$reportNull$$$0(15);
            }
            return list2;
        }
        List list3 = VcsTreeModelData.exactlySelected((JTree)((Object)shelvedChangeTree)).iterateUserObjects(ShelvedChangeList.class).toList();
        if (list3 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(16);
        }
        return list3;
    }

    private void activateAndUpdate(@NotNull Runnable postUpdateRunnable) {
        if (postUpdateRunnable == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(17);
        }
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.nonModal(), (Condition)this.myProject.getDisposed(), () -> {
            this.activateContent();
            this.myUpdateQueue.cancelAllUpdates();
            this.myPostUpdateEdtActivity.add(postUpdateRunnable);
            this.updateTreeModel();
        });
    }

    public void dispose() {
        this.myUpdateQueue.cancelAllUpdates();
    }

    public void updateOnVcsMappingsChanged() {
        ApplicationManager.getApplication().invokeLater(() -> this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree2 -> {
            ChangesGroupingSupport treeGroupingSupport = tree2.getGroupingSupport();
            if (treeGroupingSupport.isAvailable("repository") && treeGroupingSupport.get("repository")) {
                tree2.onGroupingChanged();
            }
        })), this.myProject.getDisposed());
    }

    public void selectShelvedList(@NotNull ShelvedChangeList list2) {
        if (list2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(18);
        }
        this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree2 -> {
            DefaultMutableTreeNode treeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)tree2.getModel().getRoot()), (Object)list2);
            if (treeNode == null) {
                LOG.warn(VcsBundle.message("shelve.changelist.not.found", list2.DESCRIPTION));
                return;
            }
            TreeUtil.selectNode((JTree)((Object)tree2), (TreeNode)treeNode);
        }));
    }

    @NotNull
    public static List<ShelvedChange> getShelveChanges(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(19);
        }
        List list2 = ContainerUtil.notNullize((List)((List)dataContext.getData(SHELVED_CHANGE_KEY)));
        if (list2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(20);
        }
        return list2;
    }

    @NotNull
    public static List<ShelvedBinaryFile> getBinaryShelveChanges(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(21);
        }
        List list2 = ContainerUtil.notNullize((List)((List)dataContext.getData(SHELVED_BINARY_FILE_KEY)));
        if (list2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(22);
        }
        return list2;
    }

    @NotNull
    public static List<String> getSelectedShelvedChangeNames(@NotNull DataContext dataContext) {
        ChangesTree shelvedChangeTree;
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(23);
        }
        if ((shelvedChangeTree = (ChangesTree)((Object)dataContext.getData(SHELVED_CHANGES_TREE))) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                ShelvedChangesViewManager.$$$reportNull$$$0(24);
            }
            return list2;
        }
        List list3 = VcsTreeModelData.selected((JTree)((Object)shelvedChangeTree)).iterateUserObjects(ShelvedWrapper.class).map(ShelvedWrapper::getPath).toList();
        if (list3 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(25);
        }
        return list3;
    }

    @NotNull
    private static List<ShelvedChange> getChangesNotInLists(@NotNull List<ShelvedChangeList> listsToDelete, @NotNull List<ShelvedChange> shelvedChanges) {
        if (listsToDelete == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(26);
        }
        if (shelvedChanges == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(27);
        }
        ArrayList<ShelvedChange> result2 = new ArrayList<ShelvedChange>(shelvedChanges);
        listsToDelete.stream().map(list2 -> Objects.requireNonNull(list2.getChanges())).forEach(result2::removeAll);
        ArrayList<ShelvedChange> arrayList = result2;
        if (arrayList == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    @NotNull
    @Nls
    private static String constructDeleteSuccessfullyMessage(int fileNum, int listNum, @Nullable ShelvedChangeList first) {
        String listDescription;
        String filesMessage = fileNum != 0 ? VcsBundle.message("shelve.delete.files.successful.message", fileNum) : "";
        String string2 = listDescription = listNum == 1 && first != null ? first.DESCRIPTION : "";
        String changelistsMessage = listNum != 0 ? VcsBundle.message("shelve.delete.changelists.message", listNum, listDescription, listDescription.isEmpty() ? 0 : 1) : "";
        String string3 = StringUtil.capitalize((String)VcsBundle.message("shelve.delete.successful.message", filesMessage, fileNum > 0 && listNum > 0 ? 1 : 0, changelistsMessage));
        if (string3 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(29);
        }
        return string3;
    }

    public static void deleteShelves(@NotNull Project project2, @NotNull List<ShelvedChangeList> shelvedListsToDelete) {
        if (project2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(30);
        }
        if (shelvedListsToDelete == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(31);
        }
        ShelvedChangesViewManager.deleteShelves(project2, shelvedListsToDelete, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    private static void deleteShelves(@NotNull Project project2, @NotNull List<ShelvedChangeList> shelvedListsToDelete, @NotNull List<ShelvedChangeList> shelvedListsFromChanges, @NotNull List<ShelvedChange> selectedChanges, @NotNull List<ShelvedBinaryFile> selectedBinaryChanges) {
        if (project2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(32);
        }
        if (shelvedListsToDelete == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(33);
        }
        if (shelvedListsFromChanges == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(34);
        }
        if (selectedChanges == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(35);
        }
        if (selectedBinaryChanges == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(36);
        }
        List<ShelvedChange> changesToDelete = ShelvedChangesViewManager.getChangesNotInLists(shelvedListsToDelete, selectedChanges);
        List<ShelvedBinaryFile> binariesToDelete = ShelvedChangesViewManager.getBinariesNotInLists(shelvedListsToDelete, selectedBinaryChanges);
        ShelveChangesManager manager = ShelveChangesManager.getInstance(project2);
        int fileListSize = binariesToDelete.size() + changesToDelete.size();
        Map<ShelvedChangeList, Date> createdDeletedListsWithOriginalDates = manager.deleteShelves(shelvedListsToDelete, shelvedListsFromChanges, changesToDelete, binariesToDelete);
        if (!createdDeletedListsWithOriginalDates.isEmpty()) {
            ShelvedChangesViewManager.showUndoDeleteNotification(project2, shelvedListsToDelete, fileListSize, createdDeletedListsWithOriginalDates);
        }
    }

    private static void showUndoDeleteNotification(@NotNull Project project2, @NotNull List<ShelvedChangeList> shelvedListsToDelete, int fileListSize, @NotNull Map<ShelvedChangeList, Date> createdDeletedListsWithOriginalDate) {
        if (project2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(37);
        }
        if (shelvedListsToDelete == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(38);
        }
        if (createdDeletedListsWithOriginalDate == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(39);
        }
        String message2 = ShelvedChangesViewManager.constructDeleteSuccessfullyMessage(fileListSize, shelvedListsToDelete.size(), (ShelvedChangeList)ContainerUtil.getFirstItem(shelvedListsToDelete));
        ShelfDeleteNotification shelfDeletionNotification = new ShelfDeleteNotification(message2);
        shelfDeletionNotification.setDisplayId("vcs.shelf.undo.delete");
        shelfDeletionNotification.addAction((AnAction)new UndoShelfDeletionAction(project2, createdDeletedListsWithOriginalDate));
        VcsNotifier.getInstance(project2).showNotificationAndHideExisting(shelfDeletionNotification, ShelfDeleteNotification.class);
    }

    private static List<ShelvedBinaryFile> getBinariesNotInLists(@NotNull List<ShelvedChangeList> listsToDelete, @NotNull List<ShelvedBinaryFile> binaryFiles) {
        if (listsToDelete == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(40);
        }
        if (binaryFiles == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(41);
        }
        ArrayList<ShelvedBinaryFile> result2 = new ArrayList<ShelvedBinaryFile>(binaryFiles);
        for (ShelvedChangeList list2 : listsToDelete) {
            result2.removeAll(list2.getBinaryFiles());
        }
        return result2;
    }

    private static boolean canHandleDropEvent(@NotNull Project project2, @NotNull DnDEvent event) {
        Object attachedObject;
        if (project2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(42);
        }
        if (event == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(43);
        }
        if ((attachedObject = event.getAttachedObject()) instanceof ChangeListDragBean) {
            List<Change> changes = ((ChangeListDragBean)attachedObject).getChanges();
            return !changes.isEmpty();
        }
        return false;
    }

    private static void handleDropEvent(@NotNull Project project2, @NotNull DnDEvent event) {
        Object attachedObject;
        if (project2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(44);
        }
        if (event == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(45);
        }
        if ((attachedObject = event.getAttachedObject()) instanceof ChangeListDragBean) {
            FileDocumentManager.getInstance().saveAllDocuments();
            List<Change> changes = ((ChangeListDragBean)attachedObject).getChanges();
            ShelveChangesManager.getInstance(project2).shelveSilentlyUnderProgress(changes, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5, 9, 10, 11, 12, 14, 17, 18, 19, 21, 23, 26, 27, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 5: 
            case 12: 
            case 14: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeConsumer";
                break;
            }
            case 10: 
            case 30: 
            case 32: 
            case 37: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChangeList";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postUpdateRunnable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 26: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listsToDelete";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChanges";
                break;
            }
            case 31: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedListsToDelete";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedListsFromChanges";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedChanges";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedBinaryChanges";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdDeletedListsWithOriginalDate";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryFiles";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "initToolWindowPanel";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLists";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChangesOrAll";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getShelvedLists";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExactlySelectedLists";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getShelveChanges";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryShelveChanges";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedShelvedChangeNames";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesNotInLists";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "constructDeleteSuccessfullyMessage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedLists";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedChangesOrAll";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateTreeIfShown";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hideDefaultShelfTab";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "startEditing";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getShelvedLists";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExactlySelectedLists";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "activateAndUpdate";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "selectShelvedList";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getShelveChanges";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryShelveChanges";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedShelvedChangeNames";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getChangesNotInLists";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "deleteShelves";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "showUndoDeleteNotification";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getBinariesNotInLists";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "canHandleDropEvent";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "handleDropEvent";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 5, 9, 10, 11, 12, 14, 17, 18, 19, 21, 23, 26, 27, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45 -> new IllegalArgumentException(string2);
        };
    }

    private static final class ShelfToolWindowPanel
    extends SimpleToolWindowPanel
    implements Disposable {
        @NotNull
        private static final RegistryValue isOpenEditorDiffPreviewWithSingleClick = Registry.get((String)"show.diff.preview.as.editor.tab.with.single.click");
        private final Project myProject;
        private final ShelveChangesManager myShelveChangesManager;
        private final VcsConfiguration myVcsConfiguration;
        @NotNull
        private final JScrollPane myTreeScrollPane;
        private final ShelfTree myTree;
        private MyShelvedPreviewProcessor myEditorChangeProcessor;
        private MyShelvedPreviewProcessor mySplitterChangeProcessor;
        private EditorTabPreview myEditorDiffPreview;
        private PreviewDiffSplitterComponent mySplitterDiffPreview;

        private ShelfToolWindowPanel(@NotNull Project project2) {
            if (project2 == null) {
                ShelfToolWindowPanel.$$$reportNull$$$0(0);
            }
            super(true);
            this.myProject = project2;
            this.myShelveChangesManager = ShelveChangesManager.getInstance(this.myProject);
            this.myVcsConfiguration = VcsConfiguration.getInstance(this.myProject);
            this.myTree = new ShelfTree(this.myProject);
            this.myTree.setEditable(true);
            this.myTree.setDragEnabled(!ApplicationManager.getApplication().isHeadlessEnvironment());
            this.myTree.setCellEditor(new ShelveRenameTreeCellEditor());
            AnAction showDiffAction = ActionManager.getInstance().getAction("Diff.ShowDiff");
            showDiffAction.registerCustomShortcutSet(showDiffAction.getShortcutSet(), (JComponent)((Object)this.myTree));
            EditSourceAction editSourceAction = new EditSourceAction();
            editSourceAction.registerCustomShortcutSet(editSourceAction.getShortcutSet(), (JComponent)((Object)this.myTree));
            DefaultActionGroup actionGroup = new DefaultActionGroup();
            actionGroup.addAll((ActionGroup)ActionManager.getInstance().getAction(ShelvedChangesViewManager.SHELVED_CHANGES_TOOLBAR));
            actionGroup.add((AnAction)Separator.getInstance());
            actionGroup.add((AnAction)new MyToggleDetailsAction());
            ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar("ShelvedChanges", (ActionGroup)actionGroup, false);
            toolbar2.setTargetComponent((JComponent)((Object)this.myTree));
            this.myTreeScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree), (boolean)true);
            this.setContent(this.myTreeScrollPane);
            this.setToolbar(toolbar2.getComponent());
            this.updatePanelLayout();
            this.setDiffPreview();
            EditorTabDiffPreviewManager.getInstance(project2).subscribeToPreviewVisibilityChange(this, this::setDiffPreview);
            isOpenEditorDiffPreviewWithSingleClick.addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue value2) {
                    if (value2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (myEditorDiffPreview != null) {
                        this.setDiffPreview();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfToolWindowPanel$1", "afterValueChanged"));
                }
            }, (Disposable)this);
            this.myProject.getMessageBus().connect((Disposable)this).subscribe(ChangesViewContentManagerListener.TOPIC, () -> this.updatePanelLayout());
            PopupHandler.installPopupMenu((JComponent)((Object)this.myTree), (String)"ShelvedChangesPopupMenu", (String)ShelvedChangesViewManager.SHELF_CONTEXT_MENU);
            new MyDnDSupport(this.myProject, this.myTree, this.myTreeScrollPane).install(this);
        }

        public void dispose() {
            this.myTree.shutdown();
        }

        private void updatePanelLayout() {
            this.setVertical(ChangesViewContentManagerKt.isCommitToolWindowShown(this.myProject));
        }

        private void setDiffPreview() {
            boolean needUpdatePreviews;
            boolean isEditorPreview = ChangesViewManager.isEditorPreview(this.myProject);
            boolean hasSplitterPreview = !ChangesViewContentManagerKt.isCommitToolWindowShown(this.myProject);
            boolean bl = isEditorPreview != (this.myEditorChangeProcessor != null) || hasSplitterPreview != (this.mySplitterChangeProcessor != null) ? true : (needUpdatePreviews = false);
            if (!needUpdatePreviews) {
                return;
            }
            if (this.myEditorChangeProcessor != null) {
                Disposer.dispose((Disposable)this.myEditorChangeProcessor);
            }
            if (this.mySplitterChangeProcessor != null) {
                Disposer.dispose((Disposable)this.mySplitterChangeProcessor);
            }
            if (isEditorPreview) {
                this.myEditorChangeProcessor = new MyShelvedPreviewProcessor(this.myProject, this.myTree, true);
                Disposer.register((Disposable)this, (Disposable)this.myEditorChangeProcessor);
                this.myEditorDiffPreview = this.installEditorPreview(this.myEditorChangeProcessor, hasSplitterPreview);
            } else {
                this.myEditorChangeProcessor = null;
                this.myEditorDiffPreview = null;
            }
            if (hasSplitterPreview) {
                this.mySplitterChangeProcessor = new MyShelvedPreviewProcessor(this.myProject, this.myTree, false);
                Disposer.register((Disposable)this, (Disposable)this.mySplitterChangeProcessor);
                this.mySplitterDiffPreview = this.installSplitterPreview(this.mySplitterChangeProcessor);
            } else {
                this.mySplitterChangeProcessor = null;
                this.mySplitterDiffPreview = null;
            }
        }

        @NotNull
        private EditorTabPreview installEditorPreview(final @NotNull MyShelvedPreviewProcessor changeProcessor, boolean hasSplitterPreview) {
            if (changeProcessor == null) {
                ShelfToolWindowPanel.$$$reportNull$$$0(1);
            }
            return new SimpleTreeEditorDiffPreview(changeProcessor, this.myTree, this.myTreeScrollPane, isOpenEditorDiffPreviewWithSingleClick.asBoolean() && !hasSplitterPreview){

                @Override
                public void returnFocusToTree() {
                    ToolWindow toolWindow = ChangesViewContentManager.getToolWindowFor(myProject, "Shelf");
                    if (toolWindow != null) {
                        toolWindow.activate(null);
                    }
                }

                @Override
                public void updateDiffAction(@NotNull AnActionEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    DiffShelvedChangesActionProvider.updateAvailability(event);
                }

                @Override
                protected String getCurrentName() {
                    ChangeViewDiffRequestProcessor.Wrapper myCurrentShelvedElement = changeProcessor.getCurrentChange();
                    return myCurrentShelvedElement != null ? VcsBundle.message("shelve.editor.diff.preview.title", myCurrentShelvedElement.getPresentableName()) : VcsBundle.message("shelved.version.name", new Object[0]);
                }

                @Override
                protected boolean skipPreviewUpdate() {
                    if (super.skipPreviewUpdate()) {
                        return true;
                    }
                    if (!((Object)((Object)myTree)).equals(IdeFocusManager.getInstance((Project)myProject).getFocusOwner())) {
                        return true;
                    }
                    return !this.isPreviewOpen() && !this.isEditorPreviewAllowed();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfToolWindowPanel$2", "updateDiffAction"));
                }
            };
        }

        @NotNull
        private PreviewDiffSplitterComponent installSplitterPreview(@NotNull MyShelvedPreviewProcessor changeProcessor) {
            if (changeProcessor == null) {
                ShelfToolWindowPanel.$$$reportNull$$$0(2);
            }
            PreviewDiffSplitterComponent previewSplitter = new PreviewDiffSplitterComponent(changeProcessor, ShelvedChangesViewManager.SHELVE_PREVIEW_SPLITTER_PROPORTION);
            previewSplitter.setFirstComponent(this.myTreeScrollPane);
            DiffPreview.setPreviewVisible(previewSplitter, this.myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN);
            this.myTree.addSelectionListener(() -> previewSplitter.updatePreview(false), (Disposable)changeProcessor);
            this.setContent((JComponent)((Object)previewSplitter));
            Disposer.register((Disposable)changeProcessor, () -> this.setContent(this.myTreeScrollPane));
            PreviewDiffSplitterComponent previewDiffSplitterComponent = previewSplitter;
            if (previewDiffSplitterComponent == null) {
                ShelfToolWindowPanel.$$$reportNull$$$0(3);
            }
            return previewDiffSplitterComponent;
        }

        private boolean isEditorPreviewAllowed() {
            return !isOpenEditorDiffPreviewWithSingleClick.asBoolean() || this.myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN;
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                ShelfToolWindowPanel.$$$reportNull$$$0(4);
            }
            if (EditorTabDiffPreviewManager.EDITOR_TAB_DIFF_PREVIEW.is(dataId)) {
                return this.myEditorDiffPreview;
            }
            return super.getData(dataId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeProcessor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfToolWindowPanel";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfToolWindowPanel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "installSplitterPreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "installEditorPreview";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "installSplitterPreview";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }

        private class ShelveRenameTreeCellEditor
        extends DefaultTreeCellEditor
        implements CellEditorListener {
            ShelveRenameTreeCellEditor() {
                super((JTree)((Object)ShelfToolWindowPanel.this.myTree), null);
                this.addCellEditorListener(this);
            }

            @Override
            public boolean isCellEditable(EventObject event) {
                return !(event instanceof MouseEvent) && super.isCellEditable(event);
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                TreeNode node = (TreeNode)ShelfToolWindowPanel.this.myTree.getLastSelectedPathComponent();
                if (node instanceof ShelvedListNode) {
                    ShelvedListNode changeListNode = (ShelvedListNode)node;
                    Object object = e.getSource();
                    if (object instanceof TreeCellEditor) {
                        TreeCellEditor treeCellEditor = (TreeCellEditor)object;
                        String editorValue = treeCellEditor.getCellEditorValue().toString();
                        ShelvedChangeList shelvedChangeList = changeListNode.getList();
                        ShelfToolWindowPanel.this.myShelveChangesManager.renameChangeList(shelvedChangeList, editorValue);
                    }
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        }

        private class MyToggleDetailsAction
        extends ShowDiffPreviewAction {
            private MyToggleDetailsAction() {
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyToggleDetailsAction.$$$reportNull$$$0(0);
                }
                super.update(e);
                e.getPresentation().setEnabledAndVisible(ShelfToolWindowPanel.this.mySplitterDiffPreview != null || isOpenEditorDiffPreviewWithSingleClick.asBoolean());
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    MyToggleDetailsAction.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    MyToggleDetailsAction.$$$reportNull$$$0(2);
                }
                DiffPreview previewSplitter = (DiffPreview)ObjectUtils.chooseNotNull((Object)ShelfToolWindowPanel.this.mySplitterDiffPreview, (Object)ShelfToolWindowPanel.this.myEditorDiffPreview);
                DiffPreview.setPreviewVisible(previewSplitter, state);
                ShelfToolWindowPanel.this.myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN = state;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyToggleDetailsAction.$$$reportNull$$$0(3);
                }
                return ShelfToolWindowPanel.this.myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfToolWindowPanel$MyToggleDetailsAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfToolWindowPanel$MyToggleDetailsAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        }

        private static class MyDnDSupport
        implements DnDDropHandler,
        DnDTargetChecker {
            @NotNull
            private final Project myProject;
            @NotNull
            private final ChangesTree myTree;
            @NotNull
            private final JScrollPane myTreeScrollPane;

            private MyDnDSupport(@NotNull Project project2, @NotNull ChangesTree tree2, @NotNull JScrollPane treeScrollPane) {
                if (project2 == null) {
                    MyDnDSupport.$$$reportNull$$$0(0);
                }
                if (tree2 == null) {
                    MyDnDSupport.$$$reportNull$$$0(1);
                }
                if (treeScrollPane == null) {
                    MyDnDSupport.$$$reportNull$$$0(2);
                }
                this.myProject = project2;
                this.myTree = tree2;
                this.myTreeScrollPane = treeScrollPane;
            }

            public void install(@NotNull Disposable disposable) {
                if (disposable == null) {
                    MyDnDSupport.$$$reportNull$$$0(3);
                }
                DnDSupport.createBuilder((JComponent)((Object)this.myTree)).setTargetChecker((DnDTargetChecker)this).setDropHandler((DnDDropHandler)this).setImageProvider(this::createDraggedImage).setBeanProvider(this::createDragStartBean).setDisposableParent(disposable).install();
            }

            public void drop(DnDEvent aEvent) {
                ShelvedChangesViewManager.handleDropEvent(this.myProject, aEvent);
            }

            public boolean update(DnDEvent aEvent) {
                aEvent.hideHighlighter();
                aEvent.setDropPossible(false, "");
                boolean canHandle = ShelvedChangesViewManager.canHandleDropEvent(this.myProject, aEvent);
                if (!canHandle) {
                    return true;
                }
                Rectangle tableCellRect = new Rectangle(0, 0, JBUI.scale((int)300), JBUI.scale((int)12));
                aEvent.setHighlighting(new RelativeRectangle((Component)this.myTreeScrollPane, tableCellRect), 1);
                aEvent.setDropPossible(true);
                return false;
            }

            @Nullable
            private DnDDragStartBean createDragStartBean(@NotNull DnDActionInfo info) {
                if (info == null) {
                    MyDnDSupport.$$$reportNull$$$0(4);
                }
                if (info.isMove()) {
                    DataContext dc = DataManager.getInstance().getDataContext((Component)((Object)this.myTree));
                    return new DnDDragStartBean((Object)new ShelvedChangeListDragBean(ShelvedChangesViewManager.getShelveChanges(dc), ShelvedChangesViewManager.getBinaryShelveChanges(dc), ShelvedChangesViewManager.getShelvedLists(dc)));
                }
                return null;
            }

            @NotNull
            private DnDImage createDraggedImage(@NotNull DnDActionInfo info) {
                if (info == null) {
                    MyDnDSupport.$$$reportNull$$$0(5);
                }
                String imageText = VcsBundle.message("unshelve.changes.action", new Object[0]);
                Image image = (Image)DnDAwareTree.getDragImage((Tree)this.myTree, (String)imageText, null).getFirst();
                return new DnDImage(image, new Point(-image.getWidth(null), -image.getHeight(null)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tree";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "treeScrollPane";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "disposable";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "info";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfToolWindowPanel$MyDnDSupport";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "install";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createDragStartBean";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createDraggedImage";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static final class ShelfTree
    extends AsyncChangesTree {
        private final DeleteProvider myDeleteProvider;
        private final ShelfTreeAsyncModel myAsyncTreeModel;

        private ShelfTree(@NotNull Project project2) {
            if (project2 == null) {
                ShelfTree.$$$reportNull$$$0(0);
            }
            super(project2, false, false, false);
            this.myDeleteProvider = new MyShelveDeleteProvider(this.myProject, this);
            this.myAsyncTreeModel = new ShelfTreeAsyncModel(project2, this.getScope());
            TreeSpeedSearch.installOn((JTree)((Object)this), (boolean)true, ChangesBrowserNode.TO_TEXT_CONVERTER);
            this.setKeepTreeState(true);
            this.setDoubleClickHandler((Processor<? super MouseEvent>)((Processor)e -> this.showShelvedChangesDiff()));
            this.setEnterKeyHandler((Processor<? super KeyEvent>)((Processor)e -> this.showShelvedChangesDiff()));
        }

        @Override
        @NotNull
        protected AsyncChangesTreeModel getChangesTreeModel() {
            ShelfTreeAsyncModel shelfTreeAsyncModel = this.myAsyncTreeModel;
            if (shelfTreeAsyncModel == null) {
                ShelfTree.$$$reportNull$$$0(1);
            }
            return shelfTreeAsyncModel;
        }

        public boolean isPathEditable(TreePath path2) {
            return this.isEditable() && this.getSelectionCount() == 1 && path2.getLastPathComponent() instanceof ShelvedListNode;
        }

        @Override
        @NotNull
        protected ChangesGroupingSupport installGroupingSupport() {
            ChangesGroupingSupport groupingSupport = new ChangesGroupingSupport(this.myProject, (Object)this, false);
            ChangesTree.installGroupingSupport((ChangesTree)this, groupingSupport, () -> ShelveChangesManager.getInstance(this.myProject).getGrouping(), (? super Collection<String> newGrouping) -> ShelveChangesManager.getInstance(this.myProject).setGrouping((Collection<String>)newGrouping));
            ChangesGroupingSupport changesGroupingSupport = groupingSupport;
            if (changesGroupingSupport == null) {
                ShelfTree.$$$reportNull$$$0(2);
            }
            return changesGroupingSupport;
        }

        @Override
        public int getToggleClickCount() {
            return 2;
        }

        private boolean showShelvedChangesDiff() {
            if (!this.hasExactlySelectedChanges()) {
                return false;
            }
            DiffShelvedChangesActionProvider.showShelvedChangesDiff(DataManager.getInstance().getDataContext((Component)((Object)this)));
            return true;
        }

        private boolean hasExactlySelectedChanges() {
            return VcsTreeModelData.exactlySelected((JTree)((Object)this)).iterateUserObjects(ShelvedWrapper.class).isNotEmpty();
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                ShelfTree.$$$reportNull$$$0(3);
            }
            if (SHELVED_CHANGES_TREE.is(dataId)) {
                return this;
            }
            if (SHELVED_CHANGELIST_KEY.is(dataId)) {
                return new ArrayList<ShelvedChangeList>(ShelvedChangesViewManager.getSelectedLists(this, l -> !l.isRecycled() && !l.isDeleted()));
            }
            if (SHELVED_RECYCLED_CHANGELIST_KEY.is(dataId)) {
                return new ArrayList<ShelvedChangeList>(ShelvedChangesViewManager.getSelectedLists(this, l -> l.isRecycled() && !l.isDeleted()));
            }
            if (SHELVED_DELETED_CHANGELIST_KEY.is(dataId)) {
                return new ArrayList<ShelvedChangeList>(ShelvedChangesViewManager.getSelectedLists(this, l -> l.isDeleted()));
            }
            if (SHELVED_CHANGE_KEY.is(dataId)) {
                return VcsTreeModelData.selected((JTree)((Object)this)).iterateUserObjects(ShelvedWrapper.class).map(s -> s.getShelvedChange()).filterNotNull().toList();
            }
            if (SHELVED_BINARY_FILE_KEY.is(dataId)) {
                return VcsTreeModelData.selected((JTree)((Object)this)).iterateUserObjects(ShelvedWrapper.class).map(s -> s.getBinaryFile()).filterNotNull().toList();
            }
            if (VcsDataKeys.CHANGES.is(dataId)) {
                List<ShelvedWrapper> shelvedChanges = VcsTreeModelData.selected((JTree)((Object)this)).userObjects(ShelvedWrapper.class);
                if (!shelvedChanges.isEmpty()) {
                    return ContainerUtil.map2Array(shelvedChanges, Change.class, s -> s.getChangeWithLocal(this.myProject));
                }
            } else {
                if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) && !this.isEditing()) {
                    return this.myDeleteProvider;
                }
                if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                    List<ShelvedWrapper> shelvedChanges = VcsTreeModelData.selected((JTree)((Object)this)).userObjects(ShelvedWrapper.class);
                    ArrayDeque<1> navigatables = new ArrayDeque<1>();
                    for (final ShelvedWrapper shelvedChange : shelvedChanges) {
                        if (shelvedChange.getBeforePath() == null || FileStatus.ADDED.equals(shelvedChange.getFileStatus())) continue;
                        NavigatableAdapter navigatable = new NavigatableAdapter(){

                            public void navigate(boolean requestFocus) {
                                VirtualFile vf = shelvedChange.getBeforeVFUnderProject(myProject);
                                if (vf != null) {
                                    1.navigate((Project)myProject, (VirtualFile)vf, (boolean)true);
                                }
                            }
                        };
                        navigatables.add(navigatable);
                    }
                    return navigatables.toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY);
                }
                if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
                    return ShelvedChangesViewManager.HELP_ID;
                }
            }
            return super.getData(dataId);
        }

        public void invalidateDataAndRefresh(@Nullable Runnable onRefreshed) {
            this.myAsyncTreeModel.invalidateData();
            this.requestRefresh(onRefreshed);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfTree";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfTree";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangesTreeModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "installGroupingSupport";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 2 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class UndoShelfDeletionAction
    extends NotificationAction {
        @NotNull
        private final Project myProject;
        @NotNull
        private final Map<ShelvedChangeList, Date> myListDateMap;

        private UndoShelfDeletionAction(@NotNull Project project2, @NotNull Map<ShelvedChangeList, Date> listDateMap) {
            if (project2 == null) {
                UndoShelfDeletionAction.$$$reportNull$$$0(0);
            }
            if (listDateMap == null) {
                UndoShelfDeletionAction.$$$reportNull$$$0(1);
            }
            super(IdeBundle.messagePointer((String)"undo.dialog.title", (Object[])new Object[0]));
            this.myProject = project2;
            this.myListDateMap = listDateMap;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            if (e == null) {
                UndoShelfDeletionAction.$$$reportNull$$$0(2);
            }
            if (notification == null) {
                UndoShelfDeletionAction.$$$reportNull$$$0(3);
            }
            ShelveChangesManager manager = ShelveChangesManager.getInstance(this.myProject);
            List cantRestoreList = ContainerUtil.findAll(this.myListDateMap.keySet(), l -> l == null || !manager.getDeletedLists().contains(l));
            this.myListDateMap.forEach((l, d) -> manager.restoreList((ShelvedChangeList)l, (Date)d));
            notification.expire();
            if (!cantRestoreList.isEmpty()) {
                VcsNotifier.getInstance(this.myProject).notifyMinorWarning("vcs.shelve.deletion.undo", VcsBundle.message("shelve.undo.deletion", new Object[0]), VcsBundle.message("shelve.changes.restore.error", cantRestoreList.size()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listDateMap";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$UndoShelfDeletionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyShelfManagerListener
    implements ShelveChangesManagerListener {
        private final Project myProject;

        public MyShelfManagerListener(@NotNull Project project2) {
            if (project2 == null) {
                MyShelfManagerListener.$$$reportNull$$$0(0);
            }
            this.myProject = project2;
        }

        @Override
        public void shelvedListsChanged() {
            ApplicationManager.getApplication().invokeLater(() -> ((ChangesViewContentManagerListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, ChangesViewContentManagerListener.TOPIC)).toolWindowMappingChanged());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelfManagerListener", "<init>"));
        }
    }

    private static class ShelvedChangeNode
    extends ChangesBrowserNode<ShelvedWrapper>
    implements Comparable<ShelvedChangeNode> {
        @NotNull
        private final ShelvedWrapper myShelvedChange;
        @NotNull
        private final FilePath myFilePath;
        @Nullable
        @Nls
        private final String myAdditionalText;

        protected ShelvedChangeNode(@NotNull ShelvedWrapper shelvedChange, @NotNull FilePath filePath, @Nullable @Nls String additionalText) {
            if (shelvedChange == null) {
                ShelvedChangeNode.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                ShelvedChangeNode.$$$reportNull$$$0(1);
            }
            super(shelvedChange);
            this.myShelvedChange = shelvedChange;
            this.myFilePath = filePath;
            this.myAdditionalText = additionalText;
        }

        @Override
        public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
            if (renderer2 == null) {
                ShelvedChangeNode.$$$reportNull$$$0(2);
            }
            String path2 = this.myShelvedChange.getRequestName();
            String directory = StringUtil.defaultIfEmpty((String)PathUtil.getParentPath((String)path2), (String)VcsBundle.message("shelve.default.path.rendering", new Object[0]));
            String fileName = StringUtil.defaultIfEmpty((String)PathUtil.getFileName((String)path2), (String)path2);
            renderer2.append(fileName, new SimpleTextAttributes(0, this.myShelvedChange.getFileStatus().getColor()));
            if (this.myAdditionalText != null) {
                renderer2.append(FontUtil.spaceAndThinSpace() + this.myAdditionalText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            if (renderer2.isShowFlatten()) {
                renderer2.append(FontUtil.spaceAndThinSpace() + FileUtil.toSystemDependentName((String)directory), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            renderer2.setIcon(FileTypeManager.getInstance().getFileTypeByFileName(fileName).getIcon());
        }

        @Override
        public String getTextPresentation() {
            return PathUtil.getFileName((String)this.myShelvedChange.getRequestName());
        }

        @Override
        protected boolean isFile() {
            return true;
        }

        @Override
        public int compareTo(@NotNull ShelvedChangeNode o) {
            if (o == null) {
                ShelvedChangeNode.$$$reportNull$$$0(3);
            }
            return ShelvedChangeNode.compareFilePaths(this.myFilePath, o.myFilePath);
        }

        @Override
        @Nullable
        public Color getBackgroundColor(@NotNull Project project2) {
            if (project2 == null) {
                ShelvedChangeNode.$$$reportNull$$$0(4);
            }
            return ShelvedChangeNode.getBackgroundColorFor(project2, this.myFilePath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shelvedChange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelvedChangeNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "render";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBackgroundColor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ShelvedListNode
    extends ChangesBrowserNode<ShelvedChangeList> {
        @NotNull
        private final ShelvedChangeList myList;

        ShelvedListNode(@NotNull ShelvedChangeList list2) {
            if (list2 == null) {
                ShelvedListNode.$$$reportNull$$$0(0);
            }
            super(list2);
            this.myList = list2;
        }

        @NotNull
        public ShelvedChangeList getList() {
            ShelvedChangeList shelvedChangeList = this.myList;
            if (shelvedChangeList == null) {
                ShelvedListNode.$$$reportNull$$$0(1);
            }
            return shelvedChangeList;
        }

        @Override
        public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
            String listName;
            if (renderer2 == null) {
                ShelvedListNode.$$$reportNull$$$0(2);
            }
            if (StringUtil.isEmptyOrSpaces((String)(listName = this.myList.DESCRIPTION))) {
                listName = VcsBundle.message("changes.nodetitle.empty.changelist.name", new Object[0]);
            }
            if (this.myList.isRecycled() || this.myList.isDeleted()) {
                renderer2.appendTextWithIssueLinks(listName, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            } else {
                renderer2.appendTextWithIssueLinks(listName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            this.appendCount(renderer2);
            String date = DateFormatUtil.formatPrettyDateTime((Date)this.myList.DATE);
            renderer2.append(", " + date, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            String loadingError = this.myList.getChangesLoadingError();
            if (loadingError != null) {
                renderer2.append(FontUtil.spaceAndThinSpace() + loadingError, SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }

        @Override
        @Nls
        public String getTextPresentation() {
            return ((ShelvedChangeList)this.getUserObject()).toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelvedListNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelvedListNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "render";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private static class MyShelvedPreviewProcessor
    extends ChangeViewDiffRequestProcessor
    implements DiffPreviewUpdateProcessor {
        @NotNull
        private final ShelfTree myTree;
        private final boolean myIsInEditor;
        @NotNull
        private final DiffShelvedChangesActionProvider.PatchesPreloader myPreloader;

        MyShelvedPreviewProcessor(@NotNull Project project2, @NotNull ShelfTree tree2, boolean isInEditor) {
            if (project2 == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(0);
            }
            if (tree2 == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(1);
            }
            super(project2, "ShelveView");
            this.myTree = tree2;
            this.myIsInEditor = isInEditor;
            this.myPreloader = new DiffShelvedChangesActionProvider.PatchesPreloader(project2);
            this.putContextUserData(DiffShelvedChangesActionProvider.PatchesPreloader.SHELF_PRELOADER, this.myPreloader);
        }

        @Override
        @RequiresEdt
        public void clear() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.setCurrentChange(null);
            this.dropCaches();
        }

        protected boolean shouldAddToolbarBottomBorder(@NotNull FrameDiffTool.ToolbarComponents toolbarComponents) {
            if (toolbarComponents == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(2);
            }
            return !this.myIsInEditor || super.shouldAddToolbarBottomBorder(toolbarComponents);
        }

        @Override
        @NotNull
        public Iterable<? extends ChangeViewDiffRequestProcessor.Wrapper> iterateSelectedChanges() {
            JBIterable<ShelvedWrapper> jBIterable = VcsTreeModelData.selected((JTree)((Object)this.myTree)).iterateUserObjects(ShelvedWrapper.class);
            if (jBIterable == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public Iterable<? extends ChangeViewDiffRequestProcessor.Wrapper> iterateAllChanges() {
            Set changeLists = VcsTreeModelData.selected((JTree)((Object)this.myTree)).iterateUserObjects(ShelvedWrapper.class).map(wrapper -> wrapper.getChangeList()).toSet();
            JBIterable jBIterable = VcsTreeModelData.all((JTree)((Object)this.myTree)).iterateRawNodes().filter(node -> node instanceof ShelvedListNode && changeLists.contains(((ShelvedListNode)node).getList())).flatMap(node -> VcsTreeModelData.allUnder(node).iterateUserObjects(ShelvedWrapper.class));
            if (jBIterable == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        @Override
        protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
            if (change == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(5);
            }
            if (change instanceof ShelvedWrapper) {
                ChangesBrowserNode<?> root = this.myTree.getRoot();
                DefaultMutableTreeNode changelistNode = TreeUtil.findNodeWithObject(root, (Object)((ShelvedWrapper)change).getChangeList());
                if (changelistNode == null) {
                    return;
                }
                DefaultMutableTreeNode node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)changelistNode, (Object)change);
                if (node == null) {
                    return;
                }
                TreeUtil.selectPath((JTree)((Object)this.myTree), (TreePath)TreeUtil.getPathFromRoot((TreeNode)node), (boolean)false);
            }
        }

        @Override
        @Nullable
        protected DiffRequest loadRequestFast(@NotNull DiffRequestProducer provider) {
            ShelvedChange shelvedChange;
            if (provider == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(6);
            }
            if (provider instanceof ShelvedWrapperDiffRequestProducer && (shelvedChange = ((ShelvedWrapperDiffRequestProducer)provider).getWrapper().getShelvedChange()) != null && this.myPreloader.isPatchFileChanged(shelvedChange.getPatchPath())) {
                return null;
            }
            return super.loadRequestFast(provider);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolbarComponents";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelvedPreviewProcessor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelvedPreviewProcessor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateSelectedChanges";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateAllChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldAddToolbarBottomBorder";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "selectChange";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "loadRequestFast";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 4 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class MyDnDTarget
    extends VcsToolwindowDnDTarget {
        private MyDnDTarget(@NotNull Project project2, @NotNull Content content) {
            if (project2 == null) {
                MyDnDTarget.$$$reportNull$$$0(0);
            }
            if (content == null) {
                MyDnDTarget.$$$reportNull$$$0(1);
            }
            super(project2, content);
        }

        @Override
        public void drop(DnDEvent event) {
            super.drop(event);
            ShelvedChangesViewManager.handleDropEvent(this.myProject, event);
        }

        @Override
        public boolean isDropPossible(@NotNull DnDEvent event) {
            if (event == null) {
                MyDnDTarget.$$$reportNull$$$0(2);
            }
            return ShelvedChangesViewManager.canHandleDropEvent(this.myProject, event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyDnDTarget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDropPossible";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyShelveDeleteProvider
    implements DeleteProvider {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ShelfTree myTree;

        private MyShelveDeleteProvider(@NotNull Project project2, @NotNull ShelfTree tree2) {
            if (project2 == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(0);
            }
            if (tree2 == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(1);
            }
            this.myProject = project2;
            this.myTree = tree2;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(3);
            }
            List shelvedListsToDelete = TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this.myTree), ShelvedChangeList.class);
            List<ShelvedChangeList> shelvedListsFromChanges = ShelvedChangesViewManager.getShelvedLists(dataContext);
            List<ShelvedChange> selectedChanges = ShelvedChangesViewManager.getShelveChanges(dataContext);
            List<ShelvedBinaryFile> selectedBinaryChanges = ShelvedChangesViewManager.getBinaryShelveChanges(dataContext);
            ShelvedChangesViewManager.deleteShelves(this.myProject, shelvedListsToDelete, shelvedListsFromChanges, selectedChanges, selectedBinaryChanges);
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(4);
            }
            return !ShelvedChangesViewManager.getShelvedLists(dataContext).isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteElement";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private static class ShelfTreeAsyncModel
    extends TwoStepAsyncChangesTreeModel<List<ShelvedChangeList>> {
        private final Project myProject;

        private ShelfTreeAsyncModel(@NotNull Project project2, @NotNull CoroutineScope scope2) {
            if (project2 == null) {
                ShelfTreeAsyncModel.$$$reportNull$$$0(0);
            }
            if (scope2 == null) {
                ShelfTreeAsyncModel.$$$reportNull$$$0(1);
            }
            super(scope2);
            this.myProject = project2;
        }

        @Override
        public List<ShelvedChangeList> fetchData() {
            List<ShelvedChangeList> lists = ShelveChangesManager.getInstance(this.myProject).getAllLists();
            lists.forEach(l -> l.loadChangesIfNeeded(this.myProject));
            return ContainerUtil.sorted(lists, (Comparator)ChangelistComparator.getInstance());
        }

        @Override
        @NotNull
        public DefaultTreeModel buildTreeModelSync(@NotNull List<ShelvedChangeList> changeLists, @NotNull ChangesGroupingPolicyFactory grouping) {
            if (changeLists == null) {
                ShelfTreeAsyncModel.$$$reportNull$$$0(2);
            }
            if (grouping == null) {
                ShelfTreeAsyncModel.$$$reportNull$$$0(3);
            }
            boolean showRecycled = ShelveChangesManager.getInstance(this.myProject).isShowRecycled();
            MyShelvedTreeModelBuilder modelBuilder = new MyShelvedTreeModelBuilder(this.myProject, grouping);
            modelBuilder.setShelvedLists(ContainerUtil.filter(changeLists, l -> !l.isDeleted() && (showRecycled || !l.isRecycled())));
            modelBuilder.setDeletedShelvedLists(ContainerUtil.filter(changeLists, ShelvedChangeList::isDeleted));
            DefaultTreeModel defaultTreeModel = modelBuilder.build();
            if (defaultTreeModel == null) {
                ShelfTreeAsyncModel.$$$reportNull$$$0(4);
            }
            return defaultTreeModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeLists";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grouping";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfTreeAsyncModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfTreeAsyncModel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildTreeModelSync";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "buildTreeModelSync";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 4 -> new IllegalStateException(string2);
            };
        }
    }

    static class ChangelistComparator
    implements Comparator<ShelvedChangeList> {
        private static final ChangelistComparator ourInstance = new ChangelistComparator();

        ChangelistComparator() {
        }

        public static ChangelistComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(ShelvedChangeList o1, ShelvedChangeList o2) {
            return o2.DATE.compareTo(o1.DATE);
        }
    }

    public static class ContentProvider
    implements ChangesViewContentProvider {
        @NotNull
        private final Project myProject;

        public ContentProvider(@NotNull Project project2) {
            if (project2 == null) {
                ContentProvider.$$$reportNull$$$0(0);
            }
            this.myProject = project2;
        }

        @Override
        public void initTabContent(@NotNull Content content) {
            if (content == null) {
                ContentProvider.$$$reportNull$$$0(1);
            }
            ShelfToolWindowPanel panel2 = ShelvedChangesViewManager.getInstance(this.myProject).initToolWindowPanel();
            content.setHelpId(ShelvedChangesViewManager.HELP_ID);
            content.setComponent((JComponent)((Object)panel2));
            content.setDisposer((Disposable)panel2);
            content.setPreferredFocusableComponent((JComponent)((Object)panel2.myTree));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ContentProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "initTabContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class ContentPredicate
    implements Predicate<Project> {
        ContentPredicate() {
        }

        @Override
        public boolean test(Project project2) {
            if (ShelvedChangesViewManager.hideDefaultShelfTab(project2)) {
                return false;
            }
            ShelveChangesManager shelveManager = (ShelveChangesManager)project2.getServiceIfCreated(ShelveChangesManager.class);
            return shelveManager != null && !shelveManager.getAllLists().isEmpty();
        }
    }

    public static class ContentPreloader
    implements ChangesViewContentProvider.Preloader {
        @NotNull
        private final Project myProject;

        public ContentPreloader(@NotNull Project project2) {
            if (project2 == null) {
                ContentPreloader.$$$reportNull$$$0(0);
            }
            this.myProject = project2;
        }

        @Override
        public void preloadTabContent(@NotNull Content content) {
            if (content == null) {
                ContentPreloader.$$$reportNull$$$0(1);
            }
            content.putUserData(Content.TAB_DND_TARGET_KEY, (Object)new MyDnDTarget(this.myProject, content));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ContentPreloader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preloadTabContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyShelvedTreeModelBuilder
    extends TreeModelBuilder {
        private MyShelvedTreeModelBuilder(Project project2, @NotNull ChangesGroupingPolicyFactory grouping) {
            if (grouping == null) {
                MyShelvedTreeModelBuilder.$$$reportNull$$$0(0);
            }
            super(project2, grouping);
        }

        public void setShelvedLists(@NotNull List<ShelvedChangeList> shelvedLists) {
            if (shelvedLists == null) {
                MyShelvedTreeModelBuilder.$$$reportNull$$$0(1);
            }
            this.createShelvedListsWithChangesNode(shelvedLists, this.myRoot);
        }

        public void setDeletedShelvedLists(@NotNull List<ShelvedChangeList> shelvedLists) {
            if (shelvedLists == null) {
                MyShelvedTreeModelBuilder.$$$reportNull$$$0(2);
            }
            this.createShelvedListsWithChangesNode(shelvedLists, this.createTagNode(VcsBundle.message("shelve.recently.deleted.node", new Object[0])));
        }

        private void createShelvedListsWithChangesNode(@NotNull List<ShelvedChangeList> shelvedLists, @NotNull ChangesBrowserNode<?> parentNode) {
            if (shelvedLists == null) {
                MyShelvedTreeModelBuilder.$$$reportNull$$$0(3);
            }
            if (parentNode == null) {
                MyShelvedTreeModelBuilder.$$$reportNull$$$0(4);
            }
            for (ShelvedChangeList changeList : shelvedLists) {
                ShelvedListNode shelvedListNode = new ShelvedListNode(changeList);
                this.insertSubtreeRoot(shelvedListNode, parentNode);
                List<ShelvedChange> changes = changeList.getChanges();
                if (changes == null) continue;
                ArrayList<ShelvedWrapper> shelvedChanges = new ArrayList<ShelvedWrapper>();
                changes.stream().map(change -> new ShelvedWrapper((ShelvedChange)change, changeList)).forEach(shelvedChanges::add);
                changeList.getBinaryFiles().stream().map(binaryChange -> new ShelvedWrapper((ShelvedBinaryFile)binaryChange, changeList)).forEach(shelvedChanges::add);
                shelvedChanges.sort(Comparator.comparing(s -> s.getChangeWithLocal(this.myProject), CHANGE_COMPARATOR));
                for (ShelvedWrapper shelved : shelvedChanges) {
                    Change change2 = shelved.getChangeWithLocal(this.myProject);
                    FilePath filePath = ChangesUtil.getFilePath(change2);
                    this.insertChangeNode(change2, shelvedListNode, new ShelvedChangeNode(shelved, filePath, change2.getOriginText(this.myProject)));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grouping";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shelvedLists";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentNode";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelvedTreeModelBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setShelvedLists";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setDeletedShelvedLists";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createShelvedListsWithChangesNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DisplayNameSupplier
    implements Supplier<String> {
        @Override
        public String get() {
            return VcsBundle.message("shelf.tab", new Object[0]);
        }
    }
}

