/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.Alphabet;
import com.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import com.thaiopensource.relaxng.impl.RestrictionViolationException;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class ListPattern
extends Pattern {
    private final Pattern p;
    private final Locator locator;

    ListPattern(Pattern pattern2, Locator locator) {
        super(false, 3, Pattern.combineHashCode(37, pattern2.hashCode()));
        this.p = pattern2;
        this.locator = locator;
    }

    Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
        Pattern pattern2 = this.p.expand(schemaPatternBuilder);
        if (pattern2 != this.p) {
            return schemaPatternBuilder.makeList(pattern2, this.locator);
        }
        return this;
    }

    void checkRecursion(int n) throws SAXException {
        this.p.checkRecursion(n);
    }

    boolean samePattern(Pattern pattern2) {
        return pattern2 instanceof ListPattern && this.p == ((ListPattern)pattern2).p;
    }

    void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitList(this.p);
    }

    Object apply(PatternFunction patternFunction) {
        return patternFunction.caseList(this);
    }

    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 7: {
                throw new RestrictionViolationException("data_except_contains_list");
            }
            case 0: {
                throw new RestrictionViolationException("start_contains_list");
            }
            case 6: {
                throw new RestrictionViolationException("list_contains_list");
            }
        }
        try {
            this.p.checkRestrictions(6, duplicateAttributeDetector, null);
        }
        catch (RestrictionViolationException restrictionViolationException) {
            restrictionViolationException.maybeSetLocator(this.locator);
            throw restrictionViolationException;
        }
    }

    Pattern getOperand() {
        return this.p;
    }
}

