/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonBinaryWriterBuilder;
import com.intellij.util.ThrowableConsumer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.Supplier;

public class ToolingStreamApiUtils {
    public static final String OBJECT_ID_FIELD = "objectID";

    @NotNull
    public static IonBinaryWriterBuilder createIonWriter() {
        IonBinaryWriterBuilder ionBinaryWriterBuilder = IonBinaryWriterBuilder.standard().withLocalSymbolTableAppendEnabled().withStreamCopyOptimized(true);
        if (ionBinaryWriterBuilder == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(0);
        }
        return ionBinaryWriterBuilder;
    }

    @Nullable
    public static String readString(@NotNull IonReader reader, @Nullable String fieldName) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(1);
        }
        IonType type = reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, fieldName);
        if (type == null) {
            return null;
        }
        return reader.stringValue();
    }

    @Nullable
    public static String readString(@NotNull IonReader reader, @Nullable String fieldName, @NotNull ConcurrentMap<String, String> stringCache) {
        String str;
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(2);
        }
        if (stringCache == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(3);
        }
        if ((str = ToolingStreamApiUtils.readString(reader, fieldName)) == null) {
            return null;
        }
        String old = stringCache.putIfAbsent(str, str);
        if (old == null) {
            return str;
        }
        return old;
    }

    public static int readInt(@NotNull IonReader reader, @NotNull String fieldName) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(4);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(5);
        }
        reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, fieldName);
        return reader.intValue();
    }

    public static long readLong(@NotNull IonReader reader, @NotNull String fieldName) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(6);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(7);
        }
        reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, fieldName);
        return reader.longValue();
    }

    public static boolean readBoolean(@NotNull IonReader reader, @NotNull String fieldName) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(8);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(9);
        }
        reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, fieldName);
        return reader.booleanValue();
    }

    public static List<File> readFiles(@NotNull IonReader reader) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(10);
        }
        return ToolingStreamApiUtils.readFiles(reader, null);
    }

    public static List<File> readFiles(@NotNull IonReader reader, @Nullable String fieldName) {
        File file;
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(11);
        }
        reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, fieldName);
        ArrayList<File> list = new ArrayList<File>();
        reader.stepIn();
        while ((file = ToolingStreamApiUtils.readFile(reader, null)) != null) {
            list.add(file);
        }
        reader.stepOut();
        return list;
    }

    public static Set<File> readFilesSet(@NotNull IonReader reader) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(12);
        }
        return ToolingStreamApiUtils.readFilesSet(reader, null);
    }

    @NotNull
    public static Set<File> readFilesSet(@NotNull IonReader reader, @Nullable String fieldName) {
        File file;
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(13);
        }
        reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, fieldName);
        HashSet<File> set = new HashSet<File>();
        reader.stepIn();
        while ((file = ToolingStreamApiUtils.readFile(reader, null)) != null) {
            set.add(file);
        }
        reader.stepOut();
        HashSet<File> hashSet = set;
        if (hashSet == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    @Nullable
    public static File readFile(@NotNull IonReader reader, @Nullable String fieldName) {
        String filePath;
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(15);
        }
        return (filePath = ToolingStreamApiUtils.readString(reader, fieldName)) == null ? null : new File(filePath);
    }

    public static <K, V> Map<K, V> readMap(@NotNull IonReader reader, @NotNull Supplier<? extends K> keyReader, @NotNull Supplier<? extends V> valueReader) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(16);
        }
        if (keyReader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(17);
        }
        if (valueReader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(18);
        }
        return ToolingStreamApiUtils.readMap(reader, null, keyReader, valueReader);
    }

    public static <K, V> Map<K, V> readMap(@NotNull IonReader reader, @Nullable String fieldName, @NotNull Supplier<? extends K> keyReader, @NotNull Supplier<? extends V> valueReader) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(19);
        }
        if (keyReader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(20);
        }
        if (valueReader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(21);
        }
        reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, fieldName);
        reader.stepIn();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        while (reader.next() != null) {
            reader.stepIn();
            map.put(keyReader.get(), valueReader.get());
            reader.stepOut();
        }
        reader.stepOut();
        return map;
    }

    public static void writeString(@NotNull IonWriter writer, @NotNull String fieldName, @Nullable String value) throws IOException {
        if (writer == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(22);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(23);
        }
        writer.setFieldName(fieldName);
        writer.writeString(value);
    }

    public static void writeLong(@NotNull IonWriter writer, @NotNull String fieldName, long value) throws IOException {
        if (writer == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(24);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(25);
        }
        writer.setFieldName(fieldName);
        writer.writeInt(value);
    }

    public static void writeBoolean(@NotNull IonWriter writer, @NotNull String fieldName, boolean value) throws IOException {
        if (writer == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(26);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(27);
        }
        writer.setFieldName(fieldName);
        writer.writeBool(value);
    }

    public static void writeFile(@NotNull IonWriter writer, @NotNull String fieldName, @Nullable File file) throws IOException {
        if (writer == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(28);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(29);
        }
        ToolingStreamApiUtils.writeString(writer, fieldName, file == null ? null : file.getPath());
    }

    public static <K, V> void writeMap(@NotNull IonWriter writer, @NotNull String fieldName, @NotNull Map<K, V> map, @NotNull ThrowableConsumer<? super K, ? extends IOException> keyWriter, @NotNull ThrowableConsumer<? super V, ? extends IOException> valueWriter) throws IOException {
        if (writer == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(30);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(31);
        }
        if (map == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(32);
        }
        if (keyWriter == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(33);
        }
        if (valueWriter == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(34);
        }
        writer.setFieldName(fieldName);
        writer.stepIn(IonType.LIST);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            writer.stepIn(IonType.STRUCT);
            writer.setFieldName("key");
            keyWriter.consume(entry.getKey());
            writer.setFieldName("value");
            valueWriter.consume(entry.getValue());
            writer.stepOut();
        }
        writer.stepOut();
    }

    public static void writeFiles(@NotNull IonWriter writer, @NotNull String fieldName, @NotNull Collection<File> files) throws IOException {
        if (writer == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(35);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(36);
        }
        if (files == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(37);
        }
        writer.setFieldName(fieldName);
        writer.stepIn(IonType.LIST);
        for (File file : files) {
            writer.writeString(file.getPath());
        }
        writer.stepOut();
    }

    public static void writeStrings(@NotNull IonWriter writer, @NotNull String fieldName, @NotNull Collection<String> strings) throws IOException {
        if (writer == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(38);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(39);
        }
        if (strings == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(40);
        }
        writer.setFieldName(fieldName);
        writer.stepIn(IonType.LIST);
        for (String str : strings) {
            writer.writeString(str);
        }
        writer.stepOut();
    }

    public static Set<String> readStringSet(@NotNull IonReader reader) {
        String nextString;
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(41);
        }
        HashSet<String> set = new HashSet<String>();
        reader.next();
        reader.stepIn();
        while ((nextString = ToolingStreamApiUtils.readString(reader, null)) != null) {
            set.add(nextString);
        }
        reader.stepOut();
        return set;
    }

    public static List<String> readStringList(@NotNull IonReader reader) {
        String nextString;
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(42);
        }
        ArrayList<String> list = new ArrayList<String>();
        reader.next();
        reader.stepIn();
        while ((nextString = ToolingStreamApiUtils.readString(reader, null)) != null) {
            list.add(nextString);
        }
        reader.stepOut();
        return list;
    }

    public static void assertFieldName(@NotNull IonReader reader, @Nullable String fieldName) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(43);
        }
        String readerFieldName = reader.getFieldName();
        assert (fieldName == null || fieldName.equals(readerFieldName)) : "Expected field name '" + fieldName + "', got `" + readerFieldName + "' ";
    }

    @NotNull
    public static <T> T assertNotNull(@Nullable T t) {
        assert (t != null);
        T t2 = t;
        if (t2 == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(44);
        }
        return t2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/tooling/serialization/ToolingStreamApiUtils";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringCache";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyReader";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueReader";
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyWriter";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueWriter";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createIonWriter";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/serialization/ToolingStreamApiUtils";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "readFilesSet";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "assertNotNull";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readString";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readInt";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readLong";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readBoolean";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readFiles";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readFilesSet";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readFile";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "readMap";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "writeString";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "writeLong";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "writeBoolean";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "writeFile";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "writeMap";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "writeFiles";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "writeStrings";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "readStringSet";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "readStringList";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "assertFieldName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

