/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.jvm.gradle;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.qodana.staticAnalysis.projectDescription.QodanaProjectDescriber;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/qodana/jvm/gradle/GradleProjectDescriber;", "Lorg/jetbrains/qodana/staticAnalysis/projectDescription/QodanaProjectDescriber;", "()V", "id", "", "getId", "()Ljava/lang/String;", "description", "Lorg/jetbrains/qodana/jvm/gradle/GradleProjectDescriber$GradleDescription;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "GradleDescription", "LibraryDescription", "intellij.qodana.jvm.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleProjectDescriber.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleProjectDescriber.kt\norg/jetbrains/qodana/jvm/gradle/GradleProjectDescriber\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n1#2:45\n1855#3,2:46\n*S KotlinDebug\n*F\n+ 1 GradleProjectDescriber.kt\norg/jetbrains/qodana/jvm/gradle/GradleProjectDescriber\n*L\n21#1:46,2\n*E\n"})
public final class GradleProjectDescriber
implements QodanaProjectDescriber {
    @NotNull
    private final String id;

    public GradleProjectDescriber() {
        this.id = "Gradle";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public Object description(@NotNull Project project2, @NotNull Continuation<? super GradleDescription> $completion) {
        GradleProjectSettings gradleProjectSettings;
        String string = project2.getBasePath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            gradleProjectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)project2).getLinkedProjectSettings(it);
        } else {
            gradleProjectSettings = null;
        }
        GradleProjectSettings projectSettings = gradleProjectSettings;
        Collection collection = ProjectDataManager.getInstance().getExternalProjectsData(project2, GradleConstants.SYSTEM_ID);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getExternalProjectsData(...)");
        Collection externalProjects = collection;
        List libraries = new ArrayList();
        Iterable $this$forEach$iv = externalProjects;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExternalProjectInfo projectInfo = (ExternalProjectInfo)element$iv;
            boolean bl = false;
            DataNode dataNode = projectInfo.getExternalProjectStructure();
            if (dataNode == null) continue;
            dataNode.visit(arg_0 -> GradleProjectDescriber.description$lambda$2$lambda$1((Function1)new Function1<DataNode<?>, Unit>(libraries){
                final /* synthetic */ List<LibraryDescription> $libraries;
                {
                    this.$libraries = $libraries;
                    super(1);
                }

                public final void invoke(DataNode<?> it) {
                    if (Intrinsics.areEqual((Object)ProjectKeys.LIBRARY, (Object)it.getKey())) {
                        Object object = it.getData();
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.externalSystem.model.project.LibraryData");
                        LibraryData libraryData = (LibraryData)object;
                        this.$libraries.add(new LibraryDescription(libraryData));
                    }
                }
            }, arg_0));
        }
        GradleProjectSettings gradleProjectSettings2 = projectSettings;
        return new GradleDescription(gradleProjectSettings2 != null ? gradleProjectSettings2.getGradleJvm() : null, libraries);
    }

    private static final void description$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/qodana/jvm/gradle/GradleProjectDescriber$GradleDescription;", "", "gradleJvm", "", "libraries", "", "Lorg/jetbrains/qodana/jvm/gradle/GradleProjectDescriber$LibraryDescription;", "(Ljava/lang/String;Ljava/util/List;)V", "getGradleJvm", "()Ljava/lang/String;", "getLibraries", "()Ljava/util/List;", "intellij.qodana.jvm.gradle"})
    public static final class GradleDescription {
        @Nullable
        private final String gradleJvm;
        @NotNull
        private final List<LibraryDescription> libraries;

        public GradleDescription(@Nullable String gradleJvm, @NotNull List<LibraryDescription> libraries) {
            Intrinsics.checkNotNullParameter(libraries, (String)"libraries");
            this.gradleJvm = gradleJvm;
            this.libraries = libraries;
        }

        @Nullable
        public final String getGradleJvm() {
            return this.gradleJvm;
        }

        @NotNull
        public final List<LibraryDescription> getLibraries() {
            return this.libraries;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0018\u0010\u0005\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\f0\u0006\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0018\u0010\u000e\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0016\u0010\u0010\u001a\u00070\u0006\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/qodana/jvm/gradle/GradleProjectDescriber$LibraryDescription;", "", "data", "Lcom/intellij/openapi/externalSystem/model/project/LibraryData;", "(Lcom/intellij/openapi/externalSystem/model/project/LibraryData;)V", "artifactId", "", "Lorg/jetbrains/annotations/Nullable;", "getArtifactId", "()Ljava/lang/String;", "gradleName", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getGradleName", "groupId", "getGroupId", "ideaName", "getIdeaName", "unresolved", "", "getUnresolved", "()Z", "version", "getVersion", "intellij.qodana.jvm.gradle"})
    public static final class LibraryDescription {
        @NotNull
        private final String ideaName;
        @NotNull
        private final String gradleName;
        private final boolean unresolved;
        @Nullable
        private final String groupId;
        @Nullable
        private final String artifactId;
        @Nullable
        private final String version;

        public LibraryDescription(@NotNull LibraryData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String string = data.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalName(...)");
            this.ideaName = string;
            String string2 = data.getExternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExternalName(...)");
            this.gradleName = string2;
            this.unresolved = data.isUnresolved();
            this.groupId = data.getGroupId();
            this.artifactId = data.getArtifactId();
            this.version = data.getVersion();
        }

        @NotNull
        public final String getIdeaName() {
            return this.ideaName;
        }

        @NotNull
        public final String getGradleName() {
            return this.gradleName;
        }

        public final boolean getUnresolved() {
            return this.unresolved;
        }

        @Nullable
        public final String getGroupId() {
            return this.groupId;
        }

        @Nullable
        public final String getArtifactId() {
            return this.artifactId;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }
    }
}

