/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.model.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.gradle.model.impl.GradleResourceFileFilter;
import org.jetbrains.jps.gradle.model.impl.GradleResourcesTarget;
import org.jetbrains.jps.gradle.model.impl.ResourceRootConfiguration;

public class GradleResourceRootDescriptor
extends BuildRootDescriptor {
    private static final Logger LOG = Logger.getInstance(GradleResourceRootDescriptor.class);
    private final GradleResourcesTarget myTarget;
    private final ResourceRootConfiguration myConfig;
    private final File myFile;
    private final String myId;
    private final boolean myOverwrite;
    private final int myIndexInPom;

    public GradleResourceRootDescriptor(@NotNull GradleResourcesTarget target, ResourceRootConfiguration config, int indexInPom, boolean overwrite) {
        if (target == null) {
            GradleResourceRootDescriptor.$$$reportNull$$$0(0);
        }
        this.myTarget = target;
        this.myConfig = config;
        String path = FileUtil.toCanonicalPath((String)config.directory);
        this.myFile = new File(path);
        this.myId = path;
        this.myIndexInPom = indexInPom;
        this.myOverwrite = overwrite;
    }

    public ResourceRootConfiguration getConfiguration() {
        return this.myConfig;
    }

    @NotNull
    public String getRootId() {
        String string = this.myId;
        if (string == null) {
            GradleResourceRootDescriptor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public File getRootFile() {
        File file = this.myFile;
        if (file == null) {
            GradleResourceRootDescriptor.$$$reportNull$$$0(2);
        }
        return file;
    }

    @NotNull
    public GradleResourcesTarget getTarget() {
        GradleResourcesTarget gradleResourcesTarget = this.myTarget;
        if (gradleResourcesTarget == null) {
            GradleResourceRootDescriptor.$$$reportNull$$$0(3);
        }
        return gradleResourcesTarget;
    }

    @NotNull
    public FileFilter createFileFilter() {
        try {
            return new GradleResourceFileFilter(this.myFile, this.myConfig);
        }
        catch (Throwable e) {
            LOG.warn("Can not create resource file filter", e);
            FileFilter fileFilter = FileFilters.EVERYTHING;
            if (fileFilter == null) {
                GradleResourceRootDescriptor.$$$reportNull$$$0(4);
            }
            return fileFilter;
        }
    }

    public boolean canUseFileCache() {
        return true;
    }

    public int getIndexInPom() {
        return this.myIndexInPom;
    }

    public boolean isOverwrite() {
        return this.myOverwrite;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/gradle/model/impl/GradleResourceRootDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/gradle/model/impl/GradleResourceRootDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

