/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.conflict;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitRevisionNumber;
import git4idea.branch.GitRebaseParams;
import git4idea.history.GitHistoryUtils;
import git4idea.merge.GitDefaultMergeDialogCustomizer;
import git4idea.rebase.GitRebaseSpec;
import git4idea.rebase.conflict.GitRebaseMergeDialogCustomizer;
import git4idea.repo.GitRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createRebaseDialogCustomizer", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;", "repository", "Lgit4idea/repo/GitRepository;", "rebaseSpec", "Lgit4idea/rebase/GitRebaseSpec;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRebaseMergeDialogCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRebaseMergeDialogCustomizer.kt\ngit4idea/rebase/conflict/GitRebaseMergeDialogCustomizerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,141:1\n1#2:142\n10#3:143\n*S KotlinDebug\n*F\n+ 1 GitRebaseMergeDialogCustomizer.kt\ngit4idea/rebase/conflict/GitRebaseMergeDialogCustomizerKt\n*L\n24#1:143\n*E\n"})
public final class GitRebaseMergeDialogCustomizerKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final MergeDialogCustomizer createRebaseDialogCustomizer(@NotNull GitRepository repository, @NotNull GitRebaseSpec rebaseSpec) {
        Hash hash;
        String branch;
        String string;
        String upstream;
        String string2;
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)rebaseSpec, (String)"rebaseSpec");
        GitRebaseParams rebaseParams = rebaseSpec.getParams();
        if (rebaseParams == null) {
            Project project = repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return new GitDefaultMergeDialogCustomizer(project);
        }
        String currentBranchAtTheStartOfRebase = rebaseSpec.getInitialBranchNames().get(repository);
        String it = string2 = rebaseParams.getUpstream();
        boolean bl = false;
        String string3 = !Intrinsics.areEqual((Object)it, (Object)"HEAD") ? string2 : null;
        if (string3 == null) {
            string3 = upstream = currentBranchAtTheStartOfRebase;
        }
        if ((string = rebaseParams.getBranch()) == null) {
            string = branch = currentBranchAtTheStartOfRebase;
        }
        if (upstream == null || branch == null) {
            Project project = repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return new GitDefaultMergeDialogCustomizer(project);
        }
        try {
            it = HashImpl.build((String)GitRevisionNumber.resolve(repository.getProject(), repository.getRoot(), "REBASE_HEAD").asString());
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            it = null;
        }
        String rebaseHead = it;
        try {
            Hash hash2;
            GitRevisionNumber gitRevisionNumber = GitHistoryUtils.getMergeBase(repository.getProject(), repository.getRoot(), upstream, branch);
            if (gitRevisionNumber != null) {
                GitRevisionNumber it2 = gitRevisionNumber;
                boolean bl2 = false;
                hash2 = HashImpl.build((String)it2.getRev());
            } else {
                hash2 = null;
            }
            hash = hash2;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            hash = null;
        }
        Hash mergeBase = hash;
        return new GitRebaseMergeDialogCustomizer(repository, upstream, branch, (Hash)rebaseHead, mergeBase);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitRebaseMergeDialogCustomizer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

