/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.aether;

import com.intellij.openapi.application.ClassPathUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpConnection;
import org.apache.http.client.HttpClient;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.building.Problem;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import org.codehaus.plexus.interpolation.Interpolator;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.DefaultSessionData;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SessionData;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.artifact.DelegatingArtifact;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.visitor.FilteringDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.eclipse.aether.version.VersionRange;
import org.eclipse.aether.version.VersionScheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactDependencyNode;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.aether.JreProxySelector;
import org.jetbrains.idea.maven.aether.ProgressConsumer;
import org.jetbrains.idea.maven.aether.Retry;
import org.jetbrains.idea.maven.aether.RetryProvider;
import org.jetbrains.idea.maven.aether.ThrowingFunction;
import org.slf4j.Marker;
import org.slf4j.jul.JDK14LoggerFactory;

public final class ArtifactRepositoryManager {
    private static final VersionScheme ourVersioning = new GenericVersionScheme();
    private static final JreProxySelector ourProxySelector = new JreProxySelector();
    private static final Logger LOG = Logger.getInstance(ArtifactRepositoryManager.class);
    private final RepositorySystemSessionFactory mySessionFactory;
    private static final RemoteRepository MAVEN_CENTRAL_REPOSITORY = ArtifactRepositoryManager.createRemoteRepository("central", "https://repo1.maven.org/maven2/");
    private static final RemoteRepository JBOSS_COMMUNITY_REPOSITORY = ArtifactRepositoryManager.createRemoteRepository("jboss.community", "https://repository.jboss.org/nexus/content/repositories/public/");
    private static final RepositorySystem ourSystem;
    private final List<RemoteRepository> myRemoteRepositories;

    public ArtifactRepositoryManager(@NotNull File localRepositoryPath) {
        if (localRepositoryPath == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(0);
        }
        this(localRepositoryPath, ProgressConsumer.DEAF);
    }

    public ArtifactRepositoryManager(@NotNull File localRepositoryPath, @NotNull ProgressConsumer progressConsumer) {
        if (localRepositoryPath == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(1);
        }
        if (progressConsumer == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(2);
        }
        this(localRepositoryPath, ArtifactRepositoryManager.createDefaultRemoteRepositories(), progressConsumer);
    }

    public ArtifactRepositoryManager(@NotNull File localRepositoryPath, List<RemoteRepository> remoteRepositories, @NotNull ProgressConsumer progressConsumer) {
        if (localRepositoryPath == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(3);
        }
        if (progressConsumer == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(4);
        }
        this(localRepositoryPath, remoteRepositories, progressConsumer, false);
    }

    public ArtifactRepositoryManager(@NotNull File localRepositoryPath, List<RemoteRepository> remoteRepositories, @NotNull ProgressConsumer progressConsumer, boolean offline) {
        if (localRepositoryPath == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(5);
        }
        if (progressConsumer == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(6);
        }
        this(localRepositoryPath, remoteRepositories, progressConsumer, offline, RetryProvider.disabled());
    }

    public ArtifactRepositoryManager(@NotNull File localRepositoryPath, List<RemoteRepository> remoteRepositories, @NotNull ProgressConsumer progressConsumer, @NotNull Retry retry) {
        if (localRepositoryPath == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(7);
        }
        if (progressConsumer == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(8);
        }
        if (retry == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(9);
        }
        this(localRepositoryPath, remoteRepositories, progressConsumer, false, retry);
    }

    public ArtifactRepositoryManager(@NotNull File localRepositoryPath, List<RemoteRepository> remoteRepositories, @NotNull ProgressConsumer progressConsumer, boolean offline, @NotNull Retry retry) {
        if (localRepositoryPath == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(10);
        }
        if (progressConsumer == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(11);
        }
        if (retry == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(12);
        }
        this.myRemoteRepositories = new ArrayList<RemoteRepository>();
        this.myRemoteRepositories.addAll(remoteRepositories);
        this.mySessionFactory = new RepositorySystemSessionFactory(localRepositoryPath, progressConsumer, offline, retry);
    }

    public static Class<?>[] getClassesFromDependencies() {
        ArrayList<Class> result = new ArrayList<Class>(List.of(ArtifactRepositoryManager.class, VersionsMetadataGeneratorFactory.class, Artifact.class, StringUtils.class, org.codehaus.plexus.util.Base64.class, Problem.class, Model.class, ModelBuilder.class, Metadata.class, Interpolator.class, RepositorySystem.class, BasicRepositoryConnectorFactory.class, RepositoryConnector.class, ConfigUtils.class, ArtifactResolver.class, FileTransporterFactory.class, HttpTransporterFactory.class, HttpConnection.class, HttpClient.class, LogFactory.class, Marker.class, JDK14LoggerFactory.class, Base64.class));
        result.addAll(List.of(ClassPathUtil.getUtilClasses()));
        return result.toArray(ArrayUtil.EMPTY_CLASS_ARRAY);
    }

    @NotNull
    public Collection<File> resolveDependency(String groupId, String artifactId, String version, boolean includeTransitiveDependencies, List<String> excludedDependencies) throws Exception {
        Collection<org.eclipse.aether.artifact.Artifact> artifacts = this.resolveDependencyAsArtifact(groupId, artifactId, version, EnumSet.of(ArtifactKind.ARTIFACT), includeTransitiveDependencies, excludedDependencies);
        if (artifacts.isEmpty()) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                ArtifactRepositoryManager.$$$reportNull$$$0(13);
            }
            return list;
        }
        ArrayList<File> files = new ArrayList<File>(artifacts.size());
        for (org.eclipse.aether.artifact.Artifact artifact : artifacts) {
            files.add(artifact.getFile());
        }
        ArrayList<File> arrayList = files;
        if (arrayList == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Nullable
    public ArtifactDependencyNode collectDependencies(String groupId, String artifactId, String versionConstraint) throws Exception {
        Set<VersionConstraint> constraints = Collections.singleton(ArtifactRepositoryManager.asVersionConstraint(versionConstraint));
        CollectRequest collectRequest = this.createCollectRequest(groupId, artifactId, constraints, EnumSet.of(ArtifactKind.ARTIFACT));
        ArtifactDependencyTreeBuilder builder = new ArtifactDependencyTreeBuilder();
        DependencyNode root = this.mySessionFactory.retryWithClearSessionData(this.mySessionFactory.createVerboseSession(), s -> ourSystem.collectDependencies(s, collectRequest)).getResult().getRoot();
        if (root.getArtifact() == null && root.getChildren().size() == 1) {
            root = (DependencyNode)root.getChildren().get(0);
        }
        root.accept((DependencyVisitor)new TreeDependencyVisitor((DependencyVisitor)new FilteringDependencyVisitor((DependencyVisitor)builder, ArtifactRepositoryManager.createScopeFilter())));
        return builder.getRoot();
    }

    @NotNull
    public Collection<org.eclipse.aether.artifact.Artifact> resolveDependencyAsArtifact(String groupId, String artifactId, String versionConstraint, Set<ArtifactKind> artifactKinds, boolean includeTransitiveDependencies, List<String> excludedDependencies) throws Exception {
        ArrayList<org.eclipse.aether.artifact.Artifact> artifacts = new ArrayList<org.eclipse.aether.artifact.Artifact>();
        VersionConstraint originalConstraints = ArtifactRepositoryManager.asVersionConstraint(versionConstraint);
        for (ArtifactKind kind : artifactKinds) {
            try {
                ArrayList<ArtifactRequest> requests = new ArrayList<ArtifactRequest>();
                Set<VersionConstraint> constraints = kind == ArtifactKind.ANNOTATIONS ? ArtifactRepositoryManager.relaxForAnnotations(originalConstraints) : Collections.singleton(originalConstraints);
                RepositorySystemSession session = this.prepareRequests(groupId, artifactId, constraints, kind, includeTransitiveDependencies, excludedDependencies, requests);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resolving " + groupId + ":" + artifactId + ":" + versionConstraint + " transitiveDependencies=" + includeTransitiveDependencies + " excludedDependencies=" + excludedDependencies + " kind=" + kind + " requests=" + requests);
                }
                if (requests.isEmpty()) continue;
                try {
                    List resultList = this.mySessionFactory.retryWithClearSessionData(session, s -> ourSystem.resolveArtifacts(s, (Collection)requests)).getResult();
                    for (ArtifactResult result : resultList) {
                        artifacts.add(result.getArtifact());
                    }
                }
                catch (ArtifactResolutionException e) {
                    if (kind != ArtifactKind.ARTIFACT) {
                        if (requests.size() <= 1) continue;
                        for (ArtifactRequest request : requests) {
                            try {
                                ArtifactResult result = ourSystem.resolveArtifact(session, request);
                                artifacts.add(result.getArtifact());
                            }
                            catch (ArtifactResolutionException artifactResolutionException) {}
                        }
                        continue;
                    }
                    throw e;
                }
            }
            catch (DependencyCollectionException e) {
                if (kind != ArtifactKind.ARTIFACT) continue;
                throw e;
            }
        }
        ArrayList<org.eclipse.aether.artifact.Artifact> arrayList = artifacts;
        if (arrayList == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    private RepositorySystemSession prepareRequests(String groupId, String artifactId, Set<VersionConstraint> constraints, ArtifactKind kind, boolean includeTransitiveDependencies, List<String> excludedDependencies, List<ArtifactRequest> requests) throws Exception {
        RepositorySystemSession session;
        if (includeTransitiveDependencies) {
            CollectRequest collectRequest = this.createCollectRequest(groupId, artifactId, constraints, EnumSet.of(kind));
            RepositorySystemSessionFactory.RetryWithClearSessionDataResult<CollectResult> resultAndSession = this.mySessionFactory.retryWithClearSessionData(this.mySessionFactory.createSession(excludedDependencies), s -> ourSystem.collectDependencies(s, collectRequest));
            session = resultAndSession.getSession();
            CollectResult collectResult = resultAndSession.getResult();
            ArtifactRequestBuilder builder = new ArtifactRequestBuilder(kind);
            DependencyFilter filter = ArtifactRepositoryManager.createScopeFilter();
            if (!excludedDependencies.isEmpty()) {
                filter = DependencyFilterUtils.andFilter((DependencyFilter[])new DependencyFilter[]{filter, new ExcludeDependenciesFilter(excludedDependencies)});
            }
            collectResult.getRoot().accept((DependencyVisitor)new TreeDependencyVisitor((DependencyVisitor)new FilteringDependencyVisitor((DependencyVisitor)builder, filter)));
            requests.addAll(builder.getRequests());
        } else {
            session = this.mySessionFactory.createDefaultSession();
            for (org.eclipse.aether.artifact.Artifact artifact : ArtifactRepositoryManager.toArtifacts(groupId, artifactId, constraints, Collections.singleton(kind))) {
                if (ourVersioning.parseVersionConstraint(artifact.getVersion()).getRange() != null) {
                    VersionRangeRequest versionRangeRequest = new VersionRangeRequest(artifact, Collections.unmodifiableList(this.myRemoteRepositories), null);
                    VersionRangeResult result = ourSystem.resolveVersionRange(session, versionRangeRequest);
                    if (result.getVersions().isEmpty()) continue;
                    org.eclipse.aether.artifact.Artifact newArtifact = artifact.setVersion(result.getHighestVersion().toString());
                    requests.add(new ArtifactRequest(newArtifact, Collections.unmodifiableList(this.myRemoteRepositories), null));
                    continue;
                }
                requests.add(new ArtifactRequest(artifact, Collections.unmodifiableList(this.myRemoteRepositories), null));
            }
        }
        RepositorySystemSession repositorySystemSession = session;
        if (repositorySystemSession == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(16);
        }
        return repositorySystemSession;
    }

    @NotNull
    public Collection<org.eclipse.aether.artifact.Artifact> resolveDependencyAsArtifactStrict(String groupId, String artifactId, String versionConstraint, ArtifactKind kind, boolean includeTransitiveDependencies, List<String> excludedDependencies) throws Exception {
        ArrayList<org.eclipse.aether.artifact.Artifact> artifacts = new ArrayList<org.eclipse.aether.artifact.Artifact>();
        ArrayList<ArtifactRequest> requests = new ArrayList<ArtifactRequest>();
        Set<VersionConstraint> constraints = Collections.singleton(ArtifactRepositoryManager.asVersionConstraint(versionConstraint));
        RepositorySystemSession session = this.prepareRequests(groupId, artifactId, constraints, kind, includeTransitiveDependencies, excludedDependencies, requests);
        if (!requests.isEmpty()) {
            List resultList = this.mySessionFactory.retryWithClearSessionData(session, s -> ourSystem.resolveArtifacts(s, (Collection)requests)).getResult();
            for (ArtifactResult result : resultList) {
                artifacts.add(result.getArtifact());
            }
        }
        ArrayList<org.eclipse.aether.artifact.Artifact> arrayList = artifacts;
        if (arrayList == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    private static Set<VersionConstraint> relaxForAnnotations(VersionConstraint constraint) {
        VersionRange range;
        Object annotationsConstraint = constraint.toString();
        Version version = constraint.getVersion();
        if (version != null) {
            String lower = ArtifactRepositoryManager.chooseLowerBoundString(version);
            annotationsConstraint = "[" + lower + ", " + version + "-an10000]";
        }
        if ((range = constraint.getRange()) != null) {
            Version lowerBoundVersion = range.getLowerBound().getVersion();
            String lower = ArtifactRepositoryManager.chooseLowerBoundString(lowerBoundVersion);
            String upper = range.getUpperBound().isInclusive() ? range.getUpperBound().toString() + "-an10000]" : range.getUpperBound().toString() + ")";
            annotationsConstraint = "[" + lower + ", " + upper;
        }
        try {
            return Collections.singleton(ourVersioning.parseVersionConstraint((String)annotationsConstraint));
        }
        catch (InvalidVersionSpecificationException e) {
            LOG.info("Failed to parse version constraint " + (String)annotationsConstraint, (Throwable)e);
            return Collections.singleton(constraint);
        }
    }

    private static String chooseLowerBoundString(Version lowerBoundVersion) {
        String lowerBoundString = lowerBoundVersion.toString();
        String candidate = lowerBoundString.split("[.\\-_]")[0];
        try {
            Version candidateVersion = ourVersioning.parseVersion(candidate);
            if (lowerBoundVersion.compareTo((Object)candidateVersion) < 0) {
                return lowerBoundString;
            }
        }
        catch (InvalidVersionSpecificationException e) {
            LOG.info("Failed to parse major part of lower bound of version " + lowerBoundVersion, (Throwable)e);
        }
        return candidate;
    }

    @NotNull
    private static DependencyFilter createScopeFilter() {
        DependencyFilter dependencyFilter = DependencyFilterUtils.classpathFilter((String[])new String[]{"compile", "runtime"});
        if (dependencyFilter == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(18);
        }
        return dependencyFilter;
    }

    @NotNull
    public List<Version> getAvailableVersions(String groupId, String artifactId, String versionConstraint, ArtifactKind artifactKind) throws Exception {
        VersionRangeResult result = ourSystem.resolveVersionRange(this.mySessionFactory.createDefaultSession(), this.createVersionRangeRequest(groupId, artifactId, ArtifactRepositoryManager.asVersionConstraint(versionConstraint), artifactKind));
        List list = result.getVersions();
        if (list == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(19);
        }
        return list;
    }

    public static RemoteRepository createRemoteRepository(String id, String url) {
        return ArtifactRepositoryManager.createRemoteRepository(id, url, null, true);
    }

    public static RemoteRepository createRemoteRepository(String id, String url, boolean allowSnapshots) {
        return ArtifactRepositoryManager.createRemoteRepository(id, url, null, allowSnapshots);
    }

    public static RemoteRepository createRemoteRepository(String id, String url, ArtifactAuthenticationData authenticationData) {
        return ArtifactRepositoryManager.createRemoteRepository(id, url, authenticationData, true);
    }

    public static RemoteRepository createRemoteRepository(String id, String url, ArtifactAuthenticationData authenticationData, boolean allowSnapshots) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(id, "default", url);
        if (!allowSnapshots) {
            builder.setSnapshotPolicy(new RepositoryPolicy(false, null, null));
        }
        if (authenticationData != null) {
            AuthenticationBuilder authenticationBuilder = new AuthenticationBuilder();
            authenticationBuilder.addUsername(authenticationData.getUsername());
            authenticationBuilder.addPassword(authenticationData.getPassword());
            builder.setAuthentication(authenticationBuilder.build());
        }
        return builder.setProxy(ourProxySelector.getProxy(url)).build();
    }

    private static RemoteRepository createRemoteRepository(RemoteRepository prototype) {
        String url = prototype.getUrl();
        return new RemoteRepository.Builder(prototype.getId(), prototype.getContentType(), url).setProxy(ourProxySelector.getProxy(url)).build();
    }

    @NotNull
    public static List<RemoteRepository> createDefaultRemoteRepositories() {
        List<RemoteRepository> list = Arrays.asList(ArtifactRepositoryManager.createRemoteRepository(MAVEN_CENTRAL_REPOSITORY), ArtifactRepositoryManager.createRemoteRepository(JBOSS_COMMUNITY_REPOSITORY));
        if (list == null) {
            ArtifactRepositoryManager.$$$reportNull$$$0(20);
        }
        return list;
    }

    private CollectRequest createCollectRequest(String groupId, String artifactId, Collection<VersionConstraint> versions, Set<ArtifactKind> kinds) {
        CollectRequest request = new CollectRequest();
        for (org.eclipse.aether.artifact.Artifact artifact : ArtifactRepositoryManager.toArtifacts(groupId, artifactId, versions, kinds)) {
            request.addDependency(new Dependency(artifact, "compile"));
        }
        return request.setRepositories(Collections.unmodifiableList(this.myRemoteRepositories));
    }

    private VersionRangeRequest createVersionRangeRequest(String groupId, String artifactId, VersionConstraint versioning, ArtifactKind artifactKind) {
        VersionRangeRequest request = new VersionRangeRequest();
        for (org.eclipse.aether.artifact.Artifact artifact : ArtifactRepositoryManager.toArtifacts(groupId, artifactId, Collections.singleton(versioning), EnumSet.of(artifactKind))) {
            request.setArtifact(artifact);
        }
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>(this.myRemoteRepositories.size());
        for (RemoteRepository repository : this.myRemoteRepositories) {
            RepositoryPolicy policy = new RepositoryPolicy(true, "always", "warn");
            repositories.add(new RemoteRepository.Builder(repository).setPolicy(policy).build());
        }
        return request.setRepositories(repositories);
    }

    public static Version asVersion(@Nullable String str) throws InvalidVersionSpecificationException {
        return ourVersioning.parseVersion(str == null ? "" : str);
    }

    private static VersionConstraint asVersionConstraint(@Nullable String str) throws InvalidVersionSpecificationException {
        return ourVersioning.parseVersionConstraint(str == null ? "" : str);
    }

    private static List<org.eclipse.aether.artifact.Artifact> toArtifacts(String groupId, String artifactId, Collection<VersionConstraint> constraints, Set<ArtifactKind> kinds) {
        if (constraints.isEmpty() || kinds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<org.eclipse.aether.artifact.Artifact> result = new ArrayList<org.eclipse.aether.artifact.Artifact>(kinds.size() * constraints.size());
        for (ArtifactKind kind : kinds) {
            for (VersionConstraint constraint : constraints) {
                result.add((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(groupId, artifactId, kind.getClassifier(), kind.getExtension(), constraint.toString()));
            }
        }
        return result;
    }

    static {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                if (exception != null) {
                    throw new RuntimeException(exception);
                }
            }
        });
        ourSystem = (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRepositoryPath";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressConsumer";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "retry";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/aether/ArtifactRepositoryManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/aether/ArtifactRepositoryManager";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDependency";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDependencyAsArtifact";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRequests";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDependencyAsArtifactStrict";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeFilter";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableVersions";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultRemoteRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RepositorySystemSessionFactory {
        private final RepositorySystemSession sessionTemplate;
        private final Retry myRetry;

        private RepositorySystemSessionFactory(@NotNull File localRepositoryPath, final @NotNull ProgressConsumer progressConsumer, boolean offline, Retry retry) {
            if (localRepositoryPath == null) {
                RepositorySystemSessionFactory.$$$reportNull$$$0(0);
            }
            if (progressConsumer == null) {
                RepositorySystemSessionFactory.$$$reportNull$$$0(1);
            }
            DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
            if (progressConsumer != ProgressConsumer.DEAF) {
                session.setTransferListener(new TransferListener(){

                    public void transferInitiated(TransferEvent event) throws TransferCancelledException {
                        this.handle(event);
                    }

                    public void transferStarted(TransferEvent event) throws TransferCancelledException {
                        this.handle(event);
                    }

                    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
                        this.handle(event);
                    }

                    public void transferCorrupted(TransferEvent event) {
                    }

                    public void transferSucceeded(TransferEvent event) {
                    }

                    public void transferFailed(TransferEvent event) {
                    }

                    private void handle(TransferEvent event) throws TransferCancelledException {
                        if (progressConsumer.isCanceled()) {
                            throw new TransferCancelledException();
                        }
                        progressConsumer.consume(event.toString());
                    }
                });
            }
            session.setLocalRepositoryManager(ourSystem.newLocalRepositoryManager((RepositorySystemSession)session, new LocalRepository(localRepositoryPath)));
            session.setProxySelector((ProxySelector)ourProxySelector);
            session.setOffline(offline);
            int artifactCachePolicy = 1;
            int metadataCachePolicy = 1;
            session.setResolutionErrorPolicy((ResolutionErrorPolicy)new SimpleResolutionErrorPolicy(artifactCachePolicy, metadataCachePolicy));
            session.setCache((RepositoryCache)new DefaultRepositoryCache());
            session.setReadOnly();
            this.sessionTemplate = session;
            this.myRetry = retry;
        }

        private RepositorySystemSession createDefaultSession() {
            return new DefaultRepositorySystemSession(this.sessionTemplate);
        }

        private RepositorySystemSession createVerboseSession() {
            DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(this.sessionTemplate);
            session.setConfigProperty("aether.conflictResolver.verbose", (Object)Boolean.TRUE);
            session.setReadOnly();
            return session;
        }

        private RepositorySystemSession createSession(@NotNull List<String> excludedDependencies) {
            if (excludedDependencies == null) {
                RepositorySystemSessionFactory.$$$reportNull$$$0(2);
            }
            DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(this.sessionTemplate);
            if (excludedDependencies.isEmpty()) {
                return session;
            }
            session.setDependencySelector((DependencySelector)new AndDependencySelector(new DependencySelector[]{session.getDependencySelector(), new ExclusionDependencySelector(RepositorySystemSessionFactory.exclusions(excludedDependencies))}));
            session.setReadOnly();
            return session;
        }

        private static List<Exclusion> exclusions(List<String> excludedDependencies) {
            return excludedDependencies.stream().map(exclusion -> {
                String[] split = exclusion.split(":", 2);
                if (split.length != 2) {
                    throw new RuntimeException("Malformed exclusion, 'groupId:artifactName' format is expected but got " + exclusion);
                }
                String groupId = split[0];
                String artifactName = split[1];
                return new Exclusion(groupId, artifactName, "*", "*");
            }).collect(Collectors.toList());
        }

        private <R> RetryWithClearSessionDataResult<R> retryWithClearSessionData(@NotNull RepositorySystemSession sessionTemplate, @NotNull ThrowingFunction<RepositorySystemSession, ? extends R> func) throws Exception {
            if (sessionTemplate == null) {
                RepositorySystemSessionFactory.$$$reportNull$$$0(3);
            }
            if (func == null) {
                RepositorySystemSessionFactory.$$$reportNull$$$0(4);
            }
            return this.myRetry.retry(() -> {
                RepositorySystemSession newSession = RepositorySystemSessionFactory.cloneSessionAndClearData(sessionTemplate);
                Object result = func.get(newSession);
                return new RetryWithClearSessionDataResult(newSession, result);
            }, LOG);
        }

        private static RepositorySystemSession cloneSessionAndClearData(RepositorySystemSession session) {
            DefaultRepositorySystemSession newSession = new DefaultRepositorySystemSession(session);
            newSession.setData((SessionData)new DefaultSessionData());
            return newSession;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localRepositoryPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressConsumer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "excludedDependencies";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sessionTemplate";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "func";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/aether/ArtifactRepositoryManager$RepositorySystemSessionFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createSession";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "retryWithClearSessionData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class RetryWithClearSessionDataResult<R> {
            private final RepositorySystemSession session;
            private final R result;

            RetryWithClearSessionDataResult(RepositorySystemSession session, R result) {
                this.session = session;
                this.result = result;
            }

            private RepositorySystemSession getSession() {
                return this.session;
            }

            private R getResult() {
                return this.result;
            }
        }
    }

    private static final class ArtifactDependencyTreeBuilder
    implements DependencyVisitor {
        private final List<List<ArtifactDependencyNode>> myCurrentChildren = new ArrayList<List<ArtifactDependencyNode>>();

        private ArtifactDependencyTreeBuilder() {
            this.myCurrentChildren.add(new ArrayList());
        }

        public boolean visitEnter(DependencyNode node) {
            org.eclipse.aether.artifact.Artifact artifact = node.getArtifact();
            if (artifact == null) {
                return false;
            }
            this.myCurrentChildren.add(new ArrayList());
            return true;
        }

        public boolean visitLeave(DependencyNode node) {
            org.eclipse.aether.artifact.Artifact artifact = node.getArtifact();
            if (artifact != null) {
                List<ArtifactDependencyNode> last = this.myCurrentChildren.get(this.myCurrentChildren.size() - 1);
                this.myCurrentChildren.remove(this.myCurrentChildren.size() - 1);
                boolean rejected = node.getData().get("conflict.winner") != null;
                this.myCurrentChildren.get(this.myCurrentChildren.size() - 1).add(new ArtifactDependencyNode(artifact, last, rejected));
            }
            return true;
        }

        public ArtifactDependencyNode getRoot() {
            List<ArtifactDependencyNode> rootNodes = this.myCurrentChildren.get(0);
            return rootNodes.isEmpty() ? null : rootNodes.get(0);
        }
    }

    private static final class ArtifactRequestBuilder
    implements DependencyVisitor {
        private final ArtifactKind myKind;
        private final List<ArtifactRequest> myRequests = new ArrayList<ArtifactRequest>();

        private ArtifactRequestBuilder(ArtifactKind kind) {
            this.myKind = kind;
        }

        public boolean visitEnter(DependencyNode node) {
            Dependency dep = node.getDependency();
            if (dep != null) {
                org.eclipse.aether.artifact.Artifact artifact = dep.getArtifact();
                String classifier = this.myKind.getClassifier();
                if (classifier.isEmpty()) {
                    this.myRequests.add(new ArtifactRequest(node));
                } else {
                    this.myRequests.add(new ArtifactRequest((org.eclipse.aether.artifact.Artifact)new ArtifactWithChangedClassifier(artifact, classifier), node.getRepositories(), node.getRequestContext()));
                }
            }
            return true;
        }

        public boolean visitLeave(DependencyNode node) {
            return true;
        }

        @NotNull
        public List<ArtifactRequest> getRequests() {
            List<ArtifactRequest> list = this.myRequests;
            if (list == null) {
                ArtifactRequestBuilder.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/aether/ArtifactRepositoryManager$ArtifactRequestBuilder", "getRequests"));
        }
    }

    private static final class ExcludeDependenciesFilter
    implements DependencyFilter {
        private final HashSet<String> myExcludedDependencies;

        private ExcludeDependenciesFilter(List<String> excludedDependencies) {
            this.myExcludedDependencies = new HashSet<String>(excludedDependencies);
        }

        public boolean accept(DependencyNode node, List<DependencyNode> parents) {
            org.eclipse.aether.artifact.Artifact artifact = node.getArtifact();
            if (artifact != null && this.myExcludedDependencies.contains(artifact.getGroupId() + ":" + artifact.getArtifactId())) {
                return false;
            }
            for (DependencyNode parent : parents) {
                org.eclipse.aether.artifact.Artifact parentArtifact = parent.getArtifact();
                if (parentArtifact == null || !this.myExcludedDependencies.contains(parentArtifact.getGroupId() + ":" + parentArtifact.getArtifactId())) continue;
                return false;
            }
            return true;
        }
    }

    public static class ArtifactAuthenticationData {
        private final String username;
        private final String password;

        public ArtifactAuthenticationData(String username, String password) {
            this.username = username;
            this.password = password;
        }

        private String getUsername() {
            return this.username;
        }

        private String getPassword() {
            return this.password;
        }
    }

    private static class ArtifactWithChangedClassifier
    extends DelegatingArtifact {
        private final String myClassifier;

        ArtifactWithChangedClassifier(org.eclipse.aether.artifact.Artifact artifact, String classifier) {
            super(artifact);
            this.myClassifier = classifier;
        }

        protected DelegatingArtifact newInstance(org.eclipse.aether.artifact.Artifact artifact) {
            return new ArtifactWithChangedClassifier(artifact, this.myClassifier);
        }

        public String getClassifier() {
            return this.myClassifier;
        }
    }
}

