/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.CachingResourceHasher;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.cache.IndexedCache;
import org.gradle.internal.fingerprint.hashing.FileSystemLocationSnapshotHasher;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContextHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.io.IoSupplier;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;

public class DefaultResourceSnapshotterCacheService
implements ResourceSnapshotterCacheService {
    private static final HashCode NO_HASH = Hashing.signature(CachingResourceHasher.class.getName() + " : no hash");
    private final IndexedCache<HashCode, HashCode> indexedCache;

    public DefaultResourceSnapshotterCacheService(IndexedCache<HashCode, HashCode> indexedCache) {
        this.indexedCache = indexedCache;
    }

    @Override
    @Nullable
    public HashCode hashFile(FileSystemLocationSnapshot snapshot, FileSystemLocationSnapshotHasher hasher, HashCode configurationHash) throws IOException {
        return this.hashFile(snapshot, () -> hasher.hash(snapshot), configurationHash);
    }

    @Override
    @Nullable
    public HashCode hashFile(RegularFileSnapshotContext fileSnapshotContext, RegularFileSnapshotContextHasher hasher, HashCode configurationHash) throws IOException {
        return this.hashFile((FileSystemLocationSnapshot)fileSnapshotContext.getSnapshot(), () -> hasher.hash(fileSnapshotContext), configurationHash);
    }

    @Nullable
    private HashCode hashFile(FileSystemLocationSnapshot snapshot, IoSupplier<HashCode> hashCodeSupplier, HashCode configurationHash) throws IOException {
        HashCode resourceHashCacheKey = DefaultResourceSnapshotterCacheService.resourceHashCacheKey(snapshot.getHash(), configurationHash);
        HashCode resourceHash = this.indexedCache.getIfPresent(resourceHashCacheKey);
        if (resourceHash != null) {
            if (resourceHash.equals(NO_HASH)) {
                return null;
            }
            return resourceHash;
        }
        resourceHash = hashCodeSupplier.get();
        if (resourceHash != null) {
            this.indexedCache.put(resourceHashCacheKey, resourceHash);
        } else {
            this.indexedCache.put(resourceHashCacheKey, NO_HASH);
        }
        return resourceHash;
    }

    private static HashCode resourceHashCacheKey(HashCode contentHash, HashCode configurationHash) {
        Hasher hasher = Hashing.newHasher();
        hasher.putHash(configurationHash);
        hasher.putHash(contentHash);
        return hasher.hash();
    }
}

