/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.packaging.impl;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginReader;
import org.gradle.caching.internal.origin.OriginWriter;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.caching.internal.packaging.impl.FilePermissionAccess;
import org.gradle.caching.internal.packaging.impl.RelativePathParser;
import org.gradle.caching.internal.packaging.impl.TarPackerFileSystemSupport;
import org.gradle.internal.RelativePathSupplier;
import org.gradle.internal.file.BufferProvider;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.file.impl.DefaultFileMetadata;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Interner;
import org.gradle.internal.impldep.com.google.common.io.CountingOutputStream;
import org.gradle.internal.impldep.org.apache.commons.compress.archivers.ArchiveEntry;
import org.gradle.internal.impldep.org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.gradle.internal.impldep.org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.gradle.internal.impldep.org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.gradle.internal.impldep.org.apache.commons.io.FileUtils;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.internal.impldep.org.apache.commons.io.input.CloseShieldInputStream;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.DirectorySnapshotBuilder;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.RelativePathTrackingFileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;
import org.gradle.util.internal.PathTraversalChecker;

public class TarBuildCacheEntryPacker
implements BuildCacheEntryPacker {
    private static final Charset ENCODING = StandardCharsets.UTF_8;
    private static final String METADATA_PATH = "METADATA";
    private static final Pattern TREE_PATH = Pattern.compile("(missing-)?tree-([^/]+)(?:/(.*))?");
    private final TarPackerFileSystemSupport fileSystemSupport;
    private final FilePermissionAccess filePermissionAccess;
    private final StreamHasher streamHasher;
    private final Interner<String> stringInterner;
    private final BufferProvider bufferProvider;

    public TarBuildCacheEntryPacker(TarPackerFileSystemSupport fileSystemSupport, FilePermissionAccess filePermissionAccess, StreamHasher streamHasher, Interner<String> stringInterner, BufferProvider bufferProvider) {
        this.fileSystemSupport = fileSystemSupport;
        this.filePermissionAccess = filePermissionAccess;
        this.streamHasher = streamHasher;
        this.stringInterner = stringInterner;
        this.bufferProvider = bufferProvider;
    }

    @Override
    public BuildCacheEntryPacker.PackResult pack(CacheableEntity entity, Map<String, ? extends FileSystemSnapshot> snapshots, OutputStream output, OriginWriter writeOrigin) throws IOException {
        BufferedOutputStream bufferedOutput = output instanceof BufferedOutputStream ? (BufferedOutputStream)output : new BufferedOutputStream(output);
        try (TarArchiveOutputStream tarOutput = new TarArchiveOutputStream((OutputStream)bufferedOutput, ENCODING.name());){
            tarOutput.setLongFileMode(3);
            tarOutput.setBigNumberMode(2);
            tarOutput.setAddPaxHeadersForNonAsciiNames(true);
            TarBuildCacheEntryPacker.packMetadata(writeOrigin, tarOutput);
            long entryCount = this.pack(entity, snapshots, tarOutput);
            BuildCacheEntryPacker.PackResult packResult = new BuildCacheEntryPacker.PackResult(entryCount + 1L);
            return packResult;
        }
    }

    private static void packMetadata(OriginWriter writeMetadata, TarArchiveOutputStream tarOutput) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        writeMetadata.execute(output);
        TarBuildCacheEntryPacker.createTarEntry(METADATA_PATH, output.size(), 33188, tarOutput);
        tarOutput.write(output.toByteArray());
        tarOutput.closeArchiveEntry();
    }

    private long pack(CacheableEntity entity, Map<String, ? extends FileSystemSnapshot> snapshots, TarArchiveOutputStream tarOutput) {
        AtomicLong entries = new AtomicLong();
        entity.visitOutputTrees((treeName, type, root) -> {
            FileSystemSnapshot treeSnapshots = (FileSystemSnapshot)snapshots.get(treeName);
            try {
                long entryCount = this.packTree(treeName, type, treeSnapshots, tarOutput);
                entries.addAndGet(entryCount);
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Could not pack tree '%s': %s", treeName, ex.getMessage()), ex);
            }
        });
        return entries.get();
    }

    private long packTree(String name, TreeType type, FileSystemSnapshot snapshots, TarArchiveOutputStream tarOutput) {
        PackingVisitor packingVisitor = new PackingVisitor(tarOutput, name, type);
        snapshots.accept(new RelativePathTracker(), packingVisitor);
        return packingVisitor.getPackedEntryCount();
    }

    private static void createTarEntry(String path, long size, int mode, TarArchiveOutputStream tarOutput) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(path, true);
        entry.setSize(size);
        entry.setMode(mode);
        tarOutput.putArchiveEntry((ArchiveEntry)entry);
    }

    @Override
    public BuildCacheEntryPacker.UnpackResult unpack(CacheableEntity entity, InputStream input, OriginReader readOrigin) throws IOException {
        try (TarArchiveInputStream tarInput = new TarArchiveInputStream(input, ENCODING.name());){
            BuildCacheEntryPacker.UnpackResult unpackResult = this.unpack(entity, tarInput, readOrigin);
            return unpackResult;
        }
    }

    private BuildCacheEntryPacker.UnpackResult unpack(CacheableEntity entity, TarArchiveInputStream tarInput, OriginReader readOriginAction) throws IOException {
        ImmutableMap.Builder treesBuilder = ImmutableMap.builder();
        entity.visitOutputTrees((name, type, root) -> treesBuilder.put((Object)name, (Object)new CacheableTree(type, root)));
        ImmutableMap treesByName = treesBuilder.build();
        OriginMetadata originMetadata = null;
        HashMap<String, FileSystemLocationSnapshot> snapshots = new HashMap<String, FileSystemLocationSnapshot>();
        TarArchiveEntry tarEntry = tarInput.getNextTarEntry();
        AtomicLong entries = new AtomicLong();
        while (tarEntry != null) {
            entries.incrementAndGet();
            String path = TarBuildCacheEntryPacker.safeEntryName(tarEntry);
            if (path.equals(METADATA_PATH)) {
                originMetadata = readOriginAction.execute((InputStream)CloseShieldInputStream.wrap((InputStream)tarInput));
                tarEntry = tarInput.getNextTarEntry();
                continue;
            }
            Matcher matcher = TREE_PATH.matcher(path);
            if (!matcher.matches()) {
                throw new IllegalStateException("Cached entry format error, invalid contents: " + path);
            }
            String treeName = TarBuildCacheEntryPacker.unescape(matcher.group(2));
            CacheableTree tree = (CacheableTree)treesByName.get((Object)treeName);
            if (tree == null) {
                throw new IllegalStateException(String.format("No tree '%s' registered", treeName));
            }
            boolean missing = matcher.group(1) != null;
            String childPath = matcher.group(3);
            tarEntry = this.unpackTree(treeName, tree.getType(), tree.getRoot(), tarInput, tarEntry, childPath, missing, snapshots, entries);
        }
        if (originMetadata == null) {
            throw new IllegalStateException("Cached result format error, no origin metadata was found.");
        }
        return new BuildCacheEntryPacker.UnpackResult(originMetadata, entries.get(), snapshots);
    }

    @Nullable
    private TarArchiveEntry unpackTree(String treeName, TreeType treeType, File treeRoot, TarArchiveInputStream input, TarArchiveEntry rootEntry, String childPath, boolean missing, Map<String, FileSystemLocationSnapshot> snapshots, AtomicLong entries) throws IOException {
        boolean isDirEntry = rootEntry.isDirectory();
        boolean root = Strings.isNullOrEmpty((String)childPath);
        if (!root) {
            throw new IllegalStateException("Root needs to be the first entry in a tree");
        }
        if (missing) {
            this.fileSystemSupport.ensureFileIsMissing(treeRoot);
            return input.getNextTarEntry();
        }
        this.fileSystemSupport.ensureDirectoryForTree(treeType, treeRoot);
        if (treeType == TreeType.FILE) {
            if (isDirEntry) {
                throw new IllegalStateException("Should be a file: " + treeName);
            }
            RegularFileSnapshot fileSnapshot = this.unpackFile(input, rootEntry, treeRoot, treeRoot.getName());
            snapshots.put(treeName, fileSnapshot);
            return input.getNextTarEntry();
        }
        if (!isDirEntry) {
            throw new IllegalStateException("Should be a directory: " + treeName);
        }
        this.chmodUnpackedFile(rootEntry, treeRoot);
        return this.unpackDirectoryTree(input, rootEntry, snapshots, entries, treeRoot, treeName);
    }

    private RegularFileSnapshot unpackFile(TarArchiveInputStream input, TarArchiveEntry entry, File file, String fileName) throws IOException {
        try (CountingOutputStream output = new CountingOutputStream((OutputStream)new FileOutputStream(file));){
            HashCode hash = this.streamHasher.hashCopy((InputStream)input, (OutputStream)output);
            this.chmodUnpackedFile(entry, file);
            String internedAbsolutePath = (String)this.stringInterner.intern((Object)file.getAbsolutePath());
            String internedFileName = (String)this.stringInterner.intern((Object)fileName);
            RegularFileSnapshot regularFileSnapshot = new RegularFileSnapshot(internedAbsolutePath, internedFileName, hash, DefaultFileMetadata.file(output.getCount(), file.lastModified(), FileMetadata.AccessType.DIRECT));
            return regularFileSnapshot;
        }
    }

    @Nullable
    private TarArchiveEntry unpackDirectoryTree(TarArchiveInputStream input, TarArchiveEntry rootEntry, Map<String, FileSystemLocationSnapshot> snapshots, AtomicLong entries, File treeRoot, String treeName) throws IOException {
        TarArchiveEntry entry;
        RelativePathParser parser = new RelativePathParser(TarBuildCacheEntryPacker.safeEntryName(rootEntry));
        DirectorySnapshotBuilder builder = MerkleDirectorySnapshotBuilder.noSortingRequired();
        builder.enterDirectory(FileMetadata.AccessType.DIRECT, (String)this.stringInterner.intern((Object)treeRoot.getAbsolutePath()), (String)this.stringInterner.intern((Object)treeRoot.getName()), DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy.INCLUDE_EMPTY_DIRS);
        while ((entry = input.getNextTarEntry()) != null) {
            boolean isDir = entry.isDirectory();
            boolean outsideOfRoot = parser.nextPath(TarBuildCacheEntryPacker.safeEntryName(entry), isDir, builder::leaveDirectory);
            if (outsideOfRoot) break;
            entries.incrementAndGet();
            File file = new File(treeRoot, parser.getRelativePath());
            if (isDir) {
                FileUtils.forceMkdir((File)file);
                this.chmodUnpackedFile(entry, file);
                String internedAbsolutePath = (String)this.stringInterner.intern((Object)file.getAbsolutePath());
                String internedName = (String)this.stringInterner.intern((Object)parser.getName());
                builder.enterDirectory(FileMetadata.AccessType.DIRECT, internedAbsolutePath, internedName, DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy.INCLUDE_EMPTY_DIRS);
                continue;
            }
            RegularFileSnapshot fileSnapshot = this.unpackFile(input, entry, file, parser.getName());
            builder.visitLeafElement(fileSnapshot);
        }
        parser.exitToRoot(builder::leaveDirectory);
        builder.leaveDirectory();
        snapshots.put(treeName, builder.getResult());
        return entry;
    }

    private static String safeEntryName(TarArchiveEntry tarEntry) {
        return PathTraversalChecker.safePathName(tarEntry.getName());
    }

    private void chmodUnpackedFile(TarArchiveEntry entry, File file) {
        this.filePermissionAccess.chmod(file, entry.getMode() & 0xFFF);
    }

    private static String escape(String name) {
        try {
            return URLEncoder.encode(name, ENCODING.name());
        }
        catch (UnsupportedEncodingException ignored) {
            throw new AssertionError();
        }
    }

    private static String unescape(String name) {
        try {
            return URLDecoder.decode(name, ENCODING.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private class PackingVisitor
    implements RelativePathTrackingFileSystemSnapshotHierarchyVisitor {
        private final TarArchiveOutputStream tarOutput;
        private final String treePath;
        private final String treeRoot;
        private final TreeType type;
        private long packedEntryCount;

        public PackingVisitor(TarArchiveOutputStream tarOutput, String treeName, TreeType type) {
            this.tarOutput = tarOutput;
            this.treePath = "tree-" + TarBuildCacheEntryPacker.escape(treeName);
            this.treeRoot = this.treePath + "/";
            this.type = type;
        }

        @Override
        public SnapshotVisitResult visitEntry(final FileSystemLocationSnapshot snapshot, RelativePathSupplier relativePath) {
            final boolean isRoot = relativePath.isRoot();
            final String targetPath = this.getTargetPath(relativePath);
            snapshot.accept(new FileSystemLocationSnapshot.FileSystemLocationSnapshotVisitor(){

                @Override
                public void visitDirectory(DirectorySnapshot directorySnapshot) {
                    PackingVisitor.this.assertCorrectType(isRoot, snapshot);
                    File dir = new File(snapshot.getAbsolutePath());
                    int dirMode = isRoot ? 493 : TarBuildCacheEntryPacker.this.filePermissionAccess.getUnixMode(dir);
                    PackingVisitor.this.storeDirectoryEntry(targetPath, dirMode, PackingVisitor.this.tarOutput);
                }

                @Override
                public void visitRegularFile(RegularFileSnapshot fileSnapshot) {
                    PackingVisitor.this.assertCorrectType(isRoot, snapshot);
                    File file = new File(snapshot.getAbsolutePath());
                    int fileMode = TarBuildCacheEntryPacker.this.filePermissionAccess.getUnixMode(file);
                    PackingVisitor.this.storeFileEntry(file, targetPath, file.length(), fileMode, PackingVisitor.this.tarOutput);
                }

                @Override
                public void visitMissing(MissingFileSnapshot missingSnapshot) {
                    if (!isRoot) {
                        throw new RuntimeException(String.format("Couldn't read content of file '%s'", snapshot.getAbsolutePath()));
                    }
                    PackingVisitor.this.storeMissingTree(targetPath, PackingVisitor.this.tarOutput);
                }
            });
            ++this.packedEntryCount;
            return SnapshotVisitResult.CONTINUE;
        }

        public long getPackedEntryCount() {
            return this.packedEntryCount;
        }

        private void assertCorrectType(boolean root, FileSystemLocationSnapshot snapshot) {
            if (root) {
                switch (this.type) {
                    case DIRECTORY: {
                        if (snapshot.getType() == FileType.Directory) break;
                        throw new IllegalArgumentException(String.format("Expected '%s' to be a directory", snapshot.getAbsolutePath()));
                    }
                    case FILE: {
                        if (snapshot.getType() == FileType.RegularFile) break;
                        throw new IllegalArgumentException(String.format("Expected '%s' to be a file", snapshot.getAbsolutePath()));
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }

        private String getTargetPath(RelativePathSupplier relativePath) {
            return relativePath.isRoot() ? this.treePath : this.treeRoot + relativePath.toRelativePath();
        }

        private void storeMissingTree(String treePath, TarArchiveOutputStream tarOutput) {
            try {
                TarBuildCacheEntryPacker.createTarEntry("missing-" + treePath, 0L, 33188, tarOutput);
                tarOutput.closeArchiveEntry();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private void storeDirectoryEntry(String path, int mode, TarArchiveOutputStream tarOutput) {
            try {
                TarBuildCacheEntryPacker.createTarEntry(path + "/", 0L, 0x4000 | mode, tarOutput);
                tarOutput.closeArchiveEntry();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private void storeFileEntry(File inputFile, String path, long size, int mode, TarArchiveOutputStream tarOutput) {
            try {
                TarBuildCacheEntryPacker.createTarEntry(path, size, 0x8000 | mode, tarOutput);
                try (FileInputStream input = new FileInputStream(inputFile);){
                    IOUtils.copyLarge((InputStream)input, (OutputStream)tarOutput, (byte[])TarBuildCacheEntryPacker.this.bufferProvider.getBuffer());
                }
                tarOutput.closeArchiveEntry();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class CacheableTree {
        private final TreeType type;
        private final File root;

        public CacheableTree(TreeType type, File root) {
            this.type = type;
            this.root = root;
        }

        public TreeType getType() {
            return this.type;
        }

        public File getRoot() {
            return this.root;
        }
    }

    private static interface UnixPermissions {
        public static final int FILE_FLAG = 32768;
        public static final int DEFAULT_FILE_PERM = 420;
        public static final int DIR_FLAG = 16384;
        public static final int DEFAULT_DIR_PERM = 493;
        public static final int PERM_MASK = 4095;
    }
}

