/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.org.apache.commons.io.FilenameUtils;

public class FileUtils {
    public static final int WINDOWS_PATH_LIMIT = 260;
    private static final Comparator<File> FILE_SEGMENT_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File left, File right) {
            String leftPath = left.getPath();
            String rightPath = right.getPath();
            int len1 = leftPath.length();
            int len2 = rightPath.length();
            int lim = Math.min(len1, len2);
            for (int k = 0; k < lim; ++k) {
                char c2;
                char c1 = leftPath.charAt(k);
                if (c1 == (c2 = rightPath.charAt(k))) continue;
                if (c1 == File.separatorChar) {
                    return -1;
                }
                if (c2 == File.separatorChar) {
                    return 1;
                }
                return c1 - c2;
            }
            return len1 - len2;
        }
    };

    public static String toSafeFileName(String name) {
        int size = name.length();
        StringBuilder rc = new StringBuilder(size * 2);
        for (int i = 0; i < size; ++i) {
            char c = name.charAt(i);
            boolean valid = c >= 'a' && c <= 'z';
            valid = valid || c >= 'A' && c <= 'Z';
            valid = valid || c >= '0' && c <= '9';
            boolean bl = valid = valid || c == '_' || c == '-' || c == '.' || c == '$';
            if (valid) {
                rc.append(c);
                continue;
            }
            rc.append('#');
            rc.append(Integer.toHexString(c));
        }
        return rc.toString();
    }

    public static File assertInWindowsPathLengthLimitation(File file) {
        if (file.getAbsolutePath().length() > 260) {
            throw new GradleException(String.format("Cannot create file. '%s' exceeds windows path limitation of %d character.", file.getAbsolutePath(), 260));
        }
        return file;
    }

    public static Collection<? extends File> calculateRoots(Iterable<? extends File> files) {
        ArrayList sortedFiles = Lists.newArrayList(files);
        Collections.sort(sortedFiles, FILE_SEGMENT_COMPARATOR);
        ArrayList result2 = Lists.newArrayListWithExpectedSize((int)sortedFiles.size());
        File currentRoot = null;
        for (File file : sortedFiles) {
            if (currentRoot != null && FileUtils.doesPathStartWith(file.getPath(), currentRoot.getPath())) continue;
            result2.add(file);
            currentRoot = file;
        }
        return result2;
    }

    public static boolean doesPathStartWith(String path, String startsWithPath) {
        if (!path.startsWith(startsWithPath)) {
            return false;
        }
        return path.length() == startsWithPath.length() || path.charAt(startsWithPath.length()) == File.separatorChar;
    }

    public static boolean hasExtension(File file, String extension) {
        return file.getPath().endsWith(extension);
    }

    public static boolean hasExtensionIgnoresCase(String fileName, String extension) {
        return FileUtils.endsWithIgnoreCase(fileName, extension);
    }

    private static boolean endsWithIgnoreCase(String subject, String suffix) {
        return subject.regionMatches(true, subject.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static String withExtension(String filePath, String extension) {
        if (filePath.toLowerCase().endsWith(extension)) {
            return filePath;
        }
        return FileUtils.removeExtension(filePath) + extension;
    }

    public static String removeExtension(String filePath) {
        int fileNameStart = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
        int extensionPos = filePath.lastIndexOf(46);
        if (extensionPos > fileNameStart) {
            return filePath.substring(0, extensionPos);
        }
        return filePath;
    }

    public static File canonicalize(File src) {
        try {
            return src.getCanonicalFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static File normalize(File src) {
        String path = src.getAbsolutePath();
        String normalizedPath = FilenameUtils.normalizeNoEndSeparator((String)path);
        if (normalizedPath != null) {
            return new File(normalizedPath);
        }
        File root = src;
        File parent = root.getParentFile();
        while (parent != null) {
            root = root.getParentFile();
            parent = root.getParentFile();
        }
        return root;
    }
}

