/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.internal.execution;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

public class XCTestSelection {
    public static final String INCLUDE_ALL_TESTS = "All";
    private static final String WILDCARD = "*";
    private final Set<String> includedTests = new LinkedHashSet<String>();

    public XCTestSelection(Collection<String> includedTests, Collection<String> includedTestsCommandLine) {
        HashSet<String> testSuiteCache = new HashSet<String>();
        this.prepareIncludedTestList(includedTests, testSuiteCache);
        this.prepareIncludedTestList(includedTestsCommandLine, testSuiteCache);
        this.removeLogicalDuplication(testSuiteCache);
        this.includeAllTestIfEmpty();
    }

    private void removeLogicalDuplication(Set<String> testSuiteCache) {
        Iterator<String> it = this.includedTests.iterator();
        while (it.hasNext()) {
            String includedTest = it.next();
            if (!XCTestSelection.isIncludedTestCase(includedTest) || !testSuiteCache.contains(XCTestSelection.getTestSuiteName(includedTest))) continue;
            it.remove();
        }
    }

    private static boolean isIncludedTestCase(String includedTest) {
        return includedTest.contains("/");
    }

    private static String getTestSuiteName(String includedTestCase) {
        return StringUtils.split((String)includedTestCase, (char)'/')[0];
    }

    private void includeAllTestIfEmpty() {
        if (this.includedTests.isEmpty()) {
            this.includedTests.add(INCLUDE_ALL_TESTS);
        }
    }

    private void prepareIncludedTestList(Collection<String> testFilters, Set<String> testSuiteCache) {
        for (String testFilter : testFilters) {
            this.includedTests.add(this.prepareIncludedTest(this.disallowForwardSlash(testFilter), testSuiteCache));
        }
    }

    private String disallowForwardSlash(String testFilter) {
        if (testFilter.contains("/")) {
            throw new IllegalArgumentException(String.format("'%s' is an invalid pattern. Patterns cannot contain forward slash.", testFilter));
        }
        return testFilter;
    }

    private String prepareIncludedTest(String testFilter, Set<String> testSuiteCache) {
        String[] tokens = StringUtils.splitPreserveAllTokens((String)testFilter, (char)'.');
        if (tokens.length > 3) {
            throw new IllegalArgumentException(String.format("'%s' is an invalid pattern. Patterns should have one or two dots.", testFilter));
        }
        if (tokens.length == 3) {
            if (WILDCARD.equals(tokens[2])) {
                String filter = tokens[0] + "." + tokens[1];
                testSuiteCache.add(filter);
                return filter;
            }
            if (tokens[2].isEmpty()) {
                return testFilter;
            }
            return tokens[0] + "." + tokens[1] + "/" + tokens[2];
        }
        if (tokens.length == 2 && !WILDCARD.equals(tokens[1])) {
            testSuiteCache.add(testFilter);
        }
        return testFilter;
    }

    public Collection<String> getIncludedTests() {
        return ImmutableList.copyOf(this.includedTests);
    }
}

