/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.comment.ui;

import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.SortedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewThread;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPREditorReviewThreadsModel;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewThreadModel;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewThreadModelImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J \u0010\u0012\u001a\u00020\u00102\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPREditorReviewThreadsModel;", "", "()V", "changeEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPREditorReviewThreadsModel$ChangesListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "modelsByLine", "", "", "Lcom/intellij/util/containers/SortedList;", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewThreadModel;", "getModelsByLine", "()Ljava/util/Map;", "addChangesListener", "", "listener", "update", "threadsByLine", "", "", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewThread;", "ChangesListener", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPREditorReviewThreadsModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPREditorReviewThreadsModel.kt\norg/jetbrains/plugins/github/pullrequest/comment/ui/GHPREditorReviewThreadsModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1549#2:55\n1620#2,3:56\n1549#2:59\n1620#2,3:60\n*S KotlinDebug\n*F\n+ 1 GHPREditorReviewThreadsModel.kt\norg/jetbrains/plugins/github/pullrequest/comment/ui/GHPREditorReviewThreadsModel\n*L\n26#1:55\n26#1:56,3\n27#1:59\n27#1:60,3\n*E\n"})
public final class GHPREditorReviewThreadsModel {
    @NotNull
    private final EventDispatcher<ChangesListener> changeEventDispatcher;
    @NotNull
    private final Map<Integer, SortedList<GHPRReviewThreadModel>> modelsByLine;

    public GHPREditorReviewThreadsModel() {
        EventDispatcher eventDispatcher = EventDispatcher.create(ChangesListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.changeEventDispatcher = eventDispatcher;
        this.modelsByLine = new LinkedHashMap();
    }

    @NotNull
    public final Map<Integer, SortedList<GHPRReviewThreadModel>> getModelsByLine() {
        return this.modelsByLine;
    }

    public final void addChangesListener(@NotNull ChangesListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.changeEventDispatcher.addListener((EventListener)listener2);
    }

    /*
     * WARNING - void declaration
     */
    public final void update(@NotNull Map<Integer, ? extends List<GHPullRequestReviewThread>> threadsByLine) {
        Intrinsics.checkNotNullParameter(threadsByLine, (String)"threadsByLine");
        Set removedLines = SetsKt.minus(this.modelsByLine.keySet(), (Iterable)threadsByLine.keySet());
        Iterator<Object> iterator = removedLines.iterator();
        while (iterator.hasNext()) {
            int n = ((Number)iterator.next()).intValue();
            List list = (List)this.modelsByLine.remove(n);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List removed = list;
            ((ChangesListener)this.changeEventDispatcher.getMulticaster()).threadsRemoved(n, CollectionsKt.toList((Iterable)removed));
        }
        for (Map.Entry entry : threadsByLine.entrySet()) {
            void $this$mapTo$iv$iv;
            Collection collection;
            Object item$iv$iv22;
            void $this$mapTo$iv$iv2;
            SortedList models2;
            int line = ((Number)entry.getKey()).intValue();
            List threads = (List)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)this.modelsByLine.computeIfAbsent(line, arg_0 -> GHPREditorReviewThreadsModel.update$lambda$0(update.models.1.INSTANCE, arg_0)), (String)"computeIfAbsent(...)");
            Iterable $this$map$iv = (Iterable)models2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv22 : $this$mapTo$iv$iv2) {
                void it;
                GHPRReviewThreadModel gHPRReviewThreadModel = (GHPRReviewThreadModel)item$iv$iv22;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)it.getId(), (Object)it));
            }
            Map modelsById = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            Iterable $this$map$iv2 = threads;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            item$iv$iv22 = $this$mapTo$iv$iv.iterator();
            while (item$iv$iv22.hasNext()) {
                void it;
                Object item$iv$iv3 = item$iv$iv22.next();
                GHPullRequestReviewThread bl = (GHPullRequestReviewThread)item$iv$iv3;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)it.getId(), (Object)it));
            }
            Map threadsById = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            Collection removedModels = MapsKt.minus((Map)modelsById, (Iterable)threadsById.keySet()).values();
            if (!removedModels.isEmpty()) {
                models2.removeAll(removedModels);
                ((ChangesListener)this.changeEventDispatcher.getMulticaster()).threadsRemoved(line, CollectionsKt.toList((Iterable)removedModels));
            }
            List addedModels = new ArrayList();
            for (Map.Entry entry2 : threadsById.entrySet()) {
                String id = (String)entry2.getKey();
                GHPullRequestReviewThread thread = (GHPullRequestReviewThread)entry2.getValue();
                GHPRReviewThreadModel current = (GHPRReviewThreadModel)modelsById.get(id);
                if (current == null) {
                    GHPRReviewThreadModelImpl model2 = new GHPRReviewThreadModelImpl(thread);
                    models2.add((Object)model2);
                    addedModels.add(model2);
                    continue;
                }
                current.update(thread);
            }
            if (!(!((Collection)addedModels).isEmpty())) continue;
            ((ChangesListener)this.changeEventDispatcher.getMulticaster()).threadsAdded(line, addedModels);
        }
    }

    private static final SortedList update$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SortedList)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&J\u001e\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPREditorReviewThreadsModel$ChangesListener;", "Ljava/util/EventListener;", "threadsAdded", "", "line", "", "threads", "", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewThreadModel;", "threadsRemoved", "intellij.vcs.github"})
    public static interface ChangesListener
    extends EventListener {
        public void threadsAdded(int var1, @NotNull List<? extends GHPRReviewThreadModel> var2);

        public void threadsRemoved(int var1, @NotNull List<? extends GHPRReviewThreadModel> var2);
    }
}

