/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrModifierFix;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GroovyAccessibilityInspection;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConstructorCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;

public class GrAccessibilityChecker {
    private static final Logger LOG = Logger.getInstance(GrAccessibilityChecker.class);
    private final HighlightDisplayKey myDisplayKey;
    private final boolean myInspectionEnabled;

    public GrAccessibilityChecker(@NotNull GroovyFileBase file, @NotNull Project project) {
        if (file == null) {
            GrAccessibilityChecker.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GrAccessibilityChecker.$$$reportNull$$$0(1);
        }
        this.myInspectionEnabled = GroovyAccessibilityInspection.isInspectionEnabled(file, project);
        this.myDisplayKey = GroovyAccessibilityInspection.findDisplayKey();
    }

    static GroovyFix[] buildFixes(PsiElement location, GroovyResolveResult resolveResult2) {
        PsiElement element = resolveResult2.getElement();
        if (!(element instanceof PsiMember)) {
            return GroovyFix.EMPTY_ARRAY;
        }
        PsiMember refElement = (PsiMember)element;
        if (refElement instanceof PsiCompiledElement) {
            return GroovyFix.EMPTY_ARRAY;
        }
        PsiModifierList modifierList = refElement.getModifierList();
        if (modifierList == null) {
            return GroovyFix.EMPTY_ARRAY;
        }
        ArrayList<GrModifierFix> fixes = new ArrayList<GrModifierFix>();
        try {
            Project project = refElement.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiModifierList modifierListCopy = facade.getElementFactory().createFieldFromText("int a;", null).getModifierList();
            assert (modifierListCopy != null);
            modifierListCopy.setModifierProperty("static", modifierList.hasModifierProperty("static"));
            String minModifier = "protected";
            if (refElement.hasModifierProperty("protected")) {
                minModifier = "public";
            }
            Object[] modifiers = new String[]{"protected", "public", "packageLocal"};
            PsiClass accessObjectClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)location, PsiClass.class, (boolean)false);
            if (accessObjectClass == null) {
                PsiFile file = location.getContainingFile();
                if (!(file instanceof GroovyFile)) {
                    return GroovyFix.EMPTY_ARRAY;
                }
                accessObjectClass = ((GroovyFile)file).getScriptClass();
            }
            for (int i2 = ArrayUtil.indexOf((Object[])modifiers, (Object)minModifier); i2 < modifiers.length; ++i2) {
                Object modifier = modifiers[i2];
                modifierListCopy.setModifierProperty((String)modifier, true);
                if (!facade.getResolveHelper().isAccessible(refElement, modifierListCopy, location, accessObjectClass, null)) continue;
                fixes.add(new GrModifierFix(refElement, (String)modifier, true, true, GrModifierFix.MODIFIER_LIST_OWNER));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return fixes.toArray(GroovyFix.EMPTY_ARRAY);
    }

    @Nullable
    public HighlightInfo checkCodeReferenceElement(@NotNull GrCodeReferenceElement ref2) {
        HighlightInfo.Builder builder;
        if (ref2 == null) {
            GrAccessibilityChecker.$$$reportNull$$$0(2);
        }
        return (builder = this.checkReferenceImpl(ref2)) == null ? null : builder.create();
    }

    private HighlightInfo.Builder checkReferenceImpl(@NotNull GrReferenceElement<?> ref2) {
        Pair<String, GroovyResolveResult> constructorError;
        boolean isCompileStatic2;
        if (ref2 == null) {
            GrAccessibilityChecker.$$$reportNull$$$0(3);
        }
        if (!this.needToCheck(ref2, isCompileStatic2 = CompileStaticUtil.isCompileStatic(ref2))) {
            return null;
        }
        PsiElement parent2 = ref2.getParent();
        if (parent2 instanceof GrConstructorCall && (constructorError = GrAccessibilityChecker.checkConstructorCall((GrConstructorCall)parent2)) != null) {
            Pair<HighlightInfo.Builder, HighlightSeverity> info = GrAccessibilityChecker.createAnnotationForRef(ref2, isCompileStatic2, (String)constructorError.first);
            this.registerFixes(ref2, (GroovyResolveResult)constructorError.second, (HighlightInfo.Builder)info.getFirst(), (HighlightSeverity)info.getSecond());
            return (HighlightInfo.Builder)info.getFirst();
        }
        Object[] results = ref2.multiResolve(false);
        boolean hasInaccessibleResults = ContainerUtil.or((Object[])results, GrAccessibilityChecker::checkResolveResult);
        if (hasInaccessibleResults) {
            String error = GroovyBundle.message("cannot.access", ref2.getReferenceName());
            Pair<HighlightInfo.Builder, HighlightSeverity> info = GrAccessibilityChecker.createAnnotationForRef(ref2, isCompileStatic2, error);
            if (results.length == 1) {
                this.registerFixes(ref2, (GroovyResolveResult)results[0], (HighlightInfo.Builder)info.getFirst(), (HighlightSeverity)info.getSecond());
            }
            return (HighlightInfo.Builder)info.getFirst();
        }
        return null;
    }

    private void registerFixes(GrReferenceElement<?> ref2, GroovyResolveResult result2, @NotNull HighlightInfo.Builder info, @NotNull HighlightSeverity severity) {
        if (info == null) {
            GrAccessibilityChecker.$$$reportNull$$$0(4);
        }
        if (severity == null) {
            GrAccessibilityChecker.$$$reportNull$$$0(5);
        }
        PsiElement element = result2.getElement();
        assert (element != null);
        if (element instanceof LightElement) {
            return;
        }
        GroovyFix[] fixes = GrAccessibilityChecker.buildFixes(ref2, result2);
        if (fixes.length == 0) {
            String displayName = HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)this.myDisplayKey);
            if (displayName != null) {
                EmptyIntentionAction action = new EmptyIntentionAction(displayName);
                info.registerFix((IntentionAction)action, null, HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)this.myDisplayKey), null, this.myDisplayKey);
            }
        } else {
            ProblemDescriptor descriptor2 = InspectionManager.getInstance((Project)ref2.getProject()).createProblemDescriptor(element, element, "", HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)severity), true, LocalQuickFix.EMPTY_ARRAY);
            for (GroovyFix fix : fixes) {
                info.registerFix((IntentionAction)new LocalQuickFixAsIntentionAdapter((LocalQuickFix)fix, descriptor2), null, HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)this.myDisplayKey), null, this.myDisplayKey);
            }
        }
    }

    @Nullable
    public HighlightInfo checkReferenceExpression(@NotNull GrReferenceExpression ref2) {
        HighlightInfo.Builder builder;
        if (ref2 == null) {
            GrAccessibilityChecker.$$$reportNull$$$0(6);
        }
        return (builder = this.checkReferenceImpl(ref2)) == null ? null : builder.create();
    }

    private static boolean checkResolveResult(GroovyResolveResult result2) {
        return result2 != null && result2.getElement() != null && !result2.isAccessible();
    }

    private boolean needToCheck(GrReferenceElement<?> ref2, boolean isCompileStatic2) {
        if (isCompileStatic2) {
            return true;
        }
        if (!this.myInspectionEnabled) {
            return false;
        }
        return !GroovyAccessibilityInspection.isSuppressed(ref2);
    }

    private static Pair<@NlsContexts.DetailedDescription String, GroovyResolveResult> checkConstructorCall(GrConstructorCall constructorCall) {
        GroovyResolveResult result2 = constructorCall.advancedResolve();
        PsiElement resultElement = result2.getElement();
        if (!(resultElement instanceof PsiMethod)) {
            return null;
        }
        if (GrAccessibilityChecker.checkResolveResult(result2)) {
            return new Pair((Object)GroovyBundle.message("cannot.access", PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)resultElement), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)263, (int)2)), (Object)result2);
        }
        return null;
    }

    @NotNull
    private static Pair<HighlightInfo.Builder, HighlightSeverity> createAnnotationForRef(@NotNull GrReferenceElement<?> ref2, boolean strongError, @NlsContexts.DetailedDescription @NotNull String message) {
        if (ref2 == null) {
            GrAccessibilityChecker.$$$reportNull$$$0(7);
        }
        if (message == null) {
            GrAccessibilityChecker.$$$reportNull$$$0(8);
        }
        HighlightDisplayLevel displayLevel = strongError ? HighlightDisplayLevel.ERROR : GroovyAccessibilityInspection.getHighlightDisplayLevel(ref2.getProject(), ref2);
        Pair pair = Pair.create((Object)GrInspectionUtil.createAnnotationForRef(ref2, displayLevel, message), (Object)displayLevel.getSeverity());
        if (pair == null) {
            GrAccessibilityChecker.$$$reportNull$$$0(9);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/bugs/GrAccessibilityChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/bugs/GrAccessibilityChecker";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationForRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkCodeReferenceElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkReferenceImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerFixes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkReferenceExpression";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationForRef";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

