/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions.strings;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class RemoveUnnecessaryEscapeCharactersIntention
extends Intention {
    public static final String HINT = "Remove unnecessary escape characters";

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            RemoveUnnecessaryEscapeCharactersIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            RemoveUnnecessaryEscapeCharactersIntention.$$$reportNull$$$0(1);
        }
        Document document = editor.getDocument();
        TextRange range = element.getTextRange();
        document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)RemoveUnnecessaryEscapeCharactersIntention.removeUnnecessaryEscapeSymbols((GrLiteral)element));
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(element instanceof GrLiteral)) {
                    return false;
                }
                String text = element.getText();
                return GrStringUtil.getStartQuote(text) != null && !RemoveUnnecessaryEscapeCharactersIntention.removeUnnecessaryEscapeSymbols((GrLiteral)element).equals(text);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/strings/RemoveUnnecessaryEscapeCharactersIntention$1", "satisfiedBy"));
            }
        };
    }

    private static String removeUnnecessaryEscapeSymbols(GrLiteral literal) {
        String text = literal.getText();
        String quote = GrStringUtil.getStartQuote(text);
        String value2 = GrStringUtil.removeQuotes(text);
        StringBuilder buffer = new StringBuilder();
        buffer.append(quote);
        switch (quote) {
            case "'": {
                GrStringUtil.escapeAndUnescapeSymbols(value2, "", "\"$", buffer);
                break;
            }
            case "'''": {
                int position = buffer.length();
                GrStringUtil.escapeAndUnescapeSymbols(value2, "", "\"'$n", buffer);
                GrStringUtil.fixAllTripleQuotes(buffer, position);
                break;
            }
            case "\"": {
                if (literal instanceof GrString) {
                    ASTNode node = literal.getNode();
                    for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                        IElementType type2 = child.getElementType();
                        if (type2 == GroovyTokenTypes.mGSTRING_BEGIN || type2 == GroovyTokenTypes.mGSTRING_END) continue;
                        if (type2 == GroovyElementTypes.GSTRING_INJECTION) {
                            buffer.append(child.getText());
                            continue;
                        }
                        GrStringUtil.escapeAndUnescapeSymbols(child.getText(), "", "'", buffer);
                    }
                    break;
                }
                GrStringUtil.escapeAndUnescapeSymbols(value2, "", "'", buffer);
                break;
            }
            case "\"\"\"": {
                if (literal instanceof GrString) {
                    ASTNode node = literal.getNode();
                    for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                        IElementType type3 = child.getElementType();
                        if (type3 == GroovyTokenTypes.mGSTRING_BEGIN || type3 == GroovyTokenTypes.mGSTRING_END) continue;
                        if (type3 == GroovyElementTypes.GSTRING_INJECTION) {
                            buffer.append(child.getText());
                            continue;
                        }
                        int position = buffer.length();
                        GrStringUtil.escapeAndUnescapeSymbols(child.getText(), "", "\"'n", buffer);
                        GrStringUtil.fixAllTripleDoubleQuotes(buffer, position);
                    }
                    break;
                }
                int position = buffer.length();
                GrStringUtil.escapeAndUnescapeSymbols(value2, "", "\"'n", buffer);
                GrStringUtil.fixAllTripleDoubleQuotes(buffer, position);
                break;
            }
            default: {
                return text;
            }
        }
        buffer.append(quote);
        return buffer.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/intentions/conversions/strings/RemoveUnnecessaryEscapeCharactersIntention";
        objectArray[2] = "processIntention";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

