/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Preconditions {
    private static RuntimeException outOfBounds(BiFunction<String, List<Integer>, ? extends RuntimeException> biFunction, String string, Integer ... integerArray) {
        List<Integer> list = Collections.unmodifiableList(Arrays.asList(integerArray));
        RuntimeException runtimeException = biFunction == null ? null : biFunction.apply(string, list);
        return runtimeException == null ? new IndexOutOfBoundsException(Preconditions.outOfBoundsMessage(string, list)) : runtimeException;
    }

    private static RuntimeException outOfBoundsCheckIndex(BiFunction<String, List<Integer>, ? extends RuntimeException> biFunction, int n, int n2) {
        return Preconditions.outOfBounds(biFunction, "checkIndex", n, n2);
    }

    private static RuntimeException outOfBoundsCheckFromToIndex(BiFunction<String, List<Integer>, ? extends RuntimeException> biFunction, int n, int n2, int n3) {
        return Preconditions.outOfBounds(biFunction, "checkFromToIndex", n, n2, n3);
    }

    private static RuntimeException outOfBoundsCheckFromIndexSize(BiFunction<String, List<Integer>, ? extends RuntimeException> biFunction, int n, int n2, int n3) {
        return Preconditions.outOfBounds(biFunction, "checkFromIndexSize", n, n2, n3);
    }

    public static <X extends RuntimeException> BiFunction<String, List<Integer>, X> outOfBoundsExceptionFormatter(final Function<String, X> function) {
        return new BiFunction<String, List<Integer>, X>(){

            @Override
            public X apply(String string, List<Integer> list) {
                return (RuntimeException)function.apply(Preconditions.outOfBoundsMessage(string, list));
            }
        };
    }

    private static String outOfBoundsMessage(String string, List<Integer> list) {
        if (string == null && list == null) {
            return String.format("Range check failed", new Object[0]);
        }
        if (string == null) {
            return String.format("Range check failed: %s", list);
        }
        if (list == null) {
            return String.format("Range check failed: %s", string);
        }
        int n = 0;
        switch (string) {
            case "checkIndex": {
                n = 2;
                break;
            }
            case "checkFromToIndex": 
            case "checkFromIndexSize": {
                n = 3;
                break;
            }
        }
        switch (list.size() != n ? "" : string) {
            case "checkIndex": {
                return String.format("Index %d out-of-bounds for length %d", list.get(0), list.get(1));
            }
            case "checkFromToIndex": {
                return String.format("Range [%d, %d) out-of-bounds for length %d", list.get(0), list.get(1), list.get(2));
            }
            case "checkFromIndexSize": {
                return String.format("Range [%d, %<d + %d) out-of-bounds for length %d", list.get(0), list.get(1), list.get(2));
            }
        }
        return String.format("Range check failed: %s %s", string, list);
    }

    public static <X extends RuntimeException> int checkIndex(int n, int n2, BiFunction<String, List<Integer>, X> biFunction) {
        if (n < 0 || n >= n2) {
            throw Preconditions.outOfBoundsCheckIndex(biFunction, n, n2);
        }
        return n;
    }

    public static <X extends RuntimeException> int checkFromToIndex(int n, int n2, int n3, BiFunction<String, List<Integer>, X> biFunction) {
        if (n < 0 || n > n2 || n2 > n3) {
            throw Preconditions.outOfBoundsCheckFromToIndex(biFunction, n, n2, n3);
        }
        return n;
    }

    public static <X extends RuntimeException> int checkFromIndexSize(int n, int n2, int n3, BiFunction<String, List<Integer>, X> biFunction) {
        if ((n3 | n | n2) < 0 || n2 > n3 - n) {
            throw Preconditions.outOfBoundsCheckFromIndexSize(biFunction, n, n2, n3);
        }
        return n;
    }
}

