/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.format.PayloadTypeEncoding;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.nlj.rtp.RedAudioRtpPacket;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.transform.node.TransformerNode;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.rtp.RtpHeader;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/nlj/transform/node/RtpParser;", "Lorg/jitsi/nlj/transform/node/TransformerNode;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "trace", "", "f", "Lkotlin/Function0;", "transform", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "jitsi-media-transform"})
public final class RtpParser
extends TransformerNode {
    @NotNull
    private final ReadOnlyStreamInformationStore streamInformationStore;
    @NotNull
    private final Logger logger;

    public RtpParser(@NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super("RTP Parser");
        this.streamInformationStore = streamInformationStore;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected PacketInfo transform(@NotNull PacketInfo packetInfo) {
        Packet packet;
        PacketInfo packetInfo2;
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        Packet packet2 = packetInfo.getPacket();
        Intrinsics.checkNotNullExpressionValue(packet2.buffer, "packet.buffer");
        byte payloadTypeNumber = (byte)RtpHeader.Companion.getPayloadType(packet2.buffer, packet2.offset);
        PayloadType payloadType = this.streamInformationStore.getRtpPayloadTypes().get(payloadTypeNumber);
        if (payloadType == null) {
            RtpParser $this$transform_u24lambda_u2d1 = this;
            boolean bl = false;
            Logger $this$cdebug$iv = $this$transform_u24lambda_u2d1.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl2 = false;
                logger.debug("Unknown payload type: " + payloadTypeNumber);
            }
            return null;
        }
        PayloadType payloadType2 = payloadType;
        PacketInfo packetInfo3 = packetInfo;
        switch (WhenMappings.$EnumSwitchMapping$1[payloadType2.getMediaType().ordinal()]) {
            case 1: {
                AudioRtpPacket audioRtpPacket;
                if (WhenMappings.$EnumSwitchMapping$0[payloadType2.getEncoding().ordinal()] == 1) {
                    void p2;
                    void p1;
                    void p0;
                    Packet this_$iv = packet2;
                    boolean $i$f$toOtherType = false;
                    Intrinsics.checkNotNullExpressionValue(this_$iv.buffer, "buffer");
                    int n = this_$iv.length;
                    int bl2 = this_$iv.offset;
                    byte[] byArray = this_$iv.buffer;
                    PacketInfo packetInfo4 = packetInfo3;
                    boolean bl = false;
                    packetInfo2 = packetInfo4;
                    audioRtpPacket = (AudioRtpPacket)((Packet)new RedAudioRtpPacket((byte[])p0, (int)p1, (int)p2));
                } else {
                    Packet this_$iv2 = packet2;
                    boolean $i$f$toOtherType2 = false;
                    Intrinsics.checkNotNullExpressionValue(this_$iv2.buffer, "buffer");
                    int p2 = this_$iv2.length;
                    int p1 = this_$iv2.offset;
                    byte[] p0 = this_$iv2.buffer;
                    PacketInfo packetInfo5 = packetInfo3;
                    boolean bl = false;
                    packetInfo2 = packetInfo5;
                    audioRtpPacket = (AudioRtpPacket)((Packet)new AudioRtpPacket(p0, p1, p2));
                }
                packet = audioRtpPacket;
                break;
            }
            case 2: {
                void p2;
                void p1;
                void p0;
                Packet this_$iv = packet2;
                boolean $i$f$toOtherType = false;
                Intrinsics.checkNotNullExpressionValue(this_$iv.buffer, "buffer");
                int this_$iv2 = this_$iv.length;
                int $i$f$toOtherType2 = this_$iv.offset;
                byte[] p22 = this_$iv.buffer;
                PacketInfo packetInfo6 = packetInfo3;
                boolean bl = false;
                packetInfo2 = packetInfo6;
                packet = new VideoRtpPacket((byte[])p0, (int)p1, (int)p2);
                break;
            }
            default: {
                throw new Exception("Unrecognized media type: '" + payloadType2.getMediaType() + "'");
            }
        }
        packetInfo2.setPacket(packet);
        packetInfo.resetPayloadVerification();
        return packetInfo;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PayloadTypeEncoding.values().length];
            nArray[PayloadTypeEncoding.RED.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MediaType.values().length];
            nArray[MediaType.AUDIO.ordinal()] = 1;
            nArray[MediaType.VIDEO.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

