/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtp;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.rtp.RtpHeader;
import org.jitsi.rtp.rtp.header_extensions.HeaderExtensionHelpers;
import org.jitsi.rtp.rtp.header_extensions.HeaderExtensionParser;
import org.jitsi.rtp.rtp.header_extensions.OneByteHeaderExtensionParser;
import org.jitsi.rtp.rtp.header_extensions.TwoByteHeaderExtensionParser;
import org.jitsi.rtp.util.BufferPool;
import org.jitsi.rtp.util.FieldParsersKt;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.rtp.util.RtpUtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0007\b\u0017\u0018\u0000 g2\u00020\u0001:\u0005ghijkB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0016\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u00062\u0006\u0010W\u001a\u00020\u0006J\b\u0010X\u001a\u00020\u0000H\u0016J\u001e\u0010Y\u001a\u00020Z2\u0014\u0010[\u001a\u0010\u0012\u0004\u0012\u00020U\u0012\u0004\u0012\u00020\u001d\u0018\u00010\\H\u0002J\u0006\u0010]\u001a\u00020ZJ\u0012\u0010^\u001a\u0004\u0018\u00010U2\u0006\u0010_\u001a\u00020\u0006H\u0002J\u0010\u0010`\u001a\u0004\u0018\u00010U2\u0006\u0010_\u001a\u00020\u0006J\u001a\u0010a\u001a\u00020*2\u0010\u0010C\u001a\f\u0012\b\u0012\u00060ER\u00020\u00000\u0014H\u0002J\u000e\u0010b\u001a\u00020Z2\u0006\u0010V\u001a\u00020\u0006J\u0014\u0010c\u001a\u00020Z2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00060eJ\b\u0010f\u001a\u00020@H\u0016R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u00060\nR\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0012R$\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R$\u0010#\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"R$\u0010&\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010 \"\u0004\b(\u0010\"R\u0016\u0010)\u001a\u0004\u0018\u00010*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R$\u0010.\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u0006@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0012\"\u0004\b0\u00101R$\u00102\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b2\u0010 \"\u0004\b3\u0010\"R$\u00104\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b5\u0010\u0012\"\u0004\b6\u00101R\u0011\u00107\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0012R\u0011\u00109\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0012R$\u0010<\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010\u0012\"\u0004\b>\u00101R\u0014\u0010?\u001a\u00020@8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR\u001a\u0010C\u001a\u000e\u0012\b\u0012\u00060ER\u00020\u0000\u0018\u00010DX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010F\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bG\u0010\u0012\"\u0004\bH\u00101R$\u0010I\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR$\u0010N\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bO\u0010K\"\u0004\bP\u0010MR$\u0010Q\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bR\u0010\u0012\"\u0004\bS\u00101\u00a8\u0006l"}, d2={"Lorg/jitsi/rtp/rtp/RtpPacket;", "Lorg/jitsi/rtp/Packet;", "buffer", "", "([B)V", "offset", "", "length", "([BII)V", "_encodedHeaderExtensions", "Lorg/jitsi/rtp/rtp/RtpPacket$EncodedHeaderExtensions;", "_payloadType", "_sequenceNumber", "_ssrc", "", "_timestamp", "csrcCount", "getCsrcCount", "()I", "csrcs", "", "getCsrcs", "()Ljava/util/List;", "encodedHeaderExtensions", "getEncodedHeaderExtensions", "()Lorg/jitsi/rtp/rtp/RtpPacket$EncodedHeaderExtensions;", "extensionsProfileType", "getExtensionsProfileType", "value", "", "hasEncodedExtensions", "getHasEncodedExtensions", "()Z", "setHasEncodedExtensions", "(Z)V", "hasExtensions", "getHasExtensions", "setHasExtensions", "hasPadding", "getHasPadding", "setHasPadding", "headerExtensionParser", "Lorg/jitsi/rtp/rtp/header_extensions/HeaderExtensionParser;", "getHeaderExtensionParser", "()Lorg/jitsi/rtp/rtp/header_extensions/HeaderExtensionParser;", "<set-?>", "headerLength", "getHeaderLength", "setHeaderLength", "(I)V", "isMarked", "setMarked", "paddingSize", "getPaddingSize", "setPaddingSize", "payloadLength", "getPayloadLength", "payloadOffset", "getPayloadOffset", "newValue", "payloadType", "getPayloadType", "setPayloadType", "payloadVerification", "", "getPayloadVerification", "()Ljava/lang/String;", "pendingHeaderExtensions", "", "Lorg/jitsi/rtp/rtp/RtpPacket$PendingHeaderExtension;", "sequenceNumber", "getSequenceNumber", "setSequenceNumber", "ssrc", "getSsrc", "()J", "setSsrc", "(J)V", "timestamp", "getTimestamp", "setTimestamp", "version", "getVersion", "setVersion", "addHeaderExtension", "Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "id", "extDataLength", "clone", "createPendingHeaderExtensions", "", "removeIf", "Lkotlin/Function1;", "encodeHeaderExtensions", "getEncodedHeaderExtension", "extensionId", "getHeaderExtension", "pickParserForEncodedHeaders", "removeHeaderExtension", "removeHeaderExtensionsExcept", "retain", "", "toString", "Companion", "EncodedHeaderExtension", "EncodedHeaderExtensions", "HeaderExtension", "PendingHeaderExtension", "rtp"})
@SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="We intentionally pass a reference to our buffer when using observableWhenChanged.")
public class RtpPacket
extends Packet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int _payloadType;
    private int _sequenceNumber;
    private long _timestamp;
    private long _ssrc;
    private int headerLength;
    @NotNull
    private final EncodedHeaderExtensions _encodedHeaderExtensions;
    @Nullable
    private List<PendingHeaderExtension> pendingHeaderExtensions;
    public static final int HEADER_EXT_HEADER_SIZE = 1;
    public static final int BYTES_TO_LEAVE_AT_START_OF_PACKET = 10;

    public RtpPacket(@NotNull byte[] buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        super(buffer, offset, length);
        this._payloadType = RtpHeader.Companion.getPayloadType(buffer, offset);
        this._sequenceNumber = RtpHeader.Companion.getSequenceNumber(buffer, offset);
        this._timestamp = RtpHeader.Companion.getTimestamp(buffer, offset);
        this._ssrc = RtpHeader.Companion.getSsrc(buffer, offset);
        this.headerLength = RtpHeader.Companion.getTotalLength(buffer, offset);
        if (this.headerLength > length) {
            throw new IllegalArgumentException("RTP packet header length " + this.headerLength + " > length " + length);
        }
        this._encodedHeaderExtensions = new EncodedHeaderExtensions();
    }

    public RtpPacket(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this(buffer, 0, buffer.length);
    }

    public final int getVersion() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return RtpHeader.Companion.getVersion(this.buffer, this.offset);
    }

    public final void setVersion(int value2) {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        RtpHeader.Companion.setVersion(this.buffer, this.offset, value2);
    }

    public final boolean getHasPadding() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return RtpHeader.Companion.hasPadding(this.buffer, this.offset);
    }

    public final void setHasPadding(boolean value2) {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        RtpHeader.Companion.setPadding(this.buffer, this.offset, value2);
    }

    private final boolean getHasEncodedExtensions() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return RtpHeader.Companion.hasExtensions(this.buffer, this.offset);
    }

    private final void setHasEncodedExtensions(boolean value2) {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        RtpHeader.Companion.setHasExtensions(this.buffer, this.offset, value2);
    }

    public final int getCsrcCount() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return RtpHeader.Companion.getCsrcCount(this.buffer, this.offset);
    }

    public final boolean isMarked() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return RtpHeader.Companion.getMarker(this.buffer, this.offset);
    }

    public final void setMarked(boolean value2) {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        RtpHeader.Companion.setMarker(this.buffer, this.offset, value2);
    }

    public final int getPayloadType() {
        return this._payloadType;
    }

    public final void setPayloadType(int newValue) {
        if (newValue != this._payloadType) {
            Intrinsics.checkNotNullExpressionValue(this.buffer, "this.buffer");
            RtpHeader.Companion.setPayloadType(this.buffer, this.offset, newValue);
            this._payloadType = newValue;
        }
    }

    public final int getSequenceNumber() {
        return this._sequenceNumber;
    }

    public final void setSequenceNumber(int newValue) {
        if (newValue != this._sequenceNumber) {
            Intrinsics.checkNotNullExpressionValue(this.buffer, "this.buffer");
            RtpHeader.Companion.setSequenceNumber(this.buffer, this.offset, newValue);
            this._sequenceNumber = newValue;
        }
    }

    public final long getTimestamp() {
        return this._timestamp;
    }

    public final void setTimestamp(long newValue) {
        if (newValue != this._timestamp) {
            Intrinsics.checkNotNullExpressionValue(this.buffer, "this.buffer");
            RtpHeader.Companion.setTimestamp(this.buffer, this.offset, newValue);
            this._timestamp = newValue;
        }
    }

    public final long getSsrc() {
        return this._ssrc;
    }

    public final void setSsrc(long newValue) {
        if (newValue != this._ssrc) {
            Intrinsics.checkNotNullExpressionValue(this.buffer, "this.buffer");
            RtpHeader.Companion.setSsrc(this.buffer, this.offset, newValue);
            this._ssrc = newValue;
        }
    }

    @NotNull
    public final List<Long> getCsrcs() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return RtpHeader.Companion.getCsrcs(this.buffer, this.offset);
    }

    public final int getExtensionsProfileType() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return RtpHeader.Companion.getExtensionsProfileType(this.buffer, this.offset);
    }

    public final int getHeaderLength() {
        return this.headerLength;
    }

    protected final void setHeaderLength(int n) {
        this.headerLength = n;
    }

    public final int getPayloadLength() {
        return this.length - this.headerLength;
    }

    public final int getPayloadOffset() {
        return this.offset + this.headerLength;
    }

    public final int getPaddingSize() {
        if (!this.getHasPadding()) {
            return 0;
        }
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return FieldParsersKt.getByteAsInt(this.buffer, this.offset + this.length - 1);
    }

    public final void setPaddingSize(int value2) {
        if (value2 > 0) {
            this.setHasPadding(true);
            this.buffer[this.offset + this.length - 1] = (byte)value2;
        } else {
            this.setHasPadding(false);
        }
    }

    private final HeaderExtensionParser getHeaderExtensionParser() {
        return HeaderExtensionHelpers.Companion.getHeaderExtensionParser(this.getExtensionsProfileType());
    }

    private final EncodedHeaderExtensions getEncodedHeaderExtensions() {
        this._encodedHeaderExtensions.reset$rtp();
        return this._encodedHeaderExtensions;
    }

    @Override
    @NotNull
    public String getPayloadVerification() {
        int n = this.getPayloadLength();
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return "type=RtpPacket len=" + n + " hashCode=" + ByteArrayExtensionsKt.hashCodeOfSegment(this.buffer, this.getPayloadOffset(), this.getPayloadOffset() + this.getPayloadLength());
    }

    private final HeaderExtension getEncodedHeaderExtension(int extensionId) {
        if (!this.getHasEncodedExtensions()) {
            return null;
        }
        Iterator $this$forEach$iv = this.getEncodedHeaderExtensions();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            HeaderExtension ext = (HeaderExtension)element$iv;
            boolean bl = false;
            if (ext.getId() != extensionId) continue;
            return ext;
        }
        return null;
    }

    public final boolean getHasExtensions() {
        List<PendingHeaderExtension> list = this.pendingHeaderExtensions;
        return list != null ? !((Collection)list).isEmpty() : this.getHasEncodedExtensions();
    }

    public final void setHasExtensions(boolean value2) {
        List<PendingHeaderExtension> p = this.pendingHeaderExtensions;
        if (p != null) {
            if (value2 && p.isEmpty()) {
                throw new IllegalStateException("Cannot set hasExtensions to true with empty pending extensions");
            }
            if (!value2) {
                p.clear();
            }
        } else {
            this.setHasEncodedExtensions(value2);
        }
    }

    @Nullable
    public final HeaderExtension getHeaderExtension(int extensionId) {
        List<PendingHeaderExtension> activeHeaderExtensions;
        List<PendingHeaderExtension> list = this.pendingHeaderExtensions;
        if (list == null || (list = list.iterator()) == null) {
            list = this.getEncodedHeaderExtensions();
        }
        List<PendingHeaderExtension> $this$forEach$iv = activeHeaderExtensions = list;
        boolean $i$f$forEach = false;
        List<PendingHeaderExtension> list2 = $this$forEach$iv;
        while (list2.hasNext()) {
            Object element$iv = list2.next();
            HeaderExtension ext = (HeaderExtension)element$iv;
            boolean bl = false;
            if (ext.getId() != extensionId) continue;
            return ext;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void createPendingHeaderExtensions(Function1<? super HeaderExtension, Boolean> removeIf) {
        ArrayList arrayList;
        if (this.pendingHeaderExtensions != null) {
            return;
        }
        if (!(!this.getHasEncodedExtensions() || this.getHeaderExtensionParser() != null)) {
            boolean $i$a$-check-RtpPacket$createPendingHeaderExtensions$22 = false;
            String $i$a$-check-RtpPacket$createPendingHeaderExtensions$22 = "Cannot modify header extensions for header extension type " + Integer.toHexString(this.getExtensionsProfileType());
            throw new IllegalStateException($i$a$-check-RtpPacket$createPendingHeaderExtensions$22.toString());
        }
        ArrayList $i$a$-check-RtpPacket$createPendingHeaderExtensions$22 = arrayList = new ArrayList();
        RtpPacket rtpPacket = this;
        boolean bl = false;
        Iterator $this$forEach$iv = this.getEncodedHeaderExtensions();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            void l;
            Object element$iv = iterator2.next();
            HeaderExtension it = (HeaderExtension)element$iv;
            boolean bl2 = false;
            if (removeIf != null && removeIf.invoke(it).booleanValue()) continue;
            l.add(new PendingHeaderExtension(this, it));
        }
        rtpPacket.pendingHeaderExtensions = arrayList;
    }

    public final void removeHeaderExtension(int id) {
        List<PendingHeaderExtension> list = this.pendingHeaderExtensions;
        if (list != null) {
            list.removeIf(arg_0 -> RtpPacket.removeHeaderExtension$lambda-5(id, arg_0));
        } else {
            this.createPendingHeaderExtensions((Function1<? super HeaderExtension, Boolean>)new Function1<HeaderExtension, Boolean>(id){
                final /* synthetic */ int $id;
                {
                    this.$id = $id;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull HeaderExtension h2) {
                    Intrinsics.checkNotNullParameter(h2, "h");
                    return h2.getId() == this.$id;
                }
            });
        }
    }

    public final void removeHeaderExtensionsExcept(@NotNull Set<Integer> retain) {
        Intrinsics.checkNotNullParameter(retain, "retain");
        List<PendingHeaderExtension> list = this.pendingHeaderExtensions;
        if (list != null) {
            list.removeIf(arg_0 -> RtpPacket.removeHeaderExtensionsExcept$lambda-6(retain, arg_0));
        } else {
            this.createPendingHeaderExtensions((Function1<? super HeaderExtension, Boolean>)new Function1<HeaderExtension, Boolean>(retain){
                final /* synthetic */ Set<Integer> $retain;
                {
                    this.$retain = $retain;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull HeaderExtension h2) {
                    Intrinsics.checkNotNullParameter(h2, "h");
                    return !this.$retain.contains(h2.getId());
                }
            });
        }
    }

    @NotNull
    public final HeaderExtension addHeaderExtension(int id, int extDataLength) {
        if (!(1 <= id ? id < 256 : false)) {
            boolean $i$a$-require-RtpPacket$addHeaderExtension$32 = false;
            String $i$a$-require-RtpPacket$addHeaderExtension$32 = "Invalid header extension ID " + id;
            throw new IllegalArgumentException($i$a$-require-RtpPacket$addHeaderExtension$32.toString());
        }
        if (!(0 <= extDataLength ? extDataLength < 256 : false)) {
            boolean bl = false;
            String string = "Invalid header extension length " + extDataLength;
            throw new IllegalArgumentException(string.toString());
        }
        PendingHeaderExtension newHeader = new PendingHeaderExtension(this, id, extDataLength);
        if (this.pendingHeaderExtensions == null) {
            this.createPendingHeaderExtensions(null);
        }
        List<PendingHeaderExtension> list = this.pendingHeaderExtensions;
        Intrinsics.checkNotNull(list);
        list.add(newHeader);
        return newHeader;
    }

    private final HeaderExtensionParser pickParserForEncodedHeaders(List<PendingHeaderExtension> pendingHeaderExtensions) {
        Iterable $this$forEach$iv = pendingHeaderExtensions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PendingHeaderExtension it = (PendingHeaderExtension)element$iv;
            boolean bl = false;
            if (it.getId() < 15 && it.getDataLengthBytes() != 0 && it.getDataLengthBytes() <= 16) continue;
            return TwoByteHeaderExtensionParser.INSTANCE;
        }
        return OneByteHeaderExtensionParser.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public final void encodeHeaderExtensions() {
        byte[] byArray;
        int n;
        List<PendingHeaderExtension> list = this.pendingHeaderExtensions;
        if (list == null) {
            return;
        }
        List<PendingHeaderExtension> pendingHeaderExtensions = list;
        HeaderExtensionParser newParser = this.pickParserForEncodedHeaders(pendingHeaderExtensions);
        int currHeaderLength = this.headerLength;
        int currPayloadLength = this.getPayloadLength();
        int baseHeaderLength = 12 + this.getCsrcCount() * 4;
        if (pendingHeaderExtensions.isEmpty()) {
            n = 0;
        } else {
            int n2;
            Iterable iterable = pendingHeaderExtensions;
            int n3 = 4;
            int n4 = 0;
            for (Object object : iterable) {
                void h2;
                PendingHeaderExtension pendingHeaderExtension = (PendingHeaderExtension)object;
                n2 = n4;
                boolean bl = false;
                int n5 = newParser.getExtHeaderSizeBytes() + h2.getDataLengthBytes();
                n4 = n2 + n5;
            }
            n2 = n4;
            int rawHeaderLength = n3 + n2;
            n = rawHeaderLength + RtpUtils.Companion.getNumPaddingBytes(rawHeaderLength);
        }
        int newExtHeaderLength = n;
        int newHeaderLength = baseHeaderLength + newExtHeaderLength;
        int newPacketLength = newHeaderLength + currPayloadLength;
        int newPayloadOffset = 0;
        if (this.buffer.length >= newPacketLength + 20) {
            if (this.offset + currHeaderLength >= newPacketLength - currPayloadLength) {
                newPayloadOffset = this.getPayloadOffset();
            } else {
                newPayloadOffset = this.buffer.length - currPayloadLength - 20;
                System.arraycopy(this.buffer, this.getPayloadOffset(), this.buffer, newPayloadOffset, currPayloadLength);
            }
            byArray = this.buffer;
        } else {
            Object object;
            object = BufferPool.Companion.getGetArray().invoke(newPacketLength + 20);
            byte[] $this$encodeHeaderExtensions_u24lambda_u2d11 = (byte[])object;
            boolean bl = false;
            newPayloadOffset = $this$encodeHeaderExtensions_u24lambda_u2d11.length - currPayloadLength - 20;
            System.arraycopy(this.buffer, this.getPayloadOffset(), $this$encodeHeaderExtensions_u24lambda_u2d11, newPayloadOffset, currPayloadLength);
            byArray = (byte[])object;
        }
        byte[] newBuffer = byArray;
        int newOffset = newPayloadOffset - newHeaderLength;
        if (this.buffer != newBuffer || this.offset != newOffset) {
            System.arraycopy(this.buffer, this.offset, newBuffer, newOffset, baseHeaderLength);
        }
        if (!((Collection)pendingHeaderExtensions).isEmpty()) {
            int off = 0;
            off = newOffset + baseHeaderLength;
            Intrinsics.checkNotNullExpressionValue(newBuffer, "newBuffer");
            ByteArrayExtensionsKt.putShort(newBuffer, off, (short)newParser.getHeaderExtensionLabel());
            ByteArrayExtensionsKt.putShort(newBuffer, off + 2, (short)((newExtHeaderLength - 4) / 4));
            off += 4;
            Iterable $this$forEach$iv = pendingHeaderExtensions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PendingHeaderExtension h3 = (PendingHeaderExtension)element$iv;
                boolean bl = false;
                int len = h3.writeToBuffer(newBuffer, off, newParser);
                off += len;
            }
            while (off < newOffset + newHeaderLength) {
                newBuffer[off] = 0;
                int n6 = off;
                off = n6 + 1;
            }
        }
        byte[] oldBuffer = this.buffer;
        this.buffer = newBuffer;
        if (oldBuffer != newBuffer) {
            Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnArray();
            Intrinsics.checkNotNullExpressionValue(oldBuffer, "oldBuffer");
            function1.invoke(oldBuffer);
        }
        this.offset = newOffset;
        this.length = newPacketLength;
        this.headerLength = newHeaderLength;
        this.setHasEncodedExtensions(!((Collection)pendingHeaderExtensions).isEmpty());
        this.pendingHeaderExtensions = null;
    }

    @Override
    @NotNull
    public RtpPacket clone() {
        RtpPacket rtpPacket;
        RtpPacket it = rtpPacket = new RtpPacket(this.cloneBuffer(10), 10, this.length);
        boolean bl = false;
        if (this.pendingHeaderExtensions != null) {
            it.pendingHeaderExtensions = new ArrayList(this.pendingHeaderExtensions);
        }
        return rtpPacket;
    }

    @NotNull
    public String toString() {
        StringBuilder $this$toString_u24lambda_u2d14 = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u2d14.append("RtpPacket: ");
        $this$toString_u24lambda_u2d14.append("PT=" + this.getPayloadType());
        $this$toString_u24lambda_u2d14.append(", Ssrc=" + this.getSsrc());
        $this$toString_u24lambda_u2d14.append(", SeqNum=" + this.getSequenceNumber());
        $this$toString_u24lambda_u2d14.append(", M=" + this.isMarked());
        $this$toString_u24lambda_u2d14.append(", X=" + this.getHasEncodedExtensions());
        $this$toString_u24lambda_u2d14.append(", Ts=" + this.getTimestamp());
        String string = $this$toString_u24lambda_u2d14.toString();
        Intrinsics.checkNotNullExpressionValue(string, "with(StringBuilder()) {\n\u2026\n        toString()\n    }");
        return string;
    }

    private static final boolean removeHeaderExtension$lambda-5(int $id, PendingHeaderExtension h2) {
        Intrinsics.checkNotNullParameter(h2, "h");
        return h2.getId() == $id;
    }

    private static final boolean removeHeaderExtensionsExcept$lambda-6(Set $retain, PendingHeaderExtension h2) {
        Intrinsics.checkNotNullParameter($retain, "$retain");
        Intrinsics.checkNotNullParameter(h2, "h");
        return !$retain.contains(h2.getId());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0018\u0010\f\u001a\u00020\u0007X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "", "buffer", "", "getBuffer", "()[B", "dataLengthBytes", "", "getDataLengthBytes", "()I", "dataOffset", "getDataOffset", "id", "getId", "setId", "(I)V", "totalLengthBytes", "getTotalLengthBytes", "rtp"})
    public static interface HeaderExtension {
        @NotNull
        public byte[] getBuffer();

        public int getDataOffset();

        public int getId();

        public void setId(int var1);

        public int getDataLengthBytes();

        public int getTotalLengthBytes();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bR\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR$\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/jitsi/rtp/rtp/RtpPacket$EncodedHeaderExtension;", "Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "(Lorg/jitsi/rtp/rtp/RtpPacket;)V", "buffer", "", "getBuffer", "()[B", "currExtLength", "", "currExtOffset", "dataLengthBytes", "getDataLengthBytes", "()I", "dataOffset", "getDataOffset", "newId", "id", "getId", "setId", "(I)V", "totalLengthBytes", "getTotalLengthBytes", "setOffsetLength", "", "nextHeaderExtOffset", "nextHeaderExtLength", "rtp"})
    public final class EncodedHeaderExtension
    implements HeaderExtension {
        private int currExtOffset;
        private int currExtLength;

        @Override
        public int getDataLengthBytes() {
            HeaderExtensionParser headerExtensionParser = RtpPacket.this.getHeaderExtensionParser();
            Intrinsics.checkNotNull(headerExtensionParser);
            return headerExtensionParser.getDataLengthBytes(this.getBuffer(), this.currExtOffset);
        }

        @Override
        @NotNull
        public byte[] getBuffer() {
            Intrinsics.checkNotNullExpressionValue(RtpPacket.this.buffer, "this@RtpPacket.buffer");
            return RtpPacket.this.buffer;
        }

        @Override
        public int getId() {
            if (this.currExtLength <= 0) {
                return -1;
            }
            HeaderExtensionParser headerExtensionParser = RtpPacket.this.getHeaderExtensionParser();
            Intrinsics.checkNotNull(headerExtensionParser);
            return headerExtensionParser.getId(this.getBuffer(), this.currExtOffset);
        }

        @Override
        public void setId(int newId) {
            HeaderExtensionParser headerExtensionParser = RtpPacket.this.getHeaderExtensionParser();
            Intrinsics.checkNotNull(headerExtensionParser);
            if (this.currExtLength < headerExtensionParser.getMinimumExtSizeBytes()) {
                throw new IllegalStateException("Can't set ID: Header extension too short");
            }
            HeaderExtensionParser headerExtensionParser2 = RtpPacket.this.getHeaderExtensionParser();
            Intrinsics.checkNotNull(headerExtensionParser2);
            headerExtensionParser2.writeIdAndLength(newId, this.getDataLengthBytes(), this.getBuffer(), this.currExtOffset);
        }

        @Override
        public int getDataOffset() {
            HeaderExtensionParser headerExtensionParser = RtpPacket.this.getHeaderExtensionParser();
            Intrinsics.checkNotNull(headerExtensionParser);
            return headerExtensionParser.getExtHeaderSizeBytes() + this.currExtOffset;
        }

        @Override
        public int getTotalLengthBytes() {
            HeaderExtensionParser headerExtensionParser = RtpPacket.this.getHeaderExtensionParser();
            Intrinsics.checkNotNull(headerExtensionParser);
            return headerExtensionParser.getExtHeaderSizeBytes() + this.getDataLengthBytes();
        }

        public final void setOffsetLength(int nextHeaderExtOffset, int nextHeaderExtLength) {
            this.currExtOffset = nextHeaderExtOffset;
            this.currExtLength = nextHeaderExtLength;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\b\u0087\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/jitsi/rtp/rtp/RtpPacket$PendingHeaderExtension;", "Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "other", "(Lorg/jitsi/rtp/rtp/RtpPacket;Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;)V", "id", "", "dataLengthBytes", "(Lorg/jitsi/rtp/rtp/RtpPacket;II)V", "buffer", "", "getBuffer", "()[B", "getDataLengthBytes", "()I", "dataOffset", "getDataOffset", "getId", "setId", "(I)V", "totalLengthBytes", "getTotalLengthBytes", "writeToBuffer", "offset", "parser", "Lorg/jitsi/rtp/rtp/header_extensions/HeaderExtensionParser;", "rtp"})
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="We intentionally expose the internal buffer.")
    public final class PendingHeaderExtension
    implements HeaderExtension {
        private int id;
        private final int dataLengthBytes;
        @NotNull
        private final byte[] buffer;
        private final int dataOffset;
        final /* synthetic */ RtpPacket this$0;

        public PendingHeaderExtension(RtpPacket this$0, int id, int dataLengthBytes) {
            this.this$0 = this$0;
            this.id = id;
            this.dataLengthBytes = dataLengthBytes;
            this.buffer = new byte[this.getDataLengthBytes()];
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public void setId(int n) {
            this.id = n;
        }

        @Override
        public int getDataLengthBytes() {
            return this.dataLengthBytes;
        }

        @Override
        @NotNull
        public byte[] getBuffer() {
            return this.buffer;
        }

        @Override
        public int getDataOffset() {
            return this.dataOffset;
        }

        @Override
        public int getTotalLengthBytes() {
            int n = this.getDataLengthBytes();
            HeaderExtensionParser headerExtensionParser = this.this$0.getHeaderExtensionParser();
            Intrinsics.checkNotNull(headerExtensionParser);
            return n + headerExtensionParser.getExtHeaderSizeBytes();
        }

        public PendingHeaderExtension(@NotNull RtpPacket this$0, HeaderExtension other) {
            Intrinsics.checkNotNullParameter(other, "other");
            this(this$0, other.getId(), other.getDataLengthBytes());
            System.arraycopy(other.getBuffer(), other.getDataOffset(), this.getBuffer(), 0, this.getDataLengthBytes());
        }

        public final int writeToBuffer(@NotNull byte[] buffer, int offset, @NotNull HeaderExtensionParser parser2) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            Intrinsics.checkNotNullParameter(parser2, "parser");
            parser2.writeIdAndLength(this.getId(), this.getDataLengthBytes(), buffer, offset);
            System.arraycopy(this.getBuffer(), this.getDataOffset(), buffer, offset + parser2.getExtHeaderSizeBytes(), this.getDataLengthBytes());
            return parser2.getExtHeaderSizeBytes() + this.getDataLengthBytes();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\bH\u0002J\t\u0010\u000b\u001a\u00020\fH\u0096\u0002J\t\u0010\r\u001a\u00020\u0002H\u0096\u0002J\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010R\u0012\u0010\u0004\u001a\u00060\u0005R\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/rtp/rtp/RtpPacket$EncodedHeaderExtensions;", "", "Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "(Lorg/jitsi/rtp/rtp/RtpPacket;)V", "currHeaderExtension", "Lorg/jitsi/rtp/rtp/RtpPacket$EncodedHeaderExtension;", "Lorg/jitsi/rtp/rtp/RtpPacket;", "nextOffset", "", "remainingLength", "getNextExtLength", "hasNext", "", "next", "reset", "", "reset$rtp", "rtp"})
    public final class EncodedHeaderExtensions
    implements Iterator<HeaderExtension>,
    KMappedMarker {
        private int nextOffset;
        private int remainingLength;
        @NotNull
        private final EncodedHeaderExtension currHeaderExtension;

        public EncodedHeaderExtensions() {
            this.currHeaderExtension = new EncodedHeaderExtension();
        }

        @Override
        public boolean hasNext() {
            if (RtpPacket.this.getHeaderExtensionParser() == null) {
                return false;
            }
            while (this.remainingLength > 0 && RtpUtilsKt.isPadding(RtpPacket.this.buffer[this.nextOffset])) {
                int n = this.nextOffset;
                this.nextOffset = n + 1;
                n = this.remainingLength;
                this.remainingLength = n + -1;
            }
            if (this.remainingLength <= 0 || this.nextOffset < 0) {
                return false;
            }
            return this.getNextExtLength() > 0;
        }

        @Override
        @NotNull
        public HeaderExtension next() {
            int nextExtLen = this.getNextExtLength();
            if (nextExtLen <= 0) {
                throw new Exception("Invalid extension length.  Did hasNext() return true?");
            }
            this.currHeaderExtension.setOffsetLength(this.nextOffset, nextExtLen);
            this.nextOffset += nextExtLen;
            this.remainingLength -= nextExtLen;
            return this.currHeaderExtension;
        }

        private final int getNextExtLength() {
            HeaderExtensionParser headerExtensionParser = RtpPacket.this.getHeaderExtensionParser();
            if (headerExtensionParser != null) {
                HeaderExtensionParser headerExtensionParser2 = headerExtensionParser;
                RtpPacket rtpPacket = RtpPacket.this;
                HeaderExtensionParser parser2 = headerExtensionParser2;
                boolean bl = false;
                if (this.remainingLength < parser2.getMinimumExtSizeBytes()) {
                    return -1;
                }
                Intrinsics.checkNotNullExpressionValue(rtpPacket.buffer, "buffer");
                int extLen = parser2.getEntireLengthBytes(rtpPacket.buffer, this.nextOffset);
                return extLen > this.remainingLength ? -1 : extLen;
            }
            EncodedHeaderExtensions $this$getNextExtLength_u24lambda_u2d1 = this;
            boolean bl = false;
            return -1;
        }

        public final void reset$rtp() {
            int extLength;
            int n;
            if (RtpPacket.this.getHeaderExtensionParser() != null) {
                Intrinsics.checkNotNullExpressionValue(RtpPacket.this.buffer, "buffer");
                int extensionBlockLength = HeaderExtensionHelpers.Companion.getExtensionsTotalLength(RtpPacket.this.buffer, RtpPacket.this.offset + 12 + RtpPacket.this.getCsrcCount() * 4);
                n = extensionBlockLength - 4;
            } else {
                n = extLength = 0;
            }
            if (extLength <= 0) {
                this.nextOffset = -1;
                this.remainingLength = -1;
            } else {
                this.nextOffset = RtpPacket.this.offset + 12 + RtpPacket.this.getCsrcCount() * 4 + 4;
                this.remainingLength = extLength;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/rtp/rtp/RtpPacket$Companion;", "", "()V", "BYTES_TO_LEAVE_AT_START_OF_PACKET", "", "HEADER_EXT_HEADER_SIZE", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

