/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jibri;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.xmpp.extensions.jibri.JibriIq;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;

public class JibriIqProvider
extends IqProvider<JibriIq> {
    @Override
    public JibriIq parse(XmlPullParser parser2, int initialDepth, IqData data2, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        JibriIq iq;
        String namespace = parser2.getNamespace();
        if (!"http://jitsi.org/protocol/jibri".equals(namespace)) {
            return null;
        }
        String rootElement = parser2.getName();
        if ("jibri".equals(rootElement)) {
            String sipAddress;
            String displayName;
            String shouldRetryStr;
            String failureStr;
            String appData;
            String sessionId;
            String youTubeBroadcastId;
            String streamId;
            String room;
            iq = new JibriIq();
            String action = parser2.getAttributeValue("", "action");
            iq.setAction(JibriIq.Action.parse(action));
            String status = parser2.getAttributeValue("", "status");
            iq.setStatus(JibriIq.Status.parse(status));
            String recordingMode = parser2.getAttributeValue("", "recording_mode");
            if (StringUtils.isNotEmpty(recordingMode)) {
                iq.setRecordingMode(JibriIq.RecordingMode.parse(recordingMode));
            }
            if (StringUtils.isNotEmpty(room = parser2.getAttributeValue("", "room"))) {
                EntityBareJid roomJid = JidCreate.entityBareFrom(room);
                iq.setRoom(roomJid);
            }
            if (StringUtils.isNotEmpty(streamId = parser2.getAttributeValue("", "streamid"))) {
                iq.setStreamId(streamId);
            }
            if (StringUtils.isNotEmpty(youTubeBroadcastId = parser2.getAttributeValue("", "you_tube_broadcast_id"))) {
                iq.setYouTubeBroadcastId(youTubeBroadcastId);
            }
            if (StringUtils.isNotEmpty(sessionId = parser2.getAttributeValue("", "session_id"))) {
                iq.setSessionId(sessionId);
            }
            if (StringUtils.isNotEmpty(appData = parser2.getAttributeValue("", "app_data"))) {
                iq.setAppData(appData);
            }
            if (StringUtils.isNotEmpty(failureStr = parser2.getAttributeValue("", "failure_reason"))) {
                iq.setFailureReason(JibriIq.FailureReason.parse(failureStr));
            }
            if (StringUtils.isNotEmpty(shouldRetryStr = parser2.getAttributeValue("", "should_retry"))) {
                iq.setShouldRetry(Boolean.valueOf(shouldRetryStr));
            }
            if (StringUtils.isNotEmpty(displayName = parser2.getAttributeValue("", "displayname"))) {
                iq.setDisplayName(displayName);
            }
            if (StringUtils.isNotEmpty(sipAddress = parser2.getAttributeValue("", "sipaddress"))) {
                iq.setSipAddress(sipAddress);
            }
        } else {
            return null;
        }
        ParserUtils.forwardToEndTagOfDepth(parser2, initialDepth);
        return iq;
    }
}

