/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import org.jboss.logging.Logger;
import org.keycloak.models.AbstractKeycloakTransaction;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.mappers.LDAPTransaction;

public abstract class TxAwareLDAPUserModelDelegate
extends UserModelDelegate {
    public static final Logger logger = Logger.getLogger(TxAwareLDAPUserModelDelegate.class);
    protected LDAPStorageProvider provider;
    protected LDAPObject ldapUser;

    public TxAwareLDAPUserModelDelegate(UserModel delegate, LDAPStorageProvider provider, LDAPObject ldapUser) {
        super(delegate);
        this.provider = provider;
        this.ldapUser = ldapUser;
    }

    protected void ensureTransactionStarted() {
        LDAPTransaction transaction = this.provider.getUserManager().getTransaction(this.getId());
        if (transaction.getState() == AbstractKeycloakTransaction.TransactionState.NOT_STARTED) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Starting and enlisting transaction for object " + this.ldapUser.getDn()));
            }
            this.provider.getSession().getTransactionManager().enlistAfterCompletion((KeycloakTransaction)transaction);
        }
    }

    protected void markUpdatedAttributeInTransaction(String modelAttributeName) {
        this.ensureTransactionStarted();
        LDAPTransaction transaction = this.provider.getUserManager().getTransaction(this.getId());
        transaction.addUpdatedAttribute(modelAttributeName);
    }

    protected void markUpdatedRequiredActionInTransaction(String requiredActionName) {
        this.ensureTransactionStarted();
        LDAPTransaction transaction = this.provider.getUserManager().getTransaction(this.getId());
        transaction.addUpdatedRequiredAction(requiredActionName);
    }
}

