/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.health.registry;

import io.smallrye.health.api.HealthRegistry;
import io.smallrye.health.api.HealthType;
import io.smallrye.health.api.Wellness;
import io.smallrye.health.registry.HealthRegistryImpl;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.eclipse.microprofile.health.Startup;

@ApplicationScoped
public class HealthRegistries {
    private static final int MAX_GROUP_REGISTRIES_COUNT_DEFAULT = 100;
    private static final Map<HealthType, HealthRegistry> registries = new ConcurrentHashMap<HealthType, HealthRegistry>();
    private static final Map<String, HealthRegistry> groupRegistries = new ConcurrentHashMap<String, HealthRegistry>();
    private static int maxGroupRegistriesCount = 100;

    @Produces
    @Liveness
    @ApplicationScoped
    public HealthRegistry getLivenessRegistry() {
        return HealthRegistries.getRegistry(HealthType.LIVENESS);
    }

    @Produces
    @Readiness
    @ApplicationScoped
    public HealthRegistry getReadinessRegistry() {
        return HealthRegistries.getRegistry(HealthType.READINESS);
    }

    @Produces
    @Startup
    @ApplicationScoped
    public HealthRegistry getStartupRegistry() {
        return HealthRegistries.getRegistry(HealthType.STARTUP);
    }

    @Produces
    @Wellness
    @ApplicationScoped
    public HealthRegistry getWellnessRegistry() {
        return HealthRegistries.getRegistry(HealthType.WELLNESS);
    }

    public static HealthRegistry getRegistry(HealthType type) {
        return registries.computeIfAbsent(type, t -> new HealthRegistryImpl());
    }

    public static HealthRegistry getHealthGroupRegistry(String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException("Health group name cannot be null");
        }
        HealthRegistry healthRegistry = groupRegistries.get(groupName);
        if (healthRegistry == null) {
            if (groupRegistries.keySet().size() >= maxGroupRegistriesCount) {
                throw new IllegalStateException("Attempted to create more custom health group registries than allowed: " + maxGroupRegistriesCount);
            }
            healthRegistry = groupRegistries.computeIfAbsent(groupName, s -> new HealthRegistryImpl());
        }
        return healthRegistry;
    }

    public static Collection<HealthRegistry> getHealthGroupRegistries() {
        return Collections.unmodifiableCollection(groupRegistries.values());
    }

    static {
        try {
            maxGroupRegistriesCount = ConfigProvider.getConfig().getOptionalValue("io.smallrye.health.maxGroupRegistriesCount", Integer.class).orElse(100);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

