/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.def;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Principal;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.jboss.logging.Logger;
import org.keycloak.common.crypto.UserIdentityExtractor;
import org.keycloak.common.crypto.UserIdentityExtractorProvider;

public class BCUserIdentityExtractorProvider
extends UserIdentityExtractorProvider {
    private static final Logger logger = Logger.getLogger((String)BCUserIdentityExtractorProvider.class.getName());

    public UserIdentityExtractor getX500NameExtractor(String identifier, Function<X509Certificate[], Principal> x500Name) {
        return new X500NameRDNExtractorBCProvider(identifier, x500Name);
    }

    public UserIdentityExtractorProvider.SubjectAltNameExtractor getSubjectAltNameExtractor(int generalName) {
        return new SubjectAltNameExtractorBCProvider(generalName);
    }

    class X500NameRDNExtractorBCProvider
    extends UserIdentityExtractorProvider.X500NameRDNExtractor {
        private ASN1ObjectIdentifier x500NameStyle;
        Function<X509Certificate[], Principal> x500Name;

        public X500NameRDNExtractorBCProvider(String attrName, Function<X509Certificate[], Principal> x500Name) {
            super((UserIdentityExtractorProvider)BCUserIdentityExtractorProvider.this);
            this.x500NameStyle = BCStyle.INSTANCE.attrNameToOID(attrName);
            this.x500Name = x500Name;
        }

        public Object extractUserIdentity(X509Certificate[] certs) {
            RDN[] rnds;
            if (certs == null || certs.length == 0) {
                throw new IllegalArgumentException();
            }
            X500Name name = new X500Name(this.x500Name.apply(certs).getName());
            if (name != null && (rnds = name.getRDNs(this.x500NameStyle)) != null && rnds.length > 0) {
                RDN cn = rnds[0];
                if (cn.isMultiValued()) {
                    AttributeTypeAndValue[] attributeTypeAndValues = cn.getTypesAndValues();
                    Optional<AttributeTypeAndValue> optionalFirst = Arrays.stream(attributeTypeAndValues).filter(attributeTypeAndValue -> attributeTypeAndValue.getType().getId().equals(this.x500NameStyle.getId())).findFirst();
                    if (optionalFirst.isPresent()) {
                        return IETFUtils.valueToString((ASN1Encodable)optionalFirst.get().getValue());
                    }
                    return null;
                }
                return IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
            }
            return null;
        }
    }

    class SubjectAltNameExtractorBCProvider
    extends UserIdentityExtractorProvider.SubjectAltNameExtractor {
        private static final String UPN_OID = "1.3.6.1.4.1.311.20.2.3";
        private final int generalName;

        SubjectAltNameExtractorBCProvider(int generalName) {
            super((UserIdentityExtractorProvider)BCUserIdentityExtractorProvider.this);
            this.generalName = generalName;
        }

        public Object extractUserIdentity(X509Certificate[] certs) {
            if (certs == null || certs.length == 0) {
                throw new IllegalArgumentException();
            }
            try {
                Collection<List<?>> subjectAlternativeNames = certs[0].getSubjectAlternativeNames();
                if (subjectAlternativeNames == null) {
                    return null;
                }
                Iterator<List<?>> iterator = subjectAlternativeNames.iterator();
                boolean foundUpn = false;
                String tempOtherName = null;
                String tempOid = null;
                block4: while (iterator.hasNext() && !foundUpn) {
                    List<?> next = iterator.next();
                    if ((Integer)Integer.class.cast(next.get(0)) != this.generalName) continue;
                    for (int i = 1; i < next.size(); ++i) {
                        Object obj = next.get(i);
                        if (this.generalName != 0) {
                            logger.tracef("Extracted identity '%s' from Subject Alternative Name of type '%d'", obj, (Object)this.generalName);
                            return obj;
                        }
                        byte[] otherNameBytes = (byte[])obj;
                        try {
                            ASN1InputStream asn1Stream = new ASN1InputStream((InputStream)new ByteArrayInputStream(otherNameBytes));
                            ASN1Primitive asn1otherName = asn1Stream.readObject();
                            asn1otherName = this.unwrap((ASN1Encodable)asn1otherName);
                            ASN1Sequence asn1Sequence = ASN1Sequence.getInstance((Object)asn1otherName);
                            if (asn1Sequence == null) continue;
                            ASN1Encodable encodedOid = asn1Sequence.getObjectAt(0);
                            ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance((Object)this.unwrap(encodedOid));
                            tempOid = oid.getId();
                            ASN1Encodable principalNameEncoded = asn1Sequence.getObjectAt(1);
                            DERUTF8String principalName = DERUTF8String.getInstance((Object)this.unwrap(principalNameEncoded));
                            tempOtherName = principalName.getString();
                            if (!UPN_OID.equals(tempOid)) continue;
                            foundUpn = true;
                            continue block4;
                        }
                        catch (Exception e) {
                            logger.error((Object)"Failed to parse subjectAltName", (Throwable)e);
                        }
                    }
                }
                logger.tracef("Parsed otherName from subjectAltName. OID: '%s', Principal: '%s'", tempOid, tempOtherName);
                return tempOtherName;
            }
            catch (CertificateParsingException cause) {
                logger.errorf((Throwable)cause, "Failed to obtain identity from subjectAltName extension", new Object[0]);
                return null;
            }
        }

        private ASN1Encodable unwrap(ASN1Encodable encodable) {
            while (encodable instanceof ASN1TaggedObject) {
                ASN1TaggedObject taggedObj = (ASN1TaggedObject)encodable;
                encodable = taggedObj.getObject();
            }
            return encodable;
        }
    }
}

