/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.console;

import io.quarkus.deployment.console.ConsoleCliManager;
import io.quarkus.deployment.console.DelegateConnection;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.dev.console.StatusLine;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aesh.command.impl.registry.AeshCommandRegistryBuilder;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.settings.Settings;
import org.aesh.command.settings.SettingsBuilder;
import org.aesh.readline.ReadlineConsole;
import org.aesh.readline.alias.Alias;
import org.aesh.readline.alias.AliasManager;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.tty.Size;

public class AeshConsole
extends QuarkusConsole {
    public static final String ALTERNATE_SCREEN_BUFFER = "\u001b[?1049h\n";
    public static final String EXIT_ALTERNATE_SCREEN = "\u001b[?1049l";
    public static final String ALIAS_FILE = ".quarkus/console-aliases.txt";
    private final Connection connection;
    private Size size;
    private Attributes attributes;
    private String[] messages = new String[0];
    private int totalStatusLines = 0;
    private int lastWriteCursorX;
    private String lastColorCode;
    private volatile boolean doingReadline;
    private int bottomBlankSpace = 0;
    private final LinkedBlockingDeque<String> writeQueue = new LinkedBlockingDeque();
    private final Lock connectionLock = new ReentrantLock();
    private static final ThreadLocal<Boolean> IN_WRITE = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    static final Pattern ESCAPE = Pattern.compile("\u001b\\[(\\d\\d?)[\\d;]*m");
    static final TreeMap<Integer, StatusLineImpl> statusMap = new TreeMap();
    private final ReadWriteLock positionLock = new ReentrantReadWriteLock();
    private volatile boolean closed;
    private final StatusLine prompt;
    private volatile boolean pauseOutput;
    private volatile boolean firstConsoleRun = true;
    private DelegateConnection delegateConnection;
    private ReadlineConsole aeshConsole;

    public AeshConsole(final Connection connection) {
        INSTANCE = this;
        this.connection = connection;
        connection.openNonBlocking();
        this.setup(connection);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                connection.close();
            }
        }, "Console Shutdown Hook"));
        this.prompt = this.registerStatusLine(0);
    }

    private void updatePromptOnChange(StringBuilder buffer, int newLines) {
        if (newLines > this.totalStatusLines) {
            StringBuilder nb = new StringBuilder();
            for (int i = 0; i < newLines - this.totalStatusLines; ++i) {
                if (this.bottomBlankSpace > 0) {
                    --this.bottomBlankSpace;
                    continue;
                }
                nb.append("\n");
            }
            this.writeQueue.add(nb.toString());
            this.deadlockSafeWrite();
        } else if (newLines < this.totalStatusLines) {
            this.bottomBlankSpace += this.totalStatusLines - newLines;
        }
        this.totalStatusLines = newLines;
        this.printStatusAndPrompt(buffer);
        this.writeQueue.add(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusLine registerStatusLine(int priority) {
        try {
            this.positionLock.writeLock().lock();
            while (statusMap.containsKey(priority)) {
                ++priority;
            }
            StatusLineImpl value = new StatusLineImpl(priority);
            statusMap.put(priority, value);
            this.rebalance();
            StatusLineImpl statusLineImpl = value;
            return statusLineImpl;
        }
        finally {
            this.positionLock.writeLock().unlock();
        }
    }

    public void setPromptMessage(String promptMessage) {
        this.prompt.setMessage(promptMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AeshConsole setMessage(int position, String message) {
        AeshConsole aeshConsole = this;
        synchronized (aeshConsole) {
            if (this.messages.length <= position) {
                String[] old = this.messages;
                this.messages = new String[position + 1];
                System.arraycopy(old, 0, this.messages, 0, old.length);
            }
            this.messages[position] = message;
            int newLines = this.countTotalStatusLines();
            StringBuilder buffer = new StringBuilder();
            this.clearStatusMessages(buffer);
            this.updatePromptOnChange(buffer, newLines);
        }
        this.deadlockSafeWrite();
        return this;
    }

    private int countTotalStatusLines() {
        int total = 0;
        for (String i : this.messages) {
            if (i == null) continue;
            ++total;
            total += this.countLines(i);
        }
        return total == 0 ? total : total + 1;
    }

    private void end(Connection conn) {
        conn.setAttributes(this.attributes);
        StringBuilder sb = new StringBuilder();
        sb.append("\u001b[0m\n");
        this.writeQueue.add(sb.toString());
        this.deadlockSafeWrite();
        this.closed = true;
    }

    private void deadlockSafeWrite() {
        block3: while (!this.pauseOutput) {
            if (this.writeQueue.isEmpty()) {
                return;
            }
            if (!this.connectionLock.tryLock()) continue;
            IN_WRITE.set(true);
            try {
                while (true) {
                    if (this.writeQueue.isEmpty()) continue block3;
                    String s = this.writeQueue.poll();
                    this.connection.write(s);
                }
            }
            finally {
                IN_WRITE.set(false);
                this.connectionLock.unlock();
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setup(Connection conn) {
        AeshConsole aeshConsole = this;
        synchronized (aeshConsole) {
            this.size = conn.size();
            conn.setSignalHandler(event -> {
                switch (event) {
                    case INT: {
                        if (this.delegateConnection != null) {
                            this.exitCliMode();
                            return;
                        }
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                System.exit(0);
                            }
                        }).start();
                    }
                }
            });
            conn.setStdinHandler(keys -> {
                int pos;
                QuarkusConsole.StateChangeInputStream redirectIn = QuarkusConsole.REDIRECT_IN;
                if (redirectIn == null) {
                    return;
                }
                for (pos = 0; pos < ((int[])keys).length && redirectIn.acceptInput(keys[pos]); ++pos) {
                }
                if (pos > 0) {
                    if (pos == ((int[])keys).length) {
                        return;
                    }
                    int[] newKeys = new int[((int[])keys).length - pos];
                    System.arraycopy(keys, pos, newKeys, 0, newKeys.length);
                    keys = newKeys;
                }
                try {
                    if (this.delegateConnection != null) {
                        if (((int[])keys).length == 1) {
                            for (int k : keys) {
                                if (k != 27) continue;
                                this.exitCliMode();
                                return;
                            }
                        }
                        if (this.delegateConnection.getStdinHandler() != null) {
                            try {
                                this.delegateConnection.getStdinHandler().accept((int[])keys);
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                        return;
                    }
                    Consumer handler = this.inputHandler;
                    if (handler != null) {
                        try {
                            handler.accept(keys);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    if (this.doingReadline) {
                        for (int k : keys) {
                            if (k != 10 && k != 13) continue;
                            this.doingReadline = false;
                            this.connection.enterRawMode();
                        }
                    } else {
                        for (int k : keys) {
                            if (k != 58) continue;
                            this.runAeshCli();
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            });
            conn.setCloseHandler(close -> this.end(conn));
            conn.setSizeHandler(size -> this.setup(conn));
            this.attributes = conn.enterRawMode();
            StringBuilder sb = new StringBuilder();
            this.printStatusAndPrompt(sb);
            this.writeQueue.add(sb.toString());
        }
        this.deadlockSafeWrite();
    }

    private void printStatusAndPrompt(StringBuilder buffer) {
        if (this.totalStatusLines == 0 || this.closed) {
            return;
        }
        if (this.totalStatusLines < this.size.getHeight()) {
            this.clearStatusMessages(buffer);
            this.gotoLine(buffer, this.size.getHeight() - this.totalStatusLines);
        } else {
            this.bottomBlankSpace = 0;
        }
        buffer.append("\n--\n");
        block0: for (int i = this.messages.length - 1; i >= 0; --i) {
            String msg = this.messages[i];
            if (msg == null) continue;
            buffer.append(msg);
            if (i <= 0) continue;
            for (int j = 0; j < i; ++j) {
                if (this.messages[j] == null) continue;
                buffer.append("\n");
                continue block0;
            }
        }
    }

    private void clearStatusMessages(StringBuilder buffer) {
        this.gotoLine(buffer, this.size.getHeight() - this.totalStatusLines + 1);
        buffer.append("\u001b[J");
    }

    private StringBuilder gotoLine(StringBuilder builder, int line) {
        return this.gotoCoords(builder, line, 0);
    }

    private StringBuilder gotoCoords(StringBuilder builder, int line, int col) {
        return builder.append("\u001b[").append(line).append(";").append(col).append("H");
    }

    int countLines(String s) {
        return this.countLines(s, 0);
    }

    int countLines(String s, int cursorPos) {
        if (s == null) {
            return 0;
        }
        s = this.stripAnsiCodes(s);
        int lines = 0;
        int curLength = cursorPos;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\n') {
                ++lines;
                curLength = 0;
                continue;
            }
            if (curLength++ != this.size.getWidth()) continue;
            ++lines;
            curLength = 0;
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(boolean errorStream, String s) {
        if (IN_WRITE.get().booleanValue()) {
            return;
        }
        if (this.closed) {
            IN_WRITE.set(true);
            try {
                this.connection.write((String)s);
                return;
            }
            finally {
                IN_WRITE.set(false);
            }
        }
        if (this.lastColorCode != null) {
            s = this.lastColorCode + (String)s;
        }
        Matcher m = ESCAPE.matcher((CharSequence)s);
        while (m.find()) {
            int val = Integer.parseInt(m.group(1));
            if (val != 0 && (val < 30 || val > 39) && (val < 90 || val > 97)) continue;
            this.lastColorCode = m.group(0);
        }
        StringBuilder buffer = new StringBuilder();
        if (!this.shouldWrite(errorStream, (String)s)) {
            return;
        }
        AeshConsole aeshConsole = this;
        synchronized (aeshConsole) {
            if (this.totalStatusLines == 0) {
                this.bottomBlankSpace = 0;
                this.writeQueue.add((String)s);
            } else {
                this.clearStatusMessages(buffer);
                int cursorPos = this.lastWriteCursorX;
                String stripped = this.stripAnsiCodes((String)s);
                int lines = this.countLines((String)s, cursorPos);
                int trailing = 0;
                int index = stripped.lastIndexOf("\n");
                trailing = index == -1 ? stripped.length() : stripped.length() - index - 1;
                int newCursorPos = lines == 0 ? trailing + cursorPos : trailing;
                int usedBlankSpace = 0;
                if (cursorPos > 1 && lines == 0) {
                    this.gotoCoords(buffer, this.size.getHeight() - this.bottomBlankSpace - this.totalStatusLines - 1, cursorPos + 1);
                    buffer.append((String)s);
                    this.lastWriteCursorX = newCursorPos;
                    this.writeQueue.add(buffer.toString());
                } else {
                    this.gotoLine(buffer, this.size.getHeight());
                    if (lines == 0) {
                        ++lines;
                    }
                    int originalBlank = this.bottomBlankSpace;
                    if (this.bottomBlankSpace > 0) {
                        usedBlankSpace = Math.min(this.bottomBlankSpace, lines);
                        this.bottomBlankSpace -= usedBlankSpace;
                    }
                    int appendLines = Math.max(Math.min(cursorPos > 1 ? lines - 1 : lines, this.totalStatusLines + 1), 1);
                    appendLines -= usedBlankSpace;
                    this.clearStatusMessages(buffer);
                    buffer.append("\u001b[").append(this.size.getHeight() - this.totalStatusLines - originalBlank - (cursorPos > 0 ? 1 : 0)).append(";").append(cursorPos + 1).append("H");
                    buffer.append((String)s);
                    buffer.append("\u001b[").append(this.size.getHeight()).append(";").append(0).append("H");
                    for (int i = 0; i < appendLines; ++i) {
                        buffer.append("\n");
                    }
                    this.lastWriteCursorX = newCursorPos;
                    this.printStatusAndPrompt(buffer);
                    this.writeQueue.add(buffer.toString());
                }
            }
        }
        this.deadlockSafeWrite();
    }

    public void write(boolean errorStream, byte[] buf, int off, int len) {
        this.write(errorStream, new String(buf, off, len, this.connection.outputEncoding()));
    }

    public boolean isAnsiSupported() {
        return true;
    }

    public void doReadLine() {
        this.setPromptMessage("");
        this.connection.setAttributes(this.attributes);
        this.doingReadline = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rebalance() {
        AeshConsole aeshConsole = this;
        synchronized (aeshConsole) {
            int count = 1;
            this.messages = new String[statusMap.size()];
            for (StatusLineImpl val : statusMap.values()) {
                val.position = count;
                this.setMessage(count++, val.message);
            }
        }
    }

    public void runAeshCli() {
        if (ConsoleCliManager.commands.isEmpty()) {
            System.out.println("No commands registered, please wait for Quarkus to start before using the console");
            return;
        }
        try {
            this.pauseOutput = true;
            this.delegateConnection = new DelegateConnection(this.connection);
            this.connection.write(ALTERNATE_SCREEN_BUFFER);
            if (this.firstConsoleRun) {
                this.connection.write("You are now in Quarkus Terminal. Your app is still running. Use `help` or tab completion to explore, `quit` or `q` to return to your application.\n");
                this.firstConsoleRun = false;
            }
            AeshCommandRegistryBuilder commandBuilder = AeshCommandRegistryBuilder.builder();
            ConsoleCliManager.commands.forEach(arg_0 -> ((AeshCommandRegistryBuilder)commandBuilder).command(arg_0));
            CommandRegistry registry = commandBuilder.create();
            Settings settings = SettingsBuilder.builder().enableExport(false).enableAlias(true).aliasManager(new AliasManager(Paths.get(System.getProperty("user.home"), new String[0]).resolve(ALIAS_FILE).toFile(), true)).connection((Connection)this.delegateConnection).commandRegistry(registry).build();
            this.aeshConsole = new ReadlineConsole(settings);
            this.aeshConsole.setPrompt("quarkus$ ");
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AeshConsole.this.aeshConsole.start();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }, "Quarkus integrated CLI thread");
            t.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<Character, String> singleLetterAliases() {
        try {
            AliasManager manager = new AliasManager(Paths.get(System.getProperty("user.home"), new String[0]).resolve(ALIAS_FILE).toFile(), true);
            HashMap<Character, String> ret = new HashMap<Character, String>();
            for (String alias : manager.getAllNames()) {
                if (alias.length() != 1) continue;
                ret.put(Character.valueOf(alias.charAt(0)), ((Alias)manager.getAlias(alias).get()).getValue());
            }
            return ret;
        }
        catch (IOException e) {
            return Map.of();
        }
    }

    public void runAlias(char alias) {
        try {
            AeshCommandRegistryBuilder commandBuilder = AeshCommandRegistryBuilder.builder();
            ConsoleCliManager.commands.forEach(arg_0 -> ((AeshCommandRegistryBuilder)commandBuilder).command(arg_0));
            CommandRegistry registry = commandBuilder.create();
            Settings settings = SettingsBuilder.builder().enableExport(false).inputStream((InputStream)new ByteArrayInputStream(new byte[]{(byte)alias, 10})).enableAlias(true).aliasManager(new AliasManager(Paths.get(System.getProperty("user.home"), new String[0]).resolve(ALIAS_FILE).toFile(), true)).connection((Connection)this.delegateConnection).commandRegistry(registry).build();
            this.aeshConsole = new ReadlineConsole(settings);
            this.aeshConsole.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void exitCliMode() {
        if (this.aeshConsole == null || this.delegateConnection == null) {
            return;
        }
        this.aeshConsole.stop();
        this.aeshConsole = null;
        this.delegateConnection.close();
        this.delegateConnection = null;
        this.connection.enterRawMode();
        this.connection.write(EXIT_ALTERNATE_SCREEN);
        this.pauseOutput = false;
        this.write(false, "");
        this.deadlockSafeWrite();
    }

    class StatusLineImpl
    implements StatusLine {
        final int priority;
        int position;
        String message;
        boolean closed;

        StatusLineImpl(int priority) {
            this.priority = priority;
        }

        public void setMessage(String message) {
            try {
                AeshConsole.this.positionLock.readLock().lock();
                this.message = message;
                if (!this.closed) {
                    AeshConsole.this.setMessage(this.position, message);
                }
            }
            finally {
                AeshConsole.this.positionLock.readLock().unlock();
            }
        }

        public void close() {
            AeshConsole.this.positionLock.writeLock().lock();
            this.closed = true;
            try {
                AeshConsole.this.setMessage(this.position, null);
                statusMap.remove(this.priority);
                AeshConsole.this.rebalance();
            }
            finally {
                AeshConsole.this.positionLock.writeLock().unlock();
            }
        }
    }
}

